/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.ChangeToVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.NormalMode;
import net.sourceforge.vrapper.vim.modes.TemporaryMode;

public class TempNormalMode
extends NormalMode
implements TemporaryMode {
    public static final String NAME = "temporary normal mode";
    public static final String DISPLAY_NAME = "NORMAL (insert)";

    public TempNormalMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        super.enterMode(args);
        Position pos = this.editorAdaptor.getCursorService().getMark("]");
        this.editorAdaptor.setPosition(pos, StickyColumnPolicy.ON_CHANGE);
    }

    @Override
    protected void commandDone() {
        super.commandDone();
        this.editorAdaptor.changeModeSafely("insert mode", InsertMode.RESUME_ON_MODE_ENTER);
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) throws CommandExecutionException {
        boolean switchBackToInsert = this.isEnabled;
        super.leaveMode(hints);
        if (switchBackToInsert) {
            this.editorAdaptor.changeModeSafely("insert mode", InsertMode.RESUME_ON_MODE_ENTER);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    protected State<Command> buildInitialState() {
        State switchTempModes = ConstructorWrappers.state(ConstructorWrappers.leafBind('V', new ChangeToVisualModeCommand("temporary linewise visual mode")), ConstructorWrappers.leafBind('v', new ChangeToVisualModeCommand("temporary visual mode")));
        return StateUtils.union(switchTempModes, super.buildInitialState());
    }
}

