/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes;

import net.sourceforge.vrapper.keymap.State;
import net.sourceforge.vrapper.keymap.StateUtils;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.keymap.vim.CountingState;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.ChangeToSearchModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;
import net.sourceforge.vrapper.vim.commands.SwapSelectionSidesCommand;
import net.sourceforge.vrapper.vim.commands.VisualMotionCommand;
import net.sourceforge.vrapper.vim.commands.motions.SearchResultMotion;
import net.sourceforge.vrapper.vim.modes.AbstractVisualMode;

public class VisualMode
extends AbstractVisualMode {
    public static final String NAME = "visual mode";
    public static final String DISPLAY_NAME = "VISUAL";

    public VisualMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void fixCaret() {
        String selectionType = this.editorAdaptor.getConfiguration().get(Options.SELECTION);
        CaretType type = "inclusive".equals(selectionType) ? CaretType.RECTANGULAR : ("exclusive".equals(selectionType) ? CaretType.VERTICAL_BAR : CaretType.RECTANGULAR);
        this.editorAdaptor.getCursorService().setCaret(type);
    }

    @Override
    protected State<Command> buildInitialState() {
        VisualMotionCommand doSearchCommand = new VisualMotionCommand(SearchResultMotion.REPEAT);
        State characterwiseSpecific = ConstructorWrappers.state(ConstructorWrappers.leafBind('o', SwapSelectionSidesCommand.INSTANCE), ConstructorWrappers.leafBind('V', new ChangeToVisualModeCommand("linewise visual mode")), ConstructorWrappers.leafCtrlBind('v', new ChangeToVisualModeCommand("block visual mode")), ConstructorWrappers.leafCtrlBind('q', new ChangeToVisualModeCommand("block visual mode")), ConstructorWrappers.leafBind('v', LeaveVisualModeCommand.INSTANCE));
        State searchSpecific = CountingState.wrap(ConstructorWrappers.state(ConstructorWrappers.leafBind('/', new ChangeToSearchModeCommand(false, doSearchCommand, true)), ConstructorWrappers.leafBind('?', new ChangeToSearchModeCommand(true, doSearchCommand, true))));
        return StateUtils.union(this.getPlatformSpecificState(NAME), characterwiseSpecific, searchSpecific, super.buildInitialState());
    }

    @Override
    protected Selection fixSelection(Selection selection) {
        Position start = selection.getFrom();
        Position end = selection.getTo();
        TextRange range = "inclusive".equals(this.editorAdaptor.getConfiguration().get(Options.SELECTION)) ? StartEndTextRange.inclusive(this.editorAdaptor.getCursorService(), start, end) : new StartEndTextRange(start, end);
        return new SimpleSelection(start, end, range);
    }
}

