/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.vim.ConstructorWrappers;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.AbstractMode;
import net.sourceforge.vrapper.vim.modes.InitialContentsHint;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.commandline.AbstractCommandParser;

public abstract class AbstractCommandLineMode
extends AbstractMode {
    public static final String COMMANDLINE_KEYMAP_NAME = "Command Mode Keymap";
    protected AbstractCommandParser parser;
    protected int mapBufferStart = -1;
    protected int mapBufferLength = -1;
    public static final ModeSwitchHint FROM_VISUAL = new ModeSwitchHint(){};

    protected abstract String getPrompt();

    protected abstract AbstractCommandParser createParser();

    public AbstractCommandLineMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        this.isEnabled = true;
        this.mapBufferStart = -1;
        this.mapBufferLength = -1;
        CommandLineUI commandLine = this.editorAdaptor.getCommandLine();
        commandLine.setPrompt(this.getPrompt());
        this.parser = this.createParser();
        this.parser.setCommandLine(commandLine);
        commandLine.open();
        ModeSwitchHint[] modeSwitchHintArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ModeSwitchHint hint = modeSwitchHintArray[n2];
            if (hint == FROM_VISUAL) {
                this.parser.setFromVisual(true);
                this.editorAdaptor.rememberLastActiveSelection();
            } else if (hint instanceof InitialContentsHint) {
                commandLine.resetContents(((InitialContentsHint)hint).getContents());
            }
            ++n2;
        }
    }

    @Override
    public void leaveMode(ModeSwitchHint ... hints) {
        this.isEnabled = false;
        this.parser = null;
        this.editorAdaptor.getCommandLine().close();
    }

    @Override
    public boolean handleKey(KeyStroke stroke) {
        this.parser.type(stroke);
        return true;
    }

    @Override
    public void addKeyToMapBuffer(KeyStroke stroke) {
        String strokeString = ConstructorWrappers.keyStrokeToString(stroke);
        if (this.mapBufferStart == -1) {
            this.mapBufferStart = this.parser.commandLine.getPosition();
        }
        this.mapBufferLength = this.mapBufferLength == -1 ? strokeString.length() : (this.mapBufferLength += strokeString.length());
        this.parser.commandLine.type(strokeString);
    }

    @Override
    public void cleanMapBuffer(boolean mappingSucceeded) {
        if (this.mapBufferStart != -1 && this.mapBufferLength != -1) {
            this.parser.commandLine.replace(this.mapBufferStart, this.mapBufferStart + this.mapBufferLength, "");
        }
        this.mapBufferStart = -1;
        this.mapBufferLength = -1;
    }

    protected AbstractCommandParser getParser() {
        return this.parser;
    }
}

