/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLineHistory {
    private Map<String, ArrayList<String>> modeHistory = new HashMap<String, ArrayList<String>>();
    private int index = -1;
    private String original;
    private List<String> history;
    public static final CommandLineHistory INSTANCE = new CommandLineHistory();

    private CommandLineHistory() {
    }

    public void setMode(String modeName) {
        this.index = -1;
        if (!this.modeHistory.containsKey(modeName)) {
            this.modeHistory.put(modeName, new ArrayList());
        }
        this.history = this.modeHistory.get(modeName);
    }

    public void append(String command) {
        if (this.history.contains(command)) {
            this.history.remove(command);
        }
        this.history.add(0, command);
        this.index = -1;
    }

    public void setTemp(String temp) {
        this.original = temp;
        this.index = -1;
    }

    public String getPrevious() {
        int i = this.index + 1;
        while (i < this.history.size()) {
            String command = this.history.get(i);
            if (command.startsWith(this.original)) {
                this.index = i;
                return command;
            }
            ++i;
        }
        return null;
    }

    public String getNext() {
        int i = this.index - 1;
        while (i > -1) {
            String command = this.history.get(i);
            if (command.startsWith(this.original)) {
                this.index = i;
                return command;
            }
            --i;
        }
        this.index = -1;
        return this.original;
    }
}

