/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.SelectionService;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineRange;
import net.sourceforge.vrapper.utils.SimpleLineRange;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.SubstitutionDefinition;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.AnonymousMacroOperation;
import net.sourceforge.vrapper.vim.commands.AsciiCommand;
import net.sourceforge.vrapper.vim.commands.ChangeModeCommand;
import net.sourceforge.vrapper.vim.commands.ChangeToInsertModeCommand;
import net.sourceforge.vrapper.vim.commands.CloseCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.ConfigCommand;
import net.sourceforge.vrapper.vim.commands.DeleteMarksCommand;
import net.sourceforge.vrapper.vim.commands.DummyCommand;
import net.sourceforge.vrapper.vim.commands.DummyTextObject;
import net.sourceforge.vrapper.vim.commands.EditFileCommand;
import net.sourceforge.vrapper.vim.commands.ExCommandOperation;
import net.sourceforge.vrapper.vim.commands.ExSearchCommand;
import net.sourceforge.vrapper.vim.commands.FindFileCommand;
import net.sourceforge.vrapper.vim.commands.LineRangeOperationCommand;
import net.sourceforge.vrapper.vim.commands.ListBuffersCommand;
import net.sourceforge.vrapper.vim.commands.ListMarksCommand;
import net.sourceforge.vrapper.vim.commands.ListRegistersCommand;
import net.sourceforge.vrapper.vim.commands.ListUserCommandsCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.OpenInGvimCommand;
import net.sourceforge.vrapper.vim.commands.ReadExternalOperation;
import net.sourceforge.vrapper.vim.commands.RedoCommand;
import net.sourceforge.vrapper.vim.commands.RepeatLastSubstitutionCommand;
import net.sourceforge.vrapper.vim.commands.RetabOperation;
import net.sourceforge.vrapper.vim.commands.SaveAllCommand;
import net.sourceforge.vrapper.vim.commands.SaveCommand;
import net.sourceforge.vrapper.vim.commands.SetLocalOptionCommand;
import net.sourceforge.vrapper.vim.commands.SetOptionCommand;
import net.sourceforge.vrapper.vim.commands.SortOperation;
import net.sourceforge.vrapper.vim.commands.SubstitutionOperation;
import net.sourceforge.vrapper.vim.commands.SwitchBufferCommand;
import net.sourceforge.vrapper.vim.commands.TextObject;
import net.sourceforge.vrapper.vim.commands.TextOperationTextObjectCommand;
import net.sourceforge.vrapper.vim.commands.UndoCommand;
import net.sourceforge.vrapper.vim.commands.VimCommandSequence;
import net.sourceforge.vrapper.vim.commands.motions.GoToLineMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import net.sourceforge.vrapper.vim.commands.motions.MoveRight;
import net.sourceforge.vrapper.vim.modes.ConfirmSubstitutionMode;
import net.sourceforge.vrapper.vim.modes.KeyMapResolver;
import net.sourceforge.vrapper.vim.modes.commandline.AbstractCommandParser;
import net.sourceforge.vrapper.vim.modes.commandline.AutoCmdParser;
import net.sourceforge.vrapper.vim.modes.commandline.CommandWrapper;
import net.sourceforge.vrapper.vim.modes.commandline.ComplexLocalOptionEvaluator;
import net.sourceforge.vrapper.vim.modes.commandline.ComplexOptionEvaluator;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;
import net.sourceforge.vrapper.vim.modes.commandline.EvaluatorMapping;
import net.sourceforge.vrapper.vim.modes.commandline.FilePathTabCompletion;
import net.sourceforge.vrapper.vim.modes.commandline.HighlightSearch;
import net.sourceforge.vrapper.vim.modes.commandline.KeyMapper;
import net.sourceforge.vrapper.vim.modes.commandline.LetExpressionEvaluator;
import net.sourceforge.vrapper.vim.modes.commandline.PrintOptionCommand;
import net.sourceforge.vrapper.vim.modes.commandline.ToggleLocalOptionCommand;
import net.sourceforge.vrapper.vim.modes.commandline.ToggleOptionCommand;

public class CommandLineParser
extends AbstractCommandParser {
    public static final Pattern EDIT_CMD_PATTERN = Pattern.compile("^(e|edit)\\s+");
    public static final Pattern FIND_CMD_PATTERN = Pattern.compile("^(find|fin)\\s+");
    public static final Pattern TABF_CMD_PATTERN = Pattern.compile("^(tabf|tabfind)\\s+");
    public static final Pattern CD_CMD_PATTERN = Pattern.compile("^cd\\s+");
    public static final Pattern SPLIT_CMD_PATTERN = Pattern.compile("^(split|sp)\\s+");
    public static final Pattern VSPLIT_CMD_PATTERN = Pattern.compile("^(vsplit|vs)\\s+");
    private Matcher matcher;
    private final EvaluatorMapping mapping;
    private final FilePathTabCompletion tabComplete;

    static EvaluatorMapping coreCommands() {
        KeyMapper.Map noremap = new KeyMapper.Map(false, "Visual Mode Keymap", "Normal Mode Keymap", KeyMapResolver.OMAP_NAME);
        KeyMapper.Map map = new KeyMapper.Map(true, "Visual Mode Keymap", "Normal Mode Keymap", KeyMapResolver.OMAP_NAME);
        KeyMapper.Map nnoremap = new KeyMapper.Map(false, "Normal Mode Keymap");
        KeyMapper.Map nmap = new KeyMapper.Map(true, "Normal Mode Keymap");
        KeyMapper.Map onoremap = new KeyMapper.Map(false, KeyMapResolver.OMAP_NAME);
        KeyMapper.Map omap = new KeyMapper.Map(true, KeyMapResolver.OMAP_NAME);
        KeyMapper.Map vnoremap = new KeyMapper.Map(false, "Visual Mode Keymap");
        KeyMapper.Map vmap = new KeyMapper.Map(true, "Visual Mode Keymap");
        KeyMapper.Map inoremap = new KeyMapper.Map(false, "Insert Mode Keymap");
        KeyMapper.Map imap = new KeyMapper.Map(true, "Insert Mode Keymap");
        KeyMapper.Map canoremap = new KeyMapper.Map(false, "Content Assist Mode Keymap");
        KeyMapper.Map camap = new KeyMapper.Map(true, "Content Assist Mode Keymap");
        KeyMapper.Map cnoremap = new KeyMapper.Map(false, "Command Mode Keymap");
        KeyMapper.Map cmap = new KeyMapper.Map(true, "Command Mode Keymap");
        AsciiCommand ascii = AsciiCommand.INSTANCE;
        SaveCommand save = SaveCommand.INSTANCE;
        SaveAllCommand saveAll = SaveAllCommand.INSTANCE;
        Command close = CloseCommand.CLOSE;
        Command closeAll = CloseCommand.CLOSE_ALL;
        VimCommandSequence saveAndClose = new VimCommandSequence(save, close);
        VimCommandSequence saveAndCloseAll = new VimCommandSequence(saveAll, closeAll);
        EvaluatorWithExclaim quit = new EvaluatorWithExclaim(CloseCommand.CLOSE, CloseCommand.FORCED_CLOSE);
        EvaluatorWithExclaim quitAll = new EvaluatorWithExclaim(CloseCommand.CLOSE_ALL, CloseCommand.FORCED_CLOSE_ALL);
        EvaluatorWithExclaim quitOthers = new EvaluatorWithExclaim(CloseCommand.CLOSE_OTHERS, CloseCommand.FORCED_CLOSE_OTHERS);
        KeyMapper.Unmap unmap = new KeyMapper.Unmap("Visual Mode Keymap", "Normal Mode Keymap");
        KeyMapper.Unmap nunmap = new KeyMapper.Unmap("Normal Mode Keymap");
        KeyMapper.Unmap ounmap = new KeyMapper.Unmap(KeyMapResolver.OMAP_NAME);
        KeyMapper.Unmap vunmap = new KeyMapper.Unmap("Visual Mode Keymap");
        KeyMapper.Unmap iunmap = new KeyMapper.Unmap("Insert Mode Keymap");
        KeyMapper.Clear clear = new KeyMapper.Clear("Visual Mode Keymap", "Normal Mode Keymap");
        KeyMapper.Clear nclear = new KeyMapper.Clear("Normal Mode Keymap");
        KeyMapper.Clear oclear = new KeyMapper.Clear(KeyMapResolver.OMAP_NAME);
        KeyMapper.Clear vclear = new KeyMapper.Clear("Visual Mode Keymap");
        KeyMapper.Clear iclear = new KeyMapper.Clear("Insert Mode Keymap");
        MotionCommand gotoEOF = new MotionCommand(GoToLineMotion.LAST_LINE);
        Evaluator nohlsearch = HighlightSearch.CLEAR_HIGHLIGHT;
        final Evaluator printWorkingDir = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                String dir = vim.getConfiguration().get(Options.AUTO_CHDIR) != false ? vim.getFileService().getCurrentFilePath() : vim.getRegisterManager().getCurrentWorkingDirectory();
                vim.getUserInterfaceService().setInfoMessage(dir);
                return null;
            }
        };
        Evaluator chDir = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
                String dir = command.isEmpty() ? "/" : command.poll();
                vim.getRegisterManager().setCurrentWorkingDirectory(dir);
                printWorkingDir.evaluate(vim, command);
                return null;
            }
        };
        Evaluator editFile = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                if (command.isEmpty()) {
                    vim.getFileService().refreshFile();
                    return null;
                }
                try {
                    new EditFileCommand(command.poll()).execute(vim);
                }
                catch (CommandExecutionException commandExecutionException) {}
                return null;
            }
        };
        Evaluator findFile = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                if (command.isEmpty()) {
                    vim.getUserInterfaceService().setErrorMessage("No file name");
                    return null;
                }
                try {
                    new FindFileCommand(command.poll()).execute(vim);
                }
                catch (CommandExecutionException commandExecutionException) {}
                return null;
            }
        };
        Evaluator sort = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                String commandStr = "";
                while (command.size() > 0) {
                    commandStr = String.valueOf(commandStr) + command.poll() + " ";
                }
                TextObject selection = new DummyTextObject(null);
                if (vim.getSelection().getModelLength() > 0) {
                    selection = vim.getSelection();
                }
                try {
                    new SortOperation(commandStr).execute(vim, 0, selection);
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        Evaluator retab = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                String commandStr = "";
                while (command.size() > 0) {
                    commandStr = String.valueOf(commandStr) + command.poll() + " ";
                }
                try {
                    RetabOperation retabOperation = new RetabOperation(commandStr);
                    retabOperation.execute(vim, retabOperation.getDefaultRange(vim, 0, vim.getPosition()));
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        Evaluator sourceConfigFile = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                if (command.isEmpty()) {
                    vim.getUserInterfaceService().setErrorMessage("Argument required");
                    return null;
                }
                String filename = command.poll();
                if (!vim.sourceConfigurationFile(filename)) {
                    vim.getUserInterfaceService().setErrorMessage("Can't open file " + filename);
                }
                return null;
            }
        };
        Evaluator startInsert = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                try {
                    if (!command.isEmpty() && command.poll().equals("!")) {
                        new ChangeToInsertModeCommand(new MotionCommand(MoveRight.INSTANCE)).execute(vim);
                    } else {
                        new ChangeToInsertModeCommand().execute(vim);
                    }
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        Evaluator registers = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                try {
                    String names = "";
                    while (command.size() > 0) {
                        names = String.valueOf(names) + command.poll();
                    }
                    new ListRegistersCommand(names).execute(vim);
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        Evaluator marks = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                try {
                    String names = "";
                    while (command.size() > 0) {
                        names = String.valueOf(names) + command.poll();
                    }
                    new ListMarksCommand(names).execute(vim);
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        Evaluator delmarks = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                if (command.isEmpty()) {
                    vim.getUserInterfaceService().setErrorMessage("Argument required");
                }
                try {
                    new DeleteMarksCommand(command).execute(vim);
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        LetExpressionEvaluator let = new LetExpressionEvaluator();
        Evaluator userCommand = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                if (command.isEmpty()) {
                    try {
                        new ListUserCommandsCommand().execute(vim);
                    }
                    catch (CommandExecutionException e) {
                        vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                    }
                    return null;
                }
                String name = command.poll();
                if (Character.isLowerCase(name.charAt(0))) {
                    vim.getUserInterfaceService().setErrorMessage("User defined commands must start with an uppercase letter");
                    return null;
                }
                if (command.isEmpty()) {
                    try {
                        new ListUserCommandsCommand(name).execute(vim);
                    }
                    catch (CommandExecutionException e) {
                        vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                    }
                    return null;
                }
                String args = "";
                while (command.size() > 0) {
                    args = String.valueOf(args) + command.poll() + " ";
                }
                vim.getPlatformSpecificStateProvider().getCommands().addUserDefined(name, args);
                return null;
            }
        };
        Evaluator normal = new Evaluator(){

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                try {
                    StringBuilder args = new StringBuilder();
                    if (command.size() > 0) {
                        args.append(command.poll());
                    }
                    while (command.size() > 0) {
                        args.append(' ').append(command.poll());
                    }
                    TextRange nativeSelection = vim.getNativeSelection();
                    SimpleLineRange range = nativeSelection.getModelLength() > 0 && SelectionService.VRAPPER_SELECTION_ACTIVE.equals(nativeSelection) ? SimpleLineRange.fromSelection(vim, vim.getSelection()) : (nativeSelection.getModelLength() > 0 ? SimpleLineRange.fromTextRange(vim, nativeSelection) : SimpleLineRange.singleLine(vim, vim.getPosition()));
                    new AnonymousMacroOperation(args.toString()).execute(vim, range);
                }
                catch (CommandExecutionException e) {
                    vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                }
                return null;
            }
        };
        EvaluatorMapping mapping = new EvaluatorMapping();
        mapping.add("se", CommandLineParser.buildConfigEvaluator(false));
        mapping.add("set", CommandLineParser.buildConfigEvaluator(false));
        mapping.add("setlocal", CommandLineParser.buildConfigEvaluator(true));
        mapping.add("so", sourceConfigFile);
        mapping.add("source", sourceConfigFile);
        mapping.add("let", let);
        mapping.add("w", save);
        mapping.add("wall", saveAll);
        mapping.add("wqall", saveAndCloseAll);
        mapping.add("xall", saveAndCloseAll);
        mapping.add("xa", saveAndCloseAll);
        mapping.add("update", save);
        mapping.add("wq", saveAndClose);
        mapping.add("x", saveAndClose);
        mapping.add("q", quit);
        mapping.add("bdelete", quit);
        mapping.add("qall", quitAll);
        mapping.add("quitall", quitAll);
        mapping.add("only", quitOthers);
        mapping.add("tabonly", quitOthers);
        mapping.add("command", userCommand);
        mapping.add("noremap", noremap);
        mapping.add("no", noremap);
        mapping.add("nnoremap", nnoremap);
        mapping.add("nn", nnoremap);
        mapping.add("onoremap", onoremap);
        mapping.add("ono", onoremap);
        mapping.add("inoremap", inoremap);
        mapping.add("ino", inoremap);
        mapping.add("cno", cnoremap);
        mapping.add("cnoremap", cnoremap);
        mapping.add("canoremap", canoremap);
        mapping.add("cano", canoremap);
        mapping.add("vnoremap", vnoremap);
        mapping.add("vn", vnoremap);
        mapping.add("map", map);
        mapping.add("nmap", nmap);
        mapping.add("nm", nmap);
        mapping.add("omap", omap);
        mapping.add("om", omap);
        mapping.add("imap", imap);
        mapping.add("im", imap);
        mapping.add("cm", cmap);
        mapping.add("cmap", cmap);
        mapping.add("camap", camap);
        mapping.add("cam", camap);
        mapping.add("vmap", vmap);
        mapping.add("vm", vmap);
        mapping.add("unmap", unmap);
        mapping.add("unm", unmap);
        mapping.add("nunmap", nunmap);
        mapping.add("nun", nunmap);
        mapping.add("ounmap", ounmap);
        mapping.add("oun", ounmap);
        mapping.add("vunmap", vunmap);
        mapping.add("vu", vunmap);
        mapping.add("iunmap", iunmap);
        mapping.add("iu", iunmap);
        mapping.add("mapclear", clear);
        mapping.add("mapc", clear);
        mapping.add("nmapclear", nclear);
        mapping.add("nmapc", nclear);
        mapping.add("omapclear", oclear);
        mapping.add("omapc", oclear);
        mapping.add("vmapclear", vclear);
        mapping.add("vmapc", vclear);
        mapping.add("imapclear", iclear);
        mapping.add("imapc", iclear);
        UndoCommand undo = UndoCommand.INSTANCE;
        RedoCommand redo = RedoCommand.INSTANCE;
        mapping.add("red", redo);
        mapping.add("redo", redo);
        mapping.add("undo", undo);
        mapping.add("u", undo);
        mapping.add("$", new CommandWrapper(gotoEOF));
        mapping.add("nohlsearch", nohlsearch);
        mapping.add("nohls", nohlsearch);
        mapping.add("noh", nohlsearch);
        mapping.add("pwd", printWorkingDir);
        mapping.add("edit", editFile);
        mapping.add("new", editFile);
        mapping.add("vim", OpenInGvimCommand.INSTANCE);
        mapping.add("find", findFile);
        mapping.add("tabfind", findFile);
        mapping.add("cd", chDir);
        mapping.add("sort", sort);
        mapping.add("retab", retab);
        mapping.add("ascii", ascii);
        mapping.add("normal", normal);
        mapping.add("startinsert", startInsert);
        mapping.add("registers", registers);
        mapping.add("display", registers);
        mapping.add("marks", marks);
        mapping.add("delmarks", delmarks);
        mapping.add("ls", new CommandWrapper(ListBuffersCommand.INSTANCE));
        mapping.add("buffers", new CommandWrapper(ListBuffersCommand.INSTANCE));
        return mapping;
    }

    private static Evaluator buildConfigEvaluator(boolean local) {
        PrintOptionCommand<Object> status;
        ComplexOptionEvaluator ev = local ? new ComplexLocalOptionEvaluator() : new ComplexOptionEvaluator();
        EvaluatorMapping config = new EvaluatorMapping(ev);
        for (Configuration.Option<Boolean> option : Options.BOOLEAN_OPTIONS) {
            ConfigCommand toggle;
            ConfigCommand disable;
            ConfigCommand enable;
            if (local) {
                enable = new SetLocalOptionCommand<Boolean>(option, Boolean.TRUE);
                disable = new SetLocalOptionCommand<Boolean>(option, Boolean.FALSE);
                toggle = new ToggleLocalOptionCommand(option);
            } else {
                enable = new SetOptionCommand<Boolean>(option, Boolean.TRUE);
                disable = new SetOptionCommand<Boolean>(option, Boolean.FALSE);
                toggle = new ToggleOptionCommand(option);
            }
            PrintOptionCommand<Boolean> status2 = new PrintOptionCommand<Boolean>(option);
            for (String alias : option.getAllNames()) {
                config.add(alias, enable);
                config.add("no" + alias, disable);
                config.add(String.valueOf(alias) + "!", toggle);
                config.add(String.valueOf(alias) + "?", status2);
            }
        }
        for (Configuration.Option<Comparable<Boolean>> option : Options.INT_OPTIONS) {
            status = new PrintOptionCommand<Comparable<Boolean>>(option);
            for (String alias : option.getAllNames()) {
                config.add(String.valueOf(alias) + "?", status);
            }
        }
        for (Configuration.Option<Object> option : Options.STRING_OPTIONS) {
            status = new PrintOptionCommand<Object>(option);
            for (String alias : option.getAllNames()) {
                config.add(String.valueOf(alias) + "?", status);
            }
        }
        for (Configuration.Option<Object> option : Options.STRINGSET_OPTIONS) {
            status = new PrintOptionCommand<Object>(option);
            for (String alias : option.getAllNames()) {
                config.add(String.valueOf(alias) + "?", status);
            }
        }
        CommandLineParser.addActionsToBooleanOption(config, Options.GLOBAL_REGISTERS, ConfigAction.GLOBAL_REGISTERS, ConfigAction.NO_GLOBAL_REGISTERS);
        return config;
    }

    private static void addActionsToBooleanOption(EvaluatorMapping config, Configuration.Option<Boolean> option, ConfigAction enable, ConfigAction disable) {
        OptionDependentEvaluator toggle = new OptionDependentEvaluator(option, disable, enable);
        for (String alias : option.getAllNames()) {
            config.add(alias, enable);
            config.add("no" + alias, disable);
            config.add(String.valueOf(alias) + "!", toggle);
        }
    }

    public CommandLineParser(EditorAdaptor vim, EvaluatorMapping commands) {
        super(vim);
        this.mapping = commands;
        this.tabComplete = new FilePathTabCompletion(vim);
    }

    @Override
    public void setFromVisual(boolean isFromVisual) {
        super.setFromVisual(isFromVisual);
        if (isFromVisual) {
            this.commandLine.resetContents("'<,'>");
        }
    }

    private boolean patternMatch(Pattern pattern, String input) {
        this.matcher = pattern.matcher(input);
        return this.matcher.find();
    }

    private int getMatcherLength(int group) {
        if (this.matcher == null) {
            return 0;
        }
        return this.matcher.end(group) - this.matcher.start(group);
    }

    @Override
    protected String completeArgument(String commandLineContents, KeyStroke e) {
        int cmdLen = 0;
        boolean paths = false;
        boolean dirsOnly = false;
        if (this.patternMatch(EDIT_CMD_PATTERN, commandLineContents.toString())) {
            cmdLen = this.getMatcherLength(0);
        } else if (this.patternMatch(FIND_CMD_PATTERN, commandLineContents.toString()) || this.patternMatch(TABF_CMD_PATTERN, commandLineContents.toString())) {
            cmdLen = this.getMatcherLength(0);
            paths = true;
        } else if (this.patternMatch(CD_CMD_PATTERN, commandLineContents.toString())) {
            cmdLen = this.getMatcherLength(0);
            dirsOnly = true;
        } else if (this.patternMatch(SPLIT_CMD_PATTERN, commandLineContents.toString())) {
            cmdLen = this.getMatcherLength(0);
        } else if (this.patternMatch(VSPLIT_CMD_PATTERN, commandLineContents.toString())) {
            cmdLen = this.getMatcherLength(0);
        }
        if (cmdLen > 0) {
            String cmd = commandLineContents.substring(0, cmdLen);
            String prefix = commandLineContents.substring(cmdLen);
            prefix = this.tabComplete.getNextMatch(prefix, paths, dirsOnly, e.withShiftKey());
            return String.valueOf(cmd) + prefix;
        }
        this.commandLine.type("\t");
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Command parseAndExecute(String first, String command) {
        block40: {
            block39: {
                this.editor.getRegisterManager().setLastCommand(String.valueOf(first) + command + "<cr>");
                if (first != null) {
                    while (command.startsWith(first)) {
                        command = command.substring(1);
                    }
                }
                if (command.indexOf(" | ") > -1 && !command.startsWith("com")) {
                    block38: {
                        commands = command.split(" | ");
                        this.editor.getHistory().beginCompoundChange();
                        this.editor.getHistory().lock("chained-commands");
                        performedChain = false;
                        try {
                            var9_8 = commands;
                            var8_9 = commands.length;
                            var7_12 = 0;
                            while (var7_12 < var8_9) {
                                chainCommand = var9_8[var7_12];
                                if (!"|".equals(chainCommand)) {
                                    c = this.parseAndExecute(first, chainCommand);
                                    if (c == null) break;
                                    c.execute(this.editor);
                                    performedChain = true;
                                }
                                ++var7_12;
                            }
                        }
                        catch (CommandExecutionException e) {
                            if (performedChain) {
                                this.editor.getUserInterfaceService().setErrorMessage(e.getMessage());
                            }
                            this.editor.getHistory().unlock("chained-commands");
                            this.editor.getHistory().endCompoundChange();
                            break block38;
                        }
                        catch (NullPointerException v0) {
                            try {
                                break block38;
                            }
                            catch (Throwable var10_18) {
                                throw var10_18;
                            }
                            finally {
                                this.editor.getHistory().unlock("chained-commands");
                                this.editor.getHistory().endCompoundChange();
                            }
                        }
                        this.editor.getHistory().unlock("chained-commands");
                        this.editor.getHistory().endCompoundChange();
                    }
                    if (!performedChain) break block39;
                    return null;
                }
            }
            try {
                line = Integer.parseInt(command);
                return new MotionCommand((Motion)GoToLineMotion.FIRST_LINE.withCount(line));
            }
            catch (NumberFormatException v1) {
                if (AutoCmdParser.INSTANCE.validate(this.editor, command)) {
                    AutoCmdParser.INSTANCE.parse(this.editor, command);
                    if (AutoCmdParser.INSTANCE.getCommand() != null) {
                        command = AutoCmdParser.INSTANCE.getCommand();
                    } else {
                        return AutoCmdParser.INSTANCE;
                    }
                }
                if (LineRangeOperationCommand.isCurrentLineOperation(command)) {
                    return new LineRangeOperationCommand("." + command);
                }
                platformCommands = this.editor.getPlatformSpecificStateProvider().getCommands();
                if (command.length() <= 1 || !LineRangeOperationCommand.isLineRangeOperation(command)) break block40;
                rangeOp = new LineRangeOperationCommand(command);
                nizer = new StringTokenizer(rangeOp.getOperationStr());
                tokens = new LinkedList<String>();
                ** while (nizer.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                tokens.add(nizer.nextToken().trim());
                continue;
            }
lbl69:
            // 1 sources

            if (platformCommands != null && platformCommands.contains((String)tokens.peek())) {
                return new RunSelectionAwareEvaluatorCommand(rangeOp, platformCommands, tokens, this.isFromVisual());
            }
            if (this.mapping != null && this.mapping.contains((String)tokens.peek())) {
                return new RunSelectionAwareEvaluatorCommand(rangeOp, this.mapping, tokens, this.isFromVisual());
            }
            return rangeOp;
        }
        if (command.startsWith("/") || command.startsWith("?")) {
            return new ExSearchCommand("" + command.charAt(0), command.substring(1));
        }
        substitution = this.parseSubstitution(command);
        if (substitution != null) {
            return substitution;
        }
        if (command.length() > 1 && (command.startsWith("g") || command.startsWith("v")) && VimUtils.isPatternDelimiter("" + command.charAt(1))) {
            return new TextOperationTextObjectCommand(new ExCommandOperation(command), new DummyTextObject(null));
        }
        if (ReadExternalOperation.isValid(this.editor, command)) {
            return new LineRangeOperationCommand("." + command);
        }
        nizer = new StringTokenizer(command);
        tokens = new LinkedList<E>();
        while (nizer.hasMoreTokens()) {
            tokens.add(nizer.nextToken().trim());
        }
        if (tokens.isEmpty()) {
            return null;
        }
        if (tokens.peek().endsWith("!")) {
            tok = tokens.poll();
            if (tokens.isEmpty()) {
                tokens.add(tok.substring(0, tok.length() - 1));
                tokens.add("!");
            } else {
                tokens.add(0, tok.substring(0, tok.length() - 1));
                tokens.add(1, "!");
            }
        }
        if ((switchBuffer = this.parseSwitchBufferCommand(tokens)) != null) {
            return switchBuffer;
        }
        if (platformCommands != null && platformCommands.contains(tokens.peek())) {
            return new RunEvaluatorCommand(platformCommands, tokens);
        }
        if (this.mapping != null && this.mapping.contains(tokens.peek())) {
            return new RunEvaluatorCommand(this.mapping, tokens);
        }
        if (platformCommands != null && (commandName = platformCommands.getNameFromPartial(tokens.peek())) != null) {
            tokens.set(0, commandName);
            return new RunEvaluatorCommand(platformCommands, tokens);
        }
        if (this.mapping != null && (commandName = this.mapping.getNameFromPartial(tokens.peek())) != null) {
            tokens.set(0, commandName);
            return new RunEvaluatorCommand(this.mapping, tokens);
        }
        this.editor.getUserInterfaceService().setErrorMessage("Not an editor command: " + tokens.peek());
        return null;
    }

    private Command parseSubstitution(String command) {
        if (command.equals("s")) {
            return RepeatLastSubstitutionCommand.CURRENT_LINE_ONLY;
        }
        if (command.startsWith("s") && VimUtils.isPatternDelimiter("" + command.charAt(1))) {
            SubstitutionDefinition subDef;
            try {
                subDef = new SubstitutionDefinition(command, this.editor.getRegisterManager());
            }
            catch (IllegalArgumentException e) {
                return new DummyCommand(e.getMessage());
            }
            if (subDef.hasFlag('c')) {
                int line = this.editor.getModelContent().getLineInformationOfOffset(this.editor.getCursorService().getPosition().getModelOffset()).getNumber();
                return new ChangeModeCommand("confirm substitution mode", new ConfirmSubstitutionMode.SubstitutionConfirm(subDef, line, line));
            }
            return new TextOperationTextObjectCommand(new SubstitutionOperation(subDef), new DummyTextObject(null));
        }
        return null;
    }

    private Command parseSwitchBufferCommand(LinkedList<String> originalTokens) {
        LinkedList<String> tokens = new LinkedList<String>(originalTokens);
        tokens.remove("!");
        String cmdStr = tokens.peek();
        Matcher bufferPrefixMatcher = SwitchBufferCommand.BUFFER_CMD_PATTERN.matcher(cmdStr);
        if (bufferPrefixMatcher.lookingAt()) {
            if (bufferPrefixMatcher.end() < cmdStr.length()) {
                String cmdRemaining = cmdStr.substring(bufferPrefixMatcher.end());
                Matcher glued = SwitchBufferCommand.BUFFER_CMD_GLUED_ARG_PATTERN.matcher(cmdRemaining);
                if (glued.matches()) {
                    if (glued.groupCount() == 1 && glued.group(1) != null) {
                        return new SwitchBufferCommand(glued.group(1));
                    }
                    if (cmdRemaining.endsWith("#")) {
                        return SwitchBufferCommand.INSTANCE;
                    }
                    return new SwitchBufferCommand("%");
                }
                return null;
            }
            if (tokens.size() <= 1) {
                return new SwitchBufferCommand("%");
            }
            return new SwitchBufferCommand(tokens.get(1));
        }
        return null;
    }

    private static enum ConfigAction implements Evaluator
    {
        GLOBAL_REGISTERS{

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                vim.getConfiguration().set(Options.GLOBAL_REGISTERS, Boolean.TRUE);
                vim.useGlobalRegisters();
                return null;
            }
        }
        ,
        NO_GLOBAL_REGISTERS{

            @Override
            public Object evaluate(EditorAdaptor vim, Queue<String> command) {
                vim.getConfiguration().set(Options.GLOBAL_REGISTERS, Boolean.FALSE);
                vim.useLocalRegisters();
                return null;
            }
        };

    }

    private static class EvaluatorWithExclaim
    implements Evaluator {
        Command without;
        Command with;

        private EvaluatorWithExclaim(Command withoutExclaim, Command withExclaim) {
            this.without = withoutExclaim;
            this.with = withExclaim;
        }

        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) {
            try {
                if (!command.isEmpty() && command.peek().endsWith("!")) {
                    this.with.execute(vim);
                } else {
                    this.without.execute(vim);
                }
            }
            catch (CommandExecutionException e) {
                vim.getUserInterfaceService().setErrorMessage(e.getMessage());
            }
            return null;
        }
    }

    private static class OptionDependentEvaluator
    implements Evaluator {
        private final Configuration.Option<Boolean> option;
        private final Evaluator onTrue;
        private final Evaluator onFalse;

        private OptionDependentEvaluator(Configuration.Option<Boolean> option, Evaluator onTrue, Evaluator onFalse) {
            this.option = option;
            this.onTrue = onTrue;
            this.onFalse = onFalse;
        }

        @Override
        public Object evaluate(EditorAdaptor vim, Queue<String> command) throws CommandExecutionException {
            return vim.getConfiguration().get(this.option) != false ? this.onTrue.evaluate(vim, command) : this.onFalse.evaluate(vim, command);
        }
    }

    public class RunEvaluatorCommand
    implements Command {
        private Evaluator mappping = null;
        private Queue<String> tokens = null;

        public RunEvaluatorCommand(Evaluator mappping, Queue<String> tokens) {
            this.mappping = mappping;
            this.tokens = tokens;
        }

        @Override
        public Command repetition() {
            return null;
        }

        @Override
        public Command withCount(int count) {
            return null;
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            this.mappping.evaluate(editorAdaptor, this.tokens);
        }
    }

    class RunSelectionAwareEvaluatorCommand
    implements Command {
        private LineRangeOperationCommand range = null;
        private Evaluator action = null;
        private Queue<String> tokens = null;
        private boolean isFromVisual;

        public RunSelectionAwareEvaluatorCommand(LineRangeOperationCommand range, Evaluator action, Queue<String> tokens, boolean isFromVisual) {
            this.range = range;
            this.action = action;
            this.tokens = tokens;
            this.isFromVisual = isFromVisual;
        }

        @Override
        public Command repetition() {
            return null;
        }

        @Override
        public Command withCount(int count) {
            return null;
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
            boolean linewise = !this.isFromVisual || editorAdaptor.getSelection().getContentType(editorAdaptor.getConfiguration()) == ContentType.LINES;
            LineRange lineRange = this.range.parseRangeDefinition(editorAdaptor);
            TextRange selectionRange = lineRange == null ? null : (linewise ? lineRange.getRegion(editorAdaptor, 0) : StartEndTextRange.exclusive(lineRange.getFrom(), lineRange.getTo()));
            editorAdaptor.setNativeSelection(selectionRange);
            this.action.evaluate(editorAdaptor, this.tokens);
            editorAdaptor.setSelection(null);
        }
    }
}

