/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.vim.modes.commandline;

import java.util.LinkedList;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.Search;
import net.sourceforge.vrapper.utils.SearchOffset;
import net.sourceforge.vrapper.utils.SearchResult;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.ConfigurationListener;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.ExecuteCommandHint;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.commandline.AbstractCommandLineMode;
import net.sourceforge.vrapper.vim.modes.commandline.AbstractCommandParser;
import net.sourceforge.vrapper.vim.modes.commandline.HighlightSearch;
import net.sourceforge.vrapper.vim.modes.commandline.SearchCommandParser;

public class SearchMode
extends AbstractCommandLineMode {
    public static final String NAME = "search mode";
    public static final String DISPLAY_NAME = "SEARCH";
    private Boolean forward;
    private Position startPos;
    private int originalTopLine;
    private Command command;
    private SearchCommandParser searchParser;

    public SearchMode(EditorAdaptor editorAdaptor) {
        super(editorAdaptor);
        editorAdaptor.getConfiguration().addListener(new SearchConfigurationListener(editorAdaptor));
    }

    @Override
    public void enterMode(ModeSwitchHint ... args) throws CommandExecutionException {
        this.forward = null;
        this.command = null;
        ModeSwitchHint[] modeSwitchHintArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ModeSwitchHint hint = modeSwitchHintArray[n2];
            if (hint instanceof Direction) {
                this.forward = hint.equals(Direction.FORWARD);
            } else if (hint instanceof ExecuteCommandHint.OnLeave) {
                this.command = ((ExecuteCommandHint.OnLeave)hint).getCommand();
            }
            ++n2;
        }
        if (this.forward == null || this.command == null) {
            throw new CommandExecutionException("Wrong number of hints passed to search mode!");
        }
        this.startPos = this.editorAdaptor.getCursorService().getPosition();
        this.originalTopLine = this.editorAdaptor.getViewportService().getViewPortInformation().getTopLine();
        this.searchParser = new SearchCommandParser(this.editorAdaptor, this.command);
        super.enterMode(args);
    }

    @Override
    protected AbstractCommandParser createParser() {
        return this.searchParser;
    }

    @Override
    public boolean handleKey(KeyStroke stroke) {
        boolean incsearch = this.editorAdaptor.getConfiguration().get(Options.INCREMENTAL_SEARCH);
        if (incsearch && (stroke.equals(AbstractCommandParser.KEY_RETURN) || stroke.equals(AbstractCommandParser.KEY_ESCAPE))) {
            this.resetIncSearch();
        }
        super.handleKey(stroke);
        if (incsearch && this.isEnabled) {
            this.doIncSearch();
        }
        return true;
    }

    private void resetIncSearch() {
        this.editorAdaptor.getSearchAndReplaceService().removeIncSearchHighlighting();
        this.editorAdaptor.getCursorService().setPosition(this.startPos, StickyColumnPolicy.NEVER);
        this.editorAdaptor.getViewportService().setTopLine(this.originalTopLine);
    }

    private void doIncSearch() {
        SearchResult res;
        String keyword = this.searchParser.getKeyWord();
        Search s = SearchCommandParser.createSearch(this.editorAdaptor, keyword, this.forward == false, SearchOffset.NONE);
        CursorService cursorService = this.editorAdaptor.getCursorService();
        int fixedPos = this.startPos.getModelOffset() + (this.forward != false ? 1 : -1);
        Position startSearchPos = cursorService.newPositionForModelOffset(fixedPos, this.startPos, true);
        try {
            res = VimUtils.wrapAroundSearch(this.editorAdaptor, s, startSearchPos);
        }
        catch (VrapperPlatformException vrapperPlatformException) {
            this.resetIncSearch();
            return;
        }
        boolean fromVisual = this.parser.isFromVisual();
        if (res.isFound()) {
            MotionCommand.gotoAndChangeViewPort(this.editorAdaptor, res.getStart(), StickyColumnPolicy.NEVER);
            if (fromVisual) {
                Selection lastSel = this.editorAdaptor.getLastActiveSelection();
                Selection updated = lastSel.reset(this.editorAdaptor, lastSel.getFrom(), res.getStart());
                this.editorAdaptor.setSelection(updated);
            } else {
                SearchAndReplaceService sars = this.editorAdaptor.getSearchAndReplaceService();
                sars.incSearchhighlight(res.getStart(), res.getModelLength());
            }
        } else {
            this.resetIncSearch();
            if (fromVisual) {
                this.editorAdaptor.setSelection(this.editorAdaptor.getLastActiveSelection());
            }
        }
    }

    @Override
    public String resolveKeyMap(KeyStroke stroke) {
        return "Command Mode Keymap";
    }

    @Override
    protected String getPrompt() {
        return this.forward != false ? "/" : "?";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public static enum Direction implements ModeSwitchHint
    {
        FORWARD,
        BACKWARD;

    }

    protected class SearchConfigurationListener
    implements ConfigurationListener {
        private EditorAdaptor vim;

        public SearchConfigurationListener(EditorAdaptor vim) {
            this.vim = vim;
        }

        @Override
        public <T> void optionChanged(Configuration.Option<T> option, T oldValue, T newValue) {
            Search lastSearch;
            if ((option.equals(Options.SMART_CASE) || option.equals(Options.IGNORE_CASE) || option.equals(Options.SEARCH_HIGHLIGHT) || option.equals(Options.SEARCH_HL_SCOPE) || option.equals(Options.SEARCH_REGEX)) && (lastSearch = this.vim.getRegisterManager().getSearch()) != null) {
                lastSearch = SearchCommandParser.createSearch(this.vim, lastSearch.getKeyword(), lastSearch.isBackward(), lastSearch.getSearchOffset());
                this.vim.getRegisterManager().setSearch(lastSearch);
                if (Options.SEARCH_HIGHLIGHT.equals(option) && Boolean.FALSE.equals(newValue)) {
                    try {
                        HighlightSearch.CLEAR_HIGHLIGHT.evaluate(this.vim, new LinkedList<String>());
                    }
                    catch (CommandExecutionException e) {
                        this.vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                    }
                } else if (this.vim.getConfiguration().get(Options.SEARCH_HIGHLIGHT).booleanValue()) {
                    try {
                        HighlightSearch.HIGHLIGHT.evaluate(this.vim, new LinkedList<String>());
                    }
                    catch (CommandExecutionException e) {
                        this.vim.getUserInterfaceService().setErrorMessage(e.getMessage());
                    }
                }
            }
        }
    }
}

