/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.commands;

import java.util.Arrays;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ChangeTabCommand
extends AbstractCommand {
    private static final int LAST_EDITOR_INDEX = -2147483641;
    public static ChangeTabCommand NEXT_EDITOR = new ChangeTabCommand(true);
    public static ChangeTabCommand PREVIOUS_EDITOR = new ChangeTabCommand(false);
    public static ChangeTabCommand FIRST_EDITOR = new ChangeTabCommand(1);
    public static ChangeTabCommand LAST_EDITOR = new ChangeTabCommand(-2147483641);
    private int count = 0;
    private boolean tabToRight;

    private ChangeTabCommand(boolean toRight) {
        this.tabToRight = toRight;
    }

    private ChangeTabCommand(int count) {
        this.count = count;
    }

    public Command withCount(int count) {
        if (this.tabToRight) {
            return new ChangeTabCommand(count);
        }
        return new ChangeTabCommand(-count);
    }

    public Command repetition() {
        return null;
    }

    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        int targetIndex;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = page.getEditorReferences();
        if (this.count == -2147483641) {
            targetIndex = editorReferences.length - 1;
        } else if (this.count == 0 || this.count < 0) {
            int activeEditorIndex;
            IEditorReference activeEditorRef = null;
            IEditorPart activeEditor = page.getActiveEditor();
            IEditorReference[] activeEditorDuplicates = page.findEditors(activeEditor.getEditorInput(), activeEditor.getSite().getId(), 3);
            int i = 0;
            while (i < activeEditorDuplicates.length) {
                IEditorPart editor = activeEditorDuplicates[i].getEditor(true);
                if (editor.equals(activeEditor)) {
                    activeEditorRef = activeEditorDuplicates[i];
                }
                ++i;
            }
            targetIndex = activeEditorIndex = Arrays.asList(editorReferences).indexOf(activeEditorRef);
            if (activeEditorIndex == -1) {
                throw new CommandExecutionException("Current editor not found");
            }
            targetIndex = this.count < 0 ? (targetIndex += this.count) : (this.tabToRight ? ++targetIndex : --targetIndex);
            if ((targetIndex %= editorReferences.length) < 0) {
                targetIndex += editorReferences.length;
            }
        } else {
            if (this.count > editorReferences.length) {
                throw new CommandExecutionException("Can't switch to tab number '" + this.count + "', only " + editorReferences.length + " tabs open.");
            }
            targetIndex = this.count - 1;
        }
        if (targetIndex >= 0) {
            page.activate(editorReferences[targetIndex].getPart(true));
        }
    }
}

