/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.commands;

import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractCommand;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.LeaveVisualModeCommand;
import net.sourceforge.vrapper.vim.commands.MultipleExecutionCommand;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class EclipseCommand
extends AbstractCommand {
    private final String action;
    private final boolean async;
    private boolean fromVisualMode;

    public EclipseCommand(String action) {
        this.action = action;
        this.async = false;
    }

    public EclipseCommand(String action, boolean async) {
        this.action = action;
        this.async = async;
    }

    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        if (this.fromVisualMode) {
            editorAdaptor.rememberLastActiveSelection();
        }
        EclipseCommand.doIt(this.action, editorAdaptor, this.async);
        if (this.fromVisualMode) {
            LeaveVisualModeCommand.doIt((EditorAdaptor)editorAdaptor);
        }
    }

    public String getCommandName() {
        return this.action;
    }

    public Command repetition() {
        return this;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void doIt(final String action, EditorAdaptor editorAdaptor, boolean async) {
        final IHandlerService handlerService = (IHandlerService)editorAdaptor.getService(IHandlerService.class);
        final ICommandService commandService = (ICommandService)editorAdaptor.getService(ICommandService.class);
        if (handlerService != null && commandService != null) {
            if (async) {
                EclipseCommand.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EclipseCommand.executeAction(action, handlerService, commandService);
                    }
                });
            } else {
                EclipseCommand.executeAction(action, handlerService, commandService);
            }
        } else {
            VrapperLog.error((String)("No handler service, cannot execute: " + action));
        }
    }

    private static void executeAction(String action, IHandlerService handlerService, ICommandService commandService) {
        try {
            ParameterizedCommand command = commandService.deserialize(action);
            handlerService.executeCommand(command, null);
        }
        catch (CommandException e) {
            VrapperLog.error((String)("Command not handled: " + action), (Throwable)e);
        }
    }

    public Command withCount(int count) {
        return new MultipleExecutionCommand(count, (Command)this);
    }

    public Command fromVisualMode(boolean fromVisualMode) {
        this.fromVisualMode = fromVisualMode;
        return this;
    }

    public String toString() {
        return "eclipseCmd(" + this.action + ")";
    }
}

