/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.commands;

import net.sourceforge.vrapper.eclipse.commands.EclipseCommand;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.SelectionService;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.AbstractTextObject;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;

public class EclipseCommandTextObject
extends AbstractTextObject {
    private final String commandName;

    public EclipseCommandTextObject(String commandId) {
        this.commandName = commandId;
    }

    public TextRange getRegion(EditorAdaptor editorAdaptor, int count) throws CommandExecutionException {
        if (count == 0) {
            count = 1;
        }
        int i = 0;
        while (i < count) {
            EclipseCommand.doIt(this.commandName, editorAdaptor, false);
            ++i;
        }
        TextRange result = editorAdaptor.getNativeSelection();
        if (SelectionService.VRAPPER_SELECTION_ACTIVE.equals(result)) {
            result = editorAdaptor.getSelection().getRegion(editorAdaptor, count);
        }
        Position newCarretOffset = editorAdaptor.getPosition();
        editorAdaptor.setPosition(newCarretOffset, StickyColumnPolicy.ON_CHANGE);
        return result;
    }

    public ContentType getContentType(Configuration configuration) {
        return ContentType.TEXT;
    }
}

