/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.commands;

import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.eclipse.interceptor.UnknownEditorException;
import net.sourceforge.vrapper.eclipse.platform.EclipseCursorAndSelection;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.Function;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.Command;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.commands.CountIgnoringNonRepeatableCommand;
import net.sourceforge.vrapper.vim.commands.MotionCommand;
import net.sourceforge.vrapper.vim.commands.motions.GoToMarkMotion;
import net.sourceforge.vrapper.vim.commands.motions.Motion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class GoToMarkCommand
extends CountIgnoringNonRepeatableCommand {
    public static final Function<Command, KeyStroke> LINEWISE_CONVERTER = new Function<Command, KeyStroke>(){

        public Command call(KeyStroke arg) {
            return new GoToMarkCommand(Mode.LINEWISE, String.valueOf(arg.getCharacter()), null);
        }
    };
    public static final Function<Command, KeyStroke> CHARWISE_CONVERTER = new Function<Command, KeyStroke>(){

        public Command call(KeyStroke arg) {
            return new GoToMarkCommand(Mode.CHARWISE, String.valueOf(arg.getCharacter()), null);
        }
    };
    public static final Function<Command, KeyStroke> EDITOR_CONVERTER = new Function<Command, KeyStroke>(){

        public Command call(KeyStroke arg) {
            return new GoToMarkCommand(Mode.EDITOR, String.valueOf(arg.getCharacter()), null);
        }
    };
    private final String id;
    private final Mode mode;

    private GoToMarkCommand(Mode mode, String id) {
        this.id = mode == Mode.EDITOR ? id.toUpperCase() : id;
        this.mode = mode;
    }

    public void execute(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        EditorAdaptor markEditor = editorAdaptor;
        if (editorAdaptor.getCursorService().isGlobalMark(this.id)) {
            markEditor = this.activateOrOpenEditorForMark(editorAdaptor);
        }
        if (markEditor == null) {
            return;
        }
        switch (this.mode) {
            case LINEWISE: {
                new MotionCommand((Motion)new GoToMarkMotion(true, this.id)).execute(markEditor);
                break;
            }
            case CHARWISE: {
                new MotionCommand((Motion)new GoToMarkMotion(false, this.id)).execute(markEditor);
                break;
            }
        }
    }

    private EditorAdaptor activateOrOpenEditorForMark(EditorAdaptor editorAdaptor) throws CommandExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMarker marker = EclipseCursorAndSelection.getGlobalMarker(this.id, (IResource)root);
        if (marker == null) {
            throw new CommandExecutionException("Global mark not set");
        }
        IResource markedResource = marker.getResource();
        IFile markedFile = (IFile)markedResource.getAdapter(IFile.class);
        if (markedFile == null) {
            throw new CommandExecutionException("Global mark " + this.id + " is in file of unknown type");
        }
        IEditorPart editor = this.findEditorForFile(page, markedFile);
        if (editor == null) {
            editor = this.openEditorForMarker(workbench, page, markedFile);
        }
        page.activate((IWorkbenchPart)editor);
        InputInterceptor interceptor = null;
        try {
            interceptor = VrapperPlugin.getDefault().findActiveInterceptor(editor);
        }
        catch (VrapperPlatformException e) {
            VrapperLog.error((String)("Failed to activate editor for mark " + this.id + "."), (Throwable)e);
        }
        catch (UnknownEditorException e) {
            VrapperLog.info((String)("Failed to activate editor for mark " + this.id + ". Error: " + e));
        }
        if (interceptor == null) {
            return null;
        }
        return interceptor.getEditorAdaptor();
    }

    private IEditorPart findEditorForFile(IWorkbenchPage page, IFile markedFile) {
        FileEditorInput needleInput = new FileEditorInput(markedFile);
        IEditorReference[] references = page.findEditors((IEditorInput)needleInput, null, 1);
        if (references.length > 0) {
            return references[0].getEditor(true);
        }
        return null;
    }

    private IEditorPart openEditorForMarker(IWorkbench workbench, IWorkbenchPage page, IFile markedFile) throws CommandExecutionException {
        IEditorPart editor;
        FileEditorInput editorInput = new FileEditorInput(markedFile);
        String fileName = markedFile.getName();
        IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(fileName);
        try {
            editor = desc == null ? page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor") : page.openEditor((IEditorInput)editorInput, desc.getId());
        }
        catch (PartInitException e) {
            VrapperLog.error((String)("Failed to open file " + markedFile.getFullPath()), (Throwable)e);
            throw new CommandExecutionException("Could not open editor for " + markedFile.getProjectRelativePath());
        }
        return editor;
    }

    /* synthetic */ GoToMarkCommand(Mode mode, String string, GoToMarkCommand goToMarkCommand) {
        this(mode, string);
    }

    public static enum Mode {
        LINEWISE,
        CHARWISE,
        EDITOR;

    }
}

