/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.eclipse.extractor.EditorExtractor;
import net.sourceforge.vrapper.eclipse.interceptor.BufferInfo;
import net.sourceforge.vrapper.eclipse.interceptor.BufferManager;
import net.sourceforge.vrapper.eclipse.interceptor.CaretPositionHandler;
import net.sourceforge.vrapper.eclipse.interceptor.CaretPositionUndoHandler;
import net.sourceforge.vrapper.eclipse.interceptor.EditorInfo;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptorFactory;
import net.sourceforge.vrapper.eclipse.interceptor.ProcessedInfo;
import net.sourceforge.vrapper.eclipse.interceptor.SelectionVisualHandler;
import net.sourceforge.vrapper.eclipse.interceptor.UnknownEditorException;
import net.sourceforge.vrapper.eclipse.interceptor.VimInputInterceptorFactory;
import net.sourceforge.vrapper.eclipse.platform.EclipseBufferAndTabService;
import net.sourceforge.vrapper.eclipse.platform.EclipseCursorAndSelection;
import net.sourceforge.vrapper.eclipse.utils.Utils;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.PlatformVrapperLifecycleListener;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.ModeSwitchHint;
import net.sourceforge.vrapper.vim.modes.NormalMode;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class InputInterceptorManager
implements IPartListener2,
IPageChangedListener,
BufferManager {
    public static final InputInterceptorManager INSTANCE = new InputInterceptorManager(VimInputInterceptorFactory.INSTANCE);
    private static final Method METHOD_GET_PAGE_COUNT = InputInterceptorManager.getMultiPartEditorMethod("getPageCount", new Class[0]);
    private static final Method METHOD_GET_EDITOR = InputInterceptorManager.getMultiPartEditorMethod("getEditor", Integer.TYPE);
    private final InputInterceptorFactory factory;
    private Map<IWorkbenchWindow, EclipseBufferAndTabService> bufferAndTabServices;
    private final Map<IWorkbenchPart, InputInterceptor> interceptors;
    private final Map<IWorkbenchPart, EditorInfo> toplevelEditorInfo;
    private boolean activationListenerEnabled = true;
    protected WeakHashMap<IEditorReference, BufferInfo> reservedBufferIdMapping = new WeakHashMap();
    protected WeakHashMap<IEditorInput, BufferInfo> activeBufferIdMapping = new WeakHashMap();
    protected List<PlatformVrapperLifecycleListener> lifecycleListeners = Collections.emptyList();
    protected static final AtomicInteger BUFFER_ID_SEQ = new AtomicInteger();

    protected InputInterceptorManager(InputInterceptorFactory factory) {
        this.factory = factory;
        this.bufferAndTabServices = new WeakHashMap<IWorkbenchWindow, EclipseBufferAndTabService>();
        this.interceptors = new WeakHashMap<IWorkbenchPart, InputInterceptor>();
        this.toplevelEditorInfo = new WeakHashMap<IWorkbenchPart, EditorInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("net.sourceforge.vrapper.eclipse.lifecyclelistener");
        ArrayList<PlatformVrapperLifecycleListener> matched = new ArrayList<PlatformVrapperLifecycleListener>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String listenerClass = element.getAttribute("listener-class");
            try {
                matched.add((PlatformVrapperLifecycleListener)element.createExecutableExtension("listener-class"));
            }
            catch (Exception e) {
                VrapperLog.error((String)("error while building vrapper lifecycle listener " + listenerClass), (Throwable)e);
            }
            ++n2;
        }
        this.lifecycleListeners = matched;
    }

    public EclipseBufferAndTabService ensureBufferService(IEditorPart editor) {
        IWorkbenchWindow window = editor.getEditorSite().getWorkbenchWindow();
        EclipseBufferAndTabService batservice = this.bufferAndTabServices.get(window);
        if (batservice == null) {
            batservice = new EclipseBufferAndTabService(window, this);
            this.bufferAndTabServices.put(window, batservice);
        }
        return batservice;
    }

    public void interceptWorkbenchPart(EditorInfo nestingInfo, ProcessedInfo processedInfo) {
        this.registerEditorPart(nestingInfo, false);
        IEditorPart part = nestingInfo.getCurrent();
        if (part instanceof AbstractTextEditor) {
            AbstractTextEditor editor = (AbstractTextEditor)part;
            this.interceptAbstractTextEditor(editor, nestingInfo);
        } else if (part instanceof MultiPageEditorPart) {
            try {
                MultiPageEditorPart mPart = (MultiPageEditorPart)part;
                int pageCount = (Integer)METHOD_GET_PAGE_COUNT.invoke((Object)part, new Object[0]);
                int i = 0;
                while (i < pageCount) {
                    IEditorPart subPart = (IEditorPart)METHOD_GET_EDITOR.invoke((Object)mPart, i);
                    if (subPart != null && !processedInfo.isProcessed((IWorkbenchPart)subPart) && subPart != null) {
                        this.interceptWorkbenchPart(nestingInfo.createChildInfo(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                VrapperLog.error((String)"Exception during opening of MultiPageEditorPart", (Throwable)exception);
            }
        } else if (part instanceof MultiEditor) {
            IEditorPart[] iEditorPartArray = ((MultiEditor)part).getInnerEditors();
            int i = iEditorPartArray.length;
            int pageCount = 0;
            while (pageCount < i) {
                IEditorPart subPart = iEditorPartArray[pageCount];
                if (subPart != null && !processedInfo.isProcessed((IWorkbenchPart)subPart)) {
                    this.interceptWorkbenchPart(nestingInfo.createChildInfo(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                }
                ++pageCount;
            }
        } else {
            IConfigurationElement[] configurationElements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor("net.sourceforge.vrapper.eclipse.extractor");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                EditorExtractor extractor = (EditorExtractor)Utils.createGizmoForElementConditionally((IWorkbenchPart)part, "part-must-subclass", element, "extractor-class");
                if (extractor != null) {
                    for (AbstractTextEditor ate : extractor.extractATEs(nestingInfo)) {
                        this.interceptAbstractTextEditor(ate, nestingInfo);
                        this.registerEditorPart(nestingInfo, false);
                    }
                }
                ++n2;
            }
        }
    }

    private void interceptAbstractTextEditor(AbstractTextEditor editor, EditorInfo partInfo) {
        if (this.interceptors.containsKey(editor)) {
            return;
        }
        try {
            Method me = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            me.setAccessible(true);
            Object viewer = me.invoke((Object)editor, new Object[0]);
            if (viewer != null) {
                ISourceViewer srcViewer = (ISourceViewer)viewer;
                ITextViewerExtension textViewerExt = (ITextViewerExtension)viewer;
                EclipseBufferAndTabService batService = this.ensureBufferService((IEditorPart)editor);
                InputInterceptor interceptor = this.factory.createInterceptor(editor, srcViewer, partInfo, batService, this.lifecycleListeners);
                CaretPositionHandler caretPositionHandler = interceptor.getCaretPositionHandler();
                CaretPositionUndoHandler caretPositionUndoHandler = interceptor.getCaretPositionUndoHandler();
                SelectionVisualHandler visualHandler = interceptor.getSelectionVisualHandler();
                EclipseCursorAndSelection selectionSvc = interceptor.getPlatform().getSelectionService();
                textViewerExt.prependVerifyKeyListener((VerifyKeyListener)interceptor);
                srcViewer.getTextWidget().addMouseListener((MouseListener)caretPositionHandler);
                srcViewer.getTextWidget().addCaretListener((CaretListener)caretPositionHandler);
                srcViewer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)visualHandler);
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.addOperationHistoryListener((IOperationHistoryListener)caretPositionUndoHandler);
                selectionSvc.installHooks();
                for (PlatformVrapperLifecycleListener listener : this.lifecycleListeners) {
                    try {
                        listener.editorInitialized(interceptor.getEditorAdaptor(), VrapperPlugin.isVrapperEnabled());
                    }
                    catch (Exception e) {
                        String currentFilePath = interceptor.getPlatform().getFileService().getCurrentFilePath();
                        VrapperLog.error((String)("Lifecycle listener " + listener.getClass() + "' threw " + "exception for file '" + currentFilePath + "' when firing " + "'editorInitialized' method."), (Throwable)e);
                    }
                }
                this.interceptors.put((IWorkbenchPart)editor, interceptor);
            }
        }
        catch (Exception exception) {
            VrapperLog.error((String)"Exception when intercepting AbstractTextEditor", (Throwable)exception);
        }
    }

    public void partClosed(EditorInfo nestingInfo, ProcessedInfo processedInfo) {
        IEditorPart part = nestingInfo.getCurrent();
        InputInterceptor interceptor = this.interceptors.remove(part);
        if (interceptor != null) {
            for (PlatformVrapperLifecycleListener listener : this.lifecycleListeners) {
                try {
                    listener.editorClosing(interceptor.getEditorAdaptor(), VrapperPlugin.isVrapperEnabled());
                }
                catch (Exception e) {
                    String currentFilePath = interceptor.getPlatform().getFileService().getCurrentFilePath();
                    VrapperLog.error((String)("Lifecycle listener " + listener.getClass() + "' threw " + "exception for file '" + currentFilePath + "' when firing " + "editorClosing' method."), (Throwable)e);
                }
            }
            try {
                interceptor.getEditorAdaptor().close();
            }
            catch (Exception exception) {
                VrapperLog.error((String)"Exception while closing EditorAdaptor.", (Throwable)exception);
            }
            try {
                Method me = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
                me.setAccessible(true);
                Object viewer = me.invoke((Object)part, new Object[0]);
                ITextViewer textViewer = (ITextViewer)viewer;
                ITextViewerExtension textViewerExt = (ITextViewerExtension)viewer;
                CaretPositionHandler caretPositionHandler = interceptor.getCaretPositionHandler();
                CaretPositionUndoHandler caretPositionUndoHandler = interceptor.getCaretPositionUndoHandler();
                SelectionVisualHandler visualHandler = interceptor.getSelectionVisualHandler();
                EclipseCursorAndSelection selectionSvc = interceptor.getPlatform().getSelectionService();
                textViewerExt.removeVerifyKeyListener((VerifyKeyListener)interceptor);
                textViewer.getTextWidget().removeCaretListener((CaretListener)caretPositionHandler);
                textViewer.getTextWidget().removeMouseListener((MouseListener)caretPositionHandler);
                textViewer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)visualHandler);
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.removeOperationHistoryListener((IOperationHistoryListener)caretPositionUndoHandler);
                selectionSvc.uninstallHooks();
            }
            catch (Exception exception) {
                VrapperLog.error((String)"Exception during closing IWorkbenchPart", (Throwable)exception);
            }
        }
        if (part instanceof MultiPageEditorPart) {
            try {
                MultiPageEditorPart mPart = (MultiPageEditorPart)part;
                int pageCount = (Integer)METHOD_GET_PAGE_COUNT.invoke((Object)part, new Object[0]);
                int i = 0;
                while (i < pageCount) {
                    IEditorPart subPart = (IEditorPart)METHOD_GET_EDITOR.invoke((Object)mPart, i);
                    if (subPart != null && !processedInfo.isProcessed((IWorkbenchPart)subPart) && nestingInfo.getChild(subPart) != null) {
                        this.partClosed(nestingInfo.getChild(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                VrapperLog.error((String)"Exception during closing MultiPageEditorPart", (Throwable)exception);
            }
        } else if (part instanceof MultiEditor) {
            IEditorPart[] iEditorPartArray = ((MultiEditor)part).getInnerEditors();
            int n = iEditorPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart subPart = iEditorPartArray[n2];
                if (subPart != null && !processedInfo.isProcessed((IWorkbenchPart)subPart)) {
                    this.partClosed(nestingInfo.createChildInfo(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                }
                ++n2;
            }
        }
    }

    public void partActivated(EditorInfo editorInfo, ProcessedInfo processedInfo) {
        IEditorPart part = editorInfo.getCurrent();
        InputInterceptor input = this.interceptors.get(part);
        if (input == null) {
            try {
                if (part instanceof MultiPageEditorPart) {
                    IEditorPart curEditor;
                    MultiPageEditorPart mPart = (MultiPageEditorPart)part;
                    int activePage = mPart.getActivePage();
                    int pageCount = (Integer)METHOD_GET_PAGE_COUNT.invoke((Object)part, new Object[0]);
                    int i = 0;
                    while (i < pageCount) {
                        IEditorPart subPart = (IEditorPart)METHOD_GET_EDITOR.invoke((Object)mPart, i);
                        if (subPart != null && !processedInfo.isProcessed((IWorkbenchPart)subPart)) {
                            if (editorInfo.getChild(subPart) == null) {
                                VrapperLog.info((String)("Editor " + editorInfo.getTopLevelEditor() + " dynamically added page " + subPart));
                                this.interceptWorkbenchPart(editorInfo.createChildInfo(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                            } else {
                                this.partActivated(editorInfo.getChild(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                            }
                        }
                        ++i;
                    }
                    if (activePage != -1 && (curEditor = (IEditorPart)METHOD_GET_EDITOR.invoke((Object)mPart, activePage)) != null) {
                        this.ensureBufferService((IEditorPart)mPart).setCurrentEditor(editorInfo.getChild(curEditor));
                    }
                } else if (part instanceof MultiEditor) {
                    MultiEditor mEditor = (MultiEditor)part;
                    IEditorPart[] iEditorPartArray = mEditor.getInnerEditors();
                    int n = iEditorPartArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorPart subPart = iEditorPartArray[n2];
                        if (subPart != null && !processedInfo.isProcessed((IWorkbenchPart)subPart)) {
                            if (editorInfo.getChild(subPart) == null) {
                                VrapperLog.info((String)("Editor " + editorInfo.getTopLevelEditor() + " dynamically added page " + subPart));
                                this.interceptWorkbenchPart(editorInfo.createChildInfo(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                            } else {
                                this.partActivated(editorInfo.getChild(subPart), processedInfo.markPart((IWorkbenchPart)subPart));
                            }
                        }
                        ++n2;
                    }
                    IEditorPart curEditor = mEditor.getActiveEditor();
                    if (curEditor != null) {
                        this.ensureBufferService((IEditorPart)mEditor).setCurrentEditor(editorInfo.getChild(curEditor));
                    }
                }
            }
            catch (Exception exception) {
                VrapperLog.error((String)"Exception activating MultiPageEditorPart", (Throwable)exception);
            }
        } else {
            EditorAdaptor vim = input.getEditorAdaptor();
            if (VrapperPlugin.isVrapperEnabled() && ((Boolean)vim.getConfiguration().get(Options.START_NORMAL_MODE)).booleanValue()) {
                vim.setSelection(null);
                vim.changeModeSafely("normal mode", new ModeSwitchHint[0]);
                if (vim.getCurrentMode() instanceof NormalMode) {
                    ((NormalMode)vim.getCurrentMode()).placeCursor(StickyColumnPolicy.NEVER);
                }
            }
            if (editorInfo.isSimpleEditor()) {
                IEditorPart editor = part;
                this.ensureBufferService(editor).setCurrentEditor(editorInfo);
            }
        }
    }

    private static Method getMultiPartEditorMethod(String name, Class<?> ... args) {
        try {
            Method m = MultiPageEditorPart.class.getDeclaredMethod(name, args);
            m.setAccessible(true);
            return m;
        }
        catch (Exception exception) {
            VrapperLog.error((String)"Exception extracting MultiPageEditorPart method", (Throwable)exception);
            return null;
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (!this.activationListenerEnabled) {
            return;
        }
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            EditorInfo editorInfo = this.toplevelEditorInfo.get(editor);
            if (editorInfo == null) {
                editorInfo = new EditorInfo(editor);
                this.toplevelEditorInfo.put((IWorkbenchPart)editor, editorInfo);
                this.interceptWorkbenchPart(editorInfo, new ProcessedInfo((IWorkbenchPart)editor));
            } else {
                this.partActivated(editorInfo, new ProcessedInfo((IWorkbenchPart)editor));
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            EditorInfo nestedInfo = this.toplevelEditorInfo.get(editor);
            if (nestedInfo == null) {
                nestedInfo = new EditorInfo(editor);
            }
            this.partClosed(nestedInfo, new ProcessedInfo((IWorkbenchPart)editor));
            this.toplevelEditorInfo.remove(editor);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            EditorInfo nestedInfo = new EditorInfo(editor);
            this.toplevelEditorInfo.put((IWorkbenchPart)editor, nestedInfo);
            this.interceptWorkbenchPart(nestedInfo, new ProcessedInfo((IWorkbenchPart)editor));
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(true);
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            EditorInfo editorInfo = this.toplevelEditorInfo.get(editor);
            if (editorInfo != null) {
                this.partClosed(editorInfo, new ProcessedInfo((IWorkbenchPart)editor));
                this.toplevelEditorInfo.remove(editor);
            }
            editorInfo = new EditorInfo(editor);
            this.toplevelEditorInfo.put((IWorkbenchPart)editor, editorInfo);
            this.interceptWorkbenchPart(editorInfo, new ProcessedInfo((IWorkbenchPart)editor));
        }
    }

    public void pageChanged(PageChangedEvent event) {
        if (!this.activationListenerEnabled) {
            return;
        }
        if (event.getPageChangeProvider() instanceof IEditorPart && event.getSelectedPage() instanceof IEditorPart) {
            EditorInfo topPageEditorInfo;
            IEditorPart toplevelEditor = (IEditorPart)event.getPageChangeProvider();
            IEditorPart editor = (IEditorPart)event.getSelectedPage();
            InputInterceptor interceptor = this.interceptors.get(editor);
            if (interceptor == null && (topPageEditorInfo = this.toplevelEditorInfo.get(toplevelEditor)) != null && editor instanceof AbstractTextEditor) {
                AbstractTextEditor abstractTextEditor = (AbstractTextEditor)editor;
                EditorInfo childInfo = topPageEditorInfo.createChildInfo(editor);
                this.registerEditorPart(childInfo, false);
                this.interceptAbstractTextEditor(abstractTextEditor, childInfo);
                interceptor = this.interceptors.get(editor);
            }
            if (interceptor != null) {
                EditorInfo info = interceptor.getEditorInfo();
                this.partActivated(info, new ProcessedInfo((IWorkbenchPart)editor));
                this.ensureBufferService(editor).setCurrentEditor(info);
            }
        }
    }

    @Override
    public void registerEditorRef(IEditorReference ref) {
        if (!this.reservedBufferIdMapping.containsKey(ref)) {
            int bufferId = BUFFER_ID_SEQ.incrementAndGet();
            this.reservedBufferIdMapping.put(ref, new BufferInfo(bufferId, ref, ref.getId()));
        }
    }

    @Override
    public void registerEditorPart(EditorInfo editorInfo, boolean updateLastSeen) {
        IEditorPart editorPart = editorInfo.getCurrent();
        IEditorInput input = editorPart.getEditorInput();
        if (input == null) {
            return;
        }
        IWorkbenchPage page = editorPart.getEditorSite().getPage();
        BufferInfo reservedBuffer = this.reservedBufferIdMapping.remove(page.getReference((IWorkbenchPart)editorInfo.getTopLevelEditor()));
        if (!this.activeBufferIdMapping.containsKey(input)) {
            int id;
            IEditorInput parentInput = null;
            if (editorInfo.isSimpleEditor()) {
                id = reservedBuffer == null ? BUFFER_ID_SEQ.incrementAndGet() : reservedBuffer.bufferId;
            } else {
                id = BUFFER_ID_SEQ.incrementAndGet();
                parentInput = editorInfo.getTopLevelEditor().getEditorInput();
            }
            String parentType = editorInfo.getTopLevelEditor().getEditorSite().getId();
            BufferInfo bufferInfo = new BufferInfo(id, editorPart, parentInput, parentType, input);
            if (reservedBuffer != null) {
                bufferInfo.seenWindows.putAll(reservedBuffer.seenWindows);
            }
            this.activeBufferIdMapping.put(input, bufferInfo);
        } else {
            BufferInfo bufferInfo = this.activeBufferIdMapping.get(input);
            IEditorPart lastSeenEditor = (IEditorPart)bufferInfo.lastSeenEditor.get();
            if (!editorPart.equals(lastSeenEditor) && updateLastSeen) {
                bufferInfo.parentInput = editorInfo.isSimpleEditor() ? null : editorInfo.getParentInfo().getCurrent().getEditorInput();
                bufferInfo.editorType = editorInfo.getTopLevelEditor().getEditorSite().getId();
                bufferInfo.lastSeenEditor = new WeakReference<IEditorPart>(editorPart);
            }
            bufferInfo.seenWindows.put(editorPart.getEditorSite().getWorkbenchWindow(), null);
        }
    }

    @Override
    public BufferInfo getBuffer(IEditorInput editorInput) {
        return this.activeBufferIdMapping.get(editorInput);
    }

    @Override
    public List<BufferInfo> getBuffers() {
        TreeMap<Integer, BufferInfo> bufferMap = new TreeMap<Integer, BufferInfo>();
        for (BufferInfo refBuffer : this.reservedBufferIdMapping.values()) {
            bufferMap.put(refBuffer.bufferId, refBuffer);
        }
        for (BufferInfo inputBuffer : this.activeBufferIdMapping.values()) {
            bufferMap.put(inputBuffer.bufferId, inputBuffer);
        }
        return new ArrayList<BufferInfo>(bufferMap.values());
    }

    @Override
    public void activate(BufferInfo buffer) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (buffer.reference != null) {
            IEditorPart editor = buffer.reference.getEditor(true);
            if (editor == null) {
                throw new VrapperPlatformException("Failed to activate editor for reference " + buffer.reference);
            }
            buffer.reference.getPage().activate((IWorkbenchPart)editor);
        } else {
            if (buffer.input != null && buffer.parentInput == null) {
                try {
                    page.openEditor(buffer.input, buffer.editorType, true, 3);
                }
                catch (PartInitException e) {
                    throw new VrapperPlatformException("Failed to activate editor for input " + buffer.input + ", type " + buffer.editorType, (Throwable)e);
                }
            }
            if (buffer.input != null) {
                IEditorPart parentEditor;
                this.activationListenerEnabled = false;
                try {
                    try {
                        IEditorReference[] editors = page.findEditors(buffer.parentInput, buffer.editorType, 3);
                        if (editors.length > 0) {
                            parentEditor = editors[0].getEditor(true);
                            page.activate((IWorkbenchPart)parentEditor);
                        } else {
                            parentEditor = page.openEditor(buffer.parentInput, buffer.editorType, true, 3);
                        }
                    }
                    catch (PartInitException e) {
                        throw new VrapperPlatformException("Failed to activate editor for input " + buffer.input + ", type " + buffer.editorType, (Throwable)e);
                    }
                }
                finally {
                    this.activationListenerEnabled = true;
                }
                EditorInfo parentEditorInfo = this.toplevelEditorInfo.get(parentEditor);
                this.activateInnerEditor(buffer, parentEditorInfo);
            } else {
                throw new VrapperPlatformException("Found bufferinfo object with no editor input info! This is most likely a bug.");
            }
        }
    }

    protected void activateInnerEditor(BufferInfo buffer, EditorInfo parentEditorInfo) {
        IEditorPart parentEditor = parentEditorInfo.getCurrent();
        if (parentEditor instanceof MultiPageEditorPart) {
            MultiPageEditorPart multiPage = (MultiPageEditorPart)parentEditor;
            IEditorPart[] foundEditors = multiPage.findEditors(buffer.input);
            if (foundEditors.length < 1) {
                throw new VrapperPlatformException("Failed to find inner editor for " + buffer.input + " in parent editor " + parentEditor);
            }
            IEditorPart editor = foundEditors[0];
            int activePage = multiPage.getActivePage();
            boolean activated = false;
            if (activePage != -1) {
                IEditorPart innerEditor;
                try {
                    innerEditor = (IEditorPart)METHOD_GET_EDITOR.invoke((Object)multiPage, activePage);
                }
                catch (Exception e) {
                    throw new VrapperPlatformException("Failed to get active page of " + multiPage, (Throwable)e);
                }
                if (innerEditor != null && innerEditor.getEditorInput().equals(buffer.input)) {
                    EditorInfo innerInfo = parentEditorInfo.getChild(innerEditor);
                    if (innerInfo == null) {
                        throw new VrapperPlatformException("Unknown child editor " + innerEditor);
                    }
                    this.ensureBufferService((IEditorPart)multiPage).setCurrentEditor(innerInfo);
                    activated = true;
                }
            }
            if (!activated) {
                multiPage.setActiveEditor(editor);
            }
        } else if (parentEditor instanceof MultiEditor) {
            MultiEditor editor = (MultiEditor)parentEditor;
            IEditorPart[] innerEditors = editor.getInnerEditors();
            int i = 0;
            while (i < innerEditors.length && !buffer.input.equals(innerEditors[i].getEditorInput())) {
                ++i;
            }
            if (i < innerEditors.length) {
                IEditorPart innerEditor = innerEditors[i];
                editor.activateEditor(innerEditor);
                EditorInfo innerInfo = parentEditorInfo.getChild(innerEditor);
                if (innerInfo == null) {
                    throw new VrapperPlatformException("Unknown child editor " + innerEditor);
                }
                this.partActivated(innerInfo, new ProcessedInfo((IWorkbenchPart)innerEditor));
                this.ensureBufferService((IEditorPart)editor).setCurrentEditor(innerInfo);
            }
        }
    }

    @Override
    public Map<IWorkbenchPart, InputInterceptor> getInterceptors() {
        return Collections.unmodifiableMap(this.interceptors);
    }

    @Override
    public InputInterceptor findActiveInterceptor(IWorkbenchPart toplevelEditor) throws UnknownEditorException, VrapperPlatformException {
        EditorInfo editorInfo = this.toplevelEditorInfo.get(toplevelEditor);
        if (editorInfo == null) {
            throw new UnknownEditorException("No editor info found for editor " + toplevelEditor + ". This might not be a top-level editor.");
        }
        return this.findActiveInterceptor(editorInfo, new ProcessedInfo(toplevelEditor));
    }

    protected InputInterceptor findActiveInterceptor(EditorInfo editorInfo, ProcessedInfo processedInfo) throws UnknownEditorException, VrapperPlatformException {
        InputInterceptor result;
        IEditorPart part = editorInfo.getCurrent();
        if (part instanceof MultiPageEditorPart) {
            MultiPageEditorPart mPart = (MultiPageEditorPart)part;
            int activePage = mPart.getActivePage();
            try {
                IEditorPart subPart = (IEditorPart)METHOD_GET_EDITOR.invoke((Object)mPart, activePage);
                result = this.interceptors.get(subPart);
            }
            catch (Exception e) {
                throw new VrapperPlatformException("Failed to get active input interceptor for " + editorInfo.getTopLevelEditor(), (Throwable)e);
            }
        } else if (part instanceof MultiEditor) {
            MultiEditor multiEditor = (MultiEditor)part;
            result = this.interceptors.get(multiEditor.getActiveEditor());
        } else if (part instanceof AbstractTextEditor) {
            result = this.interceptors.get(part);
        } else {
            throw new UnknownEditorException("Cannot find active input interceptor for editor " + editorInfo.getTopLevelEditor() + ". Unknown sub-editor type " + part);
        }
        if (result == null) {
            throw new UnknownEditorException("Cannot find active input interceptor for editor " + editorInfo.getTopLevelEditor() + ". Possibly on an unsupported tab.");
        }
        return result;
    }

    @Override
    public void activate(InputInterceptor interceptor) {
        EditorInfo editorInfo = interceptor.getEditorInfo();
        IEditorInput parentInput = null;
        if (!editorInfo.isSimpleEditor()) {
            parentInput = editorInfo.getTopLevelEditor().getEditorInput();
        }
        BufferInfo dummyBuffer = new BufferInfo(-1, editorInfo.getCurrent(), parentInput, editorInfo.getTopLevelEditor().getEditorSite().getId(), editorInfo.getCurrent().getEditorInput());
        this.activate(dummyBuffer);
    }
}

