/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.interceptor;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.eclipse.interceptor.CaretPositionHandler;
import net.sourceforge.vrapper.eclipse.interceptor.CaretPositionUndoHandler;
import net.sourceforge.vrapper.eclipse.interceptor.ContentAssistModeHandler;
import net.sourceforge.vrapper.eclipse.interceptor.EditorInfo;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptorFactory;
import net.sourceforge.vrapper.eclipse.interceptor.LinkedModeHandler;
import net.sourceforge.vrapper.eclipse.interceptor.SelectionVisualHandler;
import net.sourceforge.vrapper.eclipse.interceptor.UnknownEditorException;
import net.sourceforge.vrapper.eclipse.platform.EclipsePlatform;
import net.sourceforge.vrapper.eclipse.platform.SWTRegisterManager;
import net.sourceforge.vrapper.keymap.KeyStroke;
import net.sourceforge.vrapper.keymap.SpecialKey;
import net.sourceforge.vrapper.keymap.vim.SimpleKeyStroke;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.BufferAndTabService;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.GlobalConfiguration;
import net.sourceforge.vrapper.platform.Platform;
import net.sourceforge.vrapper.platform.PlatformVrapperLifecycleListener;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.vim.ConfigurationListener;
import net.sourceforge.vrapper.vim.DefaultConfigProvider;
import net.sourceforge.vrapper.vim.DefaultEditorAdaptor;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.SimpleGlobalConfiguration;
import net.sourceforge.vrapper.vim.VrapperEventListener;
import net.sourceforge.vrapper.vim.register.ReadOnlyRegister;
import net.sourceforge.vrapper.vim.register.Register;
import net.sourceforge.vrapper.vim.register.RegisterContent;
import net.sourceforge.vrapper.vim.register.RegisterManager;
import net.sourceforge.vrapper.vim.register.StringRegisterContent;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class VimInputInterceptorFactory
implements InputInterceptorFactory {
    public static final VimInputInterceptorFactory INSTANCE = new VimInputInterceptorFactory();
    private static final HashMap<Integer, SpecialKey> specialKeys;
    private static final HashMap<Character, Character> escapedChars;
    private static final HashSet<Integer> ignoredKeyCodes;
    private static final GlobalConfiguration sharedConfiguration;
    private static final RegisterManager globalRegisterManager;

    static {
        sharedConfiguration = VimInputInterceptorFactory.setupGlobalConfiguration();
        specialKeys = VimInputInterceptorFactory.createSpecialKeys();
        escapedChars = VimInputInterceptorFactory.createEscapedChars();
        ignoredKeyCodes = VimInputInterceptorFactory.createIgnoredKeyCodes();
        HashMap<String, Register> platformRegisters = new HashMap<String, Register>();
        platformRegisters.put("%", (Register)new ReadOnlyRegister(){

            public RegisterContent getContent() {
                InputInterceptor interceptor;
                try {
                    interceptor = VrapperPlugin.getDefault().findActiveInterceptor();
                    if (interceptor == null) {
                        return RegisterContent.DEFAULT_CONTENT;
                    }
                }
                catch (VrapperPlatformException e) {
                    VrapperLog.error((String)"Failed to find active editor even though Vrapper was active", (Throwable)e);
                    return RegisterContent.DEFAULT_CONTENT;
                }
                catch (UnknownEditorException unknownEditorException) {
                    VrapperLog.error((String)"Failed to find active editor even though Vrapper was active");
                    return RegisterContent.DEFAULT_CONTENT;
                }
                try {
                    return new StringRegisterContent(ContentType.TEXT, interceptor.getPlatform().getFileService().getCurrentFileLocation());
                }
                catch (IOException iOException) {
                    VrapperLog.info((String)"Current editor has no file associated with it");
                    return RegisterContent.DEFAULT_CONTENT;
                }
            }
        });
        globalRegisterManager = new SWTRegisterManager(PlatformUI.getWorkbench().getDisplay(), sharedConfiguration, platformRegisters);
    }

    private VimInputInterceptorFactory() {
    }

    private static GlobalConfiguration setupGlobalConfiguration() {
        DefaultConfigProvider globalDefaults = new DefaultConfigProvider(){

            public <T> T getDefault(Configuration.Option<T> option) {
                if (Options.SHOW_WHITESPACE.equals(option)) {
                    Boolean show = EditorsUI.getPreferenceStore().getBoolean("showWhitespaceCharacters");
                    return (T)show;
                }
                if (Options.LINE_NUMBERS.equals(option)) {
                    Boolean show = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
                    return (T)show;
                }
                if (Options.HIGHLIGHT_CURSOR_LINE.equals(option)) {
                    Boolean highlight = EditorsUI.getPreferenceStore().getBoolean("currentLine");
                    return (T)highlight;
                }
                if (Options.SPELL.equals(option)) {
                    Boolean enable = EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
                    return (T)enable;
                }
                return null;
            }
        };
        ConfigurationListener configListener = new ConfigurationListener(){

            public <T> void optionChanged(Configuration.Option<T> option, T oldValue, T newValue) {
                if (Options.DEBUGLOG.equals(option)) {
                    VrapperLog.setDebugEnabled((boolean)Boolean.TRUE.equals(newValue));
                } else if (Options.SHOW_WHITESPACE.equals(option)) {
                    Boolean show = (Boolean)newValue;
                    EditorsUI.getPreferenceStore().setValue("showWhitespaceCharacters", show.booleanValue());
                } else if (Options.LINE_NUMBERS.equals(option)) {
                    Boolean show = (Boolean)newValue;
                    EditorsUI.getPreferenceStore().setValue("lineNumberRuler", show.booleanValue());
                } else if (Options.HIGHLIGHT_CURSOR_LINE.equals(option)) {
                    Boolean highlight = (Boolean)newValue;
                    EditorsUI.getPreferenceStore().setValue("currentLine", highlight.booleanValue());
                } else if (Options.SPELL.equals(option)) {
                    Boolean enable = (Boolean)newValue;
                    EditorsUI.getPreferenceStore().setValue("spellingEnabled", enable.booleanValue());
                }
            }
        };
        List<2> configProviders = Collections.singletonList(globalDefaults);
        SimpleGlobalConfiguration sharedConfiguration = new SimpleGlobalConfiguration(configProviders);
        sharedConfiguration.set(Options.DEBUGLOG, (Object)VrapperLog.isDebugEnabled());
        sharedConfiguration.addListener(configListener);
        return sharedConfiguration;
    }

    private static HashMap<Integer, SpecialKey> createSpecialKeys() {
        HashMap<Integer, SpecialKey> specialKeys = new HashMap<Integer, SpecialKey>();
        specialKeys.put(0x1000003, SpecialKey.ARROW_LEFT);
        specialKeys.put(0x1000004, SpecialKey.ARROW_RIGHT);
        specialKeys.put(0x1000001, SpecialKey.ARROW_UP);
        specialKeys.put(0x1000002, SpecialKey.ARROW_DOWN);
        specialKeys.put(8, SpecialKey.BACKSPACE);
        specialKeys.put(127, SpecialKey.DELETE);
        specialKeys.put(9, SpecialKey.TAB);
        specialKeys.put(0x1000009, SpecialKey.INSERT);
        specialKeys.put(0x1000006, SpecialKey.PAGE_DOWN);
        specialKeys.put(0x1000005, SpecialKey.PAGE_UP);
        specialKeys.put(0x1000007, SpecialKey.HOME);
        specialKeys.put(0x1000008, SpecialKey.END);
        specialKeys.put(27, SpecialKey.ESC);
        specialKeys.put(13, SpecialKey.RETURN);
        specialKeys.put(0x1000050, SpecialKey.RETURN);
        SpecialKey[] values = SpecialKey.values();
        int swtStart = 0x100000A;
        int skStart = SpecialKey.F1.ordinal();
        int i = 0;
        while (i < 20) {
            specialKeys.put(swtStart + i, values[skStart + i]);
            ++i;
        }
        return specialKeys;
    }

    private static HashMap<Character, Character> createEscapedChars() {
        HashMap<Character, Character> escapedChars = new HashMap<Character, Character>();
        escapedChars.put(Character.valueOf('\u0000'), Character.valueOf('@'));
        escapedChars.put(Character.valueOf('\u0001'), Character.valueOf('a'));
        escapedChars.put(Character.valueOf('\u0002'), Character.valueOf('b'));
        escapedChars.put(Character.valueOf('\u0003'), Character.valueOf('c'));
        escapedChars.put(Character.valueOf('\u0004'), Character.valueOf('d'));
        escapedChars.put(Character.valueOf('\u0005'), Character.valueOf('e'));
        escapedChars.put(Character.valueOf('\u0006'), Character.valueOf('f'));
        escapedChars.put(Character.valueOf('\u0007'), Character.valueOf('g'));
        escapedChars.put(Character.valueOf('\b'), Character.valueOf('h'));
        escapedChars.put(Character.valueOf('\t'), Character.valueOf('i'));
        escapedChars.put(Character.valueOf('\n'), Character.valueOf('j'));
        escapedChars.put(Character.valueOf('\u000b'), Character.valueOf('k'));
        escapedChars.put(Character.valueOf('\f'), Character.valueOf('l'));
        escapedChars.put(Character.valueOf('\r'), Character.valueOf('m'));
        escapedChars.put(Character.valueOf('\u000e'), Character.valueOf('n'));
        escapedChars.put(Character.valueOf('\u000f'), Character.valueOf('o'));
        escapedChars.put(Character.valueOf('\u0010'), Character.valueOf('p'));
        escapedChars.put(Character.valueOf('\u0011'), Character.valueOf('q'));
        escapedChars.put(Character.valueOf('\u0012'), Character.valueOf('r'));
        escapedChars.put(Character.valueOf('\u0013'), Character.valueOf('s'));
        escapedChars.put(Character.valueOf('\u0014'), Character.valueOf('t'));
        escapedChars.put(Character.valueOf('\u0015'), Character.valueOf('u'));
        escapedChars.put(Character.valueOf('\u0016'), Character.valueOf('v'));
        escapedChars.put(Character.valueOf('\u0017'), Character.valueOf('w'));
        escapedChars.put(Character.valueOf('\u0018'), Character.valueOf('x'));
        escapedChars.put(Character.valueOf('\u0019'), Character.valueOf('y'));
        escapedChars.put(Character.valueOf('\u001a'), Character.valueOf('z'));
        escapedChars.put(Character.valueOf('\u001b'), Character.valueOf('['));
        escapedChars.put(Character.valueOf('\u001c'), Character.valueOf('\\'));
        escapedChars.put(Character.valueOf('\u001d'), Character.valueOf(']'));
        escapedChars.put(Character.valueOf('\u001e'), Character.valueOf('^'));
        escapedChars.put(Character.valueOf('\u001f'), Character.valueOf('_'));
        return escapedChars;
    }

    private static HashSet<Integer> createIgnoredKeyCodes() {
        HashSet<Integer> ignoredKeyCodes = new HashSet<Integer>();
        ignoredKeyCodes.add(262144);
        ignoredKeyCodes.add(131072);
        ignoredKeyCodes.add(65536);
        ignoredKeyCodes.add(16777298);
        ignoredKeyCodes.add(0x400000);
        return ignoredKeyCodes;
    }

    @Override
    public InputInterceptor createInterceptor(AbstractTextEditor abstractTextEditor, ISourceViewer textViewer, EditorInfo partInfo, BufferAndTabService bufferAndTabService, List<PlatformVrapperLifecycleListener> lifecycleListeners) {
        SourceViewer sourceViewer;
        ContentAssistantFacade contentAssistant;
        EclipsePlatform platform = new EclipsePlatform(partInfo, abstractTextEditor, textViewer, sharedConfiguration, bufferAndTabService);
        DefaultEditorAdaptor editorAdaptor = new DefaultEditorAdaptor((Platform)platform, globalRegisterManager, VrapperPlugin.isVrapperEnabled(), lifecycleListeners);
        editorAdaptor.addVrapperEventListener((VrapperEventListener)platform.getModeRecorder());
        InputInterceptor interceptor = this.createInterceptor((EditorAdaptor)editorAdaptor);
        interceptor.setPlatform(platform);
        interceptor.setEditorInfo(partInfo);
        interceptor.setCaretPositionUndoHandler(new CaretPositionUndoHandler((EditorAdaptor)editorAdaptor, (ITextViewer)textViewer));
        editorAdaptor.addVrapperEventListener((VrapperEventListener)interceptor.getCaretPositionUndoHandler());
        interceptor.setCaretPositionHandler(new CaretPositionHandler(editorAdaptor, (ITextViewer)textViewer));
        if (((Boolean)editorAdaptor.getConfiguration().get(Options.EXIT_LINK_MODE)).booleanValue()) {
            LinkedModeHandler linkedModeHandler = new LinkedModeHandler((EditorAdaptor)editorAdaptor);
            LinkedModeHandler.registerListener(textViewer.getDocument(), linkedModeHandler);
            interceptor.setLinkedModeHandler(linkedModeHandler);
        }
        if (((Boolean)editorAdaptor.getConfiguration().get(Options.CONTENT_ASSIST_MODE)).booleanValue() && textViewer instanceof SourceViewer && (contentAssistant = (sourceViewer = (SourceViewer)textViewer).getContentAssistantFacade()) != null) {
            contentAssistant.addCompletionListener((ICompletionListener)new ContentAssistModeHandler((EditorAdaptor)editorAdaptor));
        }
        SelectionVisualHandler visualHandler = new SelectionVisualHandler(editorAdaptor, platform.getSelectionService(), (ITextViewer)textViewer);
        interceptor.setSelectionVisualHandler(visualHandler);
        return interceptor;
    }

    @Override
    public InputInterceptor createInterceptor(EditorAdaptor editorAdaptor) {
        return new VimInputInterceptor(editorAdaptor);
    }

    private static final class VimInputInterceptor
    implements InputInterceptor {
        private final EditorAdaptor editorAdaptor;
        private EditorInfo editorInfo;
        private LinkedModeHandler linkedModeHandler;
        private CaretPositionHandler caretPositionHandler;
        private SelectionVisualHandler selectionVisualHandler;
        private CaretPositionUndoHandler caretPositionUndoHandler;
        private EclipsePlatform eclipsePlatform;

        private VimInputInterceptor(EditorAdaptor editorAdaptor) {
            this.editorAdaptor = editorAdaptor;
        }

        public void verifyKey(VerifyEvent event) {
            SimpleKeyStroke keyStroke;
            boolean isPotentiallyEscapedKey;
            boolean includesCtrlKey;
            if (!VrapperPlugin.isVrapperEnabled()) {
                return;
            }
            if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
                return;
            }
            if (ignoredKeyCodes.contains(event.keyCode)) {
                return;
            }
            EnumSet<KeyStroke.Modifier> modifiers = EnumSet.noneOf(KeyStroke.Modifier.class);
            if ((event.stateMask & 0x20000) != 0) {
                modifiers.add(KeyStroke.Modifier.SHIFT);
            }
            if ((event.stateMask & 0x10000) != 0) {
                modifiers.add(KeyStroke.Modifier.ALT);
            }
            if ((event.stateMask & 0x400000) != 0) {
                modifiers.add(KeyStroke.Modifier.COMMAND);
            }
            boolean bl = includesCtrlKey = (event.stateMask & 0x40000) != 0;
            if (includesCtrlKey) {
                modifiers.add(KeyStroke.Modifier.CONTROL);
            }
            boolean bl2 = isPotentiallyEscapedKey = (event.keyCode & 0x1000000) == 0;
            if (specialKeys.containsKey(event.keyCode)) {
                keyStroke = new SimpleKeyStroke((SpecialKey)specialKeys.get(event.keyCode), modifiers);
            } else if (isPotentiallyEscapedKey && includesCtrlKey && escapedChars.containsKey(Character.valueOf(event.character))) {
                keyStroke = new SimpleKeyStroke(((Character)escapedChars.get(Character.valueOf(event.character))).charValue(), modifiers);
            } else {
                if (event.character == '\u0000' && VrapperLog.isDebugEnabled()) {
                    VrapperLog.debug((String)("Unrecognized key. Keycode: " + event.keyCode + ", state: " + event.stateMask + ", modifiers: " + modifiers));
                }
                keyStroke = new SimpleKeyStroke(event.character, modifiers);
            }
            event.doit = !this.editorAdaptor.handleKey((KeyStroke)keyStroke);
        }

        @Override
        public EditorAdaptor getEditorAdaptor() {
            return this.editorAdaptor;
        }

        @Override
        public EditorInfo getEditorInfo() {
            return this.editorInfo;
        }

        @Override
        public void setEditorInfo(EditorInfo partInfo) {
            this.editorInfo = partInfo;
        }

        @Override
        public LinkedModeHandler getLinkedModeHandler() {
            return this.linkedModeHandler;
        }

        @Override
        public void setLinkedModeHandler(LinkedModeHandler handler) {
            this.linkedModeHandler = handler;
        }

        @Override
        public CaretPositionHandler getCaretPositionHandler() {
            return this.caretPositionHandler;
        }

        @Override
        public void setCaretPositionHandler(CaretPositionHandler handler) {
            this.caretPositionHandler = handler;
        }

        @Override
        public SelectionVisualHandler getSelectionVisualHandler() {
            return this.selectionVisualHandler;
        }

        @Override
        public void setSelectionVisualHandler(SelectionVisualHandler handler) {
            this.selectionVisualHandler = handler;
        }

        @Override
        public CaretPositionUndoHandler getCaretPositionUndoHandler() {
            return this.caretPositionUndoHandler;
        }

        @Override
        public void setCaretPositionUndoHandler(CaretPositionUndoHandler handler) {
            this.caretPositionUndoHandler = handler;
        }

        @Override
        public EclipsePlatform getPlatform() {
            return this.eclipsePlatform;
        }

        @Override
        public void setPlatform(EclipsePlatform platform) {
            this.eclipsePlatform = platform;
        }
    }
}

