/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.UnderlyingEditorSettings;
import net.sourceforge.vrapper.utils.StringUtils;
import net.sourceforge.vrapper.vim.DefaultConfigProvider;
import net.sourceforge.vrapper.vim.Options;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class AbstractTextEditorSettings
implements UnderlyingEditorSettings,
DefaultConfigProvider {
    private final AbstractTextEditor abstractTextEditor;
    private ISourceViewer sourceViewer;

    public AbstractTextEditorSettings(AbstractTextEditor abstractTextEditor, ISourceViewer sourceViewer) {
        this.abstractTextEditor = abstractTextEditor;
        this.sourceViewer = sourceViewer;
    }

    public void setReplaceMode(boolean replace) {
        try {
            Method isInsertingMethod = AbstractTextEditor.class.getDeclaredMethod("isInInsertMode", new Class[0]);
            isInsertingMethod.setAccessible(true);
            boolean isInserting = (Boolean)isInsertingMethod.invoke((Object)this.abstractTextEditor, new Object[0]);
            if (isInserting == replace) {
                Method toggleMethod = AbstractTextEditor.class.getDeclaredMethod("toggleOverwriteMode", new Class[0]);
                toggleMethod.setAccessible(true);
                toggleMethod.invoke((Object)this.abstractTextEditor, new Object[0]);
            }
        }
        catch (Exception exception) {
            VrapperLog.error((String)"error when enabling replace mode", (Throwable)exception);
        }
    }

    public void disableInputMethod() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.setImeInputMode(0);
    }

    protected SourceViewerConfiguration getSourceViewerConfig() throws IOException {
        try {
            Method me = AbstractTextEditor.class.getDeclaredMethod("getSourceViewerConfiguration", new Class[0]);
            me.setAccessible(true);
            Object sourceConfig = me.invoke((Object)this.abstractTextEditor, new Object[0]);
            if (sourceConfig == null) {
                throw new IOException("getSourceViewerConfiguration returned null!");
            }
            return (SourceViewerConfiguration)sourceConfig;
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Failed to grab sourceviewer");
        }
        catch (SecurityException securityException) {
            throw new IOException("Failed to grab sourceviewer");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Failed to grab sourceviewer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Failed to grab sourceviewer");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Failed to grab sourceviewer");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Failed to grab sourceviewer");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getDefault(Configuration.Option<T> option) {
        T result = null;
        try {
            if (Options.TAB_STOP.equals(option)) {
                SourceViewerConfiguration config = this.getSourceViewerConfig();
                Integer tabWidth = config.getTabWidth(this.sourceViewer);
                return (T)tabWidth;
            }
            if (Options.SHIFT_WIDTH.equals(option)) {
                SourceViewerConfiguration config = this.getSourceViewerConfig();
                String[] indents = config.getIndentPrefixes(this.sourceViewer, "__dftl_partition_content_type");
                if (indents.length < 1) {
                    return null;
                }
                String indent = indents[0];
                int tabWidth = config.getTabWidth(this.sourceViewer);
                int[] offsets = StringUtils.calculateVisualOffsets((String)indent, (int)indent.length(), (int)tabWidth);
                Integer shiftWidth = offsets[indent.length()];
                return (T)shiftWidth;
            }
            if (!Options.EXPAND_TAB.equals(option)) return result;
            SourceViewerConfiguration config = this.getSourceViewerConfig();
            String[] indents = config.getIndentPrefixes(this.sourceViewer, "__dftl_partition_content_type");
            if (indents.length < 1) {
                return null;
            }
            String indent = indents[0];
            Boolean expandTab = !indent.contains("\t");
            return (T)expandTab;
        }
        catch (IOException e) {
            VrapperLog.debug((String)("Failed to get source viewer: " + e));
        }
        return result;
    }
}

