/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.sourceforge.vrapper.eclipse.interceptor.BufferInfo;
import net.sourceforge.vrapper.eclipse.interceptor.BufferManager;
import net.sourceforge.vrapper.eclipse.interceptor.EditorInfo;
import net.sourceforge.vrapper.eclipse.interceptor.InputInterceptor;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.Buffer;
import net.sourceforge.vrapper.platform.BufferAndTabService;
import net.sourceforge.vrapper.platform.BufferDoException;
import net.sourceforge.vrapper.platform.Tab;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import net.sourceforge.vrapper.vim.commands.CommandExecutionException;
import net.sourceforge.vrapper.vim.modes.commandline.Evaluator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class EclipseBufferAndTabService
implements BufferAndTabService {
    protected WeakReference<IEditorPart> previousEditorReference;
    protected WeakReference<IEditorPart> currentEditorReference;
    protected BufferManager bufferIdManager;
    protected IWorkbenchWindow workbenchWindow;

    public EclipseBufferAndTabService(IWorkbenchWindow window, BufferManager bufferIdManager) {
        this.workbenchWindow = window;
        this.bufferIdManager = bufferIdManager;
        this.previousEditorReference = new WeakReference<Object>(null);
        this.currentEditorReference = new WeakReference<Object>(null);
    }

    public void setCurrentEditor(EditorInfo editorInfo) {
        IEditorPart activeEditor = editorInfo.getCurrent();
        if (activeEditor == null || activeEditor.getEditorInput() == null) {
            return;
        }
        IEditorPart currentEditor = (IEditorPart)this.currentEditorReference.get();
        if (currentEditor == null || currentEditor.getEditorInput() == null) {
            this.previousEditorReference = new WeakReference<IEditorPart>(activeEditor);
        } else if (!currentEditor.equals(activeEditor) && !activeEditor.getEditorInput().equals(currentEditor.getEditorInput())) {
            this.previousEditorReference = new WeakReference<IEditorPart>(currentEditor);
        }
        this.currentEditorReference = new WeakReference<IEditorPart>(activeEditor);
        this.bufferIdManager.registerEditorPart(editorInfo, true);
    }

    public Buffer getPreviousBuffer() {
        IEditorPart previousEditor = (IEditorPart)this.previousEditorReference.get();
        IEditorPart currentEditor = (IEditorPart)this.currentEditorReference.get();
        if (previousEditor == null) {
            previousEditor = currentEditor;
        }
        if (previousEditor == null) {
            throw new VrapperPlatformException("All previous editors are garbage collected.");
        }
        IEditorInput previousInput = previousEditor.getEditorInput();
        BufferInfo bufferInfo = this.bufferIdManager.getBuffer(previousInput);
        if (previousEditor.equals(currentEditor)) {
            return new EclipseBuffer(bufferInfo).markActive();
        }
        return new EclipseBuffer(bufferInfo).markAlternate();
    }

    public Buffer getActiveBuffer() {
        IEditorPart currentEditor = (IEditorPart)this.currentEditorReference.get();
        if (currentEditor == null) {
            throw new VrapperPlatformException("Current editor not set - cannot continue.");
        }
        IEditorInput currentInput = currentEditor.getEditorInput();
        BufferInfo bufferInfo = this.bufferIdManager.getBuffer(currentInput);
        return new EclipseBuffer(bufferInfo).markActive();
    }

    public void switchBuffer(Buffer buffer) {
        if (buffer == null) {
            throw new VrapperPlatformException("Buffer cannot be null.");
        }
        if (!(buffer instanceof EclipseBuffer)) {
            throw new VrapperPlatformException("Received an unexpected kind of Buffer object.");
        }
        EclipseBuffer targetBuffer = (EclipseBuffer)buffer;
        this.bufferIdManager.activate(targetBuffer.bufferInfo);
    }

    public List<Buffer> getBuffers() {
        ArrayList<Buffer> result = new ArrayList<Buffer>();
        List<BufferInfo> buffers = this.bufferIdManager.getBuffers();
        IEditorPart currentEditor = (IEditorPart)this.currentEditorReference.get();
        IEditorPart previousEditor = (IEditorPart)this.previousEditorReference.get();
        if (previousEditor == null) {
            previousEditor = currentEditor;
        }
        if (currentEditor == null || buffers.size() == 0) {
            return Collections.emptyList();
        }
        IEditorInput currentInput = currentEditor.getEditorInput();
        IEditorInput previousInput = previousEditor.getEditorInput();
        for (BufferInfo editorInfo : buffers) {
            if (!editorInfo.seenWindows.containsKey(this.workbenchWindow)) continue;
            EclipseBuffer eclipseBuffer = new EclipseBuffer(editorInfo);
            if (currentInput != null && currentInput.equals(editorInfo.input)) {
                eclipseBuffer.markActive();
            } else if (previousInput != null && previousInput.equals(editorInfo.input)) {
                eclipseBuffer.markAlternate();
            }
            result.add(eclipseBuffer);
        }
        return result;
    }

    public List<Object> doInBuffers(boolean initialize, Queue<String> command, Evaluator code) throws BufferDoException {
        if (initialize) {
            IEditorReference[] references;
            IEditorReference[] iEditorReferenceArray = references = this.workbenchWindow.getActivePage().getEditorReferences();
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                ref.getEditor(true);
                ++n2;
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Map<IWorkbenchPart, InputInterceptor> editors = this.bufferIdManager.getInterceptors();
        for (Map.Entry<IWorkbenchPart, InputInterceptor> editorInfo : editors.entrySet()) {
            IWorkbenchPart editor = editorInfo.getKey();
            if (editor == null || editor.getSite() == null || !this.workbenchWindow.equals(editor.getSite().getWorkbenchWindow())) continue;
            InputInterceptor interceptor = editorInfo.getValue();
            EditorAdaptor editorAdaptor = interceptor.getEditorAdaptor();
            try {
                result.add(code.evaluate(editorAdaptor, command));
            }
            catch (CommandExecutionException e) {
                try {
                    this.bufferIdManager.activate(interceptor);
                }
                catch (RuntimeException re) {
                    VrapperLog.error((String)("Failed to activate interceptor " + interceptor), (Throwable)re);
                }
                throw new BufferDoException(result, editorAdaptor, (Throwable)e);
            }
        }
        return result;
    }

    public Tab getActiveTab() {
        return null;
    }

    public List<Tab> getTabs() {
        return null;
    }

    public void switchTab(Tab tab) {
    }

    public static class EclipseBuffer
    implements Buffer {
        private BufferInfo bufferInfo;
        private boolean isActive;
        private boolean isAlternate;

        public EclipseBuffer(BufferInfo bufferInfo) {
            this.bufferInfo = bufferInfo;
        }

        public EclipseBuffer(EclipseBuffer original) {
            this.bufferInfo = original.bufferInfo;
        }

        public int getId() {
            return this.bufferInfo.bufferId;
        }

        public String getDisplayName() {
            return this.bufferInfo.getDisplayName();
        }

        public boolean isAlternate() {
            return this.isAlternate;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public EclipseBuffer markActive() {
            this.isActive = true;
            return this;
        }

        public EclipseBuffer markAlternate() {
            this.isAlternate = true;
            return this;
        }

        public boolean equals(Object other) {
            return other instanceof Buffer && this.bufferInfo.bufferId == ((Buffer)other).getId();
        }
    }
}

