/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.vrapper.eclipse.activator.VrapperPlugin;
import net.sourceforge.vrapper.eclipse.interceptor.EditorInfo;
import net.sourceforge.vrapper.eclipse.platform.EclipseTextContent;
import net.sourceforge.vrapper.eclipse.platform.OffsetConverter;
import net.sourceforge.vrapper.eclipse.platform.TextViewerPosition;
import net.sourceforge.vrapper.eclipse.platform.VrapperModeRecorder;
import net.sourceforge.vrapper.eclipse.ui.CaretUtils;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.SelectionService;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.CaretType;
import net.sourceforge.vrapper.utils.ContentType;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Space;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import net.sourceforge.vrapper.utils.VimUtils;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.commands.Selection;
import net.sourceforge.vrapper.vim.commands.SimpleSelection;
import net.sourceforge.vrapper.vim.commands.motions.StickyColumnPolicy;
import net.sourceforge.vrapper.vim.modes.InsertMode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationHistory;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class EclipseCursorAndSelection
implements CursorService,
SelectionService {
    public static final String POSITION_CATEGORY_NAME = "net.sourceforge.vrapper.position";
    public static final String GLOBAL_MARK_TYPE = "org.eclipse.core.resources.bookmark";
    private final EditorInfo editorInfo;
    private final ITextViewer textViewer;
    private int stickyColumn;
    private boolean stickToEOL = false;
    private final ITextViewerExtension5 converter;
    private Selection selection;
    private boolean selectionInProgress;
    private final SelectionChangeListener selectionChangeListener;
    private final StickyColumnUpdater caretListener;
    private final Map<String, Position> marks;
    private final List<Position> changeList;
    private int changeListIndex;
    private final Configuration configuration;
    private final EclipseTextContent textContent;
    private int averageCharWidth;
    private CaretType caretType = null;
    private Point caretCachedSize;
    private VisualCaretPainter visualCaretPainter;
    private VrapperModeRecorder vrapperModeRecorder;

    public EclipseCursorAndSelection(VrapperModeRecorder vrapperModeRecorder, Configuration configuration, EditorInfo editorInfo, ITextViewer textViewer, EclipseTextContent textContent) {
        this.vrapperModeRecorder = vrapperModeRecorder;
        this.configuration = configuration;
        this.editorInfo = editorInfo;
        this.textViewer = textViewer;
        this.textContent = textContent;
        StyledText tw = textViewer.getTextWidget();
        this.stickyColumn = tw.getLeftMargin();
        GC gc = null;
        try {
            gc = new GC((Drawable)tw);
            this.averageCharWidth = gc.getFontMetrics().getAverageCharWidth();
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        this.converter = OffsetConverter.create(textViewer);
        this.selectionChangeListener = new SelectionChangeListener();
        this.caretListener = new StickyColumnUpdater();
        this.marks = new HashMap<String, Position>();
        this.changeList = new ArrayList<Position>();
        this.visualCaretPainter = new VisualCaretPainter();
    }

    public void installHooks() {
        this.textViewer.getTextWidget().addSelectionListener((SelectionListener)this.selectionChangeListener);
        this.textViewer.getTextWidget().addCaretListener((CaretListener)this.caretListener);
        this.textViewer.getTextWidget().addPaintListener((PaintListener)this.visualCaretPainter);
        this.textViewer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.selectionChangeListener);
        this.textViewer.getDocument().addPositionCategory(POSITION_CATEGORY_NAME);
    }

    public void uninstallHooks() {
        try {
            this.textViewer.getTextWidget().removeSelectionListener((SelectionListener)this.selectionChangeListener);
            this.textViewer.getTextWidget().removeCaretListener((CaretListener)this.caretListener);
            this.textViewer.getTextWidget().removePaintListener((PaintListener)this.visualCaretPainter);
            this.textViewer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.selectionChangeListener);
            if (this.textViewer.getDocument().containsPositionCategory(POSITION_CATEGORY_NAME)) {
                this.textViewer.getDocument().removePositionCategory(POSITION_CATEGORY_NAME);
            }
        }
        catch (RuntimeException e) {
            throw new VrapperPlatformException("Failed to unhook selection listeners", (Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            throw new VrapperPlatformException("Failed to delete position category", (Throwable)e);
        }
    }

    public net.sourceforge.vrapper.utils.Position getPosition() {
        if (this.selection != null) {
            return this.selection.getTo();
        }
        Point sel = this.textViewer.getSelectedRange();
        int caretOffset = this.textViewer.getTextWidget().getCaretOffset();
        int cursorPos = this.converter.widgetOffset2ModelOffset(caretOffset);
        if (sel.y > 0 && cursorPos == sel.x + sel.y && "inclusive".equals(this.configuration.get(Options.SELECTION))) {
            return this.shiftPositionForViewOffset(caretOffset, -1, true);
        }
        return new TextViewerPosition(this.textViewer, Space.MODEL, cursorPos);
    }

    public void setPosition(net.sourceforge.vrapper.utils.Position position, StickyColumnPolicy columnPolicy) {
        this.caretListener.disable();
        net.sourceforge.vrapper.utils.Position oldPosition = this.getPosition();
        int viewOffset = position.getViewOffset();
        int oldViewOffset = oldPosition.getViewOffset();
        if (viewOffset < 0) {
            VrapperLog.info((String)("Position M" + position.getModelOffset() + " was not visible."));
            viewOffset = 0;
        }
        try {
            this.textViewer.getTextWidget().setSelection(viewOffset);
        }
        catch (IllegalArgumentException e) {
            throw new VrapperPlatformException("Cannot set caret position to V " + viewOffset, (Throwable)e);
        }
        this.selection = null;
        switch (columnPolicy) {
            case NEVER: {
                break;
            }
            case ON_CHANGE: {
                if (oldViewOffset == viewOffset) break;
                this.updateStickyColumn(viewOffset);
                break;
            }
            case RESET_EOL: {
                this.stickToEOL = false;
                this.updateStickyColumn(viewOffset);
                break;
            }
            case TO_EOL: {
                this.stickToEOL = true;
            }
        }
        this.caretListener.enable();
    }

    public net.sourceforge.vrapper.utils.Position stickyColumnAtViewLine(int lineNo) {
        StyledText tw = this.textViewer.getTextWidget();
        if (!this.stickToEOL) {
            try {
                int y = tw.getLocationAtOffset((int)tw.getOffsetAtLine((int)lineNo)).y;
                int offset = tw.getOffsetAtLocation(new Point(this.stickyColumn - tw.getHorizontalPixel(), y));
                return new TextViewerPosition(this.textViewer, Space.VIEW, offset);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        int line = this.converter.widgetLine2ModelLine(lineNo);
        try {
            int lineLen = this.textViewer.getDocument().getLineLength(line);
            String nl = this.textViewer.getDocument().getLineDelimiter(line);
            int nlLen = nl != null ? nl.length() : 0;
            int offset = tw.getOffsetAtLine(lineNo) + lineLen - nlLen;
            return new TextViewerPosition(this.textViewer, Space.VIEW, offset);
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to get sticky column for VL" + lineNo + "/ML" + line, (Throwable)e);
        }
    }

    public net.sourceforge.vrapper.utils.Position stickyColumnAtModelLine(int lineNo) {
        if (this.stickToEOL) {
            try {
                int lineLength = this.textViewer.getDocument().getLineLength(lineNo);
                int startOffset = this.textViewer.getDocument().getLineInformation(lineNo).getOffset();
                int endOffset = startOffset + lineLength;
                if (lineLength > 0) {
                    --endOffset;
                }
                if (endOffset > startOffset && VimUtils.isNewLine((String)this.textContent.getModelContent().getText(endOffset, 1))) {
                    --endOffset;
                }
                return new TextViewerPosition(this.textViewer, Space.MODEL, endOffset);
            }
            catch (Exception e) {
                throw new VrapperPlatformException("Failed to get sticky column for ML" + lineNo, (Throwable)e);
            }
        }
        try {
            return this.stickyColumnAtViewLine(this.converter.modelLine2WidgetLine(lineNo));
        }
        catch (RuntimeException e) {
            try {
                int caretOffset = this.converter.widgetOffset2ModelOffset(this.textViewer.getTextWidget().getCaretOffset());
                int lineOffset = this.textViewer.getDocument().getLineInformationOfOffset(caretOffset).getOffset();
                int y = Math.abs(caretOffset - lineOffset);
                IRegion line = this.textViewer.getDocument().getLineInformation(lineNo);
                int offset = line.getOffset() + Math.min(y, line.getLength());
                return new TextViewerPosition(this.textViewer, Space.MODEL, offset);
            }
            catch (BadLocationException badLocationException) {
                throw new VrapperPlatformException("Failed to get sticky column for ML" + lineNo, (Throwable)e);
            }
        }
    }

    public Selection getSelection() {
        if (this.selection != null) {
            return this.selection;
        }
        TextRange range = this.getNativeSelection();
        net.sourceforge.vrapper.utils.Position from = range.getStart();
        net.sourceforge.vrapper.utils.Position to = range.getEnd();
        boolean isInclusive = "inclusive".equals(this.configuration.get(Options.SELECTION));
        if (range.getModelLength() > 0 && isInclusive) {
            if (range.isReversed()) {
                from = this.shiftPositionForViewOffset(from.getViewOffset(), -1, true);
            } else {
                to = this.shiftPositionForViewOffset(to.getViewOffset(), -1, true);
            }
        }
        return new SimpleSelection(from, to, range);
    }

    public TextRange getNativeSelection() {
        int end;
        if (this.selection != null) {
            return SelectionService.VRAPPER_SELECTION_ACTIVE;
        }
        Point sel = this.textViewer.getSelectedRange();
        int start = end = sel.x;
        int len = sel.y;
        int pos = this.converter.widgetOffset2ModelOffset(this.textViewer.getTextWidget().getCaretOffset());
        if (len > 0) {
            if (sel.x == pos) {
                start += len;
            } else {
                end += len;
            }
        }
        TextViewerPosition startSel = new TextViewerPosition(this.textViewer, Space.MODEL, start);
        TextViewerPosition endSel = new TextViewerPosition(this.textViewer, Space.MODEL, end);
        return StartEndTextRange.exclusive((net.sourceforge.vrapper.utils.Position)startSel, (net.sourceforge.vrapper.utils.Position)endSel);
    }

    public boolean isSelectionInProgress() {
        return this.selectionInProgress;
    }

    public void setSelection(Selection newSel) {
        ContentType contentType;
        this.selectionInProgress = true;
        this.selection = newSel;
        ContentType contentType2 = contentType = newSel == null ? null : newSel.getContentType(this.configuration);
        if (newSel == null) {
            Point point = this.textViewer.getSelectedRange();
            this.textViewer.getTextWidget().setBlockSelection(false);
            this.textViewer.setSelectedRange(point.x, 0);
        } else if (ContentType.TEXT_RECTANGLE.equals((Object)contentType)) {
            this.setBlockSelection(newSel);
        } else {
            int start = newSel.getStart().getModelOffset();
            int length = !newSel.isReversed() ? newSel.getModelLength() : -newSel.getModelLength();
            this.selection = newSel;
            this.caretListener.disable();
            this.textViewer.getTextWidget().setBlockSelection(false);
            this.textViewer.setSelectedRange(start, length);
            this.caretListener.enable();
        }
        this.selectionInProgress = false;
    }

    private void setBlockSelection(Selection newSelection) {
        Rectangle blockRect;
        StyledText styled = this.textViewer.getTextWidget();
        styled.setBlockSelection(true);
        GC gc = new GC((Drawable)styled);
        int avgCharWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        TextContent viewContent = this.textContent.getViewContent();
        int fromOfs = this.selection.getFrom().getViewOffset();
        int toOfs = this.selection.getTo().getViewOffset();
        if (toOfs == this.textViewer.getDocument().getLength()) {
            return;
        }
        Rectangle fromRect = styled.getTextBounds(fromOfs, fromOfs);
        LineInformation fromLine = viewContent.getLineInformationOfOffset(fromOfs);
        Rectangle toRect = styled.getTextBounds(toOfs, toOfs);
        LineInformation toLine = viewContent.getLineInformationOfOffset(toOfs);
        if (fromLine.getEndOffset() == fromOfs) {
            fromRect.x += avgCharWidth;
        }
        if (toLine.getEndOffset() == toOfs) {
            toRect.x += avgCharWidth;
        }
        if (this.stickToEOL) {
            int leftTrim = fromRect.x < toRect.x ? fromRect.x : toRect.x;
            blockRect = fromOfs <= toOfs ? styled.getTextBounds(fromOfs, toOfs) : styled.getTextBounds(toOfs, fromLine.getEndOffset());
            blockRect.width += avgCharWidth;
            blockRect.width -= leftTrim - blockRect.x;
            blockRect.x = leftTrim;
        } else {
            blockRect = fromRect.union(toRect);
        }
        blockRect.x += styled.getHorizontalPixel();
        blockRect.y += styled.getTopPixel();
        this.caretListener.disable();
        styled.setBlockSelectionBounds(blockRect);
        this.caretListener.enable();
    }

    public void setNativeSelection(TextRange range) {
        int length = !range.isReversed() ? range.getModelLength() : -range.getModelLength();
        this.selection = null;
        this.caretListener.disable();
        this.textViewer.getTextWidget().setBlockSelection(false);
        this.textViewer.setSelectedRange(range.getStart().getModelOffset(), length);
        this.caretListener.enable();
    }

    public net.sourceforge.vrapper.utils.Position newPositionForModelOffset(int offset) {
        return new TextViewerPosition(this.textViewer, Space.MODEL, offset);
    }

    public net.sourceforge.vrapper.utils.Position newPositionForViewOffset(int offset) {
        return new TextViewerPosition(this.textViewer, Space.VIEW, offset);
    }

    public net.sourceforge.vrapper.utils.Position newPositionForModelOffset(int targetModelOffset, net.sourceforge.vrapper.utils.Position original, boolean allowPastLastChar) {
        int modelOffset = original.getModelOffset();
        targetModelOffset = this.safeAddModelOffset(modelOffset, targetModelOffset, allowPastLastChar);
        return new TextViewerPosition(this.textViewer, Space.MODEL, targetModelOffset);
    }

    public net.sourceforge.vrapper.utils.Position shiftPositionForModelOffset(int offset, int delta, boolean allowPastLastChar) {
        offset = this.safeAddModelOffset(offset, offset + delta, allowPastLastChar);
        return new TextViewerPosition(this.textViewer, Space.MODEL, offset);
    }

    public net.sourceforge.vrapper.utils.Position shiftPositionForViewOffset(int offset, int delta, boolean allowPastLastChar) {
        int oldModelOffset = this.converter.widgetOffset2ModelOffset(offset);
        int targetOffset = this.converter.widgetOffset2ModelOffset(offset + delta);
        int shiftedOffset = this.safeAddModelOffset(oldModelOffset, targetOffset, allowPastLastChar);
        return new TextViewerPosition(this.textViewer, Space.MODEL, shiftedOffset);
    }

    public void setCaret(CaretType caretType) {
        StyledText styledText = this.textViewer.getTextWidget();
        if (this.caretType != caretType) {
            Caret old = styledText.getCaret();
            Rectangle oldBounds = old.getBounds();
            Caret newCaret = CaretUtils.createCaret(caretType, styledText);
            old.dispose();
            this.caretType = caretType;
            this.caretCachedSize = newCaret.getSize();
            styledText.setCaret(newCaret);
            styledText.redraw(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, true);
        } else {
            Caret caret = styledText.getCaret();
            Rectangle oldBounds = caret.getBounds();
            caret.setSize(this.caretCachedSize);
            styledText.redraw(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, true);
        }
    }

    public void updateLastPosition() {
        INavigationHistory history = this.editorInfo.getCurrent().getSite().getPage().getNavigationHistory();
        INavigationLocation currentLocation = history.getCurrentLocation();
        if (currentLocation != null) {
            currentLocation.update();
        }
    }

    public void markCurrentPosition() {
        IEditorPart editorPart = this.editorInfo.getCurrent();
        editorPart.getSite().getPage().getNavigationHistory().markLocation(editorPart);
    }

    public Set<String> getAllMarks() {
        HashSet<String> allMarks = new HashSet<String>(this.marks.keySet());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = root.findMarkers(GLOBAL_MARK_TYPE, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                String markName = m.getAttribute("message", "--");
                if (!markName.equals("--")) {
                    allMarks.add(markName);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            VrapperLog.error((String)("Failed to find markers in resource root " + root), (Throwable)e);
        }
        return allMarks;
    }

    public void setMark(String id, net.sourceforge.vrapper.utils.Position position) {
        if (this.isGlobalMark(id)) {
            this.setGlobalMark(id, position);
            return;
        }
        Position p = new Position(position.getModelOffset());
        try {
            this.textViewer.getDocument().addPosition(p);
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to set mark for " + position, (Throwable)e);
        }
        if (id == ".") {
            this.changeList.add(p);
            if (this.changeList.size() > 100) {
                this.textViewer.getDocument().removePosition(this.changeList.remove(0));
            }
            this.changeListIndex = this.changeList.size();
        } else if (this.marks.containsKey(id)) {
            this.textViewer.getDocument().removePosition(this.marks.get(id));
        }
        this.marks.put(id, p);
    }

    public void deleteMark(String id) {
        if (this.isGlobalMark(id)) {
            this.deleteGlobalMark(id);
            return;
        }
        if (this.marks.containsKey(id)) {
            this.textViewer.getDocument().removePosition(this.marks.get(id));
            this.marks.remove(id);
        }
    }

    public boolean isGlobalMark(String id) {
        return id.length() == 1 && (id.charAt(0) >= 'A' && id.charAt(0) <= 'Z' || id.charAt(0) >= '0' && id.charAt(0) <= '9');
    }

    public net.sourceforge.vrapper.utils.Position getMark(String id) {
        Position p;
        IWorkspaceRoot root;
        IMarker marker;
        if (this.isGlobalMark(id) && (marker = EclipseCursorAndSelection.getGlobalMarker(id, (IResource)(root = ResourcesPlugin.getWorkspace().getRoot()))) != null) {
            return this.getGlobalMarkerPosition(marker);
        }
        if (id.equals("`")) {
            id = "'";
        }
        if ((p = this.marks.get(id)) == null || p.isDeleted) {
            if (id.equals("]")) {
                return this.getMark("[");
            }
            return null;
        }
        int offset = p.getOffset();
        return this.newPositionForModelOffset(offset);
    }

    public static IMarker getGlobalMarker(String id, IResource resource) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers(GLOBAL_MARK_TYPE, true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                if (m.getAttribute("message", "--").equals(id)) {
                    return m;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            VrapperLog.error((String)("Failed to find markers in resource " + resource), (Throwable)e);
        }
        return null;
    }

    private void setGlobalMark(String name, net.sourceforge.vrapper.utils.Position position) {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            IEditorInput editorInput = editorPart.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IFile file = fileInput.getFile();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            try {
                IMarker marker = EclipseCursorAndSelection.getGlobalMarker(name, (IResource)root);
                if (marker != null) {
                    marker.delete();
                }
                HashMap map = new HashMap();
                MarkerUtilities.setMessage(map, (String)name);
                int line = this.textViewer.getDocument().getLineOfOffset(position.getModelOffset());
                MarkerUtilities.setLineNumber(map, (int)line);
                MarkerUtilities.setCharStart(map, (int)position.getModelOffset());
                MarkerUtilities.setCharEnd(map, (int)(position.getModelOffset() + 1));
                MarkerUtilities.createMarker((IResource)file, map, (String)GLOBAL_MARK_TYPE);
            }
            catch (BadLocationException e) {
                throw new VrapperPlatformException("Failed to set global mark for " + position, (Throwable)e);
            }
            catch (CoreException e) {
                VrapperLog.error((String)("Failed to set marker in editor input " + editorInput), (Throwable)e);
            }
        }
    }

    private void deleteGlobalMark(String name) {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            IEditorInput editorInput = editorPart.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            try {
                IMarker marker = EclipseCursorAndSelection.getGlobalMarker(name, (IResource)root);
                if (marker != null) {
                    marker.delete();
                }
            }
            catch (CoreException e) {
                VrapperLog.error((String)("Failed to set marker in editor input " + editorInput), (Throwable)e);
            }
        }
    }

    private net.sourceforge.vrapper.utils.Position getGlobalMarkerPosition(IMarker marker) {
        AbstractTextEditor editor;
        IAnnotationModel annotationModel;
        int start = MarkerUtilities.getCharStart((IMarker)marker);
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null && editorPart instanceof AbstractTextEditor && (annotationModel = (editor = (AbstractTextEditor)editorPart).getDocumentProvider().getAnnotationModel((Object)editorPart.getEditorInput())) instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)annotationModel;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                start = pos.getOffset();
            } else {
                return null;
            }
        }
        return this.newPositionForModelOffset(start);
    }

    public net.sourceforge.vrapper.utils.Position getNextChangeLocation(int count) {
        int index = this.changeListIndex + count;
        return this.getChangeLocation(index);
    }

    public net.sourceforge.vrapper.utils.Position getPrevChangeLocation(int count) {
        int index = this.changeListIndex - count;
        return this.getChangeLocation(index);
    }

    private net.sourceforge.vrapper.utils.Position getChangeLocation(int index) {
        if (this.changeList.size() == 0) {
            return null;
        }
        if (index < 0) {
            index = 0;
        } else if (index >= this.changeList.size()) {
            index = this.changeList.size() - 1;
        }
        Position p = this.changeList.get(index);
        if (p == null || p.isDeleted) {
            this.changeList.remove(index);
            this.changeListIndex = this.changeList.size();
            if (p != null) {
                this.textViewer.getDocument().removePosition(p);
            }
            return null;
        }
        this.changeListIndex = index;
        return this.newPositionForModelOffset(p.getOffset());
    }

    public int getVisualOffset(net.sourceforge.vrapper.utils.Position position) {
        int offset = position.getViewOffset();
        StyledText textWidget = this.textViewer.getTextWidget();
        int visualOffset = textWidget.getLocationAtOffset((int)offset).x + textWidget.getHorizontalPixel();
        return visualOffset;
    }

    public net.sourceforge.vrapper.utils.Position getPositionByVisualOffset(int lineNo, int visualOffset) {
        Rectangle lineBounds;
        int lineOffset;
        IRegion region;
        int relVOffset;
        StyledText tw;
        block8: {
            block7: {
                tw = this.textViewer.getTextWidget();
                relVOffset = visualOffset - tw.getHorizontalPixel();
                region = this.textViewer.getDocument().getLineInformation(lineNo);
                lineOffset = this.converter.modelOffset2WidgetOffset(region.getOffset());
                if (region.getLength() != 0) break block7;
                Point lineStartPos = tw.getLocationAtOffset(lineOffset);
                if (relVOffset == lineStartPos.x) {
                    return new TextViewerPosition(this.textViewer, Space.VIEW, lineOffset);
                }
                return null;
            }
            lineBounds = tw.getTextBounds(lineOffset, lineOffset + region.getLength() - 1);
            if (lineBounds.contains(relVOffset, lineBounds.y)) break block8;
            return null;
        }
        try {
            Rectangle rect;
            int offset = lineOffset + region.getLength() * visualOffset / lineBounds.width;
            while (!(rect = tw.getTextBounds(offset, offset)).contains(relVOffset, rect.y)) {
                if (rect.x > relVOffset) {
                    --offset;
                    continue;
                }
                ++offset;
            }
            return new TextViewerPosition(this.textViewer, Space.VIEW, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int visualWidthToChars(int visualWidth) {
        return visualWidth / this.averageCharWidth;
    }

    private void updateStickyColumn(int offset) {
        Point locationAtOffset;
        StyledText textWidget = this.textViewer.getTextWidget();
        try {
            locationAtOffset = textWidget.getLocationAtOffset(offset);
        }
        catch (IllegalArgumentException e) {
            throw new VrapperPlatformException("Failed to get location info for V" + offset, (Throwable)e);
        }
        this.stickyColumn = locationAtOffset.x + textWidget.getHorizontalPixel();
        LineInformation line = this.textContent.getViewContent().getLineInformationOfOffset(offset);
        if (this.stickToEOL && offset < line.getEndOffset()) {
            this.stickToEOL = false;
        }
    }

    private int safeAddModelOffset(int oldOffset, int targetOffset, boolean allowPastLastChar) {
        IRegion lineInfo;
        int totalLineLength;
        int line;
        int delta = targetOffset - oldOffset;
        if (delta == 0) {
            return oldOffset;
        }
        if (targetOffset <= 0) {
            return 0;
        }
        int contentlength = this.textViewer.getDocument().getLength();
        if (targetOffset > contentlength) {
            targetOffset = contentlength;
        }
        try {
            line = this.textViewer.getDocument().getLineOfOffset(targetOffset);
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to get line nr for M" + targetOffset, (Throwable)e);
        }
        try {
            totalLineLength = this.textViewer.getDocument().getLineLength(line);
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to get line length for M" + targetOffset, (Throwable)e);
        }
        try {
            lineInfo = this.textViewer.getDocument().getLineInformation(line);
        }
        catch (BadLocationException e) {
            throw new VrapperPlatformException("Failed to get line info for M" + targetOffset, (Throwable)e);
        }
        int beginOffset = lineInfo.getOffset();
        int endOffset = lineInfo.getOffset() + lineInfo.getLength();
        if (targetOffset != contentlength) {
            if (delta > 0 && targetOffset > endOffset) {
                targetOffset = beginOffset + totalLineLength;
            } else if (delta < 0 && targetOffset > endOffset) {
                targetOffset = endOffset;
            }
        }
        if (!allowPastLastChar && targetOffset == endOffset && targetOffset > beginOffset) {
            --targetOffset;
        }
        return targetOffset;
    }

    public boolean shouldStickToEOL() {
        return this.stickToEOL;
    }

    private final class SelectionChangeListener
    implements SelectionListener,
    ISelectionChangedListener {
        private SelectionChangeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            if (!EclipseCursorAndSelection.this.selectionInProgress) {
                EclipseCursorAndSelection.this.selection = null;
                net.sourceforge.vrapper.utils.Position position = EclipseCursorAndSelection.this.getPosition();
                int viewOffset = position.getViewOffset();
                if (viewOffset >= 0) {
                    EclipseCursorAndSelection.this.updateStickyColumn(viewOffset);
                } else {
                    VrapperLog.error((String)("Cannot update stick column: caret is at position M" + position.getModelOffset() + " but" + " viewoffset is -1!"));
                }
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!EclipseCursorAndSelection.this.selectionInProgress) {
                EclipseCursorAndSelection.this.selection = null;
                net.sourceforge.vrapper.utils.Position position = EclipseCursorAndSelection.this.getPosition();
                int viewOffset = position.getViewOffset();
                if (viewOffset >= 0) {
                    EclipseCursorAndSelection.this.updateStickyColumn(viewOffset);
                } else {
                    VrapperLog.error((String)("Cannot update stick column: caret is at position M" + position.getModelOffset() + " but" + " viewoffset is -1!"));
                }
            }
        }
    }

    private final class StickyColumnUpdater
    implements CaretListener {
        boolean enabled = true;

        private StickyColumnUpdater() {
        }

        public void caretMoved(CaretEvent e) {
            if (this.enabled) {
                EclipseCursorAndSelection.this.updateStickyColumn(e.caretOffset);
            }
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }
    }

    private final class VisualCaretPainter
    implements PaintListener {
        private VisualCaretPainter() {
        }

        public void paintControl(PaintEvent e) {
            if (!VrapperPlugin.isVrapperEnabled()) {
                return;
            }
            StyledText text = EclipseCursorAndSelection.this.textViewer.getTextWidget();
            if (text.getSelectionCount() == 0 || EclipseCursorAndSelection.this.vrapperModeRecorder.getCurrentMode() instanceof InsertMode) {
                return;
            }
            text.getCaret().setVisible(true);
            net.sourceforge.vrapper.utils.Position to = EclipseCursorAndSelection.this.getSelection().getTo();
            boolean isInclusive = "inclusive".equals(EclipseCursorAndSelection.this.configuration.get(Options.SELECTION));
            int offset = to.getViewOffset();
            int documentLength = EclipseCursorAndSelection.this.textViewer.getDocument().getLength();
            if (offset < 0) {
                VrapperLog.debug((String)"In a fold");
                return;
            }
            if (documentLength > 0 && documentLength == to.getModelOffset() && isInclusive) {
                --offset;
            }
            Point visualOffset = text.getLocationAtOffset(offset);
            text.getCaret().setLocation(visualOffset);
        }
    }
}

