/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.HighlightingService;
import net.sourceforge.vrapper.utils.StartEndTextRange;
import net.sourceforge.vrapper.utils.TextRange;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EclipseHighlightingService
implements HighlightingService {
    private final AbstractTextEditor editor;
    private final CursorService cursorService;

    EclipseHighlightingService(AbstractTextEditor editor, CursorService cursorService) {
        this.editor = editor;
        this.cursorService = cursorService;
    }

    public List<Object> highlightRegions(String type, String name, List<TextRange> regions) {
        ArrayList<Object> annotations = new ArrayList<Object>();
        IAnnotationModel am = this.getAnnotationModel();
        if (am instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)am;
            LinkedHashMap<Annotation, Position> temp = new LinkedHashMap<Annotation, Position>(regions.size());
            for (TextRange region : regions) {
                Annotation annotation = new Annotation(type, false, name);
                int offset = region.getLeftBound().getModelOffset();
                int length = region.getModelLength();
                temp.put(annotation, new Position(offset, length));
            }
            ame.replaceAnnotations(null, temp);
            annotations.addAll(temp.keySet());
        } else if (am != null) {
            for (TextRange region : regions) {
                annotations.add(this.highlightRegion(type, name, region));
            }
        }
        return annotations;
    }

    public Object highlightRegion(String type, String name, TextRange region) {
        return this.highlightRegion(type, name, region.getLeftBound().getModelOffset(), region.getModelLength());
    }

    public Object highlightRegion(String type, String name, int offset, int length) {
        IAnnotationModel am = this.getAnnotationModel();
        if (am != null) {
            Annotation annotation = new Annotation(type, false, name);
            am.addAnnotation(annotation, new Position(offset, length));
            return annotation;
        }
        return null;
    }

    public TextRange getHighlightedRegion(Object annotationHandle) {
        Position position;
        Annotation annotation = (Annotation)annotationHandle;
        IAnnotationModel am = this.getAnnotationModel();
        if (am != null && annotation != null && (position = am.getPosition(annotation)) != null) {
            return new StartEndTextRange(this.cursorService.newPositionForModelOffset(position.getOffset()), this.cursorService.newPositionForModelOffset(position.getOffset() + position.getLength()));
        }
        return null;
    }

    public void removeHighlights(List<Object> annotationHandles) {
        IAnnotationModel am = this.getAnnotationModel();
        if (am instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)am;
            Annotation[] temp = annotationHandles.toArray(new Annotation[annotationHandles.size()]);
            ame.replaceAnnotations(temp, null);
        } else if (am != null) {
            for (Object annotationHandle : annotationHandles) {
                Annotation annotation = (Annotation)annotationHandle;
                if (annotation == null) continue;
                am.removeAnnotation(annotation);
            }
        }
    }

    public void removeHighlighting(Object annotationHandle) {
        Annotation annotation = (Annotation)annotationHandle;
        IAnnotationModel am = this.getAnnotationModel();
        if (am != null && annotation != null) {
            am.removeAnnotation(annotation);
        }
    }

    private IAnnotationModel getAnnotationModel() {
        IDocumentProvider doc = this.editor.getDocumentProvider();
        return doc != null ? doc.getAnnotationModel((Object)this.editor.getEditorInput()) : null;
    }
}

