/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.sourceforge.vrapper.eclipse.interceptor.EditorInfo;
import net.sourceforge.vrapper.eclipse.keymap.AbstractEclipseSpecificStateProvider;
import net.sourceforge.vrapper.eclipse.keymap.UnionStateProvider;
import net.sourceforge.vrapper.eclipse.mode.UnionModeProvider;
import net.sourceforge.vrapper.eclipse.platform.AbstractTextEditorSettings;
import net.sourceforge.vrapper.eclipse.platform.DummyHistoryService;
import net.sourceforge.vrapper.eclipse.platform.EclipseCursorAndSelection;
import net.sourceforge.vrapper.eclipse.platform.EclipseFileService;
import net.sourceforge.vrapper.eclipse.platform.EclipseHighlightingService;
import net.sourceforge.vrapper.eclipse.platform.EclipseHistoryService;
import net.sourceforge.vrapper.eclipse.platform.EclipseSearchAndReplaceService;
import net.sourceforge.vrapper.eclipse.platform.EclipseServiceProvider;
import net.sourceforge.vrapper.eclipse.platform.EclipseTextContent;
import net.sourceforge.vrapper.eclipse.platform.EclipseUserInterfaceService;
import net.sourceforge.vrapper.eclipse.platform.EclipseViewportService;
import net.sourceforge.vrapper.eclipse.platform.UnionTextObjectProvider;
import net.sourceforge.vrapper.eclipse.platform.VrapperModeRecorder;
import net.sourceforge.vrapper.eclipse.utils.Utils;
import net.sourceforge.vrapper.log.VrapperLog;
import net.sourceforge.vrapper.platform.AbstractPlatformSpecificModeProvider;
import net.sourceforge.vrapper.platform.BufferAndTabService;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.CursorService;
import net.sourceforge.vrapper.platform.FileService;
import net.sourceforge.vrapper.platform.GlobalConfiguration;
import net.sourceforge.vrapper.platform.HighlightingService;
import net.sourceforge.vrapper.platform.HistoryService;
import net.sourceforge.vrapper.platform.PlatformSpecificModeProvider;
import net.sourceforge.vrapper.platform.PlatformSpecificStateProvider;
import net.sourceforge.vrapper.platform.PlatformSpecificTextObjectProvider;
import net.sourceforge.vrapper.platform.SearchAndReplaceService;
import net.sourceforge.vrapper.platform.ServiceProvider;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.UnderlyingEditorSettings;
import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.utils.DefaultKeyMapProvider;
import net.sourceforge.vrapper.vim.DefaultConfigProvider;
import net.sourceforge.vrapper.vim.LocalConfiguration;
import net.sourceforge.vrapper.vim.SimpleLocalConfiguration;
import net.sourceforge.vrapper.vim.TextObjectProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EclipsePlatform
implements net.sourceforge.vrapper.platform.Platform {
    private final EclipseCursorAndSelection cursorAndSelection;
    private final EclipseTextContent textContent;
    private final EclipseFileService fileService;
    private final EclipseViewportService viewportService;
    private final HistoryService historyService;
    private final EclipseServiceProvider serviceProvider;
    private final EclipseUserInterfaceService userInterfaceService;
    private final DefaultKeyMapProvider keyMapProvider;
    private final UnderlyingEditorSettings underlyingEditorSettings;
    private final LocalConfiguration localConfiguration;
    private final AbstractTextEditor underlyingEditor;
    private final HighlightingService highlightingService;
    private final SearchAndReplaceService searchAndReplaceService;
    private final VrapperModeRecorder vrapperModeRecorder = new VrapperModeRecorder();
    private static final Map<String, PlatformSpecificStateProvider> providerCache = new ConcurrentHashMap<String, PlatformSpecificStateProvider>();
    private static final AtomicReference<PlatformSpecificModeProvider> modeProviderCache = new AtomicReference();
    private static final Map<String, PlatformSpecificTextObjectProvider> textObjProviderCache = new ConcurrentHashMap<String, PlatformSpecificTextObjectProvider>();
    private BufferAndTabService bufferAndTabService;

    public EclipsePlatform(EditorInfo partInfo, AbstractTextEditor abstractTextEditor, ISourceViewer sourceViewer, GlobalConfiguration sharedConfiguration, BufferAndTabService bufferAndTabService) {
        this.underlyingEditor = abstractTextEditor;
        this.underlyingEditorSettings = new AbstractTextEditorSettings(abstractTextEditor, sourceViewer);
        List<DefaultConfigProvider> configProviders = Collections.singletonList((DefaultConfigProvider)this.underlyingEditorSettings);
        this.localConfiguration = new SimpleLocalConfiguration(configProviders, (Configuration)sharedConfiguration);
        this.bufferAndTabService = bufferAndTabService;
        this.textContent = new EclipseTextContent((ITextViewer)sourceViewer);
        this.cursorAndSelection = new EclipseCursorAndSelection(this.vrapperModeRecorder, (Configuration)this.localConfiguration, partInfo, (ITextViewer)sourceViewer, this.textContent);
        this.fileService = new EclipseFileService(abstractTextEditor);
        this.viewportService = new EclipseViewportService((ITextViewer)sourceViewer);
        this.serviceProvider = new EclipseServiceProvider(abstractTextEditor);
        this.userInterfaceService = new EclipseUserInterfaceService((IEditorPart)abstractTextEditor, (ITextViewer)sourceViewer);
        this.keyMapProvider = new DefaultKeyMapProvider();
        this.highlightingService = new EclipseHighlightingService(abstractTextEditor, this.cursorAndSelection);
        this.searchAndReplaceService = new EclipseSearchAndReplaceService((ITextViewer)sourceViewer, (Configuration)this.localConfiguration, this.highlightingService);
        if (sourceViewer instanceof ITextViewerExtension6) {
            IUndoManager delegate = ((ITextViewerExtension6)sourceViewer).getUndoManager();
            EclipseHistoryService manager = new EclipseHistoryService((ITextViewer)sourceViewer, delegate);
            sourceViewer.setUndoManager((IUndoManager)manager);
            this.historyService = manager;
        } else {
            this.historyService = new DummyHistoryService();
        }
    }

    public VrapperModeRecorder getModeRecorder() {
        return this.vrapperModeRecorder;
    }

    public AbstractTextEditor getUnderlyingEditor() {
        return this.underlyingEditor;
    }

    public CursorService getCursorService() {
        return this.cursorAndSelection;
    }

    public TextContent getModelContent() {
        return this.textContent.getModelContent();
    }

    public EclipseCursorAndSelection getSelectionService() {
        return this.cursorAndSelection;
    }

    public TextContent getViewContent() {
        return this.textContent.getViewContent();
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public BufferAndTabService getBufferAndTabService() {
        return this.bufferAndTabService;
    }

    public ViewportService getViewportService() {
        return this.viewportService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public UserInterfaceService getUserInterfaceService() {
        return this.userInterfaceService;
    }

    public DefaultKeyMapProvider getKeyMapProvider() {
        return this.keyMapProvider;
    }

    public UnderlyingEditorSettings getUnderlyingEditorSettings() {
        return this.underlyingEditorSettings;
    }

    public LocalConfiguration getConfiguration() {
        return this.localConfiguration;
    }

    public PlatformSpecificStateProvider getPlatformSpecificStateProvider(TextObjectProvider textObjectProvider) {
        String className = this.underlyingEditor.getClass().getName();
        if (!providerCache.containsKey(className)) {
            providerCache.put(className, this.buildPlatformSpecificStateProvider(textObjectProvider));
        }
        return providerCache.get(className);
    }

    public PlatformSpecificModeProvider getPlatformSpecificModeProvider() {
        if (modeProviderCache.get() == null) {
            PlatformSpecificModeProvider provider = this.buildPlatformSpecificModeProvider();
            modeProviderCache.compareAndSet(null, provider);
        }
        return modeProviderCache.get();
    }

    public PlatformSpecificTextObjectProvider getPlatformSpecificTextObjectProvider() {
        String className = this.underlyingEditor.getClass().getName();
        if (!textObjProviderCache.containsKey(className)) {
            textObjProviderCache.put(className, this.buildPlatformSpecificTextObjectProvider());
        }
        return textObjProviderCache.get(className);
    }

    public SearchAndReplaceService getSearchAndReplaceService() {
        return this.searchAndReplaceService;
    }

    private PlatformSpecificStateProvider buildPlatformSpecificStateProvider(TextObjectProvider textObjectProvider) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("net.sourceforge.vrapper.eclipse.pssp");
        ArrayList<AbstractEclipseSpecificStateProvider> matched = new ArrayList<AbstractEclipseSpecificStateProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (VrapperLog.isDebugEnabled()) {
                VrapperLog.debug((String)("Loading Vrapper state provider " + element.getAttribute("name")));
            }
            try {
                AbstractEclipseSpecificStateProvider provider = (AbstractEclipseSpecificStateProvider)Utils.createGizmoForElementConditionally((IWorkbenchPart)this.underlyingEditor, "editor-must-subclass", element, "provider-class");
                if (provider != null) {
                    provider.configure(element);
                    provider.initializeProvider(textObjectProvider);
                    matched.add(provider);
                    if (VrapperLog.isDebugEnabled()) {
                        VrapperLog.debug((String)("Vrapper state provider " + element.getAttribute("name") + " configured"));
                    }
                }
            }
            catch (Exception e) {
                VrapperLog.error((String)("Failed to initialize state provider " + element), (Throwable)e);
            }
            ++n2;
        }
        Collections.sort(matched);
        return new UnionStateProvider("extensions for " + this.underlyingEditor.getClass().getName(), matched);
    }

    private PlatformSpecificModeProvider buildPlatformSpecificModeProvider() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("net.sourceforge.vrapper.eclipse.psmp");
        ArrayList<AbstractPlatformSpecificModeProvider> matched = new ArrayList<AbstractPlatformSpecificModeProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                matched.add((AbstractPlatformSpecificModeProvider)element.createExecutableExtension("provider-class"));
            }
            catch (Exception e) {
                VrapperLog.error((String)"error while building mode providers", (Throwable)e);
            }
            ++n2;
        }
        return new UnionModeProvider("Extension modes", matched);
    }

    private PlatformSpecificTextObjectProvider buildPlatformSpecificTextObjectProvider() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("net.sourceforge.vrapper.eclipse.pstop");
        ArrayList<PlatformSpecificTextObjectProvider> matched = new ArrayList<PlatformSpecificTextObjectProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PlatformSpecificTextObjectProvider provider = (PlatformSpecificTextObjectProvider)Utils.createGizmoForElementConditionally((IWorkbenchPart)this.underlyingEditor, "editor-must-subclass", element, "provider-class");
            if (provider != null) {
                matched.add(provider);
            }
            ++n2;
        }
        return new UnionTextObjectProvider("extensions for " + this.underlyingEditor.getClass().getName(), matched);
    }

    public String getEditorType() {
        IWorkbenchPartSite site = this.underlyingEditor.getSite();
        if (site instanceof MultiPageEditorSite) {
            site = ((MultiPageEditorSite)site).getMultiPageEditor().getSite();
        }
        return site.getRegisteredName();
    }

    public HighlightingService getHighlightingService() {
        return this.highlightingService;
    }
}

