/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import net.sourceforge.vrapper.eclipse.platform.OffsetConverter;
import net.sourceforge.vrapper.platform.TextContent;
import net.sourceforge.vrapper.platform.VrapperPlatformException;
import net.sourceforge.vrapper.utils.LineInformation;
import net.sourceforge.vrapper.utils.Space;
import net.sourceforge.vrapper.utils.TextRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;

public class EclipseTextContent {
    protected final ITextViewer textViewer;
    protected ITextViewerExtension5 converter;
    protected TextContent modelSide;
    protected TextContent viewSide;
    protected int horizontalPosition;
    protected boolean lineWiseMouseSelection;

    public EclipseTextContent(ITextViewer textViewer) {
        this.textViewer = textViewer;
        this.converter = OffsetConverter.create(textViewer);
        this.modelSide = new ModelSideTextContent();
        this.viewSide = new ViewSideTextContent();
    }

    public TextContent getModelContent() {
        return this.modelSide;
    }

    public TextContent getViewContent() {
        return this.viewSide;
    }

    protected class ModelSideTextContent
    implements TextContent {
        protected ModelSideTextContent() {
        }

        public LineInformation getLineInformation(int line) {
            try {
                IRegion region = EclipseTextContent.this.textViewer.getDocument().getLineInformation(line);
                return new LineInformation(line, region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                throw new VrapperPlatformException("Failed to get line info for ML" + line, (Throwable)e);
            }
        }

        public LineInformation getLineInformationOfOffset(int offset) {
            int line;
            try {
                line = EclipseTextContent.this.textViewer.getDocument().getLineOfOffset(offset);
            }
            catch (BadLocationException e) {
                throw new VrapperPlatformException("Failed to get line info for M" + offset, (Throwable)e);
            }
            return this.getLineInformation(line);
        }

        public int getNumberOfLines() {
            return EclipseTextContent.this.textViewer.getDocument().getNumberOfLines();
        }

        public int getTextLength() {
            return EclipseTextContent.this.textViewer.getDocument().getLength();
        }

        public String getText(int index, int length) {
            try {
                return EclipseTextContent.this.textViewer.getDocument().get(index, length);
            }
            catch (BadLocationException e) {
                throw new VrapperPlatformException("Failed to get text M" + index + " (" + length + " chars)", (Throwable)e);
            }
        }

        public String getText(TextRange range) {
            return this.getText(range.getLeftBound().getModelOffset(), range.getModelLength());
        }

        public void replace(int index, int length, String s) {
            try {
                IDocument doc = EclipseTextContent.this.textViewer.getDocument();
                if (index > doc.getLength()) {
                    index = doc.getLength();
                }
                doc.replace(index, length, s);
            }
            catch (BadLocationException e) {
                throw new VrapperPlatformException("Failed to replace for M" + index + " (" + length + " chars)", (Throwable)e);
            }
        }

        public void smartInsert(int index, String s) {
            int offset = EclipseTextContent.this.converter.modelOffset2WidgetOffset(index);
            if (offset == -1) {
                boolean exposed = EclipseTextContent.this.converter.exposeModelRange((IRegion)new Region(index, 1));
                if (!exposed) {
                    throw new VrapperPlatformException("Failed to expose M " + index + ", cannot operate on view for this index.");
                }
                offset = EclipseTextContent.this.converter.modelOffset2WidgetOffset(index);
            }
            EclipseTextContent.this.viewSide.smartInsert(offset, s);
        }

        public void smartInsert(String s) {
            EclipseTextContent.this.viewSide.smartInsert(s);
        }

        public Space getSpace() {
            return Space.MODEL;
        }
    }

    protected class ViewSideTextContent
    implements TextContent {
        protected ViewSideTextContent() {
        }

        public LineInformation getLineInformation(int line) {
            IRegion region;
            line = EclipseTextContent.this.converter.widgetLine2ModelLine(line);
            try {
                region = EclipseTextContent.this.textViewer.getDocument().getLineInformation(line);
            }
            catch (BadLocationException e) {
                throw new VrapperPlatformException("Failed to get line info for VL" + line, (Throwable)e);
            }
            return new LineInformation(EclipseTextContent.this.converter.modelLine2WidgetLine(line), EclipseTextContent.this.converter.modelOffset2WidgetOffset(region.getOffset()), region.getLength());
        }

        public LineInformation getLineInformationOfOffset(int offset) {
            int line;
            try {
                line = EclipseTextContent.this.textViewer.getTextWidget().getLineAtOffset(offset);
            }
            catch (IllegalArgumentException e) {
                throw new VrapperPlatformException("Failed to get line info for V" + offset, (Throwable)e);
            }
            return this.getLineInformation(line);
        }

        public int getNumberOfLines() {
            return EclipseTextContent.this.textViewer.getTextWidget().getLineCount();
        }

        public int getTextLength() {
            return EclipseTextContent.this.textViewer.getTextWidget().getCharCount();
        }

        public String getText(int index, int length) {
            try {
                return EclipseTextContent.this.textViewer.getTextWidget().getText(index, index + length - 1);
            }
            catch (IllegalArgumentException e) {
                throw new VrapperPlatformException("Failed to get text info for V" + index + " (" + length + " chars)", (Throwable)e);
            }
        }

        public String getText(TextRange range) {
            return this.getText(range.getLeftBound().getViewOffset(), range.getViewLength());
        }

        public void replace(int index, int length, String text) {
            try {
                EclipseTextContent.this.textViewer.getTextWidget().replaceTextRange(index, length, text);
            }
            catch (IllegalArgumentException e) {
                throw new VrapperPlatformException("Failed to replace for V" + index + " (" + length + " chars)", (Throwable)e);
            }
        }

        public void smartInsert(int index, String s) {
            StyledText textWidget = EclipseTextContent.this.textViewer.getTextWidget();
            int oldIndex = textWidget.getCaretOffset();
            Position oldposition = new Position(EclipseTextContent.this.converter.widgetOffset2ModelOffset(oldIndex));
            try {
                try {
                    EclipseTextContent.this.textViewer.getDocument().addPosition(oldposition);
                }
                catch (BadLocationException e) {
                    oldposition = null;
                    throw new VrapperPlatformException("Caret is at invalid pos V" + index, (Throwable)e);
                }
                try {
                    textWidget.setCaretOffset(index);
                }
                catch (IllegalArgumentException e) {
                    throw new VrapperPlatformException("Failed to move caret to V" + index, (Throwable)e);
                }
                textWidget.insert(s);
                try {
                    int newIndex = EclipseTextContent.this.converter.modelOffset2WidgetOffset(oldposition.offset);
                    textWidget.setCaretOffset(newIndex);
                }
                catch (IllegalArgumentException e) {
                    throw new VrapperPlatformException("Failed to move caret to M" + oldposition.offset, (Throwable)e);
                }
            }
            finally {
                if (oldposition != null) {
                    EclipseTextContent.this.textViewer.getDocument().removePosition(oldposition);
                }
            }
        }

        public void smartInsert(String s) {
            StyledText textWidget = EclipseTextContent.this.textViewer.getTextWidget();
            int pos = textWidget.getCaretOffset();
            if (pos < textWidget.getCharCount()) {
                this.smartInsert(pos, s);
            } else {
                try {
                    textWidget.replaceTextRange(pos, 0, s);
                    textWidget.setCaretOffset(textWidget.getCharCount());
                }
                catch (Exception e) {
                    throw new VrapperPlatformException("Failed to insert text at V" + pos + " (EOF)", (Throwable)e);
                }
            }
        }

        public Space getSpace() {
            return Space.VIEW;
        }
    }
}

