/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import net.sourceforge.vrapper.eclipse.ui.CommandLineUIFactory;
import net.sourceforge.vrapper.eclipse.ui.ModeContributionItem;
import net.sourceforge.vrapper.platform.CommandLineUI;
import net.sourceforge.vrapper.platform.UserInterfaceService;
import net.sourceforge.vrapper.vim.EditorAdaptor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class EclipseUserInterfaceService
implements UserInterfaceService {
    private static final String CONTRIBUTION_ITEM_NAME = "VimInputMode";
    private final CommandLineUIFactory commandLineFactory;
    private final IEditorPart editor;
    private final ModeContributionItem vimInputModeItem;
    private String lastInfoValue = "";
    private String lastErrorValue = "";
    private boolean infoSet;
    private String lastCommandResultValue = "";
    private String currentModeName;

    public EclipseUserInterfaceService(IEditorPart editor, ITextViewer textViewer) {
        this.editor = editor;
        this.commandLineFactory = new CommandLineUIFactory(textViewer.getTextWidget());
        this.vimInputModeItem = this.getContributionItem();
        this.setEditorMode("vrapper disabled");
        editor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)new PartChangeListener());
    }

    public void setEditorMode(String modeName) {
        this.currentModeName = modeName;
        this.vimInputModeItem.setText(this.currentModeName);
    }

    public void setAsciiValues(String asciiValue, int decValue, String hexValue, String octalValue) {
        String asciiValueText;
        this.lastCommandResultValue = asciiValueText = "<" + asciiValue + ">  " + decValue + ",  " + "Hex " + hexValue + ",  " + "Octal " + octalValue;
        this.setErrorMessage(null);
        this.setInfoMessage(asciiValueText);
    }

    public String getLastCommandResultValue() {
        return this.lastCommandResultValue;
    }

    public void setLastCommandResultValue(String lastCommandResultValue) {
        this.lastCommandResultValue = lastCommandResultValue;
    }

    public void setErrorMessage(String content) {
        this.editor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(content);
        this.lastErrorValue = content;
    }

    public String getLastErrorValue() {
        return this.lastErrorValue;
    }

    public void setInfoMessage(String content) {
        this.editor.getEditorSite().getActionBars().getStatusLineManager().setMessage(content);
        this.lastInfoValue = content;
    }

    public String getLastInfoValue() {
        return this.lastInfoValue;
    }

    private ModeContributionItem getContributionItem() {
        String name = CONTRIBUTION_ITEM_NAME + this.editor.getEditorSite().getId();
        IStatusLineManager manager = this.editor.getEditorSite().getActionBars().getStatusLineManager();
        ModeContributionItem item = (ModeContributionItem)manager.find(name);
        if (item == null) {
            item = new ModeContributionItem(name);
            try {
                manager.insertBefore("ElementState", (IContributionItem)item);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                manager.add((IContributionItem)item);
            }
            item.setVisible(true);
            manager.update(true);
        }
        return item;
    }

    public void setRecording(boolean b, String macroName) {
        this.setEditorMode(this.currentModeName);
        this.vimInputModeItem.setRecording(b, macroName);
    }

    public boolean isInfoSet() {
        return this.infoSet;
    }

    public void setInfoSet(boolean infoSet) {
        this.infoSet = infoSet;
    }

    public CommandLineUI getCommandLineUI(EditorAdaptor editorAdaptor) {
        return this.commandLineFactory.createCommandLineUI(editorAdaptor);
    }

    private final class PartChangeListener
    implements IPartListener {
        private PartChangeListener() {
        }

        public void partActivated(IWorkbenchPart arg0) {
            if (arg0 == EclipseUserInterfaceService.this.editor) {
                EclipseUserInterfaceService.this.setEditorMode(EclipseUserInterfaceService.this.currentModeName);
            }
        }

        public void partBroughtToTop(IWorkbenchPart arg0) {
        }

        public void partClosed(IWorkbenchPart arg0) {
            if (arg0 == EclipseUserInterfaceService.this.editor) {
                EclipseUserInterfaceService.this.editor.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
            }
        }

        public void partDeactivated(IWorkbenchPart arg0) {
        }

        public void partOpened(IWorkbenchPart arg0) {
        }
    }
}

