/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import net.sourceforge.vrapper.eclipse.platform.OffsetConverter;
import net.sourceforge.vrapper.platform.ViewportService;
import net.sourceforge.vrapper.utils.Position;
import net.sourceforge.vrapper.utils.ViewPortInformation;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;

public class EclipseViewportService
implements ViewportService {
    private final ITextViewer textViewer;
    private final ITextViewerExtension5 textViewer5;
    private Object lock;

    public EclipseViewportService(ITextViewer textViewer) {
        this.textViewer = textViewer;
        this.textViewer5 = OffsetConverter.create(textViewer);
    }

    public void setRepaint(boolean redraw) {
        if (this.lock == null) {
            this.textViewer.getTextWidget().setRedraw(redraw);
        }
    }

    public void lockRepaint(Object lock) {
        if (this.lock == null) {
            this.lock = lock;
        }
    }

    public void unlockRepaint(Object lock) {
        if (this.lock == lock) {
            this.lock = null;
        }
    }

    public void exposeModelPosition(Position position) {
        this.textViewer5.exposeModelRange((IRegion)new Region(position.getModelOffset(), 1));
    }

    public ViewPortInformation getViewPortInformation() {
        return new ViewPortInformation(this.textViewer5.modelLine2WidgetLine(this.textViewer.getTopIndex()), this.textViewer5.modelLine2WidgetLine(this.textViewer.getBottomIndex()));
    }

    public void setTopLine(int line) {
        this.textViewer.setTopIndex(this.textViewer5.widgetLine2ModelLine(line));
    }

    public int modelLine2ViewLine(int line) {
        return this.textViewer5.modelLine2WidgetLine(line);
    }

    public int viewLine2ModelLine(int line) {
        return this.textViewer5.widgetLine2ModelLine(line);
    }
}

