/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vrapper.eclipse.platform;

import java.util.Map;
import java.util.Set;
import net.sourceforge.vrapper.eclipse.platform.SWTClipboardRegister;
import net.sourceforge.vrapper.platform.Configuration;
import net.sourceforge.vrapper.platform.GlobalConfiguration;
import net.sourceforge.vrapper.vim.ConfigurationListener;
import net.sourceforge.vrapper.vim.Options;
import net.sourceforge.vrapper.vim.register.DefaultRegisterManager;
import net.sourceforge.vrapper.vim.register.Register;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;

public class SWTRegisterManager
extends DefaultRegisterManager {
    protected SWTClipboardRegister clipboardRegister;
    protected SWTClipboardRegister selectionClipboardRegister;

    public SWTRegisterManager(Display d, GlobalConfiguration globalConfig, Map<String, Register> platformRegisters) {
        super(platformRegisters);
        this.clipboardRegister = new SWTClipboardRegister(d, 1);
        this.registers.put("+", this.clipboardRegister);
        this.selectionClipboardRegister = "linux".equals(Platform.getOS()) ? new SWTClipboardRegister(d, 2) : this.clipboardRegister;
        this.registers.put("*", this.selectionClipboardRegister);
        ConfigurationListener listener = new ConfigurationListener(){

            public <T> void optionChanged(Configuration.Option<T> option, T oldValue, T newValue) {
                if (Options.CLIPBOARD.equals(option)) {
                    Set newValues = (Set)newValue;
                    Register oldDefault = SWTRegisterManager.this.defaultRegister;
                    if (newValues.contains("unnamedplus")) {
                        SWTRegisterManager.this.defaultRegister = SWTRegisterManager.this.clipboardRegister;
                    } else if (newValues.contains("unnamed")) {
                        SWTRegisterManager.this.defaultRegister = SWTRegisterManager.this.selectionClipboardRegister;
                    } else {
                        SWTRegisterManager.this.defaultRegister = SWTRegisterManager.this.unnamedRegister;
                    }
                    if (SWTRegisterManager.this.activeRegister == oldDefault) {
                        SWTRegisterManager.this.activeRegister = SWTRegisterManager.this.defaultRegister;
                    }
                }
            }
        };
        globalConfig.addListener(listener);
    }
}

