/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.access.UserServiceImpl;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;

public class User
extends Artifact
implements UserToken {
    private PropertyStore userSettings;

    public User(Long id, String guid, BranchToken branch) {
        super(id, guid, branch, CoreArtifactTypes.User);
    }

    public User(BranchToken branch) {
        super(branch, CoreArtifactTypes.User);
    }

    public void setFieldsBasedon(User u) throws Exception {
        this.setName(u.getName());
        this.setPhone(u.getPhone());
        this.setEmail(u.getEmail());
        this.setUserID(u.getUserId());
        this.setActive(u.isActive());
    }

    public String getUserId() {
        return this.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId, "");
    }

    public void setUserID(String userId) {
        this.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId, userId);
    }

    public String getEmail() {
        return this.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Email, "");
    }

    public void setEmail(String email) {
        this.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Email, email);
    }

    public String getPhone() {
        return this.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Phone, "");
    }

    public void setPhone(String phone) {
        this.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Phone, phone);
    }

    public boolean isActive() {
        return (Boolean)this.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Active);
    }

    public void setActive(boolean active) {
        this.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Active, active);
    }

    public void toggleFavoriteBranch(BranchId favoriteBranch) {
        Conditions.checkNotNull((Object)favoriteBranch, (String)"Branch");
        HashSet<BranchToken> branches = new HashSet<BranchToken>(BranchManager.getBranches(BranchArchivedState.UNARCHIVED, BranchType.WORKING, BranchType.BASELINE));
        boolean found = false;
        List attributes = this.getAttributes((AttributeTypeId)CoreAttributeTypes.FavoriteBranch);
        for (Attribute attribute : attributes) {
            BranchId branch;
            try {
                branch = BranchId.valueOf((String)((String)attribute.getValue()));
            }
            catch (Exception exception) {
                continue;
            }
            if (!branches.contains(branch)) {
                attribute.delete();
                continue;
            }
            if (!favoriteBranch.equals(branch)) continue;
            attribute.delete();
            found = true;
        }
        if (!found) {
            this.addAttribute((AttributeTypeId)CoreAttributeTypes.FavoriteBranch, favoriteBranch.getIdString());
        }
        this.setSetting(CoreAttributeTypes.FavoriteBranch.getName(), favoriteBranch.getIdString());
        this.saveSettings();
    }

    public boolean isFavoriteBranch(BranchId branch) {
        List<String> attributes = this.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.FavoriteBranch);
        for (String value : attributes) {
            try {
                if (!branch.equals(BranchId.valueOf((String)value))) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public String getSetting(String key) {
        this.ensureUserSettingsAreLoaded();
        return this.userSettings.get(key);
    }

    public boolean getBooleanSetting(String key) {
        return Boolean.parseBoolean(this.getSetting(key));
    }

    public void setSetting(String key, String value) {
        this.ensureUserSettingsAreLoaded();
        this.userSettings.put(key, value);
    }

    public void setSetting(String key, Long value) {
        this.ensureUserSettingsAreLoaded();
        this.userSettings.put(key, value.longValue());
    }

    public void saveSettings() {
        if (this.userSettings != null) {
            StringWriter stringWriter = new StringWriter();
            try {
                this.userSettings.save((Writer)stringWriter);
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            this.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.UserSettings, stringWriter.toString());
            if (this.isDirty()) {
                this.persist("User - Save Settings (IDE)");
            }
        }
    }

    private void ensureUserSettingsAreLoaded() {
        if (this.userSettings == null) {
            PropertyStore store = new PropertyStore(this.getGuid());
            try {
                String settings = this.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserSettings, null);
                if (settings != null) {
                    store.load((Reader)new StringReader(settings));
                }
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            this.userSettings = store;
        }
    }

    public boolean isSystemUser() {
        return SystemUser.isSystemUser((Id)this);
    }

    public void setBooleanSetting(String key, boolean value) {
        this.setSetting(key, String.valueOf(value));
    }

    public boolean isOseeAdmin() {
        return this.getRoles().contains(CoreUserGroups.OseeAdmin);
    }

    public List<IUserGroupArtifactToken> getRoles() {
        return UserServiceImpl.getUserGrps();
    }

    public List<String> getLoginIds() {
        return this.getAttributeValues((AttributeTypeId)CoreAttributeTypes.LoginId);
    }

    public ArtifactToken getArtifact() {
        return this;
    }

    public void setArtifact(ArtifactToken artifact) {
    }

    public String toStringFull() {
        return this.toStringWithId();
    }
}

