/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.EventTopicTransferType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.transaction.BaseTransactionData;

public class ArtifactTransactionData
extends BaseTransactionData {
    private static final String INSERT_ARTIFACT = "INSERT INTO osee_artifact (gamma_id, art_id, art_type_id, guid) VALUES (?,?,?,?)";
    private final Artifact artifact;

    public ArtifactTransactionData(Artifact artifact) {
        super((Id)artifact, artifact.getModType());
        this.artifact = artifact;
    }

    @Override
    public OseeSql getSelectTxNotCurrentSql() {
        return OseeSql.TX_GET_PREVIOUS_TX_NOT_CURRENT_ARTIFACTS;
    }

    @Override
    protected void addInsertToBatch(BaseTransactionData.InsertDataCollector collector) {
        super.addInsertToBatch(collector);
        if (!this.artifact.isUseBackingdata()) {
            this.internalAddInsertToBatch(collector, 1, INSERT_ARTIFACT, new Object[]{this.getGammaId(), this.artifact, this.artifact.getArtifactType(), this.artifact.getGuid()});
        }
    }

    @Override
    protected void internalUpdate(TransactionRecord transactionId) {
        this.artifact.internalSetPersistenceData(this.getGammaId(), (TransactionToken)transactionId, this.getModificationType(), this.getApplicabilityId(), false, false);
    }

    @Override
    protected void internalClearDirtyState() {
    }

    @Override
    protected void internalOnRollBack() {
    }

    @Override
    protected GammaId createGammaId() {
        return this.artifact.isUseBackingdata() ? this.artifact.getGammaId() : this.getNextGammaIdFromSequence();
    }

    @Override
    protected void internalAddToEvents(ArtifactEvent artifactEvent) {
        if (this.getModificationType().equals(ModificationType.DELETED)) {
            artifactEvent.addArtifact(new EventBasicGuidArtifact(EventModType.Deleted, this.artifact));
        } else {
            artifactEvent.addArtifact(new EventBasicGuidArtifact(EventModType.Added, this.artifact));
        }
    }

    @Override
    protected void internalAddToEvents(ArtifactTopicEvent artifactTopicEvent) {
        EventModType mod = this.getModificationType().equals(ModificationType.DELETED) ? EventModType.Deleted : EventModType.Added;
        EventTopicArtifactTransfer transferArt = FrameworkEventUtil.artifactTransferFactory((BranchId)this.artifact.getBranch(), this.artifact, (ArtifactTypeId)this.artifact.getArtifactType(), mod, null, null, EventTopicTransferType.BASE);
        artifactTopicEvent.addArtifact(transferArt);
    }

    @Override
    protected ApplicabilityId getApplicabilityId() {
        return this.artifact.getApplicablityId();
    }
}

