/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.client.OseeClientProperties;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UpdateBranchData;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.exception.BranchDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleBranchesExist;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.MergeBranch;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.model.cache.BranchCache;
import org.eclipse.osee.framework.core.model.cache.BranchFilter;
import org.eclipse.osee.framework.core.model.cache.IOseeCache;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.ArchiveUnArchiveBranchJob;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.DeleteBranchOperation;
import org.eclipse.osee.framework.skynet.core.artifact.IDefaultInitialBranchesProvider;
import org.eclipse.osee.framework.skynet.core.artifact.UpdateMergeBranch;
import org.eclipse.osee.framework.skynet.core.artifact.operation.UpdateBranchOperation;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.update.ConflictResolverOperation;
import org.eclipse.osee.framework.skynet.core.commit.actions.CommitAction;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictManagerExternal;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.httpRequests.CommitBranchHttpRequestOperation;
import org.eclipse.osee.framework.skynet.core.httpRequests.CreateBranchHttpRequestOperation;
import org.eclipse.osee.framework.skynet.core.httpRequests.PurgeBranchHttpRequestOperation;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.internal.accessors.DatabaseBranchAccessor;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.Id4JoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;

public final class BranchManager {
    private static final String LAST_DEFAULT_BRANCH = "LastDefaultBranchUuid";
    public static final String COMMIT_COMMENT = "Commit Branch ";
    private static final String SELECT_BRANCH_BY_NAME = "select * from osee_branch where branch_name = ?";
    private static final String SELECT_BRANCH_BY_ASSOC_ART = "select * from osee_branch where associated_art_id = ?";
    private static BranchToken lastBranch;

    private BranchManager() {
    }

    private static BranchCache getCache() {
        return ServiceUtil.getOseeCacheService().getBranchCache();
    }

    public static List<BranchToken> getBranches(Predicate<Branch> branchFilter) {
        return BranchManager.getCache().getBranches(branchFilter);
    }

    public static BranchToken getBranch(Predicate<Branch> branchFilter) {
        List<BranchToken> branches = BranchManager.getBranches(branchFilter);
        if (branches.isEmpty()) {
            return null;
        }
        if (branches.size() == 1) {
            return branches.get(0);
        }
        throw new MultipleBranchesExist("More than 1 branch exists that matches the filter: " + branchFilter, new Object[0]);
    }

    public static void refreshBranches() {
        String refreshWindow = OseeInfo.getValue("cache.reload.throttle.millis");
        boolean reload = true;
        if (Strings.isNumeric((String)refreshWindow)) {
            long timeInMillis = Long.parseLong(refreshWindow);
            long diff = System.currentTimeMillis() - BranchManager.getCache().getLastLoaded();
            if (diff < timeInMillis) {
                reload = false;
            }
        }
        if (reload) {
            BranchManager.getCache().reloadCache();
        }
    }

    public static BranchToken getBranch(String branchName) {
        Collection<BranchToken> branches = BranchManager.getBranchesByName(branchName);
        if (branches.isEmpty()) {
            throw new BranchDoesNotExist("No branch exists with the name: [%s]", new Object[]{branchName});
        }
        if (branches.size() > 1) {
            throw new MultipleBranchesExist("More than 1 branch exists with the name: [%s]", new Object[]{branchName});
        }
        return branches.iterator().next();
    }

    public static Collection<BranchToken> getBranchesByAssocArt(ArtifactToken art) {
        ArrayList<BranchToken> branches = new ArrayList<BranchToken>(1);
        ConnectionHandler.getJdbcClient().runQuery(stmt -> {
            boolean bl = branches.add(BranchManager.getBranchToken(stmt.getLong("branch_id")));
        }, SELECT_BRANCH_BY_ASSOC_ART, new Object[]{art.getId()});
        return branches;
    }

    public static Collection<BranchToken> getBranchesByName(String branchName) {
        ArrayList<BranchToken> branches = new ArrayList<BranchToken>(1);
        ConnectionHandler.getJdbcClient().runQuery(stmt -> {
            boolean bl = branches.add(BranchManager.getBranchToken(stmt.getLong("branch_id")));
        }, SELECT_BRANCH_BY_NAME, new Object[]{branchName});
        return branches;
    }

    public static BranchToken getBranchToken(BranchId branch) {
        if (branch instanceof BranchToken) {
            return (BranchToken)branch;
        }
        return BranchManager.getBranch(branch);
    }

    public static BranchToken getBranchToken(Long branchId) {
        return BranchManager.getBranch(BranchId.valueOf((Long)branchId));
    }

    public static Branch getBranch(BranchId branch) {
        if (branch instanceof Branch) {
            return (Branch)branch;
        }
        return BranchManager.getBranch(branch, branch.getViewId());
    }

    public static Branch getBranch(BranchId branchId, ArtifactId view) {
        if (branchId == null) {
            throw new BranchDoesNotExist("Branch Id is null", new Object[0]);
        }
        if (branchId.isInvalid()) {
            throw new BranchDoesNotExist("Branch id is invalid", new Object[0]);
        }
        BranchCache cache = BranchManager.getCache();
        Branch branch = null;
        if (view.notEqual((Id)ArtifactId.SENTINEL)) {
            branch = cache.getBranchWithView(branchId, view);
            if (branch == null) {
                branch = cache.get(branchId);
                if (branch == null) {
                    branch = BranchManager.loadBranchToCache(branchId);
                }
                branch = cache.cacheBranchWithView(branch, ArtifactQuery.getArtifactTokenFromId((BranchId)branch, view));
            }
        } else {
            branch = cache.get(branchId);
            if (branch == null) {
                branch = BranchManager.loadBranchToCache(branchId);
            }
        }
        return branch;
    }

    public static synchronized void checkAndReload(BranchId branch) {
        if (!BranchManager.branchExists(branch)) {
            BranchManager.loadBranchToCache(branch);
        }
    }

    private static Branch loadBranchToCache(BranchId branchId) {
        Branch branch = DatabaseBranchAccessor.loadBranchOrNull((IOseeCache<Branch>)BranchManager.getCache(), branchId);
        if (branch != null) {
            BranchManager.getCache().cache((NamedId)branch);
        }
        return branch;
    }

    public static boolean branchExists(BranchId branch) {
        return BranchManager.getCache().get(branch) != null;
    }

    public static boolean branchExists(long uuid) {
        return BranchManager.getCache().getById((Number)uuid) != null;
    }

    public static BranchToken getMergeBranch(BranchId sourceBranch, BranchId destinationBranch) {
        return BranchManager.getCache().findMergeBranch(sourceBranch, destinationBranch);
    }

    public static MergeBranch getFirstMergeBranch(BranchId sourceBranch) {
        return BranchManager.getCache().findFirstMergeBranch(sourceBranch);
    }

    public static List<MergeBranch> getMergeBranches(BranchId sourceBranch) {
        List mergeBranches = BranchManager.getCache().findAllMergeBranches(sourceBranch);
        return mergeBranches;
    }

    public static boolean hasMergeBranches(BranchId sourceBranch) {
        return !BranchManager.getMergeBranches(sourceBranch).isEmpty();
    }

    public static boolean doesMergeBranchExist(BranchId sourceBranch, BranchId destBranch) {
        return BranchManager.getMergeBranch(sourceBranch, destBranch) != null;
    }

    public static void reloadBranch(BranchId branch) {
        BranchManager.loadBranchToCache(branch);
    }

    public static XResultData isDeleteable(Collection<ArtifactToken> artifacts, XResultData results) {
        LinkedList<ArtifactToken> artIdsToCheck = new LinkedList<ArtifactToken>();
        for (ArtifactToken art : artifacts) {
            if (!art.isOnBranch((BranchId)CoreBranches.COMMON)) continue;
            artIdsToCheck.add(art);
        }
        if (!artIdsToCheck.isEmpty()) {
            for (BranchToken branch : BranchManager.getCache().getAll()) {
                ArtifactId associatedArtifactId = BranchManager.getAssociatedArtifactId((BranchId)branch);
                if (BranchManager.getState((BranchId)branch) == BranchState.DELETED || !artIdsToCheck.contains(associatedArtifactId)) continue;
                results.errorf("Cannot delete artId [%s] because it is the associated artifact of branch [%s]", new Object[]{associatedArtifactId, branch.getName()});
            }
        }
        return results;
    }

    public static boolean isUpdatable(BranchId branchToUpdate) {
        return !BranchManager.hasMergeBranches(branchToUpdate) || BranchManager.getState(branchToUpdate).isRebaselineInProgress();
    }

    public static UpdateBranchData updateBranch(BranchToken branch, ConflictResolverOperation resolver) {
        return new UpdateBranchOperation(branch, resolver).run();
    }

    public static UpdateBranchData updateBranch(BranchToken branch, BranchId fromBranch, ConflictResolverOperation resolver) {
        return new UpdateBranchOperation(branch, fromBranch, resolver).run();
    }

    public static void purgeBranch(BranchId branch) {
        Operations.executeWorkAndCheckStatus((IOperation)new PurgeBranchHttpRequestOperation(branch, false));
    }

    public static void setType(BranchId branch, BranchType type) {
        BranchEndpoint proxy = ServiceUtil.getOseeClient().getBranchEndpoint();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response response = proxy.setBranchType(branch, type);){
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                BranchManager.getBranch(branch).setBranchType(type);
                OseeEventManager.kickBranchEvent(BranchManager.class, new BranchEvent(BranchEventType.TypeUpdated, branch));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void setState(BranchId branch, BranchState state) {
        BranchEndpoint proxy = ServiceUtil.getOseeClient().getBranchEndpoint();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response response = proxy.setBranchState(branch, state);){
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                BranchManager.getBranch(branch).setBranchState(state);
                OseeEventManager.kickBranchEvent(BranchManager.class, new BranchEvent(BranchEventType.StateUpdated, branch));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void archiveUnArchiveBranch(final BranchId branch, BranchArchivedState state) {
        boolean setArchived;
        ArchiveUnArchiveBranchJob archiveBranchJob;
        if (state.isArchived()) {
            archiveBranchJob = new ArchiveUnArchiveBranchJob("Archive Branch", BranchId.valueOf((Long)branch.getId()), ArchiveUnArchiveBranchJob.ArchiveType.ARCHIVE);
            setArchived = true;
        } else {
            archiveBranchJob = new ArchiveUnArchiveBranchJob("Unarchive Branch", BranchId.valueOf((Long)branch.getId()), ArchiveUnArchiveBranchJob.ArchiveType.UNARCHIVE);
            setArchived = false;
        }
        archiveBranchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (status.equals(Status.OK_STATUS)) {
                    ArchiveUnArchiveBranchJob job = (ArchiveUnArchiveBranchJob)event.getJob();
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (Response response = job.getResponse();){
                        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                            BranchManager.getBranch(branch).setArchived(setArchived);
                            OseeEventManager.kickBranchEvent((Object)this, new BranchEvent(BranchEventType.ArchiveStateUpdated, branch));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        });
        archiveBranchJob.setUser(true);
        archiveBranchJob.setPriority(30);
        archiveBranchJob.schedule();
    }

    public static void setName(BranchId branch, String newBranchName) {
        BranchEndpoint proxy = ServiceUtil.getOseeClient().getBranchEndpoint();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response response = proxy.setBranchName(branch, newBranchName);){
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                BranchManager.getBranch(branch).setName(newBranchName);
                OseeEventManager.kickBranchEvent(BranchManager.class, new BranchEvent(BranchEventType.Renamed, branch));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Job deleteBranch(BranchId branch) {
        return Operations.executeAsJob((IOperation)new DeleteBranchOperation(branch), (boolean)true);
    }

    public static IStatus deleteBranchAndPend(BranchId branch) {
        return Operations.executeWork((IOperation)new DeleteBranchOperation(branch));
    }

    public static Job deleteBranch(List<? extends BranchId> branches) {
        ArrayList<DeleteBranchOperation> ops = new ArrayList<DeleteBranchOperation>();
        for (BranchId branchId : branches) {
            ops.add(new DeleteBranchOperation(branchId));
        }
        OperationBuilder operationBuilder = Operations.createBuilder((String)"Deleting multiple branches...");
        operationBuilder.addAll(ops);
        return Operations.executeAsJob((IOperation)operationBuilder.build(), (boolean)false);
    }

    public static TransactionResult commitBranch(IProgressMonitor monitor, ConflictManagerExternal conflictManager, boolean archiveSourceBranch, boolean overwriteUnresolvedConflicts) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (conflictManager.remainingConflictsExist() && !overwriteUnresolvedConflicts) {
            throw new OseeCoreException("Commit failed due to unresolved conflicts", new Object[0]);
        }
        if (!BranchManager.isEditable((BranchId)conflictManager.getDestinationBranch())) {
            throw new OseeCoreException("Commit failed - unable to commit into a non-editable branch", new Object[0]);
        }
        boolean skipCommitChecksAndEvents = OseeClientProperties.isSkipCommitChecksAndEvents();
        boolean updating = BranchManager.checkIfUpdateFromParent(conflictManager);
        if (!skipCommitChecksAndEvents && !updating) {
            XResultData rd = new XResultData();
            BranchManager.runCommitExtPointActions(conflictManager, rd);
            if (rd.isErrors()) {
                throw new OseeCoreException("Commit failed: %s", new Object[]{rd.toString()});
            }
        }
        boolean skipCommitEvents = OseeClientProperties.isSkipCommitEvents();
        CommitBranchHttpRequestOperation operation = new CommitBranchHttpRequestOperation((ArtifactId)UserManager.getUser(), (BranchId)conflictManager.getSourceBranch(), (BranchId)conflictManager.getDestinationBranch(), archiveSourceBranch, skipCommitEvents);
        Operations.executeWork((IOperation)operation, (IProgressMonitor)monitor);
        TransactionResult transactionResult = operation.getTransactionResult();
        return transactionResult;
    }

    private static boolean checkIfUpdateFromParent(ConflictManagerExternal conflictManager) {
        BranchState state;
        BranchToken sourceBranch = conflictManager.getSourceBranch();
        return sourceBranch.isValid() && (state = BranchManager.getState((BranchId)sourceBranch)).isRebaselineInProgress();
    }

    private static void runCommitExtPointActions(ConflictManagerExternal conflictManager, XResultData rd) {
        ExtensionDefinedObjects extensions = new ExtensionDefinedObjects("org.eclipse.osee.framework.skynet.core.CommitActions", "CommitActions", "className");
        for (CommitAction commitAction : extensions.getObjects()) {
            commitAction.runCommitAction((BranchId)conflictManager.getSourceBranch(), (BranchId)conflictManager.getDestinationBranch(), rd);
        }
    }

    public static BranchToken getOrCreateMergeBranch(BranchToken sourceBranch, BranchToken destBranch, ArrayList<ArtifactId> expectedArtIds) {
        BranchToken mergeBranch = BranchManager.getMergeBranch((BranchId)sourceBranch, (BranchId)destBranch);
        if (mergeBranch == null) {
            mergeBranch = BranchManager.createMergeBranch(sourceBranch, destBranch, expectedArtIds);
        } else {
            UpdateMergeBranch op = new UpdateMergeBranch(ConnectionHandler.getJdbcClient(), (BranchId)mergeBranch, expectedArtIds, (BranchId)destBranch, (BranchId)sourceBranch);
            Operations.executeWorkAndCheckStatus((IOperation)op);
        }
        return mergeBranch;
    }

    private static BranchToken createMergeBranch(BranchToken sourceBranch, BranchToken destBranch, ArrayList<ArtifactId> expectedArtIds) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery();){
            for (ArtifactId artId : expectedArtIds) {
                joinQuery.add((Id)sourceBranch, (Id)artId, (Id)TransactionId.SENTINEL, (Id)sourceBranch.getViewId());
            }
            joinQuery.store();
            TransactionRecord parentTx = BranchManager.getBaseTransaction((BranchId)sourceBranch);
            String creationComment = String.format("New Merge Branch from %s(%s) and %s", sourceBranch.getName(), parentTx.getId(), destBranch.getName());
            String branchName = "Merge " + sourceBranch.getShortName() + " <=> " + destBranch.getShortName();
            BranchToken branch = BranchManager.createBranch(BranchType.MERGE, (TransactionToken)parentTx, branchName, UserManager.getUser(), creationComment, joinQuery.getQueryId(), (BranchId)destBranch);
            MergeBranch mergeBranch = (MergeBranch)BranchManager.getBranch((BranchId)branch);
            mergeBranch.setSourceBranch(sourceBranch);
            mergeBranch.setDestinationBranch(destBranch);
            return mergeBranch;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BranchToken createWorkingBranchFromTx(TransactionToken parentTransactionId, String childBranchName, Artifact associatedArtifact) {
        String creationComment = String.format("New branch, copy of %s from transaction %s", BranchManager.getBranchName(parentTransactionId), parentTransactionId.getId());
        CreateBranchHttpRequestOperation operation = new CreateBranchHttpRequestOperation(BranchType.WORKING, parentTransactionId, BranchToken.create((String)childBranchName), (ArtifactId)associatedArtifact, creationComment);
        operation.setTxCopyBranchType(true);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        return operation.getNewBranch();
    }

    public static BranchToken createWorkingBranchFromBranchToken(BranchId parentBranch, BranchToken childBranchToken) {
        TransactionToken parentTransactionId = TransactionManager.getHeadTransaction(parentBranch);
        return BranchManager.createBranch(BranchType.WORKING, parentTransactionId, childBranchToken, ArtifactId.SENTINEL);
    }

    public static BranchToken createPortBranchFromTx(TransactionToken parentTransactionId, String childBranchName, Artifact associatedArtifact) {
        String creationComment = String.format("New port branch, copy of %s from transaction %s", BranchManager.getBranchName(parentTransactionId), parentTransactionId.getId());
        CreateBranchHttpRequestOperation operation = new CreateBranchHttpRequestOperation(BranchType.PORT, parentTransactionId, BranchToken.create((String)childBranchName), (ArtifactId)associatedArtifact, creationComment);
        operation.setTxCopyBranchType(true);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        return operation.getNewBranch();
    }

    public static BranchToken createWorkingBranch(BranchId parentBranch, String childBranchName) {
        return BranchManager.createWorkingBranch(parentBranch, childBranchName, ArtifactId.SENTINEL);
    }

    public static BranchToken createWorkingBranch(BranchId parentBranch, String childBranchName, ArtifactId associatedArtifact) {
        TransactionToken parentTransactionId = TransactionManager.getHeadTransaction(parentBranch);
        return BranchManager.createWorkingBranch(parentTransactionId, childBranchName, associatedArtifact);
    }

    public static BranchToken createWorkingBranch(BranchId parentBranch, BranchToken childBranch) {
        TransactionToken parentTransactionId = TransactionManager.getHeadTransaction(parentBranch);
        return BranchManager.createBranch(BranchType.WORKING, parentTransactionId, childBranch, ArtifactId.SENTINEL);
    }

    public static BranchToken createWorkingBranch(TransactionToken parentTransaction, String branchName, ArtifactId associatedArtifact) {
        return BranchManager.createBranch(BranchType.WORKING, parentTransaction, BranchToken.create((String)branchName), associatedArtifact);
    }

    public static BranchToken createBaselineBranch(BranchToken parentBranch, BranchToken childBranch) {
        return BranchManager.createBaselineBranch(parentBranch, childBranch, ArtifactId.SENTINEL);
    }

    public static BranchToken createTopLevelBranch(BranchToken branch) {
        return BranchManager.createBaselineBranch(CoreBranches.SYSTEM_ROOT, branch, ArtifactId.SENTINEL);
    }

    private static BranchToken createBaselineBranch(BranchToken parentBranch, BranchToken childBranch, ArtifactId associatedArtifact) {
        TransactionToken parentTransaction = TransactionManager.getHeadTransaction((BranchId)parentBranch);
        return BranchManager.createBranch(BranchType.BASELINE, parentTransaction, childBranch, associatedArtifact);
    }

    public static BranchToken createTopLevelBranch(String branchName) {
        return BranchManager.createTopLevelBranch(BranchToken.create((String)branchName));
    }

    private static BranchToken createBranch(BranchType branchType, TransactionToken parentTransaction, BranchToken childBranch, ArtifactId associatedArtifact) {
        String creationComment = String.format("New Branch from %s (%s)", BranchManager.getBranchName(parentTransaction), parentTransaction.getId());
        CreateBranchHttpRequestOperation operation = new CreateBranchHttpRequestOperation(branchType, parentTransaction, childBranch, associatedArtifact, creationComment);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        return operation.getNewBranch();
    }

    private static BranchToken createBranch(BranchType branchType, TransactionToken parentTransaction, String branchName, Artifact associatedArtifact, String creationComment, Long mergeAddressingQueryId, BranchId destinationBranch) {
        CreateBranchHttpRequestOperation operation = new CreateBranchHttpRequestOperation(branchType, parentTransaction, BranchToken.create((String)branchName), (ArtifactId)associatedArtifact, creationComment, mergeAddressingQueryId, destinationBranch);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        return operation.getNewBranch();
    }

    public static List<? extends BranchToken> getBaselineBranches() {
        return BranchManager.getBranches(BranchArchivedState.UNARCHIVED, BranchType.BASELINE);
    }

    public static List<BranchToken> getBranches(BranchArchivedState archivedState, BranchType ... branchTypes) {
        return BranchManager.getCache().getBranches((Predicate)new BranchFilter(archivedState, branchTypes));
    }

    private static BranchId getDefaultInitialBranch() {
        ExtensionDefinedObjects extensions = new ExtensionDefinedObjects("org.eclipse.osee.framework.skynet.core.DefaultInitialBranchProvider", "DefaultInitialBranchProvider", "class", true);
        for (IDefaultInitialBranchesProvider provider : extensions.getObjects()) {
            try {
                for (BranchId branch : provider.getDefaultInitialBranches()) {
                    if (branch == null) continue;
                    return branch;
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"Exception occurred while trying to determine initial default branch", (Throwable)ex);
            }
        }
        return CoreBranches.COMMON;
    }

    public static BranchToken getLastBranch() {
        if (lastBranch == null) {
            try {
                lastBranch = BranchManager.getBranchToken(BranchId.valueOf((String)UserManager.getSetting(LAST_DEFAULT_BRANCH)));
            }
            catch (Exception exception) {
                try {
                    lastBranch = BranchManager.getBranchToken(BranchManager.getDefaultInitialBranch());
                    UserManager.setSetting(LAST_DEFAULT_BRANCH, lastBranch.getId());
                }
                catch (OseeCoreException ex1) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex1);
                }
            }
        }
        return lastBranch;
    }

    public static void setLastBranch(BranchToken branch) {
        lastBranch = branch;
    }

    public static void decache(Branch branch) {
        BranchManager.getCache().decache((NamedId)branch);
    }

    public static boolean hasChanges(BranchId branch) {
        return BranchManager.getBaseTransaction(branch).notEqual((Id)TransactionManager.getHeadTransaction(branch));
    }

    public static boolean isChangeManaged(BranchId branch) {
        return BranchManager.getAssociatedArtifactId(branch).isValid();
    }

    public static void setAssociatedArtifactId(BranchId branch, ArtifactId artifactId) {
        OseeClient client = ServiceUtil.getOseeClient();
        BranchEndpoint proxy = client.getBranchEndpoint();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Response response = proxy.associateBranchToArtifact(branch, artifactId);){
            if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                BranchManager.getBranch(branch).setAssociatedArtifact(artifactId);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ArtifactId getAssociatedArtifactId(BranchId branch) {
        return BranchManager.getBranch(branch).getAssociatedArtifactId();
    }

    public static Artifact getAssociatedArtifact(BranchId branch) {
        ArtifactId associatedArtifactId = BranchManager.getAssociatedArtifactId(branch);
        if (associatedArtifactId.isInvalid()) {
            return Artifact.SENTINEL;
        }
        return ArtifactQuery.getArtifactFromId(associatedArtifactId, (BranchId)CoreBranches.COMMON);
    }

    public static Artifact getAssociatedArtifact(TransactionDelta txDelta) {
        Artifact associatedArtifact = null;
        if (txDelta.areOnTheSameBranch()) {
            ArtifactId commitArtId = TransactionManager.getCommitArtifact((TransactionId)txDelta.getEndTx());
            if (commitArtId.isValid()) {
                associatedArtifact = ArtifactQuery.getArtifactFromId(commitArtId, (BranchId)CoreBranches.COMMON);
            }
        } else {
            BranchId sourceBranch = txDelta.getStartTx().getBranch();
            associatedArtifact = BranchManager.getAssociatedArtifact(sourceBranch);
        }
        return associatedArtifact;
    }

    public static void invalidateBranches() {
        BranchManager.getCache().invalidate();
    }

    public static BranchToken getParentBranch(BranchId branch) {
        return BranchManager.getBranch(branch).getParentBranch();
    }

    public static boolean isParentSystemRoot(BranchId branch) {
        return BranchManager.isParent(branch, (BranchId)CoreBranches.SYSTEM_ROOT);
    }

    public static boolean isParent(BranchId branch, BranchId parentBranch) {
        return parentBranch.equals(BranchManager.getParentBranch(branch));
    }

    public static TransactionRecord getBaseTransaction(BranchId branch) {
        return BranchManager.getBranch(branch).getBaseTransaction();
    }

    public static TransactionRecord getSourceTransaction(BranchId branch) {
        return BranchManager.getBranch(branch).getSourceTransaction();
    }

    public static BranchState getState(BranchId branch) {
        return BranchManager.getBranch(branch).getBranchState();
    }

    public static BranchType getType(BranchId branch) {
        return BranchManager.getBranch(branch).getBranchType();
    }

    public static BranchType getType(TransactionToken tx) {
        return BranchManager.getBranch(tx.getBranch()).getBranchType();
    }

    public static boolean isEditable(BranchId branch) {
        Branch fullBranch = BranchManager.getBranch(branch);
        BranchState state = fullBranch.getBranchState();
        return (state.isCreated() || state.isModified() || state.isRebaselineInProgress()) && !fullBranch.isArchived();
    }

    public static Collection<BranchId> getAncestors(BranchId branch) {
        return BranchManager.getBranch(branch).getAncestors();
    }

    public static boolean hasAncestor(BranchId branch, BranchId ancestor) {
        return BranchManager.getBranch(branch).hasAncestor(ancestor);
    }

    public static boolean isArchived(BranchId branchId) {
        if (branchId.equals(CoreBranches.COMMON)) {
            return false;
        }
        return BranchManager.getAndCheck(branchId).isArchived();
    }

    private static Branch getAndCheck(BranchId branchId) {
        Branch branch = BranchManager.getBranch(branchId);
        if (branch == null) {
            throw new BranchDoesNotExist("Branch %s does not exist", new Object[]{branchId});
        }
        return branch;
    }

    public static String getArchivedStr(BranchId branchId) {
        Branch branch = BranchManager.getAndCheck(branchId);
        if (branch == null || branch.isInvalid()) {
            return "";
        }
        if (branch.getBranchState() != BranchState.COMMITTED) {
            return "UnCommitted";
        }
        return branch.isArchived() ? "Archived" : "UnArchived";
    }

    public static boolean hasChildren(BranchId branchId) {
        Branch branch = BranchManager.getAndCheck(branchId);
        return !branch.getChildren().isEmpty();
    }

    public static Collection<BranchToken> getChildBranches(BranchId branch, boolean recurse) {
        HashSet<BranchToken> children = new HashSet<BranchToken>();
        BranchFilter filter = new BranchFilter(BranchArchivedState.UNARCHIVED, new BranchType[0]);
        filter.setNegatedBranchTypes(new BranchType[]{BranchType.MERGE});
        BranchManager.getBranch(branch).getChildBranches(children, recurse, (Predicate)filter);
        return children;
    }

    public static void resetWasLoaded() {
        BranchManager.getCache().invalidate();
    }

    public static boolean isLoaded() {
        return BranchManager.getCache().isLoaded();
    }

    public static String getBranchName(BranchId branchId) {
        Branch branch = BranchManager.getAndCheck(branchId);
        return branch.getName();
    }

    public static String getBranchShortName(BranchId branchId) {
        Branch branch = BranchManager.getAndCheck(branchId);
        return branch.getShortName();
    }

    public static String getBranchName(TransactionToken tx) {
        return BranchManager.getBranch(tx.getBranch()).getName();
    }

    public static String getBranchShortName(TransactionToken tx) {
        return BranchManager.getBranch(tx.getBranch()).getShortName();
    }

    public static String toStringWithId(BranchId branch) {
        return BranchManager.getBranch(branch).toStringWithId();
    }

    public static Branch getBranch(TransactionToken transaction) {
        return BranchManager.getBranch(transaction.getBranch());
    }

    public static List<BranchCategoryToken> getBranchCategories(BranchId branchId) {
        Branch branch = null;
        branch = branchId instanceof Branch ? (Branch)branchId : BranchManager.getBranch(branchId);
        if (branch.getCategories() == null) {
            branch.setCategories(ServiceUtil.getOseeClient().getBranchEndpoint().getBranchCategories((BranchId)branch));
        }
        return branch.getCategories();
    }
}

