/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.client.QueryBuilder;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.LoadType;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactMatch;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQueryBuilder;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactSearchCriteria;
import org.eclipse.osee.framework.skynet.core.artifact.search.AttributeCriteria;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryType;
import org.eclipse.osee.framework.skynet.core.artifact.search.RelationCriteria;
import org.eclipse.osee.framework.skynet.core.artifact.search.SearchOptions;
import org.eclipse.osee.framework.skynet.core.artifact.search.SearchRequest;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.rest.model.ArtifactEndpoint;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMatch;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchParameters;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResult;

public class ArtifactQuery {
    private static Map<Long, String> uuidToGuid;
    private static String attributeTokenQuery;
    private static String artifactTokenByGuidQuery;
    private static String artifactTokenByArtIdQuery;

    static {
        attributeTokenQuery = "select art.art_id, art.art_type_id, art.guid, attr.value from osee_txs txsArt, osee_txs txsAttr, osee_artifact art, osee_attribute attr where art.art_type_id in ( ART_IDS_HERE ) and txsArt.BRANCH_ID = ? and art.GAMMA_ID = txsArt.GAMMA_ID and txsArt.TX_CURRENT = 1 and txsAttr.BRANCH_ID = ? and attr.GAMMA_ID = txsAttr.GAMMA_ID and txsAttr.TX_CURRENT = 1 and art.ART_ID = attr.art_id and attr.ATTR_TYPE_ID = ? and value = ? ";
        artifactTokenByGuidQuery = "select ART.ART_ID, attr.VALUE, art.art_type_id, art.guid from OSEE_ATTRIBUTE attr, OSEE_ARTIFACT art, OSEE_TXS txs where txs.BRANCH_ID = ? and art.GUID in ( ART_GUIDS_HERE ) and txs.TX_CURRENT = 1 and attr.ATTR_TYPE_ID = 1152921504606847088 and attr.ART_ID = art.ART_ID and txs.GAMMA_ID = ATTR.GAMMA_ID";
        artifactTokenByArtIdQuery = "select ART.ART_ID, attr.VALUE, art.art_type_id, art.guid from OSEE_ATTRIBUTE attr, OSEE_ARTIFACT art, OSEE_TXS txs where txs.BRANCH_ID = ? and art.art_id in ( ART_IDS_HERE ) and txs.TX_CURRENT = 1 and attr.ATTR_TYPE_ID = 1152921504606847088 and attr.ART_ID = art.ART_ID and txs.GAMMA_ID = ATTR.GAMMA_ID";
    }

    public static <T extends ArtifactId & HasBranch> Artifact getArtifactFromToken(T artifactToken, DeletionFlag deletionFlag) {
        return ArtifactQuery.getOrCheckArtifactFromId(artifactToken, (BranchId)((HasBranch)artifactToken).getBranch(), deletionFlag, QueryType.GET);
    }

    public static <T extends ArtifactId & HasBranch> Artifact getArtifactOrNull(T artifactToken, DeletionFlag deletionFlag) {
        return ArtifactQuery.getOrCheckArtifactFromId(artifactToken, (BranchId)((HasBranch)artifactToken).getBranch(), deletionFlag, QueryType.CHECK);
    }

    public static <T extends ArtifactId & HasBranch> Artifact getArtifactFromToken(T artifactToken) {
        Conditions.assertTrue((boolean)artifactToken.isValid(), (String)"Valid artifact token must be specified.", (Object[])new Object[0]);
        Conditions.assertTrue((boolean)((HasBranch)artifactToken).getBranch().isValid(), (String)"Branch must be specified.", (Object[])new Object[0]);
        return ArtifactQuery.getOrCheckArtifactFromId(artifactToken, (BranchId)((HasBranch)artifactToken).getBranch(), DeletionFlag.EXCLUDE_DELETED, QueryType.GET);
    }

    public static ArtifactToken getArtifactFromTokenOrSentinel(ArtifactToken artifactToken) {
        ArtifactToken art = ArtifactToken.SENTINEL;
        try {
            art = ArtifactQuery.getArtifactFromToken(artifactToken);
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return art;
    }

    public static Artifact getArtifactFromId(long artId, BranchId branch) {
        return ArtifactQuery.getOrCheckArtifactFromId(ArtifactId.valueOf((Long)artId), branch, DeletionFlag.EXCLUDE_DELETED, QueryType.GET);
    }

    public static Artifact getArtifactFromId(ArtifactId artId, BranchId branch) {
        return ArtifactQuery.getOrCheckArtifactFromId(artId, branch, DeletionFlag.EXCLUDE_DELETED, QueryType.GET);
    }

    public static Artifact getArtifactFromId(ArtifactId artifactId, BranchId branch, DeletionFlag deletionFlag) {
        return ArtifactQuery.getOrCheckArtifactFromId(artifactId, branch, deletionFlag, QueryType.GET);
    }

    public static Artifact getArtifactOrNull(ArtifactId artifactId, BranchId branch, DeletionFlag deletionFlag) {
        return ArtifactQuery.getOrCheckArtifactFromId(artifactId, branch, deletionFlag, QueryType.CHECK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Artifact getOrCheckArtifactFromId(ArtifactId artifactId, BranchId branch, DeletionFlag allowDeleted, QueryType queryType) {
        Conditions.assertNotSentinel((Id)artifactId);
        ArtifactToken artifactToken = ArtifactToken.valueOf((ArtifactId)artifactId, (BranchToken)BranchManager.getBranchToken(branch));
        Artifact artifact = ArtifactCache.getActive(artifactToken);
        if (artifact == null) return new ArtifactQueryBuilder(artifactId, branch, allowDeleted, LoadLevel.ALL).getOrCheckArtifact(queryType);
        if (!artifact.isDeleted()) return artifact;
        if (allowDeleted != DeletionFlag.EXCLUDE_DELETED) return artifact;
        if (queryType != QueryType.CHECK) throw new ArtifactDoesNotExist("Deleted artifact unexpectedly returned", new Object[0]);
        return null;
    }

    public static Artifact checkArtifactFromId(ArtifactId artifactId, BranchId branch, DeletionFlag allowDeleted) {
        return ArtifactQuery.getOrCheckArtifactFromId(artifactId, branch, allowDeleted, QueryType.CHECK);
    }

    public static Artifact checkArtifactFromId(String guid, BranchId branch, DeletionFlag allowDeleted) {
        return ArtifactQuery.getOrCheckArtifactFromId(guid, branch, allowDeleted, QueryType.CHECK);
    }

    public static Artifact checkArtifactFromId(ArtifactId artifactId, BranchId branch) {
        return ArtifactQuery.getOrCheckArtifactFromId(artifactId, branch, DeletionFlag.EXCLUDE_DELETED, QueryType.CHECK);
    }

    public static Artifact getArtifactFromId(String guid, BranchId branch) {
        return ArtifactQuery.getOrCheckArtifactFromId(guid, branch, DeletionFlag.EXCLUDE_DELETED, QueryType.GET);
    }

    public static Artifact getArtifactFromId(String guid, BranchId branch, DeletionFlag allowDeleted) {
        return ArtifactQuery.getOrCheckArtifactFromId(guid, branch, allowDeleted, QueryType.GET);
    }

    private static Artifact getOrCheckArtifactFromId(String guid, BranchId branch, DeletionFlag allowDeleted, QueryType queryType) {
        Artifact artifact = ArtifactCache.getActive(guid, branch);
        if (artifact != null) {
            if (artifact.isDeleted() && allowDeleted == DeletionFlag.EXCLUDE_DELETED) {
                if (queryType == QueryType.CHECK) {
                    return null;
                }
                throw new ArtifactDoesNotExist("Deleted artifact unexpectedly returned", new Object[0]);
            }
            return artifact;
        }
        return new ArtifactQueryBuilder(guid, branch, allowDeleted, LoadLevel.ALL).getOrCheckArtifact(queryType);
    }

    public static List<ArtifactId> getArtifactIdsFromTypeAndName(ArtifactTypeId artifactType, String artifactName, BranchId branch) {
        return new ArtifactQueryBuilder(artifactType, branch, LoadLevel.ALL, new AttributeCriteria((AttributeTypeId)CoreAttributeTypes.Name, artifactName, new QueryOption[0])).selectArtifacts(2);
    }

    public static Artifact getArtifactFromTypeAndName(ArtifactTypeId artifactType, String artifactName, BranchId branch) {
        return ArtifactQuery.getArtifactFromTypeAndAttribute(artifactType, (AttributeTypeId)CoreAttributeTypes.Name, artifactName, branch, QueryType.GET);
    }

    public static Artifact checkArtifactFromTypeAndName(ArtifactTypeId artifactType, String artifactName, BranchId branch) {
        return ArtifactQuery.getArtifactFromTypeAndAttribute(artifactType, (AttributeTypeId)CoreAttributeTypes.Name, artifactName, branch, QueryType.CHECK);
    }

    public static Artifact getArtifactFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        return ArtifactQuery.getArtifactFromTypeAndAttribute(artifactType, attributeType, attributeValue, branch, QueryType.GET);
    }

    private static Artifact getArtifactFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, String attributeValue, BranchId branch, QueryType queryType) {
        return new ArtifactQueryBuilder(artifactType, branch, LoadLevel.ALL, new AttributeCriteria(attributeType, attributeValue, new QueryOption[0])).getOrCheckArtifact(queryType);
    }

    public static List<Artifact> getArtifactListFromTypeAndName(ArtifactTypeId artifactType, String artifactName, BranchId branch) {
        return ArtifactQuery.getArtifactListFromTypeAndAttribute(artifactType, (AttributeTypeId)CoreAttributeTypes.Name, artifactName, branch);
    }

    public static List<Artifact> getArtifactListFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        return new ArtifactQueryBuilder(artifactType, branch, LoadLevel.ALL, new AttributeCriteria(attributeType, attributeValue, new QueryOption[0])).getArtifacts(100, null);
    }

    public static List<Artifact> getArtifactListFrom(Collection<? extends ArtifactId> artifactIds, BranchId branch) {
        return ArtifactLoader.loadArtifacts(artifactIds, branch, LoadLevel.ALL, LoadType.INCLUDE_CACHE, DeletionFlag.INCLUDE_DELETED);
    }

    public static List<Artifact> getArtifactListFrom(Collection<? extends ArtifactId> artifactIds, BranchId branch, DeletionFlag allowDeleted) {
        return ArtifactLoader.loadArtifacts(artifactIds, branch, LoadLevel.ALL, LoadType.INCLUDE_CACHE, allowDeleted);
    }

    public static List<Artifact> getArtifactListFromIds(List<String> guids, BranchId branch) {
        return new ArtifactQueryBuilder(guids, branch, LoadLevel.ALL).getArtifacts(30, null);
    }

    public static List<Artifact> getArtifactListFromIds(List<String> guids, BranchId branch, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(guids, branch, allowDeleted, LoadLevel.ALL).getArtifacts(30, null);
    }

    public static List<Artifact> getHistoricalArtifactListFromIds(List<String> guids, TransactionToken transactionId, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(guids, transactionId, allowDeleted, LoadLevel.ALL).getArtifacts(30, null);
    }

    public static List<Artifact> getHistoricalArtifactListFromIds(Collection<ArtifactId> artifactIds, TransactionToken transactionId, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(artifactIds, transactionId, allowDeleted, LoadLevel.ALL).getArtifacts(30, null);
    }

    public static Artifact getHistoricalArtifactFromId(ArtifactId artifactId, TransactionToken transactionId, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(artifactId, transactionId, allowDeleted, LoadLevel.ALL).getOrCheckArtifact(QueryType.GET);
    }

    public static Artifact getHistoricalArtifactOrNull(ArtifactId artifactId, TransactionToken transactionId, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(artifactId, transactionId, allowDeleted, LoadLevel.ALL).getOrCheckArtifact(QueryType.CHECK);
    }

    public static Artifact getHistoricalArtifactFromId(String guid, TransactionToken transactionId, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(Arrays.asList(guid), transactionId, allowDeleted, LoadLevel.ALL).getOrCheckArtifact(QueryType.GET);
    }

    public static List<Artifact> getArtifactListFromName(String artifactName, BranchId branch, DeletionFlag allowDeleted, QueryOption[] options) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, allowDeleted, new AttributeCriteria((AttributeTypeId)CoreAttributeTypes.Name, artifactName, options)).getArtifacts(30, null);
    }

    public static List<Artifact> getArtifactListFromName(String artifactName, BranchId branch) {
        return ArtifactQuery.getArtifactListFromTypeAndAttribute(ArtifactTypeId.SENTINEL, (AttributeTypeId)CoreAttributeTypes.Name, artifactName, branch);
    }

    public static List<Artifact> getArtifactListFromTypeAndName(ArtifactTypeId artifactType, String artifactName, BranchId branch, QueryOption[] options) {
        return new ArtifactQueryBuilder(artifactType, branch, LoadLevel.ALL, new AttributeCriteria((AttributeTypeId)CoreAttributeTypes.Name, artifactName, options)).getArtifacts(100, null);
    }

    public static Artifact getArtifactFromAttribute(AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        return ArtifactQuery.getOrCheckArtifact(QueryType.GET, ArtifactQuery.getArtifactListFromAttribute(attributeType, attributeValue, branch));
    }

    public static List<Artifact> getArtifactListFromType(ArtifactTypeToken artifactTypeToken, BranchId branch) {
        return ArtifactQuery.getArtifactListFromType(artifactTypeToken, branch, DeletionFlag.EXCLUDE_DELETED);
    }

    public static List<Artifact> getArtifactListFromType(ArtifactTypeToken artifactType, BranchId branch, DeletionFlag allowDeleted) {
        return ArtifactQuery.getArtifactListFrom(ArtifactQuery.getArtifactEndpoint(branch).getArtifactIdsByType(artifactType), branch, allowDeleted);
    }

    public static List<Artifact> getArtifactListFromBranch(BranchId branch, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, allowDeleted).getArtifacts(10000, null);
    }

    public static List<Artifact> reloadArtifactListFromBranch(BranchId branch, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, allowDeleted).reloadArtifacts(10000);
    }

    public static List<Artifact> getArtifactListFromTypes(Collection<? extends ArtifactTypeId> artifactTypes, BranchId branch, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(artifactTypes, branch, LoadLevel.ALL, allowDeleted).getArtifacts(1000, null);
    }

    public static List<Artifact> getArtifactListFromTypeWithInheritence(ArtifactTypeToken artifactType, BranchId branch, DeletionFlag allowDeleted) {
        List artifactTypes = artifactType.getAllDescendantTypes();
        artifactTypes.add(artifactType);
        return ArtifactQuery.getArtifactListFromTypes(artifactTypes, branch, allowDeleted);
    }

    public static int getArtifactCountFromTypeWithInheritence(ArtifactTypeToken artifactType, BranchId branch, DeletionFlag allowDeleted) {
        List artifactTypes = artifactType.getAllDescendantTypes();
        artifactTypes.add(artifactType);
        return ArtifactQuery.getArtifactCountFromTypes(artifactTypes, branch, allowDeleted);
    }

    public static int getArtifactCountFromTypes(Collection<? extends ArtifactTypeId> artifactTypes, BranchId branch, DeletionFlag allowDeleted) {
        return new ArtifactQueryBuilder(artifactTypes, branch, LoadLevel.ALL, allowDeleted).countArtifacts();
    }

    public static List<Artifact> getArtifactListFromTypeAnd(ArtifactTypeId artifactType, BranchId branch, int artifactCountEstimate, List<ArtifactSearchCriteria> criteria) {
        return new ArtifactQueryBuilder(artifactType, branch, LoadLevel.ALL, criteria).getArtifacts(artifactCountEstimate, null);
    }

    public static List<Artifact> getArtifactListFromCriteria(BranchId branch, int artifactCountEstimate, List<ArtifactSearchCriteria> criteria) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, criteria).getArtifacts(artifactCountEstimate, null);
    }

    public static List<Artifact> getArtifactListFromCriteria(BranchId branch, int artifactCountEstimate, ArtifactSearchCriteria ... criteria) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, DeletionFlag.EXCLUDE_DELETED, criteria).getArtifacts(artifactCountEstimate, null);
    }

    public static List<Artifact> getRelatedArtifactList(ArtifactToken artifact, RelationTypeToken relationType, RelationSide relationSide) {
        return new ArtifactQueryBuilder((BranchId)artifact.getBranch(), LoadLevel.ALL, DeletionFlag.EXCLUDE_DELETED, new RelationCriteria((ArtifactId)artifact, relationType, relationSide)).getArtifacts(1000, null);
    }

    public static List<Artifact> getArtifactListFromRelation(RelationTypeToken relationType, RelationSide relationSide, BranchId branch) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, DeletionFlag.EXCLUDE_DELETED, new RelationCriteria(relationType, relationSide)).getArtifacts(1000, null);
    }

    public static List<Artifact> getArtifactListFromAttribute(AttributeTypeId attributeType, String attributeValue, BranchId branch, QueryOption ... options) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, DeletionFlag.EXCLUDE_DELETED, new AttributeCriteria(attributeType, attributeValue, options)).getArtifacts(300, null);
    }

    public static List<Artifact> getArtifactListFromAttribute(AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        return ArtifactQuery.getArtifactListFromTypeAndAttribute(ArtifactTypeId.SENTINEL, attributeType, attributeValue, branch);
    }

    public static List<Artifact> getArtifactListFromAttributeType(AttributeTypeId attributeType, BranchId branch) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, DeletionFlag.EXCLUDE_DELETED, new AttributeCriteria(attributeType, new QueryOption[0])).getArtifacts(300, null);
    }

    public static List<Artifact> getArtifactListFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, Collection<ArtifactId> attributeValues, BranchId branch) {
        List idStrings = org.eclipse.osee.framework.jdk.core.util.Collections.transform(attributeValues, String::valueOf);
        return ArtifactQuery.getArtifactListFromTypeAndAttribute(artifactType, attributeType, idStrings, branch, 10);
    }

    public static List<Artifact> getArtifactListFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, Collection<String> attributeValues, BranchId branch, int artifactCountEstimate) {
        return new ArtifactQueryBuilder(artifactType, branch, LoadLevel.ALL, new AttributeCriteria(attributeType, attributeValues)).getArtifacts(artifactCountEstimate, null);
    }

    public static List<Artifact> getArtifactListFromAttributeValues(AttributeTypeId attributeType, Collection<String> attributeValues, BranchId branch, int artifactCountEstimate) {
        return new ArtifactQueryBuilder(branch, LoadLevel.ALL, DeletionFlag.EXCLUDE_DELETED, new AttributeCriteria(attributeType, attributeValues)).getArtifacts(artifactCountEstimate, null);
    }

    public static List<Artifact> getArtifactListFromAttributeValues(AttributeTypeId attributeType, Collection<ArtifactId> attributeValues, BranchId branch) {
        List idStrings = org.eclipse.osee.framework.jdk.core.util.Collections.transform(attributeValues, Id::getIdString);
        return ArtifactQuery.getArtifactListFromAttributeValues(attributeType, idStrings, branch, 10);
    }

    public static List<Artifact> getArtifactListFromAttributeKeywords(BranchId branch, String queryString, boolean isMatchWordOrder, DeletionFlag deletionFlag, boolean isCaseSensitive, AttributeTypeId ... attributeTypes) {
        QueryBuilderArtifact queryBuilder = ArtifactQuery.createQueryBuilder(branch);
        queryBuilder.includeDeleted(deletionFlag.areDeletedAllowed());
        QueryOption matchCase = QueryOption.getCaseType((boolean)isCaseSensitive);
        QueryOption matchWordOrder = QueryOption.getTokenOrderType((boolean)isMatchWordOrder);
        Collection<AttributeTypeId> typesToSearch = attributeTypes.length == 0 ? Collections.singleton(QueryBuilder.ANY_ATTRIBUTE_TYPE) : Arrays.asList(attributeTypes);
        queryBuilder.and(typesToSearch, queryString, new QueryOption[]{matchCase, matchWordOrder});
        return queryBuilder.getResults().getList();
    }

    public static Iterable<ArtifactMatch> getArtifactMatchesFromAttributeKeywords(SearchRequest searchRequest) {
        QueryBuilderArtifact queryBuilder = ArtifactQuery.createQueryBuilder(searchRequest.getBranch());
        SearchOptions options = searchRequest.getOptions();
        queryBuilder.includeDeleted(options.getDeletionFlag().areDeletedAllowed());
        QueryOption matchCase = QueryOption.getCaseType((boolean)options.isCaseSensitive());
        QueryOption matchWordOrder = QueryOption.getTokenOrderType((boolean)options.isMatchWordOrder());
        QueryOption matchExact = QueryOption.TOKEN_DELIMITER__ANY;
        if (options.isExactMatch()) {
            matchCase = QueryOption.CASE__MATCH;
            matchWordOrder = QueryOption.TOKEN_MATCH_ORDER__MATCH;
            matchExact = QueryOption.TOKEN_DELIMITER__EXACT;
        }
        Collection<AttributeTypeId> typesToSearch = Conditions.hasValues(options.getAttributeTypeFilter()) ? options.getAttributeTypeFilter() : Collections.singleton(QueryBuilder.ANY_ATTRIBUTE_TYPE);
        queryBuilder.and(typesToSearch, searchRequest.getRawSearch(), new QueryOption[]{matchCase, matchWordOrder, matchExact});
        if (Conditions.hasValues(options.getArtifactTypeFilter())) {
            queryBuilder.andIsOfType(options.getArtifactTypeFilter());
        }
        return queryBuilder.getMatches();
    }

    public static Artifact reloadArtifactFromId(ArtifactId artId, BranchId branch) {
        ArtifactQueryBuilder query = new ArtifactQueryBuilder(artId, branch, DeletionFlag.INCLUDE_DELETED, LoadLevel.ALL);
        Artifact artifact = query.reloadArtifact();
        OseeEventManager.kickLocalArtifactReloadEvent(query, Collections.singleton(artifact));
        return artifact;
    }

    public static Collection<? extends Artifact> reloadArtifacts(Collection<? extends ArtifactToken> artifacts) {
        ArrayList<Artifact> reloadedArts = new ArrayList<Artifact>(artifacts.size());
        HashCollection branchMap = new HashCollection();
        if (artifacts.isEmpty()) {
            return reloadedArts;
        }
        for (ArtifactToken artifactToken : artifacts) {
            branchMap.put((Object)artifactToken.getBranch(), (Object)artifactToken);
        }
        HashSet<ArtifactToken> hashSet = new HashSet<ArtifactToken>();
        for (Map.Entry entrySet : branchMap.entrySet()) {
            for (ArtifactToken artifact : (List)entrySet.getValue()) {
                hashSet.add(artifact);
            }
            ArtifactQueryBuilder query = new ArtifactQueryBuilder(hashSet, (BranchId)entrySet.getKey(), DeletionFlag.INCLUDE_DELETED, LoadLevel.ALL);
            reloadedArts.addAll(query.reloadArtifacts(hashSet.size()));
            if (!reloadedArts.isEmpty()) {
                OseeEventManager.kickLocalArtifactReloadEvent(query, reloadedArts);
            }
            hashSet.clear();
        }
        return reloadedArts;
    }

    public static QueryBuilderArtifact createQueryBuilder(BranchId branch) {
        OseeClient client = ServiceUtil.getOseeClient();
        QueryBuilder builder = client.createQueryBuilder(branch);
        QueryBuilderProxy handler = new QueryBuilderProxy(builder);
        Class[] types = new Class[]{QueryBuilderArtifact.class};
        QueryBuilderArtifact query = (QueryBuilderArtifact)Proxy.newProxyInstance(QueryBuilderArtifact.class.getClassLoader(), types, (InvocationHandler)handler);
        return query;
    }

    public static String getGuidFromId(long uuid, BranchId branch) {
        if (uuidToGuid == null) {
            uuidToGuid = new HashMap<Long, String>(200);
        }
        String result = null;
        if (uuidToGuid.containsKey(uuid)) {
            result = uuidToGuid.get(uuid);
        } else {
            Artifact art = ArtifactQuery.getArtifactFromId(uuid, branch);
            if (art != null) {
                result = art.getGuid();
                uuidToGuid.put(uuid, result);
            }
        }
        return result;
    }

    public static Collection<ArtifactToken> getArtifactTokenListFromTypeAndActive(ArtifactTypeToken artifactType, AttributeTypeToken attributeType, BranchId branch) {
        return ArtifactQuery.getArtifactEndpoint(branch).getArtifactTokensByAttribute(attributeType, "false", false, artifactType);
    }

    public static Collection<ArtifactToken> getArtifactTokenListFromTypeAndAttribute(ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String value, BranchId branch) {
        return ArtifactQuery.getArtifactEndpoint(branch).getArtifactTokensByAttribute(attributeType, value, false, artifactType);
    }

    public static Collection<ArtifactToken> getArtifactTokenListFromType(ArtifactTypeToken artifactType, BranchId branch) {
        return ArtifactQuery.getArtifactEndpoint(branch).getArtifactTokensByType(artifactType);
    }

    private static List<ArtifactToken> extractTokensFromQuery(JdbcStatement chStmt, BranchId branch) {
        LinkedList<ArtifactToken> tokens = new LinkedList<ArtifactToken>();
        while (chStmt.next()) {
            Long artId = chStmt.getLong("art_id");
            ArtifactTypeToken artTypeId = ServiceUtil.getOrcsTokenService().getArtifactType(Long.valueOf(chStmt.getLong("art_type_id")));
            String name = chStmt.getString("value");
            String guid = chStmt.getString("guid");
            ArtifactToken token = ArtifactToken.valueOf((long)artId, (String)guid, (String)name, (BranchId)branch, (ArtifactTypeToken)artTypeId);
            tokens.add(token);
        }
        return tokens;
    }

    public static List<ArtifactToken> getArtifactTokenListFromSoleAttributeInherited(ArtifactTypeToken artifactType, AttributeTypeId attributetype, String value, BranchId branch) {
        LinkedList<Long> artTypeIds = new LinkedList<Long>();
        String ids = "";
        for (ArtifactTypeToken artType : artifactType.getAllDescendantTypes()) {
            artTypeIds.add(artType.getId());
            ids = String.valueOf(ids) + artType.getIdString() + ",";
        }
        artTypeIds.add(artifactType.getId());
        ids = ids.replaceFirst(",$", "");
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            List<ArtifactToken> tokens;
            String query = attributeTokenQuery.replaceFirst("ART_IDS_HERE", ids);
            chStmt.runPreparedQuery(query, new Object[]{branch, branch, attributetype, value});
            List<ArtifactToken> list = tokens = ArtifactQuery.extractTokensFromQuery(chStmt, branch);
            return list;
        }
    }

    public static HashCollection<ArtifactId, ArtifactToken> getArtifactTokenListFromRelated(BranchToken branch, Collection<ArtifactId> artifacts, ArtifactTypeId artifactType, RelationTypeSide relationType) {
        LinkedList<Long> artIds = new LinkedList<Long>();
        String ids = "";
        for (ArtifactId art : artifacts) {
            artIds.add(art.getId());
            ids = String.valueOf(ids) + art.getIdString() + ",";
        }
        ids = ids.replaceFirst(",$", "");
        HashMap<Long, Long> artBIdToArtAId = new HashMap<Long, Long>();
        HashMap<Long, Long> artAIdToArtBId = new HashMap<Long, Long>();
        boolean isSideA = relationType.getSide().isSideA();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            String query = OseeSql.ARTIFACT_TO_RELATED_B_ARTIFACT_ID.getSql().replaceFirst("ART_IDS_HERE", ids);
            query = query.replaceAll("REL_SIDE_HERE", isSideA ? "b_art_id" : "a_art_id");
            query = query.replaceAll("REL_TYPE_LINKE_ID_HERE", relationType.getGuid().toString());
            query = query.replaceAll("BRANCH_ID_HERE", branch.getIdString());
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                Long aArtId = chStmt.getLong("a_art_id");
                Long bArtId = chStmt.getLong("b_art_id");
                artBIdToArtAId.put(bArtId, aArtId);
                artAIdToArtBId.put(aArtId, bArtId);
            }
        }
        chStmt = ConnectionHandler.getStatement();
        HashCollection artToRelatedTokens = new HashCollection();
        try {
            String query = OseeSql.ARTIFACT_TOKENS_RELATED_TO_ARTIFACT_QUERY.getSql().replaceFirst("ART_IDS_HERE", ids);
            query = query.replaceAll("OPPOSITE_REL_SIDE_HERE", isSideA ? "a_art_id" : "b_art_id");
            query = query.replaceAll("REL_SIDE_HERE", isSideA ? "b_art_id" : "a_art_id");
            query = query.replaceAll("REL_TYPE_LINKE_ID_HERE", relationType.getGuid().toString());
            query = query.replaceAll("BRANCH_ID_HERE", branch.getIdString());
            chStmt.runPreparedQuery(query, new Object[0]);
            while (chStmt.next()) {
                Long artId = chStmt.getLong("art_id");
                ArtifactTypeToken artTypeId = ServiceUtil.getOrcsTokenService().getArtifactType(Long.valueOf(chStmt.getLong("art_type_id")));
                String name = chStmt.getString("value");
                ArtifactToken token = ArtifactToken.valueOf((long)artId, (String)name, (BranchToken)branch, (ArtifactTypeToken)artTypeId);
                Long artIdLong = isSideA ? (Long)artAIdToArtBId.get(artId) : (Long)artBIdToArtAId.get(artId);
                ArtifactId aArtId = ArtifactId.valueOf((Long)artIdLong);
                artToRelatedTokens.put((Object)aArtId, (Object)token);
            }
        }
        finally {
            chStmt.close();
        }
        return artToRelatedTokens;
    }

    public static Map<String, ArtifactToken> getArtifactTokensFromGuids(BranchId branch, List<String> guids) {
        HashMap<String, ArtifactToken> guidToToken = new HashMap<String, ArtifactToken>();
        if (!guids.isEmpty()) {
            JdbcStatement chStmt = ConnectionHandler.getStatement();
            StringBuilder sb = new StringBuilder();
            for (String guid : guids) {
                sb.append("'");
                sb.append(guid);
                sb.append("',");
            }
            try {
                String query = artifactTokenByGuidQuery.replaceFirst("ART_GUIDS_HERE", sb.toString().replaceFirst(",$", ""));
                chStmt.runPreparedQuery(query, new Object[]{branch});
                for (ArtifactToken token : ArtifactQuery.extractTokensFromQuery(chStmt, branch)) {
                    guidToToken.put(token.getGuid(), token);
                }
            }
            finally {
                chStmt.close();
            }
        }
        return guidToToken;
    }

    public static ArtifactToken getArtifactTokenFromId(BranchId branch, ArtifactId artifactId) {
        return ArtifactQuery.getArtifactEndpoint(branch).getArtifactToken(artifactId);
    }

    public static Map<String, ArtifactToken> getArtifactTokensFromIds(BranchId branch, Collection<String> artIds) {
        HashMap<String, ArtifactToken> guidToToken = new HashMap<String, ArtifactToken>();
        if (!artIds.isEmpty()) {
            try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
                String query = artifactTokenByArtIdQuery.replaceFirst("ART_IDS_HERE", org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", artIds));
                chStmt.runPreparedQuery(query, new Object[]{branch});
                for (ArtifactToken token : ArtifactQuery.extractTokensFromQuery(chStmt, branch)) {
                    guidToToken.put(token.getIdString(), token);
                }
            }
        }
        return guidToToken;
    }

    public static boolean isArtifactChangedViaEntries(Artifact artifact) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        int attrCount = (Integer)jdbcClient.fetch((Object)-1, "select count(*) from OSEE_ATTRIBUTE attr, osee_txs txs where attr.art_id = ? and txs.GAMMA_ID = ATTR.GAMMA_ID and txs.BRANCH_ID = ? and txs.TX_CURRENT = 1", new Object[]{artifact, artifact.getBranch()});
        if (artifact.getAttributeCount() != attrCount) {
            return true;
        }
        int relCount = (Integer)jdbcClient.fetch((Object)-1, "select count(*) from OSEE_RELATION_LINK rel, osee_txs txs where (rel.A_ART_ID = ? or rel.B_ART_ID = ?) and txs.GAMMA_ID = rel.GAMMA_ID and txs.BRANCH_ID = ? and txs.TX_CURRENT = 1", new Object[]{artifact, artifact, artifact.getBranch()});
        return !artifact.isHistorical() && artifact.getRelationsAll(DeletionFlag.EXCLUDE_DELETED).size() != relCount;
    }

    public static boolean isArtifactChangedViaTransaction(Artifact artifact) {
        JdbcClient jdbcClient = ConnectionHandler.getJdbcClient();
        String query = "select distinct transaction_id from (select txs.transaction_id from osee_artifact art, OSEE_RELATION_LINK rel, osee_txs txs, osee_tx_details txd where art.art_id = ? and  (art.art_id = rel.A_ART_ID or art.art_id = rel.B_ART_ID) and rel.GAMMA_ID = txs.gamma_id and txs.TRANSACTION_ID = txd.TRANSACTION_ID and txs.BRANCH_ID = ? union all select txs.transaction_id from osee_artifact art, osee_attribute attr, osee_txs txs, osee_tx_details txd where art.art_id = ? and  art.art_id = attr.art_id and attr.GAMMA_ID = txs.gamma_id and txs.TRANSACTION_ID = txd.TRANSACTION_ID and txs.BRANCH_ID = ?) att_alias order by transaction_id desc ";
        long transactionId = (Long)jdbcClient.fetch((Object)-1L, query, new Object[]{artifact, artifact.getBranch(), artifact, artifact.getBranch()});
        return !artifact.getTransaction().getId().equals(transactionId);
    }

    private static ArtifactEndpoint getArtifactEndpoint(BranchId branch) {
        return ServiceUtil.getOseeClient().getArtifactEndpoint(branch);
    }

    private static Artifact getOrCheckArtifact(QueryType queryType, Collection<Artifact> artifacts) {
        if (queryType.equals((Object)QueryType.CHECK)) {
            return (Artifact)((Object)org.eclipse.osee.framework.jdk.core.util.Collections.oneOrSentinel(artifacts, null));
        }
        return (Artifact)((Object)org.eclipse.osee.framework.jdk.core.util.Collections.exactlyOne(artifacts));
    }

    private static final class QueryBuilderProxy
    implements InvocationHandler {
        private final QueryBuilder proxied;

        public QueryBuilderProxy(QueryBuilder proxied) {
            this.proxied = proxied;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object toReturn = null;
            Method localMethod = this.getMethodFor(this.getClass(), method);
            try {
                toReturn = localMethod != null ? localMethod.invoke((Object)this, args) : this.invokeOnDelegate(this.proxied, method, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            return toReturn;
        }

        protected Object invokeOnDelegate(Object target, Method method, Object[] args) throws Throwable {
            return method.invoke(target, args);
        }

        private Method getMethodFor(Class<?> clazz, Method method) {
            Method toReturn = null;
            try {
                toReturn = clazz.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {}
            return toReturn;
        }

        public ResultSet<Artifact> getResults() {
            ResultSet toReturn;
            SearchResult result = this.proxied.getSearchResult(RequestType.IDS);
            SearchParameters searchParameters = result.getSearchParameters();
            BranchId branch = searchParameters.getBranch();
            TransactionId tx = TransactionId.SENTINEL;
            if (searchParameters.getFromTx().isGreaterThan((Id)TransactionId.valueOf((int)0))) {
                tx = searchParameters.getFromTx();
            }
            DeletionFlag deletionFlag = searchParameters.isIncludeDeleted() ? DeletionFlag.INCLUDE_DELETED : DeletionFlag.EXCLUDE_DELETED;
            List ids = result.getIds();
            if (ids != null && !ids.isEmpty()) {
                List<Artifact> loadedArtifacts = ArtifactLoader.loadArtifacts(ids, branch, LoadLevel.ALL, LoadType.INCLUDE_CACHE, deletionFlag, tx);
                toReturn = ResultSets.newResultSet(loadedArtifacts);
            } else {
                toReturn = ResultSets.emptyResultSet();
            }
            return toReturn;
        }

        public ResultSet<ArtifactMatch> getMatches() {
            SearchResult result = this.proxied.getSearchResult(RequestType.MATCHES);
            SearchParameters searchParameters = result.getSearchParameters();
            BranchId branch = searchParameters.getBranch();
            TransactionId tx = TransactionId.SENTINEL;
            if (searchParameters.getFromTx().isGreaterThan((Id)TransactionId.valueOf((int)0))) {
                tx = searchParameters.getFromTx();
            }
            DeletionFlag deletionFlag = searchParameters.isIncludeDeleted() ? DeletionFlag.INCLUDE_DELETED : DeletionFlag.EXCLUDE_DELETED;
            HashMap<Long, Artifact> artIdToArtifact = new HashMap<Long, Artifact>();
            List<Artifact> loadedArtifacts = ArtifactLoader.loadArtifacts(result.getIds(), branch, LoadLevel.ALL, LoadType.INCLUDE_CACHE, deletionFlag, tx);
            for (Artifact art : loadedArtifacts) {
                artIdToArtifact.put(art.getId(), art);
            }
            HashMap<Artifact, ArtifactMatch> matches = new HashMap<Artifact, ArtifactMatch>();
            for (SearchMatch match : result.getSearchMatches()) {
                ArtifactId artId = match.getArtId();
                Artifact art = (Artifact)((Object)artIdToArtifact.get(artId.getId()));
                if (art == null) continue;
                ArtifactMatch toAddTo = (ArtifactMatch)matches.get((Object)art);
                if (toAddTo == null) {
                    toAddTo = new ArtifactMatch(art);
                    matches.put(art, toAddTo);
                }
                toAddTo.addMatchData(match.getAttrId(), match.getLocations());
            }
            return ResultSets.newResultSet(matches.values());
        }
    }
}

