/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.client.QueryBuilder;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleArtifactsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.artifact.ISearchConfirmer;
import org.eclipse.osee.framework.skynet.core.artifact.LoadType;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactSearchCriteria;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryType;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResult;

public class ArtifactQueryBuilder {
    private List<String> guids;
    private String guid;
    private final ArtifactSearchCriteria[] criteria;
    private final BranchId branch;
    private ArtifactId artifactId;
    private Collection<? extends ArtifactId> artifactIds;
    private final Collection<? extends ArtifactTypeId> artifactTypes;
    private final DeletionFlag allowDeleted;
    private final LoadLevel loadLevel;
    private boolean emptyCriteria = false;
    private final TransactionToken transactionId;

    public ArtifactQueryBuilder(ArtifactId artId, BranchId branch, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(null, artId, null, null, null, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
    }

    public ArtifactQueryBuilder(Collection<? extends ArtifactId> artifactIds, BranchId branch, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(artifactIds, ArtifactId.SENTINEL, null, null, null, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
        this.emptyCriteria = artifactIds.isEmpty();
    }

    public ArtifactQueryBuilder(List<String> guids, BranchId branch, LoadLevel loadLevel) {
        this(null, ArtifactId.SENTINEL, guids, null, null, branch, TransactionToken.SENTINEL, DeletionFlag.EXCLUDE_DELETED, loadLevel, new ArtifactSearchCriteria[0]);
        this.emptyCriteria = guids.isEmpty();
    }

    public ArtifactQueryBuilder(List<String> guids, BranchId branch, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(null, ArtifactId.SENTINEL, guids, null, null, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
        this.emptyCriteria = guids.isEmpty();
    }

    public ArtifactQueryBuilder(List<String> guids, TransactionToken transactionId, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(null, ArtifactId.SENTINEL, guids, null, null, transactionId.getBranch(), transactionId, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
        this.emptyCriteria = guids.isEmpty();
    }

    public ArtifactQueryBuilder(Collection<ArtifactId> artifactIds, TransactionToken transactionId, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(artifactIds, ArtifactId.SENTINEL, null, null, null, transactionId.getBranch(), transactionId, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
        this.emptyCriteria = artifactIds.isEmpty();
    }

    public ArtifactQueryBuilder(ArtifactId artifactId, TransactionToken transactionId, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(null, artifactId, null, null, null, transactionId.getBranch(), transactionId, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
    }

    public ArtifactQueryBuilder(String guid, BranchId branch, DeletionFlag allowDeleted, LoadLevel loadLevel) {
        this(null, ArtifactId.SENTINEL, null, ArtifactQueryBuilder.ensureValid(guid), null, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
    }

    public ArtifactQueryBuilder(ArtifactTypeId artifactType, BranchId branch, LoadLevel loadLevel, DeletionFlag allowDeleted) {
        this(null, ArtifactId.SENTINEL, null, null, Arrays.asList(artifactType), branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
    }

    public ArtifactQueryBuilder(Collection<? extends ArtifactTypeId> artifactTypes, BranchId branch, LoadLevel loadLevel, DeletionFlag allowDeleted) {
        this(null, ArtifactId.SENTINEL, null, null, artifactTypes, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
        this.emptyCriteria = artifactTypes.isEmpty();
    }

    public ArtifactQueryBuilder(BranchId branch, LoadLevel loadLevel, DeletionFlag allowDeleted) {
        this(null, ArtifactId.SENTINEL, null, null, null, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, new ArtifactSearchCriteria[0]);
    }

    public ArtifactQueryBuilder(BranchId branch, LoadLevel loadLevel, DeletionFlag allowDeleted, ArtifactSearchCriteria ... criteria) {
        this(null, ArtifactId.SENTINEL, null, null, null, branch, TransactionToken.SENTINEL, allowDeleted, loadLevel, criteria);
        this.emptyCriteria = criteria.length == 0;
    }

    public ArtifactQueryBuilder(BranchId branch, LoadLevel loadLevel, List<ArtifactSearchCriteria> criteria) {
        this(null, ArtifactId.SENTINEL, null, null, null, branch, TransactionToken.SENTINEL, DeletionFlag.EXCLUDE_DELETED, loadLevel, ArtifactQueryBuilder.toArray(criteria));
        this.emptyCriteria = criteria.isEmpty();
    }

    public ArtifactQueryBuilder(ArtifactTypeId artifactType, BranchId branch, LoadLevel loadLevel, ArtifactSearchCriteria ... criteria) {
        this(null, ArtifactId.SENTINEL, null, null, Arrays.asList(artifactType), branch, TransactionToken.SENTINEL, DeletionFlag.EXCLUDE_DELETED, loadLevel, criteria);
        this.emptyCriteria = criteria.length == 0;
    }

    public ArtifactQueryBuilder(ArtifactTypeId artifactType, BranchId branch, LoadLevel loadLevel, List<ArtifactSearchCriteria> criteria) {
        this(null, ArtifactId.SENTINEL, null, null, Arrays.asList(artifactType), branch, TransactionToken.SENTINEL, DeletionFlag.EXCLUDE_DELETED, loadLevel, ArtifactQueryBuilder.toArray(criteria));
        this.emptyCriteria = criteria.isEmpty();
    }

    private ArtifactQueryBuilder(Collection<? extends ArtifactId> artifactIds, ArtifactId artifactId, List<String> guids, String guid, Collection<? extends ArtifactTypeId> artifactTypes, BranchId branch, TransactionToken transactionId, DeletionFlag allowDeleted, LoadLevel loadLevel, ArtifactSearchCriteria ... criteria) {
        this.artifactTypes = artifactTypes;
        this.branch = branch;
        this.criteria = criteria;
        this.loadLevel = loadLevel;
        this.allowDeleted = allowDeleted;
        this.guid = guid;
        this.artifactId = artifactId;
        this.transactionId = transactionId;
        if (artifactIds != null && !artifactIds.isEmpty()) {
            if (artifactIds.size() == 1) {
                this.artifactId = artifactIds.iterator().next();
            } else {
                this.artifactIds = artifactIds;
            }
        }
        if (Conditions.hasValues(guids)) {
            if (guids.size() == 1) {
                this.guid = guids.get(0);
            } else {
                this.guids = new ArrayList<String>();
                for (String id : guids) {
                    if (!GUID.isValid((CharSequence)id)) continue;
                    this.guids.add(id);
                }
            }
        }
    }

    private static ArtifactSearchCriteria[] toArray(List<ArtifactSearchCriteria> criteria) {
        return criteria.toArray(new ArtifactSearchCriteria[criteria.size()]);
    }

    private static String ensureValid(String id) {
        boolean guidCheck = GUID.isValid((CharSequence)id);
        if (!guidCheck) {
            throw new OseeArgumentException("Invalid guid detected [%s]", new Object[]{id});
        }
        return id;
    }

    private boolean useServerSearch() {
        return Conditions.hasValues(this.artifactTypes) || this.guid != null || Conditions.hasValues(this.guids) || this.criteria.length > 0 || this.artifactId.isInvalid() && !Conditions.hasValues(this.artifactIds);
    }

    private QueryBuilder getQueryBuilder() {
        QueryBuilder toReturn;
        if (this.useServerSearch()) {
            OseeClient client = ServiceUtil.getOseeClient();
            toReturn = client.createQueryBuilder(this.branch);
        } else {
            LocalIdQueryBuilder builder = new LocalIdQueryBuilder(this.branch);
            Class[] types = new Class[]{QueryBuilder.class};
            toReturn = (QueryBuilder)Proxy.newProxyInstance(QueryBuilder.class.getClassLoader(), types, (InvocationHandler)builder);
        }
        return toReturn;
    }

    private QueryBuilder createOrcsQuery() {
        QueryBuilder builder = this.getQueryBuilder();
        if (this.allowDeleted == DeletionFlag.INCLUDE_DELETED) {
            builder.includeDeleted();
        }
        if (Conditions.hasValues(this.artifactIds)) {
            builder.andIds(this.artifactIds);
        } else if (this.artifactId.isValid()) {
            builder.andId(this.artifactId);
        }
        if (Conditions.hasValues(this.artifactTypes) && (this.artifactTypes.size() != 1 || !this.artifactTypes.iterator().next().isInvalid())) {
            builder.andTypeEquals(this.artifactTypes);
        }
        if (this.guid != null) {
            builder.andGuids(Arrays.asList(this.guid));
        }
        if (Conditions.hasValues(this.guids)) {
            builder.andGuids(this.guids);
        }
        if (this.criteria.length > 0) {
            ArtifactSearchCriteria[] artifactSearchCriteriaArray = this.criteria;
            int n = this.criteria.length;
            int n2 = 0;
            while (n2 < n) {
                ArtifactSearchCriteria idx = artifactSearchCriteriaArray[n2];
                idx.addToQueryBuilder(builder);
                ++n2;
            }
        }
        if (this.transactionId.isValid()) {
            builder.fromTransaction((TransactionId)this.transactionId);
        }
        return builder;
    }

    public List<Artifact> getArtifacts(int artifactCountEstimate, ISearchConfirmer confirmer) {
        return this.internalGetArtifacts(artifactCountEstimate, confirmer, LoadType.INCLUDE_CACHE);
    }

    public List<Artifact> reloadArtifacts(int artifactCountEstimate) {
        return this.internalGetArtifacts(artifactCountEstimate, null, LoadType.RELOAD_CACHE);
    }

    public Artifact reloadArtifact() {
        if (this.emptyCriteria) {
            throw new ArtifactDoesNotExist("received an empty list in the criteria for this search", new Object[0]);
        }
        List<Artifact> artifacts = this.internalGetArtifacts(1, null, LoadType.RELOAD_CACHE);
        if (artifacts.isEmpty()) {
            throw new ArtifactDoesNotExist(this.getSoleExceptionMessage(artifacts.size()), new Object[0]);
        }
        if (artifacts.size() > 1) {
            throw new MultipleArtifactsExist(this.getSoleExceptionMessage(artifacts.size()), new Object[0]);
        }
        return (Artifact)((Object)artifacts.iterator().next());
    }

    private List<Artifact> loadArtifactsFromServerIds(LoadType reload) {
        List ids = this.createOrcsQuery().getIds();
        List<Artifact> artifacts = ids != null && !ids.isEmpty() ? ArtifactLoader.loadArtifacts(ids, this.branch, this.loadLevel, reload, this.allowDeleted, (TransactionId)this.transactionId) : Collections.emptyList();
        return artifacts;
    }

    private List<Artifact> internalGetArtifacts(int artifactCountEstimate, ISearchConfirmer confirmer, LoadType reload) {
        if (this.emptyCriteria) {
            return Collections.emptyList();
        }
        return this.loadArtifactsFromServerIds(reload);
    }

    public List<ArtifactId> selectArtifacts(int artifactCountEstimate) {
        return this.createOrcsQuery().getIds();
    }

    public int countArtifacts() {
        if (this.emptyCriteria) {
            return 0;
        }
        return this.createOrcsQuery().getCount();
    }

    public Artifact getOrCheckArtifact(QueryType queryType) {
        if (this.emptyCriteria) {
            throw new ArtifactDoesNotExist("received an empty list in the criteria for this search", new Object[0]);
        }
        if (this.branch.isInvalid()) {
            throw new OseeArgumentException("Branch specified [%s] is invalid", new Object[]{this.branch});
        }
        List<Artifact> artifacts = this.getArtifacts(1, null);
        if (artifacts.isEmpty()) {
            if (queryType.equals((Object)QueryType.CHECK)) {
                return null;
            }
            throw new ArtifactDoesNotExist(this.getSoleExceptionMessage(artifacts.size()), new Object[0]);
        }
        if (artifacts.size() > 1) {
            throw new MultipleArtifactsExist(this.getSoleExceptionMessage(artifacts.size()), new Object[0]);
        }
        return (Artifact)((Object)artifacts.iterator().next());
    }

    private String getSoleExceptionMessage(int artifactCount) {
        StringBuilder message = new StringBuilder(250);
        if (artifactCount == 0) {
            message.append("ArtifactQueryBuilder: No artifact found");
        } else {
            message.append(artifactCount);
            message.append(" artifacts found");
        }
        if (this.artifactTypes != null) {
            message.append(" with type(s): ");
            message.append(this.artifactTypes);
        }
        if (this.artifactId.isValid()) {
            message.append(" with id \"");
            message.append(this.artifactId.getIdString());
            message.append("\"");
        }
        if (this.guid != null) {
            message.append(" with id \"");
            message.append(this.guid);
            message.append("\"");
        }
        if (this.criteria.length > 0) {
            message.append(" with criteria \"");
            message.append(Arrays.deepToString(this.criteria));
            message.append("\"");
        }
        message.append(" on branch \"");
        message.append(this.branch);
        message.append("\"");
        return message.toString();
    }

    private static final class LocalIdQueryBuilder
    implements InvocationHandler {
        private final List<ArtifactId> artIds = new ArrayList<ArtifactId>();
        private DeletionFlag allowDeleted = DeletionFlag.EXCLUDE_DELETED;
        private TransactionId txId = TransactionId.SENTINEL;
        private final BranchId branch;

        public LocalIdQueryBuilder(BranchId branch) {
            this.branch = branch;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object toReturn = null;
            Method localMethod = this.getMethodFor(this.getClass(), method);
            if (localMethod != null) {
                try {
                    toReturn = localMethod.invoke((Object)this, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                if (toReturn == null) {
                    toReturn = proxy;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return toReturn;
        }

        private Method getMethodFor(Class<?> clazz, Method method) {
            Method toReturn = null;
            try {
                toReturn = clazz.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {}
            return toReturn;
        }

        public void fromTransaction(TransactionId transactionId) {
            this.txId = transactionId;
        }

        public void includeDeleted() {
            this.includeDeleted(true);
        }

        public void includeDeleted(boolean enabled) {
            this.allowDeleted = enabled ? DeletionFlag.INCLUDE_DELETED : DeletionFlag.EXCLUDE_DELETED;
        }

        public SearchResult getSearchResult() {
            SearchResponse response = new SearchResponse();
            LinkedList<ArtifactId> ids = new LinkedList<ArtifactId>(this.artIds);
            response.setIds(ids);
            return response;
        }

        public int getCount() {
            if (this.txId.isInvalid()) {
                this.txId = TransactionManager.getHeadTransaction(this.branch);
            }
            List<Artifact> results = ArtifactLoader.loadArtifacts(this.artIds, this.branch, LoadLevel.ARTIFACT_DATA, LoadType.INCLUDE_CACHE, this.allowDeleted, this.txId);
            return results.size();
        }

        public void andId(ArtifactId artifactId) {
            this.artIds.add(artifactId);
        }

        public void andIds(Collection<? extends ArtifactId> artifactIds) {
            this.artIds.addAll(artifactIds);
        }

        public List<ArtifactId> getIds() {
            return this.artIds;
        }
    }
}

