/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;

public class BinaryContentUtils {
    public static final String ATTRIBUTE_RESOURCE_PROTOCOL = "attr";
    private static final String ATTR_RESOURCES_CONTEXT = "/resources/attr/";
    private static final int ATTR_RESOURCES_CONTEXT_LENGTH = "/resources/attr/".length();
    private static final int MAX_NAME_SIZE = 60;

    public static String getContentType(String extension) {
        String contentType = null;
        contentType = Strings.isValid((String)extension) ? URLConnection.guessContentTypeFromName("dummy." + extension) : "application/*";
        return contentType;
    }

    public static String generateFileName(Attribute<?> attribute) {
        StringBuilder builder = new StringBuilder();
        try {
            String name = attribute.getArtifact().getName();
            if (name.length() > 60) {
                name = name.substring(0, 60);
            }
            builder.append(URLEncoder.encode(name, "UTF-8"));
            builder.append(".");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        builder.append(BinaryContentUtils.getStorageName(attribute));
        String fileTypeExtension = BinaryContentUtils.getExtension(attribute);
        if (Strings.isValid((String)fileTypeExtension)) {
            builder.append(".");
            builder.append(fileTypeExtension);
        }
        return builder.toString();
    }

    private static String getExtension(Attribute<?> attribute) {
        String fileTypeExtension = attribute.getAttributeType().getFileExtension();
        if (attribute.isOfType((AttributeTypeId)CoreAttributeTypes.NativeContent)) {
            fileTypeExtension = attribute.getArtifact().getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, "");
        }
        return fileTypeExtension;
    }

    public static String getStorageName(Attribute<?> attribute) {
        String guid = attribute.getArtifact().getGuid();
        Conditions.checkExpressionFailOnTrue((!GUID.isValid((CharSequence)guid) ? 1 : 0) != 0, (String)"Artifact has an invalid guid [%s]", (Object[])new Object[]{guid});
        return guid;
    }

    public static String asResourcePath(String locator) {
        String toReturn = locator;
        if (Strings.isValid((String)toReturn)) {
            toReturn = toReturn.replaceAll("://", "/");
        }
        return toReturn;
    }

    public static String getAttributeLocation(Response response) {
        int index;
        String toReturn = response.getHeaderString("Location");
        if (Strings.isValid((String)toReturn) && (index = toReturn.indexOf(ATTR_RESOURCES_CONTEXT)) > 0 && index + ATTR_RESOURCES_CONTEXT_LENGTH < toReturn.length()) {
            toReturn = String.format("attr://%s", toReturn.substring(index + ATTR_RESOURCES_CONTEXT_LENGTH));
        }
        return toReturn;
    }
}

