/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.commit.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.commit.actions.CommitAction;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;

public class CatchArtifactChanges
implements CommitAction {
    @Override
    public void runCommitAction(BranchId sourceBranch, BranchId destinationBranch, XResultData rd) {
        ArrayList<Change> changes = new ArrayList<Change>();
        IOperation operation = ChangeManager.compareTwoBranchesHead(sourceBranch, destinationBranch, changes);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        HashSet<ArtifactId> orphanedArts = new HashSet<ArtifactId>();
        HashSet<ArtifactId> shouldBeDeletedArts = new HashSet<ArtifactId>();
        for (Change change : changes) {
            Artifact artifactChanged = change.getChangeArtifact();
            if (!artifactChanged.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails, CoreArtifactTypes.AbstractSoftwareRequirement})) continue;
            if (artifactChanged.isDeleted()) {
                this.checkArtIsFullyDeleted(shouldBeDeletedArts, artifactChanged);
                continue;
            }
            this.checkForOrphans(orphanedArts, artifactChanged);
        }
        String err = null;
        if (!orphanedArts.isEmpty()) {
            err = String.format("Commit Branch Failed. The following artifacts are orphaned.  Please appropriately parent the artifact, then recommit : [%s]\n\n", Collections.toString(orphanedArts, (String)", ", Id::getIdString));
        }
        if (!shouldBeDeletedArts.isEmpty()) {
            String temp = String.format("Commit Branch Failed. The following artifacts are deleted but still have relations.  Please remove the relations, then recommit : [%s]\n\n", Collections.toString(shouldBeDeletedArts, (String)", ", Id::getIdString));
            String string = err = err == null ? temp : String.valueOf(err) + temp;
        }
        if (err != null) {
            throw new OseeCoreException(err, new Object[0]);
        }
    }

    private void checkArtIsFullyDeleted(Set<ArtifactId> shouldBeDeletedArts, Artifact artifactChanged) {
        Artifact relatedArt = artifactChanged.getRelatedArtifactOrNull(CoreRelationTypes.DefaultHierarchical_Parent);
        if (relatedArt != null) {
            shouldBeDeletedArts.add((ArtifactId)artifactChanged);
        }
    }

    private void checkForOrphans(Set<ArtifactId> orphanedArts, Artifact artifactChanged) {
        Artifact relatedArt = artifactChanged.getRelatedArtifactOrNull(CoreRelationTypes.DefaultHierarchical_Parent);
        if (relatedArt == null) {
            orphanedArts.add((ArtifactId)artifactChanged);
        }
    }
}

