/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.conflict;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.io.Streams;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.EnumeratedAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.StringAttribute;
import org.eclipse.osee.framework.skynet.core.conflict.Conflict;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class AttributeConflict
extends Conflict {
    public static final String EMPTY_XML = "<w:p><w:r><w:t></w:t></w:r></w:p>";
    public static final String NO_VALUE = "";
    public static final String STREAM_DATA = "Stream data";
    public static final String RESOLVE_MERGE_MARKUP = "Can not mark as resolved an attribute that has merge markup.  Finish merging the document to be able to resolve the conflict.";
    public static final String DIFF_MERGE_MARKUP = "Can not run a diff against an attribute that has merge markup.  Finish merging the document to be able to resolve the conflict.";
    private final AttributeId attrId;
    private Object sourceObject;
    private Object destObject;
    private final AttributeTypeGeneric<?> attributeType;
    private boolean mergeEqualsSource;
    private boolean mergeEqualsDest;
    private boolean sourceEqualsDest;
    private static final boolean DEBUG = "TRUE".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.osee.framework.ui.skynet/debug/Merge"));
    private String changeItemName;

    public AttributeConflict(GammaId sourceGamma, GammaId destGamma, ArtifactId artId, TransactionToken toTransactionId, TransactionToken commitTransaction, String sourceValue, AttributeId attrId, AttributeTypeGeneric<?> attributeType, BranchId mergeBranch, BranchToken sourceBranch, BranchToken destBranch) {
        super(sourceGamma, destGamma, artId, toTransactionId, commitTransaction, mergeBranch, sourceBranch, destBranch);
        this.attrId = attrId;
        this.attributeType = attributeType;
        this.status = ConflictStatus.EDITED;
        this.computeEqualsValues();
    }

    public Attribute<?> getAttribute() {
        return this.getArtifact().getAttributeById(this.attrId, false);
    }

    public Attribute<?> getSourceAttribute(boolean allowDeleted) {
        Attribute<?> sourceAttribute = this.getSourceArtifact().getAttributeById(this.attrId, allowDeleted);
        if (sourceAttribute == null) {
            if (this.sourceBranch != null) {
                throw new AttributeDoesNotExist("Attribute %s could not be found on artifact %s on branch %s", new Object[]{this.attrId, this.getArtId(), this.sourceBranch});
            }
            throw new AttributeDoesNotExist("Attribute %s could not be found on artifact %s", new Object[]{this.attrId, this.getArtId()});
        }
        return sourceAttribute;
    }

    public Attribute<?> getDestAttribute() {
        Attribute<?> destAttribute = this.getDestArtifact().getAttributeById(this.attrId, false);
        if (destAttribute == null) {
            throw new AttributeDoesNotExist("Attribute %s could not be found on artifact %s on branch %s", new Object[]{this.attrId, this.getArtId(), this.destBranch});
        }
        return destAttribute;
    }

    private Attribute<?> getAttribute(Artifact artifact) {
        Attribute<?> attribute = artifact.getAttributeById(this.attrId, false);
        if (attribute == null) {
            throw new AttributeDoesNotExist("Attribute %s could not be found on artifact %s on branch %s", new Object[]{this.attrId, artifact, artifact.getBranch()});
        }
        return attribute;
    }

    public AttributeTypeGeneric<?> getAttributeType() {
        return this.attributeType;
    }

    public Object getSourceObject() {
        if (this.sourceObject != null) {
            return this.sourceObject;
        }
        try {
            this.sourceObject = this.getSourceAttribute(false).getValue();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            this.sourceObject = "DELETED";
        }
        return this.sourceObject;
    }

    public Object getDestObject() {
        if (this.destObject != null) {
            return this.destObject;
        }
        try {
            this.destObject = this.getDestAttribute().getValue();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            this.destObject = "DELETED";
        }
        return this.destObject;
    }

    public <T> T getAdapter(Class<T> type) {
        Object toReturn = null;
        if (type != null && type.isAssignableFrom(this.getClass())) {
            toReturn = this;
        }
        Attribute<?> attribute = this.getAttribute();
        if (type != null && type.isInstance(attribute)) {
            try {
                toReturn = this.getSourceAttribute(true);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return (T)toReturn;
    }

    public AttributeId getAttrId() {
        return this.attrId;
    }

    @Override
    public String getDestDisplayData() {
        String displayValue = this.isWordAttribute() ? STREAM_DATA : (this.getDestObject() == null ? "Null Value" : this.getDestObject().toString());
        try {
            this.getDestAttribute();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            displayValue = "DELETED";
        }
        return displayValue;
    }

    @Override
    public String getSourceDisplayData() {
        String displayValue = this.isWordAttribute() ? STREAM_DATA : (this.getSourceObject() == null ? "Null Value" : this.getSourceObject().toString());
        try {
            this.getSourceAttribute(false);
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            displayValue = "DELETED";
        }
        return displayValue;
    }

    @Override
    public boolean mergeEqualsSource() {
        return this.mergeEqualsSource;
    }

    @Override
    public boolean mergeEqualsDestination() {
        return this.mergeEqualsDest;
    }

    @Override
    public boolean sourceEqualsDestination() {
        return this.sourceEqualsDest;
    }

    public Object getMergeObject() {
        return this.getAttribute() != null ? this.getAttribute().getValue() : null;
    }

    public TreeSet<String> getEnumerationAttributeValues() {
        return new TreeSet<String>(this.attributeType.toEnum().getEnumStrValues());
    }

    public boolean setStringAttributeValue(String value) {
        if (!this.getStatus().isOverwriteAllowed()) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed setting the Merge Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Set the Merge Value for attr_id %s", this.getAttrId()));
        }
        this.getArtifact().setSoleAttributeFromString((AttributeTypeId)this.attributeType, value);
        this.getArtifact().persist(this.getClass().getSimpleName());
        this.markStatusToReflectEdit();
        return true;
    }

    public boolean setAttributeValue(Object value) {
        if (!this.getStatus().isOverwriteAllowed()) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed setting the Merge Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Set the Merge Value for attr_id %s", this.getAttrId()));
        }
        this.getArtifact().setSoleAttributeValue((AttributeTypeId)this.attributeType, value);
        this.getArtifact().persist(this.getClass().getSimpleName());
        this.markStatusToReflectEdit();
        return true;
    }

    @Override
    public boolean setToSource(SkynetTransaction transaction) {
        if (!this.getStatus().isOverwriteAllowed() || this.getDestObject() == null) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed setting the Merge Value to the Dest Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Set the Merge Value to the Dest Value for attr_id %s", this.getAttrId()));
        }
        this.getArtifact().setSoleAttributeValue((AttributeTypeId)this.attributeType, this.getSourceObject());
        transaction.addArtifact(this.getArtifact());
        this.markStatusToReflectEdit();
        return true;
    }

    @Override
    public boolean setToSource() {
        if (!this.getStatus().isOverwriteAllowed() || this.getSourceObject() == null) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed setting the Merge Value to the Source Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Set the Merge Value to the Source Value for attr_id %s", this.getAttrId()));
        }
        this.getArtifact().setSoleAttributeValue((AttributeTypeId)this.attributeType, this.getSourceObject());
        this.getArtifact().persist(this.getClass().getSimpleName());
        this.markStatusToReflectEdit();
        return true;
    }

    @Override
    public boolean setToDest(SkynetTransaction transaction) {
        if (!this.getStatus().isOverwriteAllowed() || this.getDestObject() == null) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed setting the Merge Value to the Dest Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Set the Merge Value to the Dest Value for attr_id %s", this.getAttrId()));
        }
        this.getArtifact().setSoleAttributeValue((AttributeTypeId)this.attributeType, this.getDestObject());
        transaction.addArtifact(this.getArtifact());
        this.markStatusToReflectEdit();
        return true;
    }

    @Override
    public boolean setToDest() {
        if (!this.getStatus().isOverwriteAllowed() || this.getDestObject() == null) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed setting the Merge Value to the Dest Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Set the Merge Value to the Dest Value for attr_id %s", this.getAttrId()));
        }
        this.getArtifact().setSoleAttributeValue((AttributeTypeId)this.attributeType, this.getDestObject());
        this.getArtifact().persist(this.getClass().getSimpleName());
        this.markStatusToReflectEdit();
        return true;
    }

    @Override
    public boolean clearValue() {
        if (!this.getStatus().isOverwriteAllowed()) {
            if (DEBUG) {
                System.out.println(String.format("AttributeConflict: Failed to clear the Merge Value for attr_id %s", this.getAttrId()));
            }
            return false;
        }
        if (DEBUG) {
            System.out.println(String.format("AttributeConflict: Cleared the Merge Value for attr_id %s", this.getAttrId()));
        }
        this.setStatus(ConflictStatus.UNTOUCHED);
        if (this.isWordAttribute()) {
            this.getAttribute().resetToDefaultValue();
            this.getArtifact().persist(this.getClass().getSimpleName());
        } else {
            this.getArtifact().setSoleAttributeFromString((AttributeTypeId)this.attributeType, NO_VALUE);
            this.getArtifact().persist(this.getClass().getSimpleName());
        }
        this.computeEqualsValues();
        return true;
    }

    @Override
    public void computeEqualsValues() {
        this.mergeEqualsSource = this.compareObjects(this.getMergeObject(), this.getSourceObject());
        this.mergeEqualsDest = this.compareObjects(this.getMergeObject(), this.getDestObject());
        this.sourceEqualsDest = this.compareObjects(this.getSourceObject(), this.getDestObject());
    }

    private boolean compareObjects(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof InputStream && obj2 instanceof InputStream) {
            InputStream inputStream1 = (InputStream)obj1;
            InputStream inputStream2 = (InputStream)obj2;
            boolean equals = Arrays.equals(Streams.getByteArray((InputStream)inputStream1), Streams.getByteArray((InputStream)inputStream2));
            try {
                inputStream1.reset();
                inputStream2.reset();
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            return equals;
        }
        return obj1.equals(obj2);
    }

    public void markStatusToReflectEdit() {
        this.computeEqualsValues();
        if (this.status.equals((Object)ConflictStatus.UNTOUCHED) || this.status.equals((Object)ConflictStatus.OUT_OF_DATE_RESOLVED) || this.status.equals((Object)ConflictStatus.OUT_OF_DATE) || this.status.equals((Object)ConflictStatus.PREVIOUS_MERGE_APPLIED_CAUTION) || this.status.equals((Object)ConflictStatus.PREVIOUS_MERGE_APPLIED_SUCCESS)) {
            this.setStatus(ConflictStatus.EDITED);
        }
    }

    @Override
    public ConflictStatus computeStatus() {
        ConflictStatus passedStatus = ConflictStatus.UNTOUCHED;
        try {
            this.getSourceAttribute(false);
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            passedStatus = ConflictStatus.INFORMATIONAL;
        }
        try {
            this.getDestAttribute();
        }
        catch (AttributeDoesNotExist attributeDoesNotExist) {
            passedStatus = ConflictStatus.INFORMATIONAL;
        }
        return super.computeStatus((Id)this.attrId, passedStatus);
    }

    @Override
    public Id getObjectId() {
        return this.attrId;
    }

    @Override
    public String getMergeDisplayData() {
        ConflictStatus status = this.getStatus();
        if (status.isUntouched() && (!this.sourceEqualsDestination() || !this.mergeEqualsSource()) || status.isInformational()) {
            return NO_VALUE;
        }
        if (!this.isWordAttribute()) {
            return this.getMergeObject() == null ? null : this.getMergeObject().toString();
        }
        return STREAM_DATA;
    }

    @Override
    public String getChangeItem() {
        if (this.changeItemName == null) {
            this.changeItemName = this.attributeType.getName();
        }
        return this.changeItemName;
    }

    @Override
    public ConflictType getConflictType() {
        return ConflictType.ATTRIBUTE;
    }

    @Override
    public GammaId getMergeGammaId() {
        return this.getAttribute().getGammaId();
    }

    public boolean isWordAttribute() {
        boolean toReturn = false;
        try {
            toReturn = this.attributeType.equals((Object)CoreAttributeTypes.WordTemplateContent);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(this.getClass(), (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return toReturn;
    }

    @Override
    public void setStatus(ConflictStatus status) {
        if (status.equals((Object)ConflictStatus.RESOLVED) && this.isWordAttribute() && WordCoreUtil.containsWordAnnotations((CharSequence)((StringAttribute)this.getAttribute()).getValue())) {
            throw new OseeStateException(RESOLVE_MERGE_MARKUP, new Object[0]);
        }
        super.setStatus(status);
    }

    public boolean wordMarkupPresent() {
        return this.isWordAttribute() && WordCoreUtil.containsWordAnnotations((CharSequence)((StringAttribute)this.getAttribute()).getValue());
    }

    @Override
    public boolean applyPreviousMerge(BranchId mergeBranchId, BranchId destBranchId) {
        if (DEBUG) {
            System.out.println("Apply the merge using the merge branch value " + mergeBranchId);
        }
        if (!this.getStatus().isResolved()) {
            Artifact destArtifact;
            Artifact mergeArtifact;
            try {
                mergeArtifact = ArtifactQuery.getArtifactFromId((ArtifactId)this.getArtifact(), mergeBranchId);
                destArtifact = ArtifactQuery.getArtifactFromId((ArtifactId)this.getArtifact(), destBranchId);
            }
            catch (ArtifactDoesNotExist artifactDoesNotExist) {
                return false;
            }
            this.setAttributeValue(this.getAttribute(mergeArtifact).getValue());
            this.computeEqualsValues();
            if (this.getDestAttribute().getValue().equals(this.getAttribute(destArtifact).getValue()) || this.getDestAttribute().getGammaId() == this.getAttribute(destArtifact).getGammaId()) {
                this.setStatus(ConflictStatus.PREVIOUS_MERGE_APPLIED_SUCCESS);
            } else {
                this.setStatus(ConflictStatus.PREVIOUS_MERGE_APPLIED_CAUTION);
            }
            return true;
        }
        return false;
    }

    public boolean isSimpleStringAttribute() {
        boolean returnValue = true;
        returnValue &= !this.isWordAttribute();
        Attribute<?> attribute = this.getAttribute();
        returnValue &= !(attribute instanceof EnumeratedAttribute);
        return returnValue &= attribute instanceof StringAttribute;
    }

    public boolean involvesNativeContent() {
        return this.getArtifact().isAttributeTypeValid((AttributeTypeId)CoreAttributeTypes.NativeContent);
    }
}

