/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.filter;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.IBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;

public class ArtifactEventFilter
implements IEventFilter {
    private final ArtifactToken artifact;

    public ArtifactEventFilter(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    @Override
    public boolean isMatch(BranchId branch) {
        return this.artifact.isOnBranch(branch);
    }

    @Override
    public boolean isMatchArtifacts(List<? extends DefaultBasicGuidArtifact> guidArts) {
        for (DefaultBasicGuidArtifact defaultBasicGuidArtifact : guidArts) {
            if (!defaultBasicGuidArtifact.equals((Object)this.artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchRelationArtifacts(List<? extends IBasicGuidRelation> relations) {
        for (IBasicGuidRelation iBasicGuidRelation : relations) {
            if (!iBasicGuidRelation.getArtA().equals((Object)this.artifact) && !iBasicGuidRelation.getArtB().equals((Object)this.artifact)) continue;
            return true;
        }
        return false;
    }
}

