/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.filter;

import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.IBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;

public class BranchIdEventFilter
implements IEventFilter {
    private final BranchId branchToken;

    public BranchIdEventFilter(BranchId branchToken) {
        this.branchToken = branchToken;
    }

    @Override
    public boolean isMatch(BranchId branch) {
        if (this.branchToken != null) {
            return this.branchToken.equals(branch);
        }
        return false;
    }

    @Override
    public boolean isMatchArtifacts(List<? extends DefaultBasicGuidArtifact> guidArts) {
        if (guidArts.isEmpty()) {
            return true;
        }
        for (DefaultBasicGuidArtifact defaultBasicGuidArtifact : guidArts) {
            if (!defaultBasicGuidArtifact.isOnBranch(this.branchToken)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchRelationArtifacts(List<? extends IBasicGuidRelation> relations) {
        if (relations.isEmpty()) {
            return true;
        }
        for (IBasicGuidRelation iBasicGuidRelation : relations) {
            if (!iBasicGuidRelation.getArtA().isOnBranch(this.branchToken) && !iBasicGuidRelation.getArtB().isOnBranch(this.branchToken)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.branchToken.getId());
    }
}

