/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.event.FrameworkEvent;
import org.eclipse.osee.framework.core.event.HasNetworkSender;
import org.eclipse.osee.framework.core.event.NetworkSender;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicUuidRelationReorder;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventModifiedBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;

public class ArtifactEvent
implements FrameworkEvent,
HasNetworkSender,
HasBranchId {
    private final BranchId branch;
    private final TransactionToken transaction;
    private NetworkSender networkSender;
    private final List<EventBasicGuidArtifact> artifacts = new ArrayList<EventBasicGuidArtifact>();
    private final List<EventBasicGuidRelation> relations = new ArrayList<EventBasicGuidRelation>();
    private final Set<DefaultBasicUuidRelationReorder> relationReorderRecords = new HashSet<DefaultBasicUuidRelationReorder>();
    private final ArtifactEventType reloadEvent;

    public ArtifactEvent(BranchId branch) {
        this(branch, ArtifactEventType.UPDATE_ARTIFACTS);
    }

    public ArtifactEvent(TransactionToken transaction) {
        this(transaction.getBranch(), transaction, ArtifactEventType.UPDATE_ARTIFACTS);
    }

    public ArtifactEvent(BranchId branch, ArtifactEventType reloadEvent) {
        this(branch, TransactionToken.SENTINEL, reloadEvent);
    }

    public ArtifactEvent(BranchId branch, TransactionToken transaction, ArtifactEventType reloadEvent) {
        this.branch = branch;
        this.transaction = transaction;
        this.reloadEvent = reloadEvent;
    }

    public boolean isReloadEvent() {
        return ArtifactEventType.RELOAD_ARTIFACTS == this.reloadEvent;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public Set<DefaultBasicUuidRelationReorder> getRelationOrderRecords() {
        return this.relationReorderRecords;
    }

    public TransactionId getTransactionId() {
        return this.transaction;
    }

    public List<EventBasicGuidArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void addArtifact(EventBasicGuidArtifact eventGuidArt) {
        this.artifacts.add(eventGuidArt);
    }

    public List<EventBasicGuidRelation> getRelations() {
        return this.relations;
    }

    public void addRelation(EventBasicGuidRelation eventGuidRelation) {
        this.relations.add(eventGuidRelation);
    }

    public NetworkSender getNetworkSender() {
        return this.networkSender;
    }

    public void setNetworkSender(NetworkSender value) {
        this.networkSender = value;
    }

    public boolean isRelAddedChangedDeleted(Artifact artifact) {
        return this.isRelAddedChangedDeleted(artifact.getBasicGuidArtifact());
    }

    private boolean isRelAddedChangedDeleted(DefaultBasicGuidArtifact guidArt) {
        return this.isRelChange(guidArt) || this.isRelAdded(guidArt) || this.isRelDeletedPurged(guidArt);
    }

    public boolean isHasEvent(Artifact artifact) {
        return this.isHasEvent(artifact.getBasicGuidArtifact());
    }

    private boolean isHasEvent(DefaultBasicGuidArtifact guidArt) {
        return this.isModified(guidArt) || this.isDeletedPurged(guidArt) || this.isRelChange(guidArt) || this.isRelDeletedPurged(guidArt) || this.isRelAdded(guidArt);
    }

    public boolean isDeletedPurged(Artifact artifact) {
        return this.isDeletedPurged(artifact.getBasicGuidArtifact());
    }

    private boolean isDeletedPurged(DefaultBasicGuidArtifact guidArt) {
        for (EventBasicGuidArtifact gArt : this.artifacts) {
            if (!gArt.is(EventModType.Deleted, EventModType.Purged) || !gArt.equals(guidArt)) continue;
            return true;
        }
        return false;
    }

    public Collection<Artifact> getRelCacheArtifacts() {
        try {
            return ArtifactCache.getActive(this.getRelationsArts(RelationEventType.ModifiedRationale, RelationEventType.Added, RelationEventType.Deleted, RelationEventType.Purged, RelationEventType.Undeleted, RelationEventType.ModifiedOrder, RelationEventType.ModifiedRelatedArtifact));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public Collection<Artifact> getCacheArtifacts(EventModType ... eventModTypes) {
        try {
            return ArtifactCache.getActive(this.get(eventModTypes));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public Collection<Artifact> getRelationOrderArtifacts(RelationTypeToken relationType, ArtifactTypeToken artifactType) {
        HashSet<Artifact> reordered = new HashSet<Artifact>(this.relationReorderRecords.size());
        for (DefaultBasicUuidRelationReorder reorder : this.relationReorderRecords) {
            Artifact artifact;
            if (relationType != null && !relationType.equals(reorder.getRelTypeGuid()) || (artifact = ArtifactCache.getActive(reorder.getParentArt())) == null || artifactType != null && !artifact.isOfType(new ArtifactTypeId[]{artifactType})) continue;
            reordered.add(artifact);
        }
        return reordered;
    }

    public Collection<Artifact> getRelationOrderArtifacts() {
        return this.getRelationOrderArtifacts(null, null);
    }

    public void addArtifact(Artifact artifact) {
        EventModifiedBasicGuidArtifact guidArt = new EventModifiedBasicGuidArtifact((BranchId)artifact.getBranch(), artifact.getArtifactType(), artifact.getGuid(), artifact.getDirtyFrameworkAttributeChanges());
        this.artifacts.add(guidArt);
        this.relationReorderRecords.addAll(artifact.getRelationOrderRecords());
    }

    public Collection<EventBasicGuidArtifact> get(EventModType ... eventModTypes) {
        HashSet<EventBasicGuidArtifact> guidArts = new HashSet<EventBasicGuidArtifact>();
        for (EventBasicGuidArtifact guidArt : this.artifacts) {
            EventModType[] eventModTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventModType modType = eventModTypeArray[n2];
                if (guidArt.getModType() == modType) {
                    guidArts.add(guidArt);
                }
                ++n2;
            }
        }
        return guidArts;
    }

    public boolean containsArtifact(Artifact artifact, EventModType ... eventModTypes) {
        for (EventBasicGuidArtifact guidArt : this.artifacts) {
            EventModType[] eventModTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventModType modType = eventModTypeArray[n2];
                if (guidArt.getModType() == modType && guidArt.equals((Object)artifact)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Collection<DefaultBasicGuidArtifact> getRelationsArts(RelationEventType ... eventModTypes) {
        HashSet<DefaultBasicGuidArtifact> guidArts = new HashSet<DefaultBasicGuidArtifact>();
        for (EventBasicGuidRelation guidRel : this.getRelations(eventModTypes)) {
            guidArts.add(guidRel.getArtA());
            guidArts.add(guidRel.getArtB());
        }
        return guidArts;
    }

    public Collection<EventBasicGuidRelation> getRelations(RelationEventType ... eventModTypes) {
        HashSet<EventBasicGuidRelation> guidRels = new HashSet<EventBasicGuidRelation>();
        for (EventBasicGuidRelation guidRel : this.relations) {
            RelationEventType[] relationEventTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                RelationEventType modType = relationEventTypeArray[n2];
                if (guidRel.getModType() == modType) {
                    guidRels.add(guidRel);
                }
                ++n2;
            }
        }
        return guidRels;
    }

    public boolean isReloaded(Artifact artifact) {
        return this.isReloaded(artifact.getBasicGuidArtifact());
    }

    private boolean isReloaded(DefaultBasicGuidArtifact guidArt) {
        return this.get(EventModType.Reloaded).contains(guidArt);
    }

    public boolean isModified(Artifact artifact) {
        return this.isModified(artifact.getBasicGuidArtifact());
    }

    private boolean isModified(DefaultBasicGuidArtifact guidArt) {
        return this.get(EventModType.Modified).contains(guidArt);
    }

    public boolean isModifiedReloaded(Artifact artifact) {
        return this.isModifiedReloaded(artifact.getBasicGuidArtifact());
    }

    private boolean isModifiedReloaded(DefaultBasicGuidArtifact guidArt) {
        return this.get(EventModType.Modified, EventModType.Reloaded).contains(guidArt);
    }

    private boolean isRelChange(DefaultBasicGuidArtifact guidArt) {
        for (EventBasicGuidRelation guidRel : this.getRelations(RelationEventType.ModifiedRationale)) {
            if (!guidRel.getArtA().equals((Object)guidArt) && !guidRel.getArtB().equals((Object)guidArt)) continue;
            return true;
        }
        for (EventBasicGuidRelation guidRel : this.getRelations(RelationEventType.ModifiedOrder)) {
            if (!guidRel.getArtA().equals((Object)guidArt) && !guidRel.getArtB().equals((Object)guidArt)) continue;
            return true;
        }
        for (EventBasicGuidRelation guidRel : this.getRelations(RelationEventType.ModifiedRelatedArtifact)) {
            if (!guidRel.getArtA().equals((Object)guidArt) && !guidRel.getArtB().equals((Object)guidArt)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelDeletedPurged(DefaultBasicGuidArtifact guidArt) {
        for (EventBasicGuidRelation guidRel : this.getRelations(RelationEventType.Deleted, RelationEventType.Purged)) {
            if (!guidRel.getArtA().equals((Object)guidArt) && !guidRel.getArtB().equals((Object)guidArt)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelAdded(DefaultBasicGuidArtifact guidArt) {
        for (EventBasicGuidRelation guidRel : this.getRelations(RelationEventType.Added, RelationEventType.Undeleted)) {
            if (!guidRel.getArtA().equals((Object)guidArt) && !guidRel.getArtB().equals((Object)guidArt)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        try {
            return String.format("ArtifactEvent: BG[%s] TrId[%s] ARTS[%s] RELS[%s] Sender[%s]", this.branch.getId(), this.transaction, this.getArtifactsString(this.artifacts), this.getRelationsString(this.relations), this.networkSender);
        }
        catch (Exception ex) {
            return String.format("ArtifactEvent exception: " + ex.getLocalizedMessage(), new Object[0]);
        }
    }

    private String getArtifactsString(List<EventBasicGuidArtifact> artifacts) {
        if (artifacts.size() <= 10) {
            return artifacts.toString();
        }
        return String.format(" %d Artifacts (data hidden)", artifacts.size());
    }

    private String getRelationsString(List<EventBasicGuidRelation> relations) {
        if (relations.size() <= 10) {
            return relations.toString();
        }
        return String.format(" %d Relations (data hidden)", relations.size());
    }

    public static enum ArtifactEventType {
        RELOAD_ARTIFACTS,
        UPDATE_ARTIFACTS;

    }
}

