/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.core.event.NetworkSender;
import org.eclipse.osee.framework.core.exception.OseeAuthenticationRequiredException;
import org.eclipse.osee.framework.messaging.event.res.msgs.RemoteNetworkSender1;

public class Sender {
    private final String sourceObject;
    private final IdeClientSession oseeSession;

    private Sender(String sourceObjectId, IdeClientSession oseeSession) {
        this.sourceObject = sourceObjectId;
        this.oseeSession = oseeSession;
    }

    public static Sender createSender(Object sourceObject, IdeClientSession oseeSession) {
        String sourceId = EventUtil.getObjectSafeName((Object)sourceObject);
        return new Sender(sourceId, oseeSession);
    }

    public static Sender createSender(NetworkSender networkSender) {
        IdeClientSession oseeSession = new IdeClientSession();
        oseeSession.setId(networkSender.sessionId);
        oseeSession.setClientName(networkSender.machineName);
        oseeSession.setClientAddress(networkSender.machineIp);
        oseeSession.setUserId(networkSender.userId);
        oseeSession.setClientPort(String.valueOf(networkSender.port));
        oseeSession.setClientVersion(networkSender.clientVersion);
        oseeSession.setAuthenticationProtocol("N/A");
        return Sender.createSender(networkSender.sourceObject, oseeSession);
    }

    public static Sender createSender(RemoteNetworkSender1 networkSender) {
        IdeClientSession oseeSession = new IdeClientSession();
        oseeSession.setId(networkSender.getSessionId());
        oseeSession.setClientName(networkSender.getMachineName());
        oseeSession.setClientAddress(networkSender.getMachineIp());
        oseeSession.setUserId(networkSender.getUserId());
        oseeSession.setClientPort(String.valueOf(networkSender.getPort()));
        oseeSession.setClientVersion(networkSender.getClientVersion());
        oseeSession.setAuthenticationProtocol("N/A");
        return Sender.createSender(networkSender.getSourceObject(), oseeSession);
    }

    public static Sender createSender(Object sourceObject) {
        IdeClientSession oseeSession = ClientSessionManager.getSafeSession();
        return Sender.createSender(sourceObject, oseeSession);
    }

    public boolean isRemote() {
        try {
            String sessionId = this.oseeSession.getId();
            if (!"Invalid".equalsIgnoreCase(sessionId)) {
                IdeClientSession session = ClientSessionManager.getSession();
                return !sessionId.equals(session.getId());
            }
            return false;
        }
        catch (OseeAuthenticationRequiredException oseeAuthenticationRequiredException) {
            return false;
        }
    }

    public boolean isLocal() {
        return !this.isRemote();
    }

    public String getAuthor() {
        return this.oseeSession.getUserId();
    }

    public IdeClientSession getOseeSession() {
        return this.oseeSession;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public NetworkSender getNetworkSender() {
        return new NetworkSender((Object)this.sourceObject, this.oseeSession.getId(), this.oseeSession.getClientName(), this.oseeSession.getUserId(), this.oseeSession.getClientAddress(), Integer.valueOf(this.oseeSession.getClientPort()).intValue(), this.oseeSession.getClientVersion());
    }

    public RemoteNetworkSender1 getNetworkSenderRes() {
        RemoteNetworkSender1 sender = new RemoteNetworkSender1();
        sender.setSourceObject(this.sourceObject);
        sender.setSessionId(this.oseeSession.getId());
        sender.setMachineName(this.oseeSession.getClientName());
        sender.setUserId(this.oseeSession.getUserId());
        sender.setMachineIp(this.oseeSession.getClientAddress());
        sender.setPort(Integer.valueOf(this.oseeSession.getClientPort()).intValue());
        sender.setClientVersion(this.oseeSession.getClientVersion());
        return sender;
    }

    public String toString() {
        String remote = this.isRemote() ? "Remote" : "Local";
        return "Sender: " + remote + " [" + this.oseeSession.toString() + "  [" + this.sourceObject + "]]";
    }
}

