/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.AbstractArtifactExtractor;

public class WholeWordDocumentExtractor
extends AbstractArtifactExtractor {
    @Override
    public String getDescription() {
        return "Extract all the content of each Word XML document as one artifact.";
    }

    @Override
    protected void extractFromSource(OperationLogger logger, URI source, RoughArtifactCollector collector) throws Exception {
        if (source == null) {
            throw new OseeArgumentException("importFile can not be null", new Object[0]);
        }
        RoughArtifact roughArtifact = new RoughArtifact(CoreArtifactTypes.MsWordWholeDocument, Lib.removeExtension((String)new File(source).getName()));
        collector.addRoughArtifact(roughArtifact);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, source);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }
        };
    }

    @Override
    public String getName() {
        return "Whole Word Document";
    }
}

