/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.event.FrameworkEvent;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerLocal;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerRemote;

public class EventHandlers {
    private final Map<Class<? extends FrameworkEvent>, EventHandlerLocal<? extends IEventListener, ? extends FrameworkEvent>> handlers = new HashMap<Class<? extends FrameworkEvent>, EventHandlerLocal<? extends IEventListener, ? extends FrameworkEvent>>();
    private final Map<Class<? extends RemoteEvent>, EventHandlerRemote<? extends RemoteEvent>> remoteHandlers = new HashMap<Class<? extends RemoteEvent>, EventHandlerRemote<? extends RemoteEvent>>();

    public void addLocalHandler(Class<? extends FrameworkEvent> clazz, EventHandlerLocal<? extends IEventListener, ? extends FrameworkEvent> handler) {
        this.handlers.put(clazz, handler);
    }

    public void removeLocalHandler(Class<? extends FrameworkEvent> clazz) {
        this.handlers.remove(clazz);
    }

    public void addRemoteHandler(Class<? extends RemoteEvent> clazz, EventHandlerRemote<? extends RemoteEvent> handler) {
        this.remoteHandlers.put(clazz, handler);
    }

    public void removeRemoteHandler(Class<? extends RemoteEvent> clazz) {
        this.remoteHandlers.remove(clazz);
    }

    public <H extends EventHandlerRemote<? extends RemoteEvent>> H getRemoteHandler(RemoteEvent event) {
        return (H)this.remoteHandlers.get(event.getClass());
    }

    public <H extends EventHandlerLocal<? extends IEventListener, ? extends FrameworkEvent>> H getLocalHandler(FrameworkEvent event) {
        return (H)this.handlers.get(event.getClass());
    }

    public int sizeLocal() {
        return this.handlers.size();
    }

    public int sizeRemote() {
        return this.remoteHandlers.size();
    }
}

