/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.cache.admin.CacheAdmin;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.UserDataStoreException;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserAdmin;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.internal.users.CurrentUserProvider;
import org.eclipse.osee.framework.skynet.core.internal.users.UserArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.internal.users.UserCacheProvider;
import org.eclipse.osee.framework.skynet.core.internal.users.UserDataLoader;
import org.eclipse.osee.framework.skynet.core.internal.users.UserKeysProvider;

public class UserAdminImpl
implements UserAdmin {
    private UserKeysProvider keysProvider;
    private LazyObject<Cache<String, User>> cacheProvider;
    private CurrentUserProvider currentUserProvider;
    private UserArtifactEventListener userArtifactEventListener;
    private CacheAdmin cacheAdmin;

    public void setCacheAdmin(CacheAdmin cacheAdmin) {
        this.cacheAdmin = cacheAdmin;
    }

    public void start() {
        UserService userService = ((OseeClient)OsgiUtil.getService(this.getClass(), OseeClient.class)).userService();
        this.keysProvider = new UserKeysProvider(userService);
        this.cacheProvider = new UserCacheProvider(this.cacheAdmin, new UserDataLoader(userService), this.keysProvider);
        this.currentUserProvider = new CurrentUserProvider(this.cacheProvider);
        this.userArtifactEventListener = new UserArtifactEventListener(this.cacheProvider, this.keysProvider);
        OseeEventManager.addListener(this.userArtifactEventListener);
    }

    public void stop() {
        if (this.userArtifactEventListener != null) {
            OseeEventManager.removeListener(this.userArtifactEventListener);
            this.userArtifactEventListener = null;
        }
        if (this.currentUserProvider != null) {
            this.currentUserProvider.invalidate();
            this.currentUserProvider = null;
        }
        if (this.cacheProvider != null) {
            this.cacheProvider.invalidate();
            this.cacheProvider = null;
        }
        if (this.keysProvider != null) {
            this.keysProvider.invalidate();
            this.keysProvider = null;
        }
    }

    @Override
    public void reset() {
        this.keysProvider.invalidate();
        this.currentUserProvider.invalidate();
        this.cacheProvider.invalidate();
    }

    private Cache<String, User> getCache() {
        return (Cache)this.cacheProvider.get();
    }

    @Override
    public boolean isDuringCurrentUserCreation() {
        return this.currentUserProvider.isDuringCurrentUserCreation();
    }

    @Override
    public User getCurrentUser() {
        if (this.isDuringCurrentUserCreation()) {
            return this.getUserByUserId(ClientSessionManager.getCurrentUserToken().getUserId());
        }
        return (User)((Object)this.currentUserProvider.get());
    }

    @Override
    public User getCurrentUserOrNull() {
        for (User user : this.getUsersAll()) {
            if (!user.getUserId().equals(ClientSessionManager.getCurrentUserToken().getUserId())) continue;
            return user;
        }
        return null;
    }

    @Override
    public void releaseCurrentUser() {
        this.currentUserProvider.invalidate();
    }

    @Override
    public User getUserByUserId(String userId) {
        Conditions.checkNotNullOrEmpty((String)userId, (String)"userId");
        Cache<String, User> cache = this.getCache();
        User user = null;
        try {
            user = (User)((Object)cache.get((Object)userId));
        }
        catch (Exception ex) {
            UserDataStoreException userEx = this.unwrapUserException(ex);
            if (userEx != null) {
                throw userEx;
            }
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return user;
    }

    private UserDataStoreException unwrapUserException(Throwable ex) {
        UserDataStoreException toReturn = null;
        Throwable cause = ex.getCause();
        if (cause instanceof UserDataStoreException) {
            toReturn = (UserDataStoreException)cause;
        } else if (cause != null) {
            toReturn = this.unwrapUserException(cause);
        }
        return toReturn;
    }

    @Override
    public List<User> getActiveUsers() {
        Cache<String, User> cache = this.getCache();
        ArrayList<User> activeUsers = new ArrayList<User>();
        Iterable all = null;
        try {
            all = cache.getAll();
            for (User user : all) {
                if (!user.isActive()) continue;
                activeUsers.add(user);
            }
        }
        catch (Exception e) {
            OseeCoreException.wrapAndThrow((Throwable)e);
        }
        return activeUsers;
    }

    @Override
    public List<User> getUsersAll() {
        Cache<String, User> cache = this.getCache();
        ArrayList<User> users = new ArrayList<User>();
        Iterable all = null;
        try {
            all = cache.getAll();
            for (User user : all) {
                users.add(user);
            }
        }
        catch (Exception e) {
            OseeCoreException.wrapAndThrow((Throwable)e);
        }
        return users;
    }

    @Override
    public List<User> getActiveUsersSortedByName() {
        List<User> users = this.getActiveUsers();
        Collections.sort(users);
        return users;
    }

    @Override
    public List<User> getUsersAllSortedByName() {
        List<User> users = this.getUsersAll();
        Collections.sort(users);
        return users;
    }

    @Override
    public String[] getUserNames() {
        List<User> allUsers = this.getUsersAll();
        String[] userNames = new String[allUsers.size()];
        int index = 0;
        for (User user : allUsers) {
            userNames[index++] = user.getName();
        }
        return userNames;
    }

    @Override
    public User getUserByName(String name) {
        Conditions.checkNotNullOrEmpty((String)name, (String)"user name");
        User toReturn = this.checkIterableForName(this.getCache().getAllPresent(), name);
        if (toReturn == null) {
            toReturn = this.checkIterableForName(this.getUsersAll(), name);
        }
        if (toReturn == null) {
            throw new UserNotInDatabase("User requested by name [%s] was not found.", new Object[]{name});
        }
        return toReturn;
    }

    private User checkIterableForName(Iterable<User> users, String name) {
        User toReturn = null;
        for (User tempUser : users) {
            if (!name.equals(tempUser.getName())) continue;
            toReturn = tempUser;
            break;
        }
        return toReturn;
    }

    @Override
    public User getUser(UserToken user) {
        Conditions.checkNotNull((Object)user, (String)"user data");
        return this.getUserByUserId(user.getUserId());
    }

    @Override
    public String getUserNameById(ArtifactId userArtifactId) {
        User user = this.getUserByArtId(userArtifactId);
        if (user == null) {
            throw new UserNotInDatabase("Unable to find user with artId[%s]", new Object[]{userArtifactId});
        }
        String name = user.getName();
        return name;
    }

    @Override
    public String getSafeUserNameById(ArtifactId userArtifactId) {
        String name = "unknown";
        if (userArtifactId != null) {
            try {
                name = this.getUserNameById(userArtifactId);
            }
            catch (Exception exception) {
                name = String.format("Could not resolve user with artId[%s]", userArtifactId);
            }
        }
        return name;
    }

    @Override
    public User getUserByArtId(ArtifactId userArtifactId) {
        User toReturn = null;
        if (userArtifactId.isInvalid()) {
            toReturn = this.getUser(SystemUser.OseeSystem);
        } else {
            toReturn = this.checkIterableForId(this.getCache().getAllPresent(), userArtifactId);
            if (toReturn == null) {
                toReturn = this.checkIterableForId(this.getUsersAll(), userArtifactId);
            }
        }
        return toReturn;
    }

    private User checkIterableForId(Iterable<User> users, ArtifactId id) {
        User toReturn = null;
        for (User tempUser : users) {
            if (!id.equals((Object)tempUser)) continue;
            toReturn = tempUser;
            break;
        }
        return toReturn;
    }
}

