/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.revision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.change.ArtifactChange;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.ArtifactWasIsLazyProvider;
import org.eclipse.osee.framework.skynet.core.change.AttributeChange;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.change.ErrorChange;
import org.eclipse.osee.framework.skynet.core.change.RelationChange;
import org.eclipse.osee.framework.skynet.core.change.TupleChange;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;

public class ChangeDataLoader
extends AbstractOperation {
    private final TransactionDelta txDelta;
    private final Collection<Change> changes;
    private final OrcsTokenService tokenService;

    public ChangeDataLoader(Collection<Change> changes, TransactionDelta txDelta) {
        super("Compute Changes", "org.eclipse.osee.framework.skynet.core");
        this.changes = changes;
        this.txDelta = txDelta;
        this.tokenService = (OrcsTokenService)OsgiUtil.getService(ArtifactLoader.class, OrcsTokenService.class);
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        List<ChangeItem> changeItems = ChangeDataLoader.requestChanges(this.txDelta);
        monitor.worked(this.calculateWork(0.2));
        if (changeItems.isEmpty()) {
            monitor.worked(this.calculateWork(0.8));
        } else {
            monitor.setTaskName("Bulk load changed artifacts");
            ChangeDataLoader.checkForCancelledStatus((IProgressMonitor)monitor);
            CompositeKeyHashMap bulkLoaded = new CompositeKeyHashMap();
            this.bulkLoadArtifactDeltas((CompositeKeyHashMap<TransactionId, ArtifactId, Artifact>)bulkLoaded, changeItems);
            monitor.worked(this.calculateWork(0.2));
            monitor.setTaskName("Compute artifact deltas");
            double workAmount = 0.6 / (double)changeItems.size();
            BranchToken startTxBranch = BranchManager.getBranchToken(this.txDelta.getStartTx().getBranch());
            for (ChangeItem item : changeItems) {
                Change change;
                ChangeDataLoader.checkForCancelledStatus((IProgressMonitor)monitor);
                if ((ChangeItemUtil.hasValueChange((ChangeItem)item) || item.getChangeType().isArtifactChange()) && ChangeItemUtil.hasApplicabilityChange((ChangeItem)item)) {
                    ChangeItem splitItem = ChangeItemUtil.splitForApplicability((ChangeItem)item);
                    Change splitChange = this.computeChange((CompositeKeyHashMap<TransactionId, ArtifactId, Artifact>)bulkLoaded, startTxBranch, splitItem);
                    this.changes.add(splitChange);
                }
                if (!this.changes.contains(change = this.computeChange((CompositeKeyHashMap<TransactionId, ArtifactId, Artifact>)bulkLoaded, startTxBranch, item))) {
                    this.changes.add(change);
                }
                monitor.worked(this.calculateWork(workAmount));
            }
        }
    }

    public void determineChanges(IProgressMonitor monitor) {
        monitor.setTaskName("Retrieve Change Items");
        List<ChangeItem> changeItems = ChangeDataLoader.requestChanges(this.txDelta);
        ChangeDataLoader.checkForCancelledStatus((IProgressMonitor)monitor);
        monitor.setTaskName("Bulk load changed artifacts");
        CompositeKeyHashMap bulkLoaded = new CompositeKeyHashMap();
        this.bulkLoadArtifactDeltas((CompositeKeyHashMap<TransactionId, ArtifactId, Artifact>)bulkLoaded, changeItems);
        monitor.setTaskName("Compute artifact deltas");
        double workAmount = 0.3 / (double)changeItems.size();
        BranchToken startTxBranch = BranchManager.getBranchToken(this.txDelta.getStartTx().getBranch());
        for (ChangeItem item : changeItems) {
            ChangeDataLoader.checkForCancelledStatus((IProgressMonitor)monitor);
            if (ChangeItemUtil.hasValueChange((ChangeItem)item) && ChangeItemUtil.hasApplicabilityChange((ChangeItem)item)) {
                ChangeItem splitItem = ChangeItemUtil.splitForApplicability((ChangeItem)item);
                Change splitChange = this.computeChangeFromGamma((CompositeKeyHashMap<TransactionId, ArtifactId, Artifact>)bulkLoaded, startTxBranch, splitItem);
                this.changes.add(splitChange);
            }
            Change change = this.computeChangeFromGamma((CompositeKeyHashMap<TransactionId, ArtifactId, Artifact>)bulkLoaded, startTxBranch, item);
            this.changes.add(change);
            monitor.worked(this.calculateWork(workAmount));
        }
    }

    private Change computeChangeFromGamma(CompositeKeyHashMap<TransactionId, ArtifactId, Artifact> bulkLoaded, BranchToken startTxBranch, ChangeItem item) {
        Change change = null;
        try {
            Artifact endTxArtifact;
            Artifact startTxArtifact;
            ArtifactId artId = item.getArtId();
            GammaId destGamma = item.getDestinationVersion().getGammaId();
            GammaId baseGamma = item.getBaselineVersion().getGammaId();
            if (this.txDelta.areOnTheSameBranch()) {
                startTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getStartTx(), (Object)artId));
                endTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getEndTx(), (Object)artId));
            } else {
                startTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getEndTx(), (Object)artId));
                endTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getStartTx(), (Object)artId));
            }
            Artifact baseTxArtifact = baseGamma != null && baseGamma.equals(destGamma) ? startTxArtifact : (Artifact)((Object)bulkLoaded.get((Object)BranchManager.getBaseTransaction(this.txDelta.getStartTx().getBranch()), (Object)artId));
            ArtifactDelta artifactDelta = new ArtifactDelta(this.txDelta, startTxArtifact, endTxArtifact, baseTxArtifact);
            change = this.createChangeObject(bulkLoaded, item, this.txDelta, startTxBranch, artifactDelta);
            change.setChangeItem(item);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            change = new ErrorChange(startTxBranch, item.getArtId(), ex.toString());
        }
        return change;
    }

    private Change computeChange(CompositeKeyHashMap<TransactionId, ArtifactId, Artifact> bulkLoaded, BranchToken startTxBranch, ChangeItem item) {
        Change change = null;
        try {
            ArtifactId artId = item.getArtId();
            ArtifactDelta artifactDelta = null;
            if (artId.isValid()) {
                Artifact endTxArtifact;
                Artifact startTxArtifact;
                if (this.txDelta.areOnTheSameBranch()) {
                    startTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getStartTx(), (Object)artId));
                    endTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getEndTx(), (Object)artId));
                } else {
                    startTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)BranchManager.getBaseTransaction(this.txDelta.getStartTx().getBranch()), (Object)artId));
                    endTxArtifact = (Artifact)((Object)bulkLoaded.get((Object)this.txDelta.getStartTx(), (Object)artId));
                }
                artifactDelta = new ArtifactDelta(this.txDelta, startTxArtifact, endTxArtifact);
            }
            change = this.createChangeObject(bulkLoaded, item, this.txDelta, startTxBranch, artifactDelta);
            change.setChangeItem(item);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            change = new ErrorChange(startTxBranch, item.getArtId(), ex.toString());
        }
        return change;
    }

    private Change createChangeObject(CompositeKeyHashMap<TransactionId, ArtifactId, Artifact> bulkLoaded, ChangeItem item, TransactionDelta txDelta, BranchToken startTxBranch, ArtifactDelta artifactDelta) {
        Change change = null;
        Long itemId = item.getItemId().getId();
        GammaId itemGammaId = item.getNetChange().getGammaId();
        ModificationType netModType = item.getNetChange().getModType();
        ArtifactId artId = item.getArtId();
        Artifact changeArtifact = Artifact.SENTINEL;
        if (artifactDelta != null) {
            changeArtifact = artifactDelta.getEndArtifact();
        }
        boolean isHistorical = txDelta.areOnTheSameBranch();
        if (item.getChangeType().isArtifactChange()) {
            if (item.isApplicabilityCopy() || ChangeItemUtil.hasApplicabilityOnlyChange((ChangeItem)item)) {
                netModType = ModificationType.APPLICABILITY;
                String isValue = "";
                String wasValue = "";
                if (item.getDestinationVersion().isValid()) {
                    wasValue = item.getDestinationVersion().getApplicabilityToken().getName();
                }
                if (item.getCurrentVersion().isValid()) {
                    isValue = item.getCurrentVersion().getApplicabilityToken().getName();
                }
                change = new ArtifactChange(startTxBranch, itemGammaId, ArtifactId.valueOf((Long)itemId), txDelta, netModType, isValue, wasValue, isHistorical, changeArtifact, artifactDelta);
            } else {
                change = new ArtifactChange(startTxBranch, itemGammaId, ArtifactId.valueOf((Long)itemId), txDelta, netModType, "", "", isHistorical, changeArtifact, artifactDelta);
            }
        } else if (item.getChangeType().isAttributeChange()) {
            AttributeTypeGeneric attributeType = this.tokenService.getAttributeType(item.getItemTypeId().getId());
            if (item.isApplicabilityCopy() || ChangeItemUtil.hasApplicabilityOnlyChange((ChangeItem)item)) {
                netModType = ModificationType.APPLICABILITY;
                change = new AttributeChange(startTxBranch, itemGammaId, artId, txDelta, netModType, item.getCurrentVersion().getApplicabilityToken().getName(), null, item.getDestinationVersion().getApplicabilityToken().getName(), null, AttributeId.valueOf((Long)itemId), (AttributeTypeToken)attributeType, netModType, isHistorical, changeArtifact, artifactDelta);
            } else {
                ChangeDateLoaderWasIsLazyProvider wasIsProvider = new ChangeDateLoaderWasIsLazyProvider(txDelta, item, (AttributeTypeToken)attributeType, artifactDelta);
                change = new AttributeChange(startTxBranch, itemGammaId, artId, txDelta, netModType, wasIsProvider, AttributeId.valueOf((Long)itemId), (AttributeTypeToken)attributeType, netModType, isHistorical, changeArtifact, artifactDelta);
            }
        } else if (item.getChangeType().isRelationChange()) {
            RelationTypeToken relationType = this.tokenService.getRelationType(item.getItemTypeId().getId());
            int relOrder = relationType.isNewRelationTable() ? item.getRelOrder() : 0;
            TransactionToken transaction = txDelta.getStartTx();
            if (txDelta.areOnTheSameBranch()) {
                transaction = txDelta.getEndTx();
            }
            Artifact endTxBArtifact = (Artifact)((Object)bulkLoaded.get((Object)transaction, (Object)item.getArtIdB()));
            String rationale = item.getCurrentVersion().getValue();
            if (item.isApplicabilityCopy() || ChangeItemUtil.hasApplicabilityOnlyChange((ChangeItem)item)) {
                netModType = ModificationType.APPLICABILITY;
                change = new RelationChange(startTxBranch, itemGammaId, artId, txDelta, netModType, (ArtifactId)endTxBArtifact, RelationId.valueOf((Long)itemId), item.getCurrentVersion().getApplicabilityToken().getName(), item.getDestinationVersion().getApplicabilityToken().getName(), relationType, isHistorical, changeArtifact, artifactDelta, endTxBArtifact, relOrder);
            } else {
                change = new RelationChange(startTxBranch, itemGammaId, artId, txDelta, netModType, (ArtifactId)endTxBArtifact, RelationId.valueOf((Long)itemId), rationale, "", relationType, isHistorical, changeArtifact, artifactDelta, endTxBArtifact, relOrder);
            }
        } else if (item.getChangeType().isTupleChange()) {
            TupleTypeId tupleTypeId = TupleTypeId.valueOf((Long)item.getItemTypeId().getId());
            String value = item.getCurrentVersion().getValue();
            StringTokenizer tok = new StringTokenizer(value, "|");
            String itemKind = "";
            String tupleIsValue = "";
            String tupleWasValue = "";
            if (tok.hasMoreTokens()) {
                itemKind = tok.nextToken();
            }
            if (tok.hasMoreElements()) {
                if (netModType.equals(ModificationType.DELETED)) {
                    tupleWasValue = tok.nextToken();
                } else {
                    tupleIsValue = tok.nextToken();
                }
            }
            change = new TupleChange(startTxBranch, itemGammaId, txDelta, netModType, tupleTypeId, tupleIsValue, tupleWasValue, itemKind, isHistorical);
        } else {
            throw new OseeCoreException("The change item must map to either an artifact, attribute or relation change", new Object[0]);
        }
        return change;
    }

    private void bulkLoadArtifactDeltas(CompositeKeyHashMap<TransactionId, ArtifactId, Artifact> bulkLoaded, Collection<ChangeItem> changeItems) {
        Set<ArtifactId> artIds = ChangeDataLoader.asArtIds(changeItems);
        ChangeDataLoader.preloadArtifacts(bulkLoaded, artIds, this.txDelta.getStartTx(), this.txDelta.areOnTheSameBranch());
        if (!this.txDelta.getStartTx().equals(this.txDelta.getEndTx())) {
            ChangeDataLoader.preloadArtifacts(bulkLoaded, artIds, this.txDelta.getEndTx(), this.txDelta.areOnTheSameBranch());
        }
        if (!this.txDelta.areOnTheSameBranch()) {
            ChangeDataLoader.preloadArtifacts(bulkLoaded, artIds, (TransactionToken)BranchManager.getBaseTransaction(this.txDelta.getStartTx().getBranch()), true);
        }
    }

    private static void preloadArtifacts(CompositeKeyHashMap<TransactionId, ArtifactId, Artifact> bulkLoaded, Collection<ArtifactId> artIds, TransactionToken tx, boolean isHistorical) {
        List<Artifact> artifacts = isHistorical ? ArtifactQuery.getHistoricalArtifactListFromIds(artIds, tx, DeletionFlag.INCLUDE_DELETED) : ArtifactQuery.getArtifactListFrom(artIds, tx.getBranch());
        for (Artifact artifact : artifacts) {
            bulkLoaded.put((Object)tx, (Object)ArtifactId.create((Id)artifact), (Object)artifact);
        }
    }

    private static Set<ArtifactId> asArtIds(Collection<ChangeItem> changeItems) {
        HashSet<ArtifactId> artIds = new HashSet<ArtifactId>();
        for (ChangeItem item : changeItems) {
            artIds.add(item.getArtId());
            if (!item.getChangeType().isRelationChange()) continue;
            artIds.add(item.getArtIdB());
        }
        return artIds;
    }

    private static List<ChangeItem> requestChanges(TransactionDelta txDelta) {
        OseeClient client = ServiceUtil.getOseeClient();
        TransactionEndpoint proxy = client.getTransactionEndpoint();
        try {
            List results = proxy.compareTxs((TransactionId)txDelta.getStartTx(), (TransactionId)txDelta.getEndTx());
            ArrayList<ChangeItem> changes = new ArrayList<ChangeItem>();
            for (ChangeItem item : results) {
                if (!ChangeDataLoader.isAllowableChange(item.getIgnoreType())) continue;
                changes.add(item);
            }
            return changes;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private static boolean isAllowableChange(ChangeIgnoreType ignoreType) {
        return ignoreType.isNone() || ignoreType.isResurrected() || ignoreType.isDeletedOnDestAndNotResurrected() || ignoreType.isDeletedOnDestination();
    }

    private static class ChangeDateLoaderWasIsLazyProvider
    implements ArtifactWasIsLazyProvider {
        private final TransactionDelta txDelta;
        private final ChangeItem item;
        private final AttributeTypeToken attributeType;
        private final ArtifactDelta artifactDelta;

        public ChangeDateLoaderWasIsLazyProvider(TransactionDelta txDelta, ChangeItem item, AttributeTypeToken attributeType, ArtifactDelta artifactDelta) {
            this.txDelta = txDelta;
            this.item = item;
            this.attributeType = attributeType;
            this.artifactDelta = artifactDelta;
        }

        @Override
        public String getWasValue() {
            String wasValue = "";
            if (!this.txDelta.areOnTheSameBranch()) {
                ChangeVersion netChange = this.item.getNetChange();
                if (!ChangeItemUtil.isNew((ChangeVersion)netChange) && !ChangeItemUtil.isIntroduced((ChangeVersion)netChange)) {
                    ChangeVersion fromVersion = ChangeItemUtil.getStartingVersion((ChangeItem)this.item);
                    wasValue = fromVersion.getValue();
                }
            } else {
                Artifact startArtifact = null;
                if (this.artifactDelta != null && (startArtifact = this.artifactDelta.getBaseArtifact()) == null) {
                    startArtifact = this.artifactDelta.getStartArtifact();
                }
                if (startArtifact != null && (wasValue = startArtifact.getAttributesToString((AttributeTypeId)this.attributeType)) == null) {
                    wasValue = "";
                }
            }
            return wasValue;
        }

        @Override
        public String getIsValue() {
            return this.item.getCurrentVersion().getValue();
        }

        @Override
        public String getWasUri() {
            return null;
        }

        @Override
        public String getIsUri() {
            return null;
        }
    }
}

