/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.revision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.change.ArtifactChange;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.AttributeChange;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.change.RelationChange;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;

public final class RevisionChangeLoader {
    private final OrcsTokenService tokenService;
    private final List<ChangeType> loadChangeTypes = new ArrayList<ChangeType>();

    protected RevisionChangeLoader() {
        this.tokenService = (OrcsTokenService)OsgiUtil.getService(ArtifactLoader.class, OrcsTokenService.class);
    }

    public Collection<Change> getChangesPerArtifact(Artifact artifact, IProgressMonitor monitor, ChangeType ... loadChangeTypes) {
        this.loadChangeTypes.clear();
        ChangeType[] changeTypeArray = loadChangeTypes;
        int n = loadChangeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeType changeType = changeTypeArray[n2];
            this.loadChangeTypes.add(changeType);
            ++n2;
        }
        return this.getChangesPerArtifact(artifact, -1, monitor);
    }

    public Collection<Change> getChangesPerArtifact(Artifact artifact, int numberTransactionsToShow, IProgressMonitor monitor, ChangeType ... loadChangeTypes) {
        this.loadChangeTypes.clear();
        ChangeType[] changeTypeArray = loadChangeTypes;
        int n = loadChangeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeType changeType = changeTypeArray[n2];
            this.loadChangeTypes.add(changeType);
            ++n2;
        }
        return this.getChangesPerArtifact(artifact, numberTransactionsToShow, monitor);
    }

    private Collection<Change> getChangesPerArtifact(Artifact artifact, int numberTransactionsToShow, IProgressMonitor monitor) {
        Collection<Change> changes = new ArrayList<Change>();
        OseeClient client = ServiceUtil.getOseeClient();
        TransactionEndpoint txEndpoint = client.getTransactionEndpoint();
        try {
            List<ChangeItem> changeItems = txEndpoint.getArtifactHistory((ArtifactId)artifact, (BranchId)artifact.getBranch());
            if (!changeItems.isEmpty()) {
                if (numberTransactionsToShow > 0) {
                    changeItems = this.trimTransactions(changeItems, numberTransactionsToShow);
                }
                CompositeKeyHashMap<TransactionToken, ArtifactId, Artifact> loadedMap = this.getBulkLoadedArtifacts(changeItems);
                changes = this.getChanges(changeItems, loadedMap, numberTransactionsToShow);
            }
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return changes;
    }

    private List<ChangeItem> trimTransactions(List<ChangeItem> changeItems, int numberTransactionsToShow) {
        ArrayList<ChangeItem> changeItemsToReturn = new ArrayList<ChangeItem>();
        Collections.reverse(changeItems);
        HashSet<TransactionToken> txSet = new HashSet<TransactionToken>();
        for (ChangeItem item : changeItems) {
            TransactionToken txToken = item.getCurrentVersion().getTransactionToken();
            if (!txSet.contains(txToken)) {
                if (txSet.size() == numberTransactionsToShow) break;
                txSet.add(txToken);
            }
            changeItemsToReturn.add(0, item);
        }
        return changeItemsToReturn;
    }

    private CompositeKeyHashMap<TransactionToken, ArtifactId, Artifact> getBulkLoadedArtifacts(List<ChangeItem> changeItems) {
        CompositeKeyHashMap loadedMap = new CompositeKeyHashMap();
        HashCollectionSet txToArtIdMap = new HashCollectionSet();
        for (ChangeItem item : changeItems) {
            txToArtIdMap.put((Object)item.getCurrentVersion().getTransactionToken(), (Object)item.getArtId());
            if (!item.getChangeType().isRelationChange()) continue;
            txToArtIdMap.put((Object)item.getCurrentVersion().getTransactionToken(), (Object)item.getArtIdB());
        }
        TransactionToken lastTx = changeItems.get(changeItems.size() - 1).getCurrentVersion().getTransactionToken();
        for (Map.Entry entry : txToArtIdMap.entrySet()) {
            TransactionToken txToken = (TransactionToken)entry.getKey();
            List<Artifact> artifacts = txToken.equals(lastTx) ? ArtifactQuery.getArtifactListFrom((Collection)entry.getValue(), txToken.getBranch(), DeletionFlag.INCLUDE_DELETED) : ArtifactQuery.getHistoricalArtifactListFromIds((Collection)entry.getValue(), txToken, DeletionFlag.INCLUDE_DELETED);
            for (Artifact art : artifacts) {
                loadedMap.put((Object)txToken, (Object)ArtifactId.create((Id)art), (Object)art);
            }
        }
        return loadedMap;
    }

    private Collection<Change> getChanges(Collection<ChangeItem> changeItems, CompositeKeyHashMap<TransactionToken, ArtifactId, Artifact> loadedMap, int numberTransactionsToShow) {
        ArrayList<Change> changes = new ArrayList<Change>();
        ArrayList<TransactionToken> modifiedTxs = new ArrayList<TransactionToken>();
        for (ChangeItem changeItem : changeItems) {
            Artifact baselineArtifact;
            TransactionToken startTx;
            ChangeVersion currentVersion = changeItem.getCurrentVersion();
            TransactionToken currentTx = currentVersion.getTransactionToken();
            ArtifactId changeArtId = changeItem.getArtId();
            BranchToken currentBranch = BranchManager.getBranchToken(currentTx.getBranch());
            GammaId currentGammaId = currentVersion.getGammaId();
            ModificationType modType = currentVersion.getModType();
            ChangeVersion startVersion = changeItem.getBaselineVersion();
            if (startVersion.isValid()) {
                startTx = startVersion.getTransactionToken();
                baselineArtifact = (Artifact)((Object)loadedMap.get((Object)startTx, (Object)changeArtId));
            } else {
                startTx = currentTx;
                baselineArtifact = Artifact.SENTINEL;
            }
            TransactionDelta txDelta = new TransactionDelta(startTx, currentTx);
            Artifact changeArtifact = (Artifact)((Object)loadedMap.get((Object)currentVersion.getTransactionToken(), (Object)changeArtId));
            if (changeArtifact != null) {
                ArtifactChange artChange;
                ArtifactDelta artDelta = new ArtifactDelta(txDelta, baselineArtifact, changeArtifact);
                boolean isHistorical = changeArtifact.isHistorical();
                ChangeType changeType = changeItem.getChangeType();
                if (changeType.isArtifactChange() && this.loadChangeTypes.contains(changeType)) {
                    artChange = new ArtifactChange(currentBranch, currentGammaId, changeArtId, txDelta, modType, "", "", isHistorical, changeArtifact, artDelta);
                    changes.add(artChange);
                    if (changeItem.isApplicabilityCopy() || (startVersion.isValid() || modType.equals(ModificationType.NEW)) && !ChangeItemUtil.areApplicabilitiesEqual((ChangeVersion)startVersion, (ChangeVersion)currentVersion) || ChangeItemUtil.isDeleted((ChangeVersion)currentVersion) && startVersion.isValid()) {
                        ArtifactChange applicChange = this.getApplicabilityChange(startVersion, currentVersion, currentBranch, currentGammaId, changeArtId, txDelta, changeArtifact, artDelta);
                        changes.add(applicChange);
                    }
                    if (modifiedTxs.contains(currentTx)) continue;
                    modifiedTxs.add(currentTx);
                    continue;
                }
                if (changeType.isAttributeChange() && this.loadChangeTypes.contains(changeType)) {
                    if (!modifiedTxs.contains(currentTx) && this.loadChangeTypes.contains(ChangeType.Artifact)) {
                        artChange = new ArtifactChange(currentBranch, GammaId.SENTINEL, changeArtId, txDelta, ModificationType.MODIFIED, "", "", isHistorical, changeArtifact, artDelta);
                        changes.add(artChange);
                        modifiedTxs.add(currentTx);
                    }
                    AttributeChange attrChange = this.getAttributeChange(changeItem, startVersion, currentVersion, currentBranch, currentGammaId, changeArtId, txDelta, modType, changeArtifact, artDelta);
                    changes.add(attrChange);
                    continue;
                }
                if (!changeType.isRelationChange() || !this.loadChangeTypes.contains(changeType)) continue;
                if (!modifiedTxs.contains(currentTx) && this.loadChangeTypes.contains(ChangeType.Artifact)) {
                    artChange = new ArtifactChange(currentBranch, GammaId.SENTINEL, changeArtId, txDelta, ModificationType.MODIFIED, "", "", true, changeArtifact, artDelta);
                    changes.add(artChange);
                    modifiedTxs.add(currentTx);
                }
                RelationChange relChange = this.getRelationChange(changeItem, loadedMap, startVersion, currentVersion, currentBranch, currentGammaId, changeArtId, txDelta, modType, changeArtifact, artDelta);
                changes.add(relChange);
                continue;
            }
            ArtifactChange change = new ArtifactChange(currentBranch, currentGammaId, changeArtId, txDelta, modType, "", "", true, Artifact.SENTINEL, null);
            changes.add(change);
        }
        return changes;
    }

    private ArtifactChange getApplicabilityChange(ChangeVersion startVersion, ChangeVersion currentVersion, BranchToken branch, GammaId gammaId, ArtifactId artId, TransactionDelta txDelta, Artifact artifact, ArtifactDelta artDelta) {
        String wasValue = "";
        String isValue = "";
        if (startVersion.isValid()) {
            wasValue = startVersion.getApplicabilityToken().getName();
        }
        if (currentVersion.isValid() && !ChangeItemUtil.isDeleted((ChangeVersion)currentVersion)) {
            isValue = currentVersion.getApplicabilityToken().getName();
        }
        ArtifactChange applicChange = new ArtifactChange(branch, gammaId, artId, txDelta, ModificationType.APPLICABILITY, isValue, wasValue, artifact.isHistorical(), artifact, artDelta);
        return applicChange;
    }

    private AttributeChange getAttributeChange(ChangeItem changeItem, ChangeVersion startVersion, ChangeVersion currentVersion, BranchToken branch, GammaId gammaId, ArtifactId artId, TransactionDelta txDelta, ModificationType modType, Artifact artifact, ArtifactDelta artDelta) {
        String isValue = currentVersion.getValue();
        String isUri = currentVersion.getUri();
        String wasValue = startVersion.getValue();
        String wasUri = startVersion.getUri();
        AttributeId attrId = AttributeId.valueOf((Long)changeItem.getItemId().getId());
        AttributeTypeGeneric typeToken = this.tokenService.getAttributeType(changeItem.getItemTypeId().getId());
        AttributeChange attrChange = new AttributeChange(branch, gammaId, artId, txDelta, modType, isValue, isUri, wasValue, wasUri, attrId, (AttributeTypeToken)typeToken, modType, artifact.isHistorical(), artifact, artDelta);
        return attrChange;
    }

    private RelationChange getRelationChange(ChangeItem changeItem, CompositeKeyHashMap<TransactionToken, ArtifactId, Artifact> loadedMap, ChangeVersion startVersion, ChangeVersion currentVersion, BranchToken branch, GammaId gammaId, ArtifactId artId, TransactionDelta txDelta, ModificationType modType, Artifact artifact, ArtifactDelta artDelta) {
        RelationId relationId = RelationId.valueOf((Long)changeItem.getItemId().getId());
        String value = currentVersion.getValue();
        RelationTypeToken relationType = this.tokenService.getRelationType(changeItem.getItemTypeId().getId());
        Artifact artifactB = (Artifact)((Object)loadedMap.get((Object)currentVersion.getTransactionToken(), (Object)changeItem.getArtIdB()));
        int relOrder = changeItem.getRelOrder();
        RelationChange relChange = new RelationChange(branch, gammaId, artId, txDelta, modType, changeItem.getArtIdB(), relationId, value, "", relationType, artifact.isHistorical(), artifact, artDelta, artifactB, relOrder);
        return relChange;
    }
}

