/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.topic.event.filter;

import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;

public class ArtifactTopicEventFilter
implements ITopicEventFilter {
    private final ArtifactToken artifact;

    public ArtifactTopicEventFilter(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    @Override
    public boolean isMatch(BranchId branch) {
        return this.artifact.isOnBranch(branch);
    }

    @Override
    public boolean isMatchArtifacts(List<? extends EventTopicArtifactTransfer> transferArts) {
        for (EventTopicArtifactTransfer eventTopicArtifactTransfer : transferArts) {
            if (!eventTopicArtifactTransfer.getArtifactToken().equals(this.artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchRelationArtifacts(List<? extends EventTopicRelationTransfer> transferRelations) {
        for (EventTopicRelationTransfer eventTopicRelationTransfer : transferRelations) {
            if (!eventTopicRelationTransfer.getArtAId().equals(this.artifact) && !eventTopicRelationTransfer.getArtBId().equals(this.artifact)) continue;
            return true;
        }
        return false;
    }
}

