/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.help.ui;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageExtractor {
    public static void main(String[] args) {
        Path currentRelativePath = Paths.get("", new String[0]);
        currentRelativePath.toAbsolutePath().toString();
        String htmlDirectory = "docs";
        String imageDirectory = "../../docs/images";
        String destinationDirectory = "docs/images";
        ImageExtractor.extractImageNames(htmlDirectory, imageDirectory, destinationDirectory);
    }

    private static void extractImageNames(String htmlDirectory, String imageDirectory, String destinationDirectory) {
        File htmlDir = new File(htmlDirectory);
        File[] htmlFiles = htmlDir.listFiles((dir, name) -> name.endsWith(".html"));
        if (htmlFiles != null) {
            File[] fileArray = htmlFiles;
            int n = htmlFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File htmlFile = fileArray[n2];
                try {
                    String content = Files.readString(htmlFile.toPath());
                    Pattern pattern = Pattern.compile("(<img[^>]+src=\")/[^\"]+/([^\"]+\\.(?:gif|png|jpg))(\"[^>]*/>)");
                    Matcher matcher = pattern.matcher(content);
                    boolean foundMatch = false;
                    while (matcher.find()) {
                        foundMatch = true;
                        String imageName = matcher.group(2);
                        Path sourcePath = Paths.get(imageDirectory, imageName);
                        Path destinationPath = Paths.get(destinationDirectory, imageName);
                        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (foundMatch) {
                        String replacedContent = matcher.replaceAll("$1images/$2$3");
                        Files.write(htmlFile.toPath(), replacedContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }
}

