/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcClientConfig;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.jdbc.SqlColumn;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.jdbc.internal.JdbcConnectionImpl;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;
import org.eclipse.osee.jdbc.internal.JdbcConnectionProvider;
import org.eclipse.osee.jdbc.internal.JdbcSequenceProvider;
import org.eclipse.osee.jdbc.internal.JdbcStatementImpl;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public final class JdbcClientImpl
implements JdbcClient {
    private static final String POSTGRESQL_VACUUM_AND_STATS = "VACUUM FULL VERBOSE ANALYZE";
    private static final String ORACLE_GATHER_STATS = "begin DBMS_STATS.GATHER_SCHEMA_STATS (ownname => '', estimate_percent => 99, granularity => 'ALL', degree => NULL , cascade => TRUE); end;";
    private final JdbcClientConfig config;
    private final JdbcConnectionProvider connectionProvider;
    private final JdbcSequenceProvider sequenceProvider;
    private final JdbcConnectionInfo dbInfo;
    private volatile JdbcDbType dbType;
    private static final String LimitStart = "select * from (";
    private static final String LimitEnd = ") where rownum <= ?";

    public JdbcClientImpl(JdbcClientConfig config, JdbcConnectionProvider connectionProvider, JdbcSequenceProvider sequenceProvider, JdbcConnectionInfo dbInfo) {
        this.config = config;
        this.connectionProvider = connectionProvider;
        this.sequenceProvider = sequenceProvider;
        this.dbInfo = dbInfo;
    }

    @Override
    public JdbcClientConfig getConfig() {
        return this.config;
    }

    @Override
    public JdbcDbType getDbType() {
        if (this.dbType == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (JdbcConnectionImpl connection = this.getConnection();){
                this.dbType = JdbcDbType.getDbType(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.dbType;
    }

    @Override
    public JdbcConnectionImpl getConnection() throws JdbcException {
        return this.connectionProvider.getConnection(this.dbInfo);
    }

    @Override
    public JdbcStatement getStatement() {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider);
    }

    @Override
    public JdbcStatement getStatement(JdbcConnection connection) {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider, (JdbcConnectionImpl)connection);
    }

    @Override
    public JdbcStatement getStatement(JdbcConnection connection, boolean autoClose) {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider, (JdbcConnectionImpl)connection, autoClose);
    }

    @Override
    public JdbcStatement getStatement(int resultSetType, int resultSetConcurrency) {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider, resultSetType, resultSetConcurrency);
    }

    @Override
    public int runPreparedUpdate(JdbcConnection connection, String query, Object ... data) throws JdbcException {
        if (connection == null) {
            return this.runPreparedUpdate(query, data);
        }
        PreparedStatement preparedStatement = null;
        int updateCount = 0;
        try {
            try {
                preparedStatement = ((JdbcConnectionImpl)connection).prepareStatement(query);
                JdbcUtil.setInputParametersForStatement(preparedStatement, data);
                updateCount = preparedStatement.executeUpdate();
            }
            catch (SQLException ex) {
                throw JdbcException.newJdbcException(ex);
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(preparedStatement);
            throw throwable;
        }
        JdbcUtil.close(preparedStatement);
        return updateCount;
    }

    @Override
    public ResultSet runPreparedUpdateReturnAuto(JdbcConnection connection, String query, Object ... data) throws JdbcException {
        ResultSet result;
        if (connection == null) {
            return this.runPreparedUpdateReturnAuto(query, data);
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement preparedStatement = ((JdbcConnectionImpl)connection).prepareStatementGen(query);){
                JdbcUtil.setInputParametersForStatement(preparedStatement, data);
                preparedStatement.executeUpdate();
                result = preparedStatement.getGeneratedKeys();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
        return result;
    }

    @Override
    public int runBatchUpdate(JdbcConnection connection, String query, Iterable<Object[]> dataList) throws JdbcException {
        if (connection == null) {
            return this.runBatchUpdate(query, dataList);
        }
        int returnCount = 0;
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = ((JdbcConnectionImpl)connection).prepareStatement(query);
                boolean needExecute = false;
                int count = 0;
                for (Object[] objectArray : dataList) {
                    JdbcUtil.setInputParametersForStatement(preparedStatement, objectArray);
                    preparedStatement.addBatch();
                    preparedStatement.clearParameters();
                    needExecute = true;
                    if (++count <= 2000) continue;
                    int[] updates = preparedStatement.executeBatch();
                    returnCount += JdbcUtil.calculateBatchUpdateResults(updates);
                    count = 0;
                    needExecute = false;
                }
                if (needExecute) {
                    int[] nArray = preparedStatement.executeBatch();
                    returnCount += JdbcUtil.calculateBatchUpdateResults(nArray);
                }
            }
            catch (SQLException ex) {
                SQLException nestedEx = ex.getNextException();
                if (nestedEx == null) {
                    nestedEx = ex;
                }
                throw JdbcException.newJdbcException(nestedEx, "sql update failed: \n%s\n%s", query, JdbcClientImpl.getBatchErrorMessage(dataList));
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(preparedStatement);
            throw throwable;
        }
        JdbcUtil.close(preparedStatement);
        return returnCount;
    }

    private static <O> String getBatchErrorMessage(Iterable<O[]> dataList) {
        StringBuilder details = new StringBuilder(4000);
        details.append("[ DATA OBJECT: \n");
        for (O[] data : dataList) {
            int i = 0;
            while (i < data.length) {
                details.append(i);
                details.append(": ");
                O dataValue = data[i];
                if (dataValue != null) {
                    details.append(dataValue.getClass().getName());
                    details.append(":");
                    String value = dataValue.toString();
                    if (value.length() > 35) {
                        details.append(value.substring(0, 35));
                    } else {
                        details.append(value);
                    }
                    details.append("\n");
                } else {
                    details.append("NULL\n");
                }
                ++i;
            }
            details.append("---------\n");
            if (details.length() > 4000) break;
        }
        details.append("]\n");
        return details.toString();
    }

    @Override
    public int runBatchUpdate(String query, Iterable<Object[]> dataList) throws JdbcException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            return this.runBatchUpdate(connection, query, dataList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int runPreparedUpdate(String query, Object ... data) throws JdbcException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            return this.runPreparedUpdate(connection, query, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet runPreparedUpdateReturnAuto(String query, Object ... data) throws JdbcException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            return this.runPreparedUpdateReturnAuto(connection, query, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T runFunction(T defaultValue, String function, Object ... data) {
        if (defaultValue == null) {
            throw JdbcException.newJdbcException("defaultValue cannot be null", new Object[0]);
        }
        String sql = this.getDbType().getFunctionCallSql(function);
        Throwable throwable = null;
        Object var6_7 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            Object object;
            CallableStatement stmt = null;
            try {
                stmt = connection.prepareCall(sql, 1003, 1007);
                Class<Object> classValue = defaultValue.getClass();
                SQL3DataType dataType = null;
                if (classValue.isAssignableFrom(String.class)) {
                    dataType = SQL3DataType.VARCHAR;
                } else if (classValue.isAssignableFrom(Boolean.class)) {
                    dataType = SQL3DataType.BOOLEAN;
                } else if (classValue.isAssignableFrom(Integer.class)) {
                    dataType = SQL3DataType.INTEGER;
                } else if (classValue.isAssignableFrom(Long.class)) {
                    dataType = SQL3DataType.BIGINT;
                } else if (classValue.isAssignableFrom(Double.class)) {
                    dataType = SQL3DataType.DOUBLE;
                } else if (classValue.isAssignableFrom(Date.class)) {
                    dataType = SQL3DataType.TIMESTAMP;
                } else {
                    throw JdbcException.newJdbcException("Unable to determine ouput SQL3DataType for function [%s] using default value [%s]", function, defaultValue);
                }
                if (this.getDbType().equals((Object)JdbcDbType.oracle)) {
                    stmt.registerOutParameter(1, dataType.getSQLTypeNumber());
                    JdbcUtil.setInputParametersForStatement((PreparedStatement)stmt, 2, data);
                } else {
                    JdbcUtil.setInputParametersForStatement((PreparedStatement)stmt, 1, data);
                }
                boolean hasResultSet = stmt.execute();
                Object toReturn = null;
                if (hasResultSet) {
                    ResultSet rSet = stmt.getResultSet();
                    rSet.next();
                    switch (dataType) {
                        case VARCHAR: {
                            toReturn = rSet.getString(1);
                            break;
                        }
                        case BOOLEAN: {
                            toReturn = rSet.getBoolean(1);
                            break;
                        }
                        case INTEGER: {
                            toReturn = rSet.getInt(1);
                            break;
                        }
                        case BIGINT: {
                            toReturn = rSet.getLong(1);
                            break;
                        }
                        case DOUBLE: {
                            toReturn = rSet.getDouble(1);
                            break;
                        }
                        default: {
                            toReturn = rSet.getObject(1);
                            break;
                        }
                    }
                } else {
                    switch (dataType) {
                        case VARCHAR: {
                            toReturn = stmt.getString(1);
                            break;
                        }
                        case BOOLEAN: {
                            toReturn = stmt.getBoolean(1);
                            break;
                        }
                        case INTEGER: {
                            toReturn = stmt.getInt(1);
                            break;
                        }
                        case BIGINT: {
                            toReturn = stmt.getLong(1);
                            break;
                        }
                        case DOUBLE: {
                            toReturn = stmt.getDouble(1);
                            break;
                        }
                        default: {
                            toReturn = stmt.getObject(1);
                        }
                    }
                }
                object = toReturn != null ? toReturn : defaultValue;
            }
            catch (SQLException ex) {
                try {
                    throw JdbcException.newJdbcException(ex);
                }
                catch (Throwable throwable2) {
                    JdbcUtil.close(stmt);
                    throw throwable2;
                }
            }
            JdbcUtil.close(stmt);
            return (T)object;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public Map<String, String> getStatistics() throws JdbcException {
        return this.connectionProvider.getStatistics();
    }

    @Override
    public int runQuery(JdbcConnection connection, Consumer<JdbcStatement> consumer, String query, Object ... data) {
        return this.runQuery(connection, consumer, 1000, query, data);
    }

    @Override
    public int runQuery(Consumer<JdbcStatement> consumer, String query, Object ... data) {
        return this.runQuery(consumer, 1000, query, data);
    }

    @Override
    public int runQueryWithMaxFetchSize(JdbcConnection connection, Consumer<JdbcStatement> consumer, String query, Object ... data) {
        return this.runQuery(connection, consumer, 10000, query, data);
    }

    @Override
    public int runQueryWithMaxFetchSize(Consumer<JdbcStatement> consumer, String query, Object ... data) {
        return this.runQuery(consumer, 10000, query, data);
    }

    @Override
    public int runQuery(Consumer<JdbcStatement> consumer, int fetchSize, String query, Object ... data) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (JdbcConnectionImpl conn = this.getConnection();){
            return this.runQuery((JdbcConnection)conn, consumer, fetchSize, query, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int runQuery(JdbcConnection connection, Consumer<JdbcStatement> consumer, int fetchSize, String query, Object ... data) {
        int rowCount = 0;
        Throwable throwable = null;
        Object var8_9 = null;
        try (JdbcStatement stmt = this.getStatement(connection);){
            stmt.runPreparedQuery(fetchSize, query, data);
            while (stmt.next()) {
                consumer.accept(stmt);
                ++rowCount;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return rowCount;
    }

    @Override
    public void runCall(String call, Object ... data) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery(call, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int runQueryWithLimit(Consumer<JdbcStatement> consumer, int limit, String query, Object ... data) {
        StringBuilder strB = new StringBuilder(query.length() + LimitStart.length() + LimitEnd.length());
        if (this.getDbType().equals((Object)JdbcDbType.oracle)) {
            strB.append(LimitStart);
            strB.append(query);
            strB.append(LimitEnd);
        } else {
            strB.append(query);
            strB.append(" limit ?");
        }
        Object[] fullData = new Object[data.length + 1];
        System.arraycopy(data, 0, fullData, 0, data.length);
        fullData[data.length] = limit;
        return this.runQuery(consumer, limit, strB.toString(), fullData);
    }

    @Override
    public <R> R fetch(R defaultValue, String query, Object ... data) {
        return this.fetch(null, defaultValue, query, data);
    }

    @Override
    public <R> R fetch(JdbcConnection connection, R defaultValue, String query, Object ... data) {
        return (R)this.fetch(connection, defaultValue, (JdbcStatement stmt) -> JdbcClientImpl.fetch(stmt, defaultValue), query, data);
    }

    private static <R> R fetch(JdbcStatement stmt, R defaultValue) {
        return JdbcClientImpl.fetch(stmt, defaultValue, defaultValue.getClass());
    }

    private static <R> R fetch(JdbcStatement stmt, R defaultValue, Class<R> clazz) {
        Object toReturn = null;
        if (Integer.class.isAssignableFrom(clazz)) {
            toReturn = stmt.getInt(1);
        } else if (Long.class.isAssignableFrom(clazz)) {
            toReturn = stmt.getLong(1);
        } else if (String.class.isAssignableFrom(clazz)) {
            toReturn = stmt.getString(1);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            String value = stmt.getObject(1).toString();
            toReturn = Boolean.parseBoolean(value);
        } else if (BaseId.class.isAssignableFrom(clazz)) {
            if (defaultValue == null) {
                throw new OseeCoreException("In JdbcClientImpl.fetch, the parameter \"default\" is null which is dereferenced", new Object[0]);
            }
            toReturn = ((BaseId)defaultValue).clone(Long.valueOf(stmt.getLong(1)));
        } else {
            throw new OseeArgumentException("Unsupported type: %s", new Object[]{clazz.getName()});
        }
        return (R)toReturn;
    }

    @Override
    public <R> R fetchOrException(Class<R> clazz, Supplier<OseeCoreException> exSupplier, String query, Object ... data) {
        return (R)this.fetchOrException(null, exSupplier, (JdbcStatement stmt) -> JdbcClientImpl.fetch(stmt, null, clazz), query, data);
    }

    @Override
    public <R> R fetch(R defaultValue, Function<JdbcStatement, R> function, String query, Object ... data) {
        return this.fetch(null, defaultValue, function, query, data);
    }

    @Override
    public <R> R fetch(JdbcConnection connection, R defaultValue, Function<JdbcStatement, R> function, String query, Object ... data) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (JdbcStatement chStmt = this.getStatement(connection);){
            chStmt.runPreparedQuery(1, query, data);
            if (chStmt.next()) {
                return function.apply(chStmt);
            }
            return defaultValue;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public <R> R fetchOrException(Supplier<OseeCoreException> exSupplier, Function<JdbcStatement, R> function, String query, Object ... data) {
        return this.fetchOrException(null, exSupplier, function, query, data);
    }

    @Override
    public <R> R fetchOrException(JdbcConnection connection, Supplier<OseeCoreException> exSupplier, Function<JdbcStatement, R> function, String query, Object ... data) {
        Throwable throwable = null;
        Object var7_8 = null;
        try (JdbcStatement chStmt = this.getStatement(connection);){
            chStmt.runPreparedQuery(1, query, data);
            if (chStmt.next()) {
                return function.apply(chStmt);
            }
            throw exSupplier.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void runTransaction(JdbcConnection jdbcConnection, JdbcTransaction dbWork) throws JdbcException {
        JdbcConnectionImpl connection = (JdbcConnectionImpl)jdbcConnection;
        boolean initialAutoCommit = true;
        try {
            try {
                initialAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                dbWork.handleTxWork(connection);
                connection.commit();
            }
            catch (Exception e) {
                JdbcClientImpl.rollbackAndDestroy(connection);
                JdbcClientImpl.handleTxException(dbWork, e);
                throw OseeCoreException.wrap((Throwable)e);
            }
        }
        finally {
            if (!connection.isClosed()) {
                connection.setAutoCommit(initialAutoCommit);
                connection.close();
            }
            dbWork.handleTxFinally();
        }
    }

    private static void rollbackAndDestroy(JdbcConnectionImpl connection) {
        try {
            try {
                connection.rollback();
            }
            catch (Exception exception) {
                connection.destroy();
            }
        }
        finally {
            connection.destroy();
        }
    }

    private static void handleTxException(JdbcTransaction dbWork, Exception e) {
        try {
            dbWork.handleTxException(e);
        }
        catch (Exception exception) {}
    }

    @Override
    public void runTransaction(JdbcTransaction dbWork) throws JdbcException {
        this.runTransaction(this.getConnection(), dbWork);
    }

    @Override
    public long getNextSequence(String sequenceName, boolean aggressiveFetch) {
        return this.sequenceProvider.getNextSequence(this, sequenceName, aggressiveFetch);
    }

    @Override
    public void invalidateSequences() {
        this.sequenceProvider.invalidate();
    }

    @Override
    public OseePreparedStatement getBatchStatement(String query) {
        return this.getBatchStatement(query, 47662);
    }

    @Override
    public OseePreparedStatement getBatchStatement(String query, int batchIncrementSize) {
        return this.getBatchStatement(null, query, batchIncrementSize);
    }

    @Override
    public OseePreparedStatement getBatchStatement(JdbcConnection connection, String query) {
        return this.getBatchStatement(connection, query, 47662);
    }

    @Override
    public OseePreparedStatement getBatchStatement(JdbcConnection connection, String query, int batchIncrementSize) {
        try {
            JdbcConnectionImpl connect;
            boolean autoClose = false;
            if (connection == null) {
                connect = this.getConnection();
                autoClose = true;
            } else {
                connect = (JdbcConnectionImpl)connection;
            }
            PreparedStatement preparedStatement = connect.prepareStatement(query);
            return new OseePreparedStatement(preparedStatement, batchIncrementSize, connect, autoClose);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public void vacuum() {
        JdbcDbType dbType = this.getDbType();
        if (dbType.equals((Object)JdbcDbType.postgresql)) {
            this.runPreparedUpdate(POSTGRESQL_VACUUM_AND_STATS, new Object[0]);
        } else if (dbType.equals((Object)JdbcDbType.oracle)) {
            this.runPreparedUpdate(ORACLE_GATHER_STATS, new Object[0]);
        }
    }

    @Override
    public int clearTable(String tableName) {
        String cmd = this.isTruncateSupported(tableName) ? "TRUNCATE TABLE" : "DELETE FROM";
        return this.runPreparedUpdate(String.format("%s %s", cmd, tableName), new Object[0]);
    }

    /*
     * Exception decompiling
     */
    private boolean isTruncateSupported(String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 12[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResultSet getPrivileges(JdbcConnection connection, String tableName) throws SQLException {
        return connection.getMetaData().getTablePrivileges(null, null, tableName.toUpperCase());
    }

    private String columnToSql(SqlColumn column) {
        StringBuilder strB = new StringBuilder(50);
        strB.append(column.getName());
        strB.append(" ");
        if (column.getType() == JDBCType.INTEGER) {
            strB.append("INT");
        } else if (column.getType() == JDBCType.BIGINT) {
            if (this.getDbType().equals((Object)JdbcDbType.oracle)) {
                strB.append("NUMBER (19, 0)");
            } else {
                strB.append("BIGINT");
            }
        } else if (this.getDbType().equals((Object)JdbcDbType.postgresql)) {
            if (column.getType() == JDBCType.BLOB) {
                strB.append("bytea");
            } else if (column.getType() == JDBCType.CLOB) {
                strB.append("text");
            } else {
                strB.append(column.getType());
            }
        } else {
            strB.append(column.getType());
        }
        if (column.getLength() > 0) {
            strB.append(" (");
            strB.append(column.getLength());
            strB.append(")");
        }
        if (column.getName().equals("BUILD_ID")) {
            strB.append(" DEFAULT 0");
        } else if (!column.isNull()) {
            strB.append(" NOT NULL");
        }
        if (column.isAutoIncrement() && (this.getDbType().equals((Object)JdbcDbType.oracle) || this.getDbType().equals((Object)JdbcDbType.postgresql))) {
            strB.append(" GENERATED ALWAYS AS IDENTITY");
        }
        if (!column.getValueConstraint().isEmpty()) {
            if (this.getDbType().equals((Object)JdbcDbType.oracle)) {
                strB.append("CONSTRAINT " + column.getName() + "_CK CHECK (" + column.getValueConstraint() + ")");
            } else {
                strB.append(" CHECK (" + column.getValueConstraint() + ")");
            }
        }
        return strB.toString();
    }

    @Override
    public void createTable(SqlTable table) {
        StringBuilder sql = new StringBuilder(200);
        sql.append("CREATE TABLE ");
        sql.append(table.getName());
        sql.append(" (\n\t");
        int i = 0;
        while (i < table.getColumns().size()) {
            sql.append(this.columnToSql(table.getColumns().get(i)));
            if (i != table.getColumns().size() - 1 || !table.getConstraints().isEmpty()) {
                sql.append(",\n\t");
            }
            ++i;
        }
        sql.append(Collections.toString((String)",\n\t", table.getConstraints()));
        sql.append("\n)");
        JdbcDbType dbType = this.getDbType();
        if (dbType.equals((Object)JdbcDbType.oracle)) {
            if (table.getIndexLevel() != -1) {
                sql.append("\tORGANIZATION INDEX ");
                if (table.getIndexLevel() > 0) {
                    sql.append("COMPRESS " + table.getIndexLevel());
                }
            }
            if (table.getTableExtras() != null) {
                sql.append("\n\t" + table.getTableExtras());
            }
        }
        this.runPreparedUpdate(sql.toString(), new Object[0]);
        for (String statement : table.getStatements()) {
            if (statement.contains("CREATE INDEX") && dbType.equals((Object)JdbcDbType.oracle)) {
                statement = String.valueOf(statement) + " TABLESPACE osee_index";
            }
            this.runPreparedUpdate(statement, new Object[0]);
        }
    }

    @Override
    public void deferredForeignKeyConstraint(String constraintName, SqlTable table, SqlColumn column, SqlTable refTable, SqlColumn refColumn) {
        String defered = this.getDbType().matches(new Id[]{JdbcDbType.oracle, JdbcDbType.postgresql}) ? " DEFERRABLE INITIALLY DEFERRED" : "";
        this.alterForeignKeyConstraint(constraintName, table, column, refTable, refColumn, defered);
    }

    @Override
    public void alterForeignKeyConstraint(String constraintName, SqlTable table, SqlColumn column, SqlTable refTable, SqlColumn refColumn, String defered) {
        String statement = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY(%s) REFERENCES %s(%s)%s", new Object[]{table, constraintName, column, refTable, refColumn, defered});
        this.runPreparedUpdate(statement, new Object[0]);
    }

    @Override
    public void dropTable(SqlTable table) {
        try {
            this.runPreparedUpdate("DROP TABLE " + table.getName(), new Object[0]);
        }
        catch (Exception ex) {
            OseeLog.log(this.getClass(), (Level)Level.INFO, (Throwable)ex);
        }
    }

    @Override
    public void dropConstraint(SqlTable table, String constraint) {
        try {
            this.runPreparedUpdate("ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + constraint, new Object[0]);
        }
        catch (Exception ex) {
            OseeLog.log(this.getClass(), (Level)Level.INFO, (Throwable)ex);
        }
    }
}

