/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.datarights;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.osee.define.rest.api.publisher.datarights.ArtifactProxy;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class Request
implements ToMessage {
    private FormatIndicator format;
    private PublishingTemplateRequest publishingTemplateRequest;
    private ArtifactProxy[] artifactProxyList;

    public Request() {
        this.format = null;
        this.publishingTemplateRequest = null;
        this.artifactProxyList = null;
    }

    public Request(FormatIndicator format, PublishingTemplateRequest publishingTemplateRequest, ArtifactProxy[] artifactProxyList) {
        this.format = Objects.requireNonNull(format, "Request::new, parameter \"format\" cannot be null.");
        this.publishingTemplateRequest = Objects.requireNonNull(publishingTemplateRequest, "Request::new, parameter \"publishingTemplateRequest\" cannot be null.");
        this.artifactProxyList = Objects.requireNonNull(artifactProxyList, "Request::new, parameter \"artifactProxyList\" cannot be null.");
    }

    public FormatIndicator getFormat() {
        if (Objects.isNull(this.format)) {
            throw new IllegalStateException("Request::getFormat, member \"format\" has not been set.");
        }
        return this.format;
    }

    public PublishingTemplateRequest getPublishingTemplateRequest() {
        if (Objects.isNull(this.publishingTemplateRequest)) {
            throw new IllegalStateException("Request::getPublishingTemplateRequest, member \"publishingTemplateRequest\" has not been set.");
        }
        return this.publishingTemplateRequest;
    }

    public ArtifactProxy[] getArtifactProxyList() {
        if (Objects.isNull(this.artifactProxyList)) {
            throw new IllegalStateException("Request::getArtifactProxyList, member \"artifactProxyList\" has not been set.");
        }
        return this.artifactProxyList;
    }

    public boolean isValid() {
        return Objects.nonNull(this.format) && Objects.nonNull(this.publishingTemplateRequest) && this.publishingTemplateRequest.isValid() && Objects.nonNull(this.artifactProxyList) && Arrays.stream(this.artifactProxyList).allMatch(ArtifactProxy::isValid);
    }

    public void setFormat(FormatIndicator format) {
        if (Objects.nonNull(this.format)) {
            throw new IllegalStateException("Request::setFormat, member \"format\" has already been set.");
        }
        this.format = Objects.requireNonNull(format, "Request::setFormat, parameter \"format\" cannot be null.");
    }

    public void setPublishingTemplateRequest(PublishingTemplateRequest publishingTemplateRequest) {
        if (Objects.nonNull(this.publishingTemplateRequest)) {
            throw new IllegalStateException("Request::setPublishingTemplateRequest, member \"publishingTemplateRequest\" has already been set.");
        }
        this.publishingTemplateRequest = Objects.requireNonNull(publishingTemplateRequest, "Request::setPublishingTemplateRequest, parameter \"publishingTemplateRequest\" cannot be null.");
    }

    public void setArtifactProxyList(ArtifactProxy[] artifactProxyList) {
        if (Objects.nonNull(this.artifactProxyList)) {
            throw new IllegalStateException("Request::setArtifactProxyList, member \"artifactProxyList\" has already been set.");
        }
        this.artifactProxyList = Objects.requireNonNull(artifactProxyList, "Request::setArtifactProxyList, parameter \"artifactProxyList\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Data Rights - Request").indentInc().segment((CharSequence)"Format Indicator", (Object)this.format).segment((CharSequence)"Publishing Template Request", (Object)this.publishingTemplateRequest).segment((CharSequence)"Artifact Proxy List", (Object)this.artifactProxyList).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

