/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.datarights;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class StatementForResponse
implements ToMessage {
    private FormatIndicator format;
    private String formattedText;

    public StatementForResponse() {
        this.format = null;
        this.formattedText = null;
    }

    public StatementForResponse(FormatIndicator format, String formattedText) {
        this.format = Objects.requireNonNull(format, "StatementForResponse::new, parameter \"format\" cannot be null.");
        this.formattedText = Objects.requireNonNull(formattedText, "StatementForResponse::new, parameter \"formattedText\" cannot be null.");
    }

    public FormatIndicator getFormat() {
        if (Objects.isNull(this.format)) {
            throw new IllegalStateException("StatementForResponse::getFormat, member \"format\" has not been set.");
        }
        return this.format;
    }

    public String getFormattedText() {
        if (Objects.isNull(this.formattedText)) {
            throw new IllegalStateException("StatementForResponse::getFormattedText, member \"formattedText\" has not been set.");
        }
        return this.formattedText;
    }

    @JsonIgnore
    public boolean isValid() {
        return Objects.nonNull(this.format) && Objects.nonNull(this.formattedText) && Strings.isValidAndNonBlank((String)this.formattedText);
    }

    public void setFormat(FormatIndicator format) {
        if (Objects.nonNull(this.format)) {
            throw new IllegalStateException("StatementForResponse::setFormat, member \"format\" has already been set.");
        }
        this.format = Objects.requireNonNull(format, "StatementForResponse::setFormat, parameter \"format\" cannot be null.");
    }

    public void setFormattedText(String formattedText) {
        if (Objects.nonNull(this.formattedText)) {
            throw new IllegalStateException("StatementForResponse::setFormattedText, member \"formattedText\" has already been set.");
        }
        this.formattedText = Objects.requireNonNull(formattedText, "StatementForResponse::setFormattedText, parameter \"formattedText\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Statement For Response").indentInc().segment((CharSequence)"Format Indicator", (Object)this.format).segment((CharSequence)"Formatted Text", (Object)this.formattedText).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

