/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.publishing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.publishing.IdentifierTypeIndicator;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;

public class LinkHandlerResult {
    private String content = null;
    private final Set<ArtifactId> knownIdentifiers = new HashSet<ArtifactId>();
    private final Set<String> unknownAmbiguousIdentifierStrings = new HashSet<String>();

    public void setContent(String content) {
        if (Objects.nonNull(this.content)) {
            throw new IllegalStateException();
        }
        this.content = Objects.requireNonNull(content);
    }

    public void addKnownIdentifier(PublishingArtifact artifact) {
        if (Objects.nonNull(this.content)) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(artifact);
        if (artifact.isInvalid()) {
            throw new IllegalArgumentException();
        }
        this.knownIdentifiers.add(ArtifactId.valueOf((Long)artifact.getId()));
    }

    public void addUnknownIdentifier(String guid) {
        if (Objects.nonNull(this.content)) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(guid);
        if (!IdentifierTypeIndicator.determine((Object)guid).isGuid()) {
            throw new IllegalArgumentException();
        }
        this.unknownAmbiguousIdentifierStrings.add(guid);
    }

    public void addUnknownIdentifier(ArtifactId artifactIdentifier) {
        if (Objects.nonNull(this.content)) {
            throw new IllegalStateException();
        }
        Objects.requireNonNull(artifactIdentifier);
        if (artifactIdentifier.isInvalid()) {
            throw new IllegalArgumentException();
        }
        this.unknownAmbiguousIdentifierStrings.add(artifactIdentifier.getIdString());
    }

    public String getContent() {
        if (Objects.isNull(this.content)) {
            throw new IllegalStateException();
        }
        return this.content;
    }

    public Set<ArtifactId> getKnownIdentifiers() {
        if (Objects.isNull(this.content)) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableSet(this.knownIdentifiers);
    }

    public Set<String> getUnknownAmbiguousIdentifierStrings() {
        if (Objects.isNull(this.content)) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableSet(this.unknownAmbiguousIdentifierStrings);
    }

    public boolean hasUnknownAmbiguousIdentifierString() {
        return !this.unknownAmbiguousIdentifierStrings.isEmpty();
    }
}

