/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.artifacts;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OteAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.ote.define.TestRunField;

public class OteToAttributeMap {
    private static final SimpleDateFormat scriptStartEndDataFormat = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy");
    private static final SimpleDateFormat lastModifiedFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss a");
    private static OteToAttributeMap instance = null;
    private static Map<TestRunField, AttributeTypeId> outfileFieldToAttributeMap;

    private OteToAttributeMap() {
        outfileFieldToAttributeMap = new HashMap<TestRunField, AttributeTypeId>();
        outfileFieldToAttributeMap.put(TestRunField.USER_ID, (AttributeTypeId)CoreAttributeTypes.UserId);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_REVISION, (AttributeTypeId)CoreAttributeTypes.Revision);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_MODIFIED_FLAG, (AttributeTypeId)CoreAttributeTypes.ModifiedFlag);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_LAST_AUTHOR, (AttributeTypeId)CoreAttributeTypes.LastAuthor);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_LAST_MODIFIED, (AttributeTypeId)CoreAttributeTypes.LastModifiedDate);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_URL, (AttributeTypeId)OteAttributeTypes.TestScriptUrl);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OS_ARCH, (AttributeTypeId)CoreAttributeTypes.OsArchitecture);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OS_NAME, (AttributeTypeId)CoreAttributeTypes.OsName);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OS_VERSION, (AttributeTypeId)CoreAttributeTypes.OsVersion);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OSEE_VERSION, (AttributeTypeId)CoreAttributeTypes.OseeVersion);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OSEE_SERVER_TITLE, (AttributeTypeId)CoreAttributeTypes.OseeServerTitle);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OSEE_SERVER_JAR_VERSIONS, (AttributeTypeId)CoreAttributeTypes.OseeServerJarVersion);
        outfileFieldToAttributeMap.put(TestRunField.PROCESSOR_ID, (AttributeTypeId)CoreAttributeTypes.ProcessorId);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_START_DATE, (AttributeTypeId)CoreAttributeTypes.StartDate);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_END_DATE, (AttributeTypeId)CoreAttributeTypes.EndDate);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_ELAPSED_TIME, (AttributeTypeId)CoreAttributeTypes.ElapsedDate);
        outfileFieldToAttributeMap.put(TestRunField.TEST_POINTS_PASSED, (AttributeTypeId)CoreAttributeTypes.PassedCount);
        outfileFieldToAttributeMap.put(TestRunField.TEST_POINTS_FAILED, (AttributeTypeId)CoreAttributeTypes.FailedCount);
        outfileFieldToAttributeMap.put(TestRunField.TOTAL_TEST_POINTS, (AttributeTypeId)CoreAttributeTypes.TotalTestPoints);
        outfileFieldToAttributeMap.put(TestRunField.TEST_ABORT_STATUS, (AttributeTypeId)CoreAttributeTypes.ScriptAborted);
        outfileFieldToAttributeMap.put(TestRunField.QUALIFICATION_LEVEL, (AttributeTypeId)CoreAttributeTypes.QualificationLevel);
        outfileFieldToAttributeMap.put(TestRunField.BUILD_ID, (AttributeTypeId)OteAttributeTypes.BuildId);
        outfileFieldToAttributeMap.put(TestRunField.IS_BATCH_MODE_ALLOWED, (AttributeTypeId)OteAttributeTypes.IsBatchModeAllowed);
        outfileFieldToAttributeMap.put(TestRunField.RAN_IN_BATCH_MODE, (AttributeTypeId)OteAttributeTypes.RanInBatchMode);
    }

    public static OteToAttributeMap getInstance() {
        if (instance == null) {
            instance = new OteToAttributeMap();
        }
        return instance;
    }

    public AttributeTypeId getAttributeType(String rawName) {
        TestRunField field = this.getFieldId(rawName);
        return outfileFieldToAttributeMap.get((Object)field);
    }

    private TestRunField getFieldId(String name) {
        TestRunField field = TestRunField.INVALID;
        try {
            field = TestRunField.valueOf(name);
        }
        catch (Exception exception) {
            field = TestRunField.INVALID;
        }
        return field;
    }

    public Object asTypedObject(AttributeTypeId attributeType, String value) throws Exception {
        Object toReturn = null;
        if (this.isDate(attributeType)) {
            toReturn = this.getFormat(attributeType).parse(value);
        } else if (this.isInteger(attributeType)) {
            if (!Strings.isValid((String)value)) {
                value = "0";
            }
            toReturn = Integer.valueOf(value);
        } else if (this.isBoolean(attributeType)) {
            if (!Strings.isValid((String)value)) {
                value = "false";
            }
            toReturn = Boolean.valueOf(value);
        } else {
            toReturn = value;
        }
        return toReturn;
    }

    private SimpleDateFormat getFormat(AttributeTypeId attributeType) {
        if (attributeType.equals(CoreAttributeTypes.LastModifiedDate)) {
            return lastModifiedFormat;
        }
        return scriptStartEndDataFormat;
    }

    private boolean isDate(AttributeTypeId attributeType) {
        return attributeType.matches(new Id[]{CoreAttributeTypes.LastModifiedDate, CoreAttributeTypes.StartDate, CoreAttributeTypes.EndDate});
    }

    private boolean isInteger(AttributeTypeId attributeType) {
        return attributeType.matches(new Id[]{CoreAttributeTypes.TotalTestPoints, CoreAttributeTypes.PassedCount, CoreAttributeTypes.FailedCount});
    }

    private boolean isBoolean(AttributeTypeId attributeType) {
        return attributeType.matches(new Id[]{CoreAttributeTypes.ScriptAborted, OteAttributeTypes.RanInBatchMode, OteAttributeTypes.IsBatchModeAllowed});
    }
}

