/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.core.ds.VersionData;

public class VersionDataImpl
implements VersionData {
    private BranchId branch = BranchId.SENTINEL;
    private TransactionId txId = TransactionId.SENTINEL;
    private GammaId gamma = GammaId.SENTINEL;
    private boolean historical = false;
    private TransactionId stripeId = TransactionId.SENTINEL;
    private TxCurrent txCurrent = TxCurrent.SENTINEL;

    @Override
    public GammaId getGammaId() {
        return this.gamma;
    }

    @Override
    public void setGammaId(GammaId gamma) {
        this.gamma = gamma;
    }

    @Override
    public TransactionId getTransactionId() {
        return this.txId;
    }

    @Override
    public void setTransactionId(TransactionId txId) {
        this.txId = txId;
    }

    @Override
    public TransactionId getStripeId() {
        return this.stripeId;
    }

    @Override
    public void setStripeId(TransactionId stripeId) {
        this.stripeId = stripeId;
    }

    @Override
    public BranchId getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(BranchId branch) {
        this.branch = branch;
    }

    @Override
    public boolean isInStorage() {
        return TransactionId.SENTINEL != this.txId;
    }

    @Override
    public boolean isHistorical() {
        return this.historical;
    }

    @Override
    public void setHistorical(boolean historical) {
        this.historical = historical;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.branch.hashCode();
        result = 31 * result + this.gamma.hashCode();
        result = 31 * result + (this.historical ? 1231 : 1237);
        result = 31 * result + this.stripeId.hashCode();
        result = 31 * result + this.txId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionDataImpl other = (VersionDataImpl)obj;
        if (this.branch.notEqual((Id)other.branch)) {
            return false;
        }
        if (this.gamma != other.gamma) {
            return false;
        }
        if (this.historical != other.historical) {
            return false;
        }
        if (this.stripeId != other.stripeId) {
            return false;
        }
        return this.txId == other.txId;
    }

    public String toString() {
        return "Version [branch=" + this.branch + ", txId=" + this.txId + ", gamma=" + this.gamma + ", historical=" + this.historical + ", stripeId=" + this.stripeId + "]";
    }

    @Override
    public VersionData clone() {
        VersionDataImpl copy = new VersionDataImpl();
        copy.setBranch(this.getBranch());
        copy.setGammaId(this.getGammaId());
        copy.setTxCurrent(this.getTxCurrent());
        copy.setHistorical(this.isHistorical());
        copy.setStripeId(this.getStripeId());
        copy.setTransactionId(this.getTransactionId());
        return copy;
    }

    @Override
    public TxCurrent getTxCurrent() {
        return this.txCurrent;
    }

    @Override
    public void setTxCurrent(TxCurrent txCurrent) {
        this.txCurrent = txCurrent;
    }
}

