/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityCacheFile;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarLexer;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarParser;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.applicability.BatStagingCreator;

public class BlockApplicabilityOps {
    private static String SCRIPT_ENGINE_NAME = "JavaScript";
    public static final String INLINE_WHITESPACE = "[ \\t]*";
    public static final String SINGLE_NEW_LINE = "\\r\\n|[\\n\\r]";
    public static final String BEGINFEATURE = " ?(Feature ?(\\[(.*?)\\])) ?";
    public static final String ENDFEATURE = " ?(End Feature ?((\\[.*?\\]))?) ?";
    public static final String BEGINCONFIG = " ?(Configuration(?!Group)( Not)? ?(\\[(.*?)\\])) ?";
    public static final String ENDCONFIG = " ?(End Configuration(?!Group) ?((\\[.*?\\]))?) ?";
    public static final String BEGINCONFIGGRP = " ?(ConfigurationGroup( Not)? ?(\\[(.*?)\\])) ?";
    public static final String ENDCONFIGGRP = " ?(End ConfigurationGroup ?((\\[.*?\\]))?) ?";
    public static final String FEATURE_ELSE = " ?(Feature Else ?((\\[.*?\\]))?) ?";
    public static final String CONFIGURE_ELSE = " ?(Configuration Else ?((\\[.*?\\]))?) ?";
    public static final String CONFIGURE_GROUP_ELSE = " ?(ConfigurationGroup Else ?((\\[.*?\\]))?) ?";
    public static final String COMMENT_EXTRA_CHARS = "[ \\t]*(\\r\\n|[\\n\\r])?";
    public static final String ELSE = WordCoreUtil.ELSE_PATTERN + "|(" + "[ \\t]*" + " ?((Feature|ConfigurationGroup|Configuration) Else) ?" + "[ \\t]*(\\r\\n|[\\n\\r])?" + ")";
    public static final Pattern ELSE_PATTERN = Pattern.compile(ELSE, 40);
    public static final int beginFeatureCommentMatcherGroup = 1;
    public static final int beginFeatureTagMatcherGroup = 2;
    public static final int endFeatureCommentMatcherGroup = 6;
    public static final int endFeatureTagMatcherGroup = 7;
    public static final int beginConfigCommentMatcherGroup = 11;
    public static final int beginConfigTagMatcherGroup = 12;
    public static final int endConfigCommentMatcherGroup = 17;
    public static final int endConfigTagMatcherGroup = 18;
    public static final int beginConfigGrpCommentMatcherGroup = 22;
    public static final int beginConfigGrpTagMatcherGroup = 23;
    public static final int endConfigGrpCommentMatcherGroup = 28;
    public static final int endConfigGrpTagMatcherGroup = 29;
    public static final int featureElseCommentMatcherGroup = 33;
    public static final int featureElseTagMatcherGroup = 34;
    public static final int configureElseCommentMatcherGroup = 38;
    public static final int configureElseTagMatcherGroup = 39;
    public static final int configureGroupElseCommentMatcherGroup = 43;
    public static final int configureGroupElseTagMatcherGroup = 44;
    private final OrcsApi orcsApi;
    private final Log logger;
    private final ScriptEngine se;
    private final BranchId branch;
    private final ArtifactToken view;
    private final List<FeatureDefinition> featureDefinition;
    private final Map<String, List<String>> viewApplicabilitiesMap;
    private final boolean useCachedConfig;
    private BatStagingCreator batCreator;
    private BlockApplicabilityCacheFile cache;
    private String plPreferences;
    private Map<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap;
    private Map<String, List<String>> configurationMap;
    private Map<String, Set<String>> fileApplicabilityCache = new ConcurrentHashMap<String, Set<String>>();

    public BlockApplicabilityOps(OrcsApi orcsApi, Log logger, BranchId branch, ArtifactToken view, BlockApplicabilityCacheFile cache) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.branch = branch;
        this.view = view;
        ScriptEngineManager sem = new ScriptEngineManager();
        this.se = sem.getEngineByName(SCRIPT_ENGINE_NAME);
        this.featureDefinition = cache.getFeatureDefinition();
        this.viewApplicabilitiesMap = cache.getViewApplicabilitiesMap();
        this.configurationMap = cache.getConfigurationMap();
        this.plPreferences = cache.getProductLinePreferences();
        this.fileTypeApplicabilityDataMap = this.populateFileTypeApplicabilityDataMap(this.plPreferences);
        this.cache = cache;
        this.useCachedConfig = true;
    }

    public BlockApplicabilityOps(OrcsApi orcsApi, Log logger, BranchId branch, ArtifactToken view) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.branch = branch;
        this.view = view;
        ScriptEngineManager sem = new ScriptEngineManager();
        this.se = sem.getEngineByName(SCRIPT_ENGINE_NAME);
        this.featureDefinition = orcsApi.getApplicabilityOps().getFeatureDefinitionData(branch);
        this.viewApplicabilitiesMap = orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap(branch, (ArtifactId)view);
        this.configurationMap = new HashMap<String, List<String>>();
        this.plPreferences = this.getProductLinePreferences();
        this.fileTypeApplicabilityDataMap = this.populateFileTypeApplicabilityDataMap(this.plPreferences);
        this.useCachedConfig = false;
    }

    public ApplicabilityBlock createApplicabilityBlock(ApplicabilityBlock.ApplicabilityType applicType, String beginExpression) {
        ApplicabilityBlock beginApplic = new ApplicabilityBlock(applicType);
        beginExpression = beginExpression.replace(" [", "[");
        beginApplic.setApplicabilityExpression(beginExpression);
        return beginApplic;
    }

    public XResultData applyApplicabilityToFiles(XResultData results, boolean commentNonApplicableBlocks, String sourcePath, String stagePath, String customStageDir) {
        HashSet<String> excludedFiles = new HashSet<String>();
        excludedFiles.add("Staging");
        if (customStageDir != null && !customStageDir.equals("")) {
            excludedFiles.add(customStageDir);
        }
        this.setUpBlockApplicability(commentNonApplicableBlocks);
        File sourceFile = new File(sourcePath);
        File stageFile = new File(stagePath);
        this.batCreator.processDirectory(results, sourceFile, stageFile, excludedFiles);
        if (!this.useCachedConfig) {
            this.createCacheFile(results, stagePath);
        }
        if (sourceFile.isDirectory()) {
            this.writeFileApplicabilityCache(results, sourceFile.getName(), stagePath);
        }
        return results;
    }

    public XResultData refreshStagedFiles(XResultData results, String sourcePath, String stagePath, String customStageDir, List<String> files) {
        File sourceDir = new File(sourcePath);
        File stageDir = new File(stagePath, sourceDir.getName());
        File fileApplicCache = this.readFileApplicabilityCache(results, stageDir);
        for (String sourceFileString : files) {
            File sourceFile = new File(sourceDir, sourceFileString);
            File stageFile = new File(stageDir, sourceFileString).getParentFile();
            if (!stageFile.exists()) {
                if (sourceFile.exists()) {
                    stageFile.mkdirs();
                } else {
                    results.warningf("The path for %s does not exist", new Object[]{sourceFile.getPath()});
                    continue;
                }
            }
            if (sourceFile.getName().equals(".fileApplicability")) {
                sourceFile = sourceFile.getParentFile();
                stageFile = stageFile.getParentFile();
            }
            Set<String> excludedFiles = customStageDir != null && !customStageDir.equals("") ? this.fileApplicabilityCache.getOrDefault(stageFile.getPath(), Sets.newHashSet((Object[])new String[]{"Staging", customStageDir})) : this.fileApplicabilityCache.getOrDefault(stageFile.getPath(), Sets.newHashSet((Object[])new String[]{"Staging"}));
            this.batCreator.processDirectory(results, sourceFile, stageFile, excludedFiles);
        }
        this.writeFileApplicabilityCache(results, fileApplicCache);
        return results;
    }

    public void setUpBlockApplicability(boolean commentNonApplicableBlocks) {
        if (this.useCachedConfig) {
            this.configurationMap = this.cache.getConfigurationMap();
            this.plPreferences = this.cache.getProductLinePreferences();
            this.fileTypeApplicabilityDataMap = this.populateFileTypeApplicabilityDataMap(this.plPreferences);
        } else {
            this.configurationMap = new HashMap<String, List<String>>();
            this.plPreferences = this.getProductLinePreferences();
            this.fileTypeApplicabilityDataMap = this.populateFileTypeApplicabilityDataMap(this.plPreferences);
        }
        StringBuilder filePattern = new StringBuilder(".*\\.(");
        filePattern.append(Collections.toString((String)"|", this.fileTypeApplicabilityDataMap.keySet()));
        filePattern.append(")");
        Pattern validFileExtensions = Pattern.compile(filePattern.toString(), 2);
        this.batCreator = new BatStagingCreator(this, this.fileTypeApplicabilityDataMap, validFileExtensions, commentNonApplicableBlocks);
    }

    public String evaluateApplicabilityExpression(ApplicabilityBlock applic) {
        String applicabilityExpression = applic.getApplicabilityExpression();
        String toInsert = "";
        try {
            String insideText = applic.getInsideText();
            ApplicabilityGrammarLexer lex = new ApplicabilityGrammarLexer((CharStream)new ANTLRStringStream(applicabilityExpression.toUpperCase()));
            ApplicabilityGrammarParser parser = new ApplicabilityGrammarParser((TokenStream)new CommonTokenStream((TokenSource)lex));
            parser.start();
            ApplicabilityBlock.ApplicabilityType type = applic.getType();
            if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.Feature)) {
                toInsert = this.getValidFeatureContent(insideText, applic.isInTable(), parser.getIdValuesMap(), parser.getOperators());
            } else if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.Configuration) || type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfiguration)) {
                toInsert = this.getValidConfigurationContent(type, insideText, parser.getIdValuesMap());
            } else if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.ConfigurationGroup) || type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup)) {
                toInsert = this.getValidConfigurationGroupContent(type, insideText, applic.getBeginTag());
            }
        }
        catch (RecognitionException recognitionException) {
            this.logger.error("Failed to parse expression: " + applicabilityExpression + " at start Index: " + applic.getStartInsertIndex(), new Object[0]);
        }
        return toInsert;
    }

    private String getValidFeatureContent(String fullText, boolean isInTable, HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators) {
        Matcher match = ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            if (isInTable) {
                String temp = fullText.substring(0, match.end());
                int lastIndexOf = temp.lastIndexOf("<w:tr wsp:rsidR=");
                if (lastIndexOf != -1) {
                    elseText = fullText.substring(lastIndexOf);
                    elseText = elseText.replaceAll("(F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p|C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n)(\\<[^>]*?>){0,30} (\\<[^>]*?>){0,30}E(\\<[^>]*?>){0,30}l(\\<[^>]*?>){0,30}s(\\<[^>]*?>){0,30}e ?", "");
                    beginningText = fullText.substring(0, lastIndexOf);
                }
            } else {
                beginningText = fullText.substring(0, match.start());
                elseText = fullText.substring(match.end());
            }
            elseText = elseText.replaceAll("E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?", "");
            elseText = elseText.replaceAll("F(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}e(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?", "");
        }
        String expression = this.createFeatureExpression(featureIdValuesMap, featureOperators);
        boolean result = false;
        try {
            result = (Boolean)this.se.eval(expression);
        }
        catch (ScriptException scriptException) {
            this.logger.error("Failed to parse expression: " + expression, new Object[0]);
        }
        StringBuilder toReturn = new StringBuilder();
        if (result) {
            toReturn.append(beginningText);
        } else {
            toReturn.append(elseText);
        }
        return toReturn.toString();
    }

    private String getValidConfigurationGroupContent(ApplicabilityBlock.ApplicabilityType type, String fullText, String beginTag) {
        Matcher match = ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            beginningText = fullText.substring(0, match.start());
            elseText = fullText.substring(match.end());
            elseText = elseText.replaceAll("E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?", "");
            elseText = elseText.replaceAll("C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}G(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}p(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?", "");
        }
        String toReturn = "";
        Boolean viewInCfgGroup = false;
        viewInCfgGroup = this.viewInCfgGroup(beginTag);
        toReturn = type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfigurationGroup) ? (viewInCfgGroup.booleanValue() ? elseText : beginningText) : (viewInCfgGroup == false ? elseText : beginningText);
        return toReturn;
    }

    private Boolean viewInCfgGroup(String beginTag) {
        String beginConfigGroup = WordCoreUtil.textOnly((String)beginTag);
        Boolean viewInCfgGroup = false;
        int start = beginConfigGroup.indexOf("[") + 1;
        int end = beginConfigGroup.indexOf("]");
        String applicExpText = beginConfigGroup.substring(start, end);
        String[] configGroups = applicExpText.split("&|\\|");
        int i = 0;
        while (i < configGroups.length) {
            configGroups[i] = configGroups[i].split("=")[0].trim();
            if (this.queryGroup(configGroups[i])) {
                viewInCfgGroup = true;
                break;
            }
            if (this.view.getName().equalsIgnoreCase(configGroups[i])) {
                viewInCfgGroup = true;
            }
            ++i;
        }
        return viewInCfgGroup;
    }

    private boolean queryGroup(String configGroup) {
        if (this.useCachedConfig) {
            return this.configurationMap.containsKey(configGroup);
        }
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andNameEquals(configGroup).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_BranchView, (ArtifactId)this.view).exists();
    }

    private String getValidConfigurationContent(ApplicabilityBlock.ApplicabilityType type, String fullText, HashMap<String, List<String>> configIdValuesMap) {
        Matcher match = ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            beginningText = fullText.substring(0, match.start());
            elseText = fullText.substring(match.end());
            elseText = elseText.replaceAll("E(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}d ?(\\<[^>]*?>){0,30} ?(\\<[^>]*?>){0,30}C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n ?((\\<[^>]*?>){0,30}(\\[.*?\\]))?", "");
            elseText = elseText.replaceAll("C(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}f(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}g(\\<[^>]*?>){0,30}u(\\<[^>]*?>){0,30}r(\\<[^>]*?>){0,30}a(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30}i(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}n(\\<[^>]*?>){0,30}( (\\<[^>]*?>){0,30}N(\\<[^>]*?>){0,30}o(\\<[^>]*?>){0,30}t(\\<[^>]*?>){0,30})? ?(\\<[^>]*?>){0,30} ?(\\[(.*?)\\]) ?", "");
        }
        String toReturn = "";
        List<String> matchingTags = new ArrayList<String>();
        if (this.view.isTypeEqual((ArtifactTypeId)CoreArtifactTypes.GroupArtifact)) {
            this.getGroupConfigMatchingTags(matchingTags, configIdValuesMap);
            if (matchingTags.isEmpty()) {
                matchingTags = null;
            }
        } else {
            matchingTags = configIdValuesMap.get(this.view.getName().toUpperCase());
        }
        if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfiguration)) {
            if (this.branchViewExists()) {
                toReturn = matchingTags != null ? elseText : beginningText;
            }
        } else {
            toReturn = matchingTags == null ? elseText : beginningText;
        }
        return toReturn;
    }

    private void getGroupConfigMatchingTags(List<String> matchingTags, HashMap<String, List<String>> configIdValuesMap) {
        if (this.useCachedConfig) {
            List configs = this.configurationMap.getOrDefault(this.view.getName(), new ArrayList());
            for (String config : configs) {
                if (!configIdValuesMap.containsKey(config.toUpperCase())) continue;
                matchingTags.add("Config = " + config);
            }
        } else {
            for (ArtifactReadable memberConfig : this.orcsApi.getQueryFactory().fromBranch(this.branch).andId((ArtifactId)this.view).getArtifact().getRelated(CoreRelationTypes.PlConfigurationGroup_BranchView).getList()) {
                if (!configIdValuesMap.containsKey(memberConfig.getName().toUpperCase())) continue;
                matchingTags.add("Config = " + memberConfig.getName());
            }
        }
    }

    private boolean branchViewExists() {
        if (this.useCachedConfig) {
            return true;
        }
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andId((ArtifactId)this.view).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).exists();
    }

    private String createFeatureExpression(HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators) {
        String myFeatureExpression = "";
        Iterator<String> iterator = featureOperators.iterator();
        for (String feature : featureIdValuesMap.keySet()) {
            List<String> values = featureIdValuesMap.get(feature);
            String valueExpression = this.createValueExpression(feature, values);
            boolean result = false;
            try {
                result = (Boolean)this.se.eval(valueExpression);
            }
            catch (ScriptException scriptException) {
                this.logger.error("Failed to parse expression: " + valueExpression, new Object[0]);
            }
            myFeatureExpression = String.valueOf(myFeatureExpression) + result + " ";
            if (!iterator.hasNext()) continue;
            String next = iterator.next();
            if (next.equals("|")) {
                myFeatureExpression = String.valueOf(myFeatureExpression) + "|| ";
                continue;
            }
            if (!next.equals("&")) continue;
            myFeatureExpression = String.valueOf(myFeatureExpression) + "&& ";
        }
        return myFeatureExpression;
    }

    private String createValueExpression(String feature, List<String> values) {
        String myValueExpression = "";
        for (String value : values) {
            if (value.equals("(")) {
                myValueExpression = String.valueOf(myValueExpression) + "( ";
                continue;
            }
            if (value.equals(")")) {
                myValueExpression = String.valueOf(myValueExpression) + ") ";
                continue;
            }
            if (value.equals("|")) {
                myValueExpression = String.valueOf(myValueExpression) + "|| ";
                continue;
            }
            if (value.equals("&")) {
                myValueExpression = String.valueOf(myValueExpression) + "&& ";
                continue;
            }
            boolean eval = this.isFeatureValuePairValid(feature, value);
            myValueExpression = String.valueOf(myValueExpression) + eval + " ";
        }
        return myValueExpression;
    }

    private boolean isFeatureValuePairValid(String feature, String value) {
        if (this.viewApplicabilitiesMap.containsKey(feature)) {
            Collection validValues = this.viewApplicabilitiesMap.get(feature);
            value = value.equalsIgnoreCase("Default") ? this.getDefaultValue(feature) : value.trim();
            return Strings.containsIgnoreCase((Collection)validValues, (String)value);
        }
        return false;
    }

    private String getDefaultValue(String feature) {
        String toReturn = null;
        for (FeatureDefinition fDef : this.featureDefinition) {
            if (!fDef.getName().equals(feature)) continue;
            toReturn = fDef.getDefaultValue();
            break;
        }
        return toReturn;
    }

    public void addFileApplicabilityEntry(String path, Set<String> excludedFiles) {
        HashSet<String> excludedSet = new HashSet<String>();
        excludedSet.addAll(excludedFiles);
        this.fileApplicabilityCache.put(path, excludedSet);
    }

    public ArtifactToken getOpsView() {
        return this.view;
    }

    private File readFileApplicabilityCache(XResultData results, File stageDir) {
        File fileApplicCache = new File(stageDir, ".fileApplicabilityCache");
        ObjectMapper objMap = new ObjectMapper();
        MapType type = objMap.getTypeFactory().constructMapType(HashMap.class, String.class, Set.class);
        try {
            this.fileApplicabilityCache = (Map)objMap.readValue(fileApplicCache, (JavaType)type);
        }
        catch (IOException iOException) {
            results.error("Error reading fileApplicabilityCache");
        }
        return fileApplicCache;
    }

    private void writeFileApplicabilityCache(XResultData results, String sourceFileName, String stagePath) {
        File fileApplicCache = new File(stagePath, sourceFileName);
        fileApplicCache = new File(fileApplicCache, ".fileApplicabilityCache");
        this.writeFileApplicabilityCache(results, fileApplicCache);
    }

    private void writeFileApplicabilityCache(XResultData results, File fileApplicCache) {
        ObjectMapper objMap = new ObjectMapper();
        try {
            objMap.writeValue(fileApplicCache, this.fileApplicabilityCache);
        }
        catch (IOException iOException) {
            results.error("Error writing file applicability cache file");
        }
    }

    public void createCacheFile(XResultData results, String stagePath) {
        ObjectMapper objMap = new ObjectMapper();
        try {
            BlockApplicabilityCacheFile cache = new BlockApplicabilityCacheFile();
            cache.setViewId(this.view.getId());
            cache.setViewName(this.view.getName());
            cache.setViewTypeId(this.view.getArtifactType().getId());
            cache.setViewApplicabilitiesMap(this.viewApplicabilitiesMap);
            cache.setFeatureDefinition(this.featureDefinition);
            cache.setConfigurationMap(this.createCacheConfigurationMap());
            cache.setProductLinePreferences(this.plPreferences);
            File cacheFile = new File(stagePath, ".applicabilityCache");
            objMap.writeValue(cacheFile, (Object)cache);
        }
        catch (IOException ex) {
            results.errorf("There was a problem while writing the cache file %s\n", new Object[]{ex.getMessage()});
        }
    }

    private Map<String, List<String>> createCacheConfigurationMap() {
        HashMap<String, List<String>> configMap = new HashMap<String, List<String>>();
        List groupConfigs = new ArrayList();
        groupConfigs = this.view.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.GroupArtifact}) ? this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts() : this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).andRelatedTo(CoreRelationTypes.PlConfigurationGroup_BranchView, (ArtifactId)this.view).follow(CoreRelationTypes.PlConfigurationGroup_BranchView).asArtifacts();
        for (ArtifactReadable groupConfig : groupConfigs) {
            List branchViews = groupConfig.getRelatedList(CoreRelationTypes.PlConfigurationGroup_BranchView);
            configMap.put(groupConfig.getName(), Named.getNames((Collection)branchViews));
        }
        return configMap;
    }

    private String getProductLinePreferences() {
        ArtifactReadable globalPreferences = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)CoreArtifactTokens.GlobalPreferences).asArtifact();
        String preferences = (String)globalPreferences.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ProductLinePreferences, (Object)"");
        return preferences;
    }

    private Map<String, FileTypeApplicabilityData> populateFileTypeApplicabilityDataMap(String plPreferences) {
        HashMap<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap = new HashMap<String, FileTypeApplicabilityData>();
        JsonNode preferencesJson = this.orcsApi.jaxRsApi().readTree(plPreferences);
        if (preferencesJson == null) {
            return fileTypeApplicabilityDataMap;
        }
        JsonNode commentStyles = preferencesJson.findValue("FileExtensionCommentStyle");
        Iterator iter = commentStyles.elements();
        while (iter.hasNext()) {
            JsonNode currNode = (JsonNode)iter.next();
            String fileExtension = currNode.findValue("FileExtension").asText();
            String commentPrefixRegex = currNode.findValue("CommentPrefixRegex").asText();
            JsonNode optionalSuffixRegex = currNode.findValue("CommentSuffixRegex");
            String commentSuffixRegex = optionalSuffixRegex == null ? "" : optionalSuffixRegex.asText();
            Pattern pattern = this.createFullPatternFromCommentStyle(commentPrefixRegex, commentSuffixRegex);
            String commentPrefix = currNode.findValue("CommentPrefix").asText();
            JsonNode optionalSuffix = currNode.findValue("CommentSuffix");
            String commentSuffix = optionalSuffix == null ? "" : optionalSuffix.asText();
            FileTypeApplicabilityData data = new FileTypeApplicabilityData(pattern, commentPrefixRegex, commentSuffixRegex, commentPrefix, commentSuffix);
            fileTypeApplicabilityDataMap.put(fileExtension.toLowerCase(), data);
        }
        return fileTypeApplicabilityDataMap;
    }

    private Pattern createFullPatternFromCommentStyle(String commentPrefix, String commentSuffix) {
        String commentedFeatureStart = "([ \\t]*" + commentPrefix + BEGINFEATURE + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedFeatureEnd = "([ \\t]*" + commentPrefix + ENDFEATURE + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedConfigStart = "([ \\t]*" + commentPrefix + BEGINCONFIG + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedConfigEnd = "([ \\t]*" + commentPrefix + ENDCONFIG + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedConfigGrpStart = "([ \\t]*" + commentPrefix + BEGINCONFIGGRP + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedConfigGrpEnd = "([ \\t]*" + commentPrefix + ENDCONFIGGRP + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedFeatureElse = "([ \\t]*" + commentPrefix + FEATURE_ELSE + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedConfigureElse = "([ \\t]*" + commentPrefix + CONFIGURE_ELSE + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String commentedConfigureGroupElse = "([ \\t]*" + commentPrefix + CONFIGURE_GROUP_ELSE + INLINE_WHITESPACE + commentSuffix + COMMENT_EXTRA_CHARS + ")";
        String pattern = String.valueOf(commentedFeatureStart) + "|" + commentedFeatureEnd + "|" + commentedConfigStart + "|" + commentedConfigEnd + "|" + commentedConfigGrpStart + "|" + commentedConfigGrpEnd + "|" + commentedFeatureElse + "|" + commentedConfigureElse + "|" + commentedConfigureGroupElse;
        return Pattern.compile(pattern, 40);
    }
}

