/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.panels;

import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.ui.skynet.panels.BranchSelectSimpleComposite;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class GrayableBranchSelectionComposite
extends Composite
implements EventHandler {
    private static final String GROUP_TEXT = "Upload results into OSEE";
    private static final String CHECK_BUTTON_TEXT = "Enable upload";
    private static final String CHECK_BUTTON_TOOL_TIP = "Select to store outfiles as Test Run Artifacts.\nNOTE: User must be authenticated to create Artifacts.";
    private static final String AUTHENTICATION_WARNING_MESSAGE = "Authentication failure - Outfile upload not allowed. Double-Click on the lock icon at the bottom of the screen to authenticate.";
    private static final String FEATURE_DISABLED = "Feature disabled.";
    private BranchSelectSimpleComposite branchSelectComposite;
    private Button branchSelectEnabled;
    private Composite statusComposite;
    private Composite selectableComposite;
    private Label statusLabel;
    private StackLayout stackedLayout;
    private Group group;
    private boolean featureEnabled;

    public GrayableBranchSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        GridLayout gL = new GridLayout();
        gL.marginWidth = 0;
        gL.marginHeight = 0;
        parent.setLayout((Layout)gL);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.group = new Group(parent, 0);
        this.group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackedLayout = new StackLayout();
        this.group.setLayout((Layout)this.stackedLayout);
        this.group.setText(GROUP_TEXT);
        this.createStatusBar((Composite)this.group);
        this.createSelectableArea((Composite)this.group);
        this.handleBranchSelectEnabled(false);
    }

    private void createSelectableArea(Composite parent) {
        this.selectableComposite = new Composite(parent, 0);
        this.selectableComposite.setLayout((Layout)new GridLayout());
        this.selectableComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.branchSelectEnabled = new Button(this.selectableComposite, 32);
        this.branchSelectEnabled.setText(CHECK_BUTTON_TEXT);
        this.branchSelectEnabled.setToolTipText(CHECK_BUTTON_TOOL_TIP);
        this.branchSelectEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrayableBranchSelectionComposite.this.handleBranchSelectEnabled(GrayableBranchSelectionComposite.this.branchSelectEnabled.getSelection());
            }
        });
        this.branchSelectComposite = new BranchSelectSimpleComposite(this.selectableComposite, 0);
    }

    private void createStatusBar(Composite parent) {
        this.statusComposite = new Composite(parent, 2048);
        this.statusComposite.setLayout((Layout)new GridLayout(2, false));
        this.statusComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.statusComposite.setBackground(Displays.getSystemColor((int)29));
        this.statusComposite.setForeground(Displays.getSystemColor((int)28));
        Label imageLabel = new Label(this.statusComposite, 0);
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        imageLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        imageLabel.setBackground(Displays.getSystemColor((int)29));
        imageLabel.setForeground(Displays.getSystemColor((int)28));
        this.statusLabel = new Label(this.statusComposite, 0);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusLabel.setText("");
        this.statusLabel.setBackground(Displays.getSystemColor((int)29));
        this.statusLabel.setForeground(Displays.getSystemColor((int)3));
    }

    private void handleBranchSelectEnabled(boolean isSelected) {
        this.setSelectable(true);
        if (!ClientSessionManager.isSessionValid()) {
            this.statusLabel.setText(AUTHENTICATION_WARNING_MESSAGE);
            this.setSelectable(false);
            isSelected = false;
        }
        this.branchSelectEnabled.setSelection(isSelected);
        this.branchSelectComposite.setEnabled(isSelected);
        Control[] controlArray = this.branchSelectComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(isSelected);
            ++n2;
        }
    }

    public BranchId getSelectedBranch() {
        return this.branchSelectComposite.getSelectedBranch();
    }

    public boolean isBranchSelectEnabled() {
        return this.branchSelectEnabled.getSelection();
    }

    public void setFeatureEnabled(final boolean isEnabled) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GrayableBranchSelectionComposite.this.featureEnabled = isEnabled;
                GrayableBranchSelectionComposite.this.handleBranchSelectEnabled(false);
                GrayableBranchSelectionComposite.this.statusLabel.setText(!GrayableBranchSelectionComposite.this.featureEnabled ? GrayableBranchSelectionComposite.FEATURE_DISABLED : "");
                GrayableBranchSelectionComposite.this.setEnabled(GrayableBranchSelectionComposite.this.featureEnabled);
                GrayableBranchSelectionComposite.this.setSelectable(GrayableBranchSelectionComposite.this.featureEnabled);
            }
        });
    }

    private boolean isFeatureEnabled() {
        return this.featureEnabled;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Control[] controlArray = this.group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
        this.branchSelectEnabled.setEnabled(enabled);
    }

    public String[] getBranchIds() {
        return this.branchSelectComposite.getBranchIds();
    }

    public void restoreWidgetValues(boolean saveAsArtifact, String[] branchUuids, String lastSelected) {
        this.branchSelectEnabled.setSelection(saveAsArtifact && ClientSessionManager.isSessionValid());
        this.branchSelectComposite.restoreWidgetValues(branchUuids, lastSelected);
    }

    private void setSelectable(final boolean isSelectable) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GrayableBranchSelectionComposite.this.stackedLayout.topControl = isSelectable ? GrayableBranchSelectionComposite.this.selectableComposite : GrayableBranchSelectionComposite.this.statusComposite;
                GrayableBranchSelectionComposite.this.group.layout();
            }
        });
    }

    private void handleUserAuthenticated() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GrayableBranchSelectionComposite.this.branchSelectEnabled != null && !GrayableBranchSelectionComposite.this.branchSelectEnabled.isDisposed() && GrayableBranchSelectionComposite.this.isFeatureEnabled()) {
                    GrayableBranchSelectionComposite.this.handleBranchSelectEnabled(GrayableBranchSelectionComposite.this.branchSelectEnabled.getSelection());
                }
            }
        });
    }

    public boolean runOnEventInDisplayThread() {
        return true;
    }

    public void handleEvent(Event event) {
        this.handleUserAuthenticated();
    }
}

