/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class AbstractWfeSubWorkflow
extends Composite {
    protected IAtsWorkItem workItem;
    private Hyperlink labelLink;
    private Hyperlink reasonLink;
    private final String positive;
    private final String negative;
    private final AttributeTypeToken attrType;
    private final int color;
    private Label iconLabel;
    private final KeyedImage image;

    protected AbstractWfeSubWorkflow(Composite parent, int style, IAtsWorkItem workItem, final WorkflowEditor editor, final String positive, String negative, AttributeTypeToken attrType, int color, KeyedImage image, String tooltip) {
        super(parent, style);
        this.workItem = workItem;
        this.image = image;
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)5, (boolean)false));
        editor.getToolkit().adapt((Composite)this);
        this.workItem = workItem;
        this.positive = positive;
        this.negative = negative;
        this.attrType = attrType;
        this.color = color;
        try {
            this.labelLink = editor.getToolkit().createHyperlink((Composite)this, "", 0);
            this.labelLink.setToolTipText(tooltip);
            this.labelLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (editor.isDirty()) {
                            editor.doSave(null);
                        }
                        AbstractWfeSubWorkflow.this.handlePositiveButtonSelection();
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
            this.iconLabel = editor.getToolkit().createLabel((Composite)this, "");
            this.reasonLink = editor.getToolkit().createHyperlink((Composite)this, "", 0);
            this.reasonLink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        if (editor.isDirty()) {
                            editor.doSave(null);
                        }
                        EntryDialog ed = new EntryDialog("View Or Change Reason for Workflow about " + positive, "Current " + positive + " Reason: " + AbstractWfeSubWorkflow.this.getReason() + "\n\n\nEnter the new reason for setting this workflow to " + positive + " if you wish to change");
                        AbstractWfeSubWorkflow.this.setReason(ed);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            });
        }
        catch (OseeCoreException ex) {
            this.labelLink.setText("Error: " + ex.getLocalizedMessage());
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        this.refresh();
    }

    public void refresh() {
        String reason = "";
        String label = "";
        try {
            reason = this.getReason();
            label = this.isNegative() ? "Remove " + this.positive : "Set Workflow to " + this.positive;
        }
        catch (OseeCoreException ex) {
            reason = "Error: " + ex.getLocalizedMessage();
        }
        this.labelLink.setText(label);
        this.labelLink.setLayoutData((Object)new GridData());
        String text = "Reason: " + reason;
        text = Strings.truncate((String)text, (int)60, (boolean)true);
        this.reasonLink.setText(text);
        this.reasonLink.setToolTipText(reason);
        boolean showReason = Strings.isValid((String)reason);
        this.reasonLink.setVisible(showReason);
        if (showReason) {
            this.reasonLink.setForeground(Displays.getSystemColor((int)this.color));
            this.iconLabel.setImage(ImageManager.getImage((KeyedImage)this.image));
        } else {
            this.reasonLink.setForeground(Displays.getSystemColor((int)2));
            this.iconLabel.setImage(null);
        }
        this.reasonLink.setLayoutData((Object)new GridData());
        this.layout();
    }

    private String getReason() {
        return (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, this.attrType, (Object)"");
    }

    private boolean isNegative() {
        return Strings.isValid((String)this.getReason());
    }

    private void handlePositiveButtonSelection() {
        if (this.isNegative()) {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set " + this.positive + " status");
            boolean unblock = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(String.valueOf(this.negative) + " Workflow "), (String)("Are you sure you wish to set this workflow to " + this.negative + "?"));
            if (unblock) {
                changes.deleteSoleAttribute(this.workItem, this.attrType);
            }
            changes.executeIfNeeded();
        } else {
            EntryDialog ed = new EntryDialog("Setting Workflow to " + this.positive, " Enter the reason to set this workflow to " + this.positive);
            this.setReason(ed);
        }
    }

    private void setReason(EntryDialog ed) {
        String Reason = "";
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set " + this.positive + " reason");
        if (ed.open() == 0) {
            Reason = ed.getEntry();
            if (!Strings.isValid((String)Reason)) {
                Reason = this.getReason();
            }
            changes.setSoleAttributeValue(this.workItem, this.attrType, Reason);
        }
        changes.executeIfNeeded();
    }
}

