/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.CreateEnumeratedArtifactDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.HtmlDialog;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CreateEnumeratedArtifactAction
extends XNavigateItemAction {
    private static final String TITLE = "Create Enumerated Artifact";

    public CreateEnumeratedArtifactAction() {
        super(TITLE, (KeyedImage)FrameworkImage.GEAR, new XNavItemCat[]{XNavigateItem.DEFINE_ADMIN, XNavItemCat.OSEE_ADMIN});
    }

    private ArtifactToken getOrCreateEnumeratedArtifactFolder() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Get or Create Enumerated Artifact Folder");
        ArtifactToken enumArtFolder = AtsApiService.get().getQueryService().getOrCreateArtifact(CoreArtifactTokens.OseeConfiguration, CoreArtifactTokens.EnumeratedArtifactsFolder, changes);
        changes.executeIfNeeded();
        return enumArtFolder;
    }

    private ArtifactToken createEnumeratedArtifact(ArtifactToken parentFolder, String name, List<String> values) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(TITLE);
        ArtifactToken enumArt = changes.createArtifact(CoreArtifactTypes.OseeTypeEnum, name);
        for (String value : values) {
            if (Strings.isValid((String)value)) {
                changes.addAttribute((ArtifactId)enumArt, (AttributeTypeToken)CoreAttributeTypes.IdValue, (Object)value);
                continue;
            }
            AWorkbench.popup((String)"ERROR", (String)(String.valueOf(value) + " is not valid."));
            return null;
        }
        changes.addChild((ArtifactId)parentFolder, (ArtifactId)enumArt);
        changes.executeIfNeeded();
        return enumArt;
    }

    private void printResults(ArtifactToken enumArt) {
        String value = AtsApiService.get().getAttributeResolver().getAttributeValues((ArtifactId)enumArt, (AttributeTypeToken)CoreAttributeTypes.IdValue).toString();
        StringBuilder html = new StringBuilder();
        html.append(AHTML.beginMultiColumnTable((int)95, (int)2));
        html.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Name", "Value(s)")));
        html.append(AHTML.addRowMultiColumnTable((String[])new String[]{enumArt.getName(), value}));
        html.append(AHTML.endMultiColumnTable());
        HtmlDialog htmlDiag = new HtmlDialog(TITLE, "\n Enumerated Artifact has been created.\n", html.toString());
        htmlDiag.open();
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        try {
            StringBuilder msg = new StringBuilder();
            msg.append("Please enter name and value(s). Note: one value per line. \n");
            msg.append("The purpose of the Enumerated Artifact is to dynamically add, edit, or remove value(s) used to populate a certain Attribute Type. \n");
            CreateEnumeratedArtifactDialog dialog = new CreateEnumeratedArtifactDialog(TITLE, msg.toString());
            if (dialog.open() == 0) {
                String name = dialog.getXtextString("name");
                String value = dialog.getXtextString("value");
                if (Strings.isValid((String)name) && Strings.isValid((String)value)) {
                    ArrayList<String> values = new ArrayList<String>();
                    String[] stringArray = value.split("\r\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        val = val.replaceAll("^ *", "");
                        if (Strings.isValid((String)(val = val.replaceAll(" *$", "")))) {
                            if (!values.contains(val)) {
                                values.add(val);
                            }
                        } else {
                            AWorkbench.popup((String)"ERROR", (String)(String.valueOf(value) + " is not valid."));
                        }
                        ++n2;
                    }
                    ArtifactToken enumArtFolder = this.getOrCreateEnumeratedArtifactFolder();
                    ArtifactToken enumArt = this.createEnumeratedArtifact(enumArtFolder, name, values);
                    this.printResults(enumArt);
                } else {
                    AWorkbench.popup((String)"ERROR", (String)(String.valueOf(name) + " and/or " + value + " are not valid."));
                }
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.DEFINE_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

